<?php
if (!class_exists('DateTime')) {
class DateTime {
    public $date;
   
    public function __construct($date) {
        $this->date = strtotime($date);
    }
   
    public function setTimeZone($timezone) {
        return;
    }
   
    private function __getDate() {
        return date(DATE_ATOM, $this->date);   
    }
   
    public function modify($multiplier) {
        $this->date = strtotime($this->__getDate() . ' ' . $multiplier);
    }
   
    public function format($format) {
        return date($format, $this->date);
    }
}
}
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebServiceOrders
 *  @copyright   Copyright 2008-2009 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-01-01
 */
/******************************************************************************* 
 *  Marketplace Web Service Orders PHP5 Library
 *  Generated: Fri Jan 21 18:53:17 UTC 2011
 * 
 */

/**
 * List Orders  Sample
 */

include_once ('.config.inc.php'); 

   $now=date("Y-m-d");
   $dateretention=date("Y-m-d", mktime(0,0,0,date("m"),date("d")-15,date("Y")));
echo   $dateretention_h=date("Y-m-d H:m:s", mktime(0,0,0,date("m"),date("d")-15,date("Y")));

/************************************************************************
 * Instantiate Implementation of MarketplaceWebServiceOrders
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
// United States:
//$serviceUrl = "https://mws.amazonservices.com/Orders/2011-01-01";
// United Kingdom
$serviceUrl = "https://mws.amazonservices.co.uk/Orders/2011-01-01";
// Germany
//$serviceUrl = "https://mws.amazonservices.de/Orders/2011-01-01";

// France
//$serviceUrl = "https://mws.amazonservices.fr/Orders/2011-01-01";
//$serviceUrl = "https://mws.amazonservices.fr/Orders/".$dateretention;

// Italy
//$serviceUrl = "https://mws.amazonservices.it/Orders/2011-01-01";
// Japan
//$serviceUrl = "https://mws.amazonservices.jp/Orders/2011-01-01";
// China
//$serviceUrl = "https://mws.amazonservices.com.cn/Orders/2011-01-01";
// Canada
//$serviceUrl = "https://mws.amazonservices.ca/Orders/2011-01-01";
 $config = array (
   'ServiceURL' => $serviceUrl,
   'ProxyHost' => null,
   'ProxyPort' => -1,
   'MaxErrorRetry' => 3,
 );

 $service = new MarketplaceWebServiceOrders_Client(
        AWS_ACCESS_KEY_ID,
        AWS_SECRET_ACCESS_KEY,
        APPLICATION_NAME,
        APPLICATION_VERSION,
        $config);


/************************************************************************
 * Uncomment to try out Mock Service that simulates MarketplaceWebServiceOrders
 * responses without calling MarketplaceWebServiceOrders service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under MarketplaceWebServiceOrders/Mock tree
 *
 ***********************************************************************/
 // $service = new MarketplaceWebServiceOrders_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for List Orders Action
 ***********************************************************************/
 $request = new MarketplaceWebServiceOrders_Model_ListOrdersRequest();
 $request->setSellerId(MERCHANT_ID);

 // List all orders udpated after a certain date
// $request->setCreatedAfter(new DateTime('2011-01-01 12:00:00', new DateTimeZone('UTC')));
//$request->setCreatedAfter(new DateTime('2012-01-01 12:00:00')); // seb php 5.1 fonction qui n existe pas
$request->setCreatedAfter(new DateTime($dateretention_h)); // seb php 5.1 fonction qui n existe pas
// $request->setCreatedAfter('Monday, 15-Aug-11 15:52:01 UTC');

 // Set the marketplaces queried in this ListOrdersRequest
 $marketplaceIdList = new MarketplaceWebServiceOrders_Model_MarketplaceIdList();
 $marketplaceIdList->setId(array(MARKETPLACE_ID));
 $request->setMarketplaceId($marketplaceIdList);

 // Set the order statuses for this ListOrdersRequest (optional)
  $orderStatuses = new MarketplaceWebServiceOrders_Model_OrderStatusList();
  $orderStatuses->setStatus(array('Unshipped','PartiallyShipped'));
  $request->setOrderStatus($orderStatuses);

 // Set the Fulfillment Channel for this ListOrdersRequest (optional)
 //$fulfillmentChannels = new MarketplaceWebServiceOrders_Model_FulfillmentChannelList();
 //$fulfillmentChannels->setChannel(array('MFN'));
 //$request->setFulfillmentChannel($fulfillmentChannels);

 // @TODO: set request. Action can be passed as MarketplaceWebServiceOrders_Model_ListOrdersRequest
 // object or array of parameters


//******************************************************* preparation enregistrement commandes */

  require('import_top_special.php');
echo "current mb_internal_encoding: ".mb_internal_encoding()."<br />";

// variables

$coef_livre = 1.16822 ; 
$status_commande=3;
$en_prod_test = 1;
$id_tva=5; // aller voir le code id de la tava dans la table tax_rates

			$tva_query= tep_db_query("SELECT tax_rate FROM tax_rates WHERE tax_rates_id = '" . $id_tva . "'");
  		    $tva_values = tep_db_fetch_array($tva_query);
        	$tva = $tva_values['tax_rate'];


//******************************************************* fin prparation enregistrement commandes */

 invokeListOrders($service, $request);

                                        
/**
  * List Orders Action Sample
  * ListOrders can be used to find orders that meet the specified criteria.
  *   
  * @param MarketplaceWebServiceOrders_Interface $service instance of MarketplaceWebServiceOrders_Interface
  * @param mixed $request MarketplaceWebServiceOrders_Model_ListOrders or array of parameters
  */
  function invokeListOrders(MarketplaceWebServiceOrders_Interface $service, $request) 
  {
	  global $now,$tva,$en_prod_test,$status_commande,$coef_livre;
      try {
              $response = $service->listOrders($request);
          
                echo ("Service Response<br> \n");


                echo("        ListOrdersResponse<br> \n");
                if ($response->isSetListOrdersResult()) { 
                    echo("            ListOrdersResult<br> \n");
                    $listOrdersResult = $response->getListOrdersResult();
                    if ($listOrdersResult->isSetNextToken()) 
                    {
                        echo("                NextToken<br> \n");
                        echo("                    " . $listOrdersResult->getNextToken() . "");
                    }
                    if ($listOrdersResult->isSetCreatedBefore()) 
                    {
                        echo("                CreatedBefore<br> \n");
                        echo("                    " . $listOrdersResult->getCreatedBefore() . "<br> \n");
                    }
                    if ($listOrdersResult->isSetLastUpdatedBefore()) 
                    {
                        echo("                LastUpdatedBefore<br> \n");
                        echo("                    " . $listOrdersResult->getLastUpdatedBefore() . "<br> \n");
                    }
                    if ($listOrdersResult->isSetOrders()) { 
                        echo("                Orders<br> \n");
                        $orders = $listOrdersResult->getOrders();
                        $orderList = $orders->getOrder();

echo "<hr>";
echo "<pre>";
print_r($orderList);
echo "</pre>";
echo "<hr>";

//******************************************************* preparation enregistrement commandes */
// variable

$customer_id=0;
$payment_method="Virement bancaire AMAZON";
$currency = "EUR";
$currency_value = 1.000000;
$info_flux="Amazon uk";
//******************************************************* traitement  enregistrement commandes */
                        foreach ($orderList as $order) {


                echo ("<hr>");    

                            echo("                    Order<br> \n");
                            if ($order->isSetAmazonOrderId()) 
                            {
                                echo("                        AmazonOrderId :  \n");
                                echo("                            " . $order->getAmazonOrderId() . "<br> \n");
                            }
                            if ($order->isSetSellerOrderId()) 
                            {
                                echo("                        SellerOrderId :  \n");
                                echo("                            " . $order->getSellerOrderId() . "<br> \n");
                            }
                            if ($order->isSetPurchaseDate()) 
                            {
                                echo("                        PurchaseDate :  \n");
                                echo("                            " . $order->getPurchaseDate() . "<br> \n");
                            }
                            if ($order->isSetLastUpdateDate()) 
                            {
                                echo("                        LastUpdateDate :  \n");
                                echo("                            " . $order->getLastUpdateDate() . "<br> \n");
                            }
                            if ($order->isSetOrderStatus()) 
                            {
                                echo("                        OrderStatus :  \n");
                                echo("                            " . $order->getOrderStatus() . "<br> \n");
                            }
                            if ($order->isSetFulfillmentChannel()) 
                            {
                                echo("                        FulfillmentChannel :  \n");
                                echo("                            " . $order->getFulfillmentChannel() . "<br> \n");
                            }
                            if ($order->isSetSalesChannel()) 
                            {
                                echo("                        SalesChannel :  \n");
                                echo("                            " . $order->getSalesChannel() . "<br> \n");
                            }
                            if ($order->isSetOrderChannel()) 
                            {
                                echo("                        OrderChannel :  \n");
                                echo("                            " . $order->getOrderChannel() . "<br> \n");
                            }
                            if ($order->isSetShipServiceLevel()) 
                            {
                                echo("                        ShipServiceLevel :  \n");
                                echo("                            " . $order->getShipServiceLevel() . "<br> \n");
                            }
                            if ($order->isSetShippingAddress()) { 
                                echo("                        ShippingAddress<br> \n");
                                $shippingAddress = $order->getShippingAddress();
                                if ($shippingAddress->isSetName()) 
                                {
                                    echo("                            Name :  \n");
                                    echo("                                " . $shippingAddress->getName() . "<br> \n");
                                }
                                if ($shippingAddress->isSetAddressLine1()) 
                                {
                                    echo("                            AddressLine1 :  \n");
                                    echo("                                " . $shippingAddress->getAddressLine1() . "<br> \n");
                                }
                                if ($shippingAddress->isSetAddressLine2()) 
                                {
                                    echo("                            AddressLine2 :  \n");
                                    echo("                                " . utf8_decode($shippingAddress->getAddressLine2()) . "<br> \n");
                                }
                                if ($shippingAddress->isSetAddressLine3()) 
                                {
                                    echo("                            AddressLine3 :  \n");
                                    echo("                                " . $shippingAddress->getAddressLine3() . "<br> \n");
                                }
                                if ($shippingAddress->isSetCity()) 
                                {
                                    echo("                            City :  \n");
                                    echo("                                " . $shippingAddress->getCity() . "<br> \n");
                                }
                                if ($shippingAddress->isSetCounty()) 
                                {
                                    echo("                            County :  \n");
                                    echo("                                " . $shippingAddress->getCounty() . "<br> \n");
                                }
                                if ($shippingAddress->isSetDistrict()) 
                                {
                                    echo("                            District :  \n");
                                    echo("                                " . $shippingAddress->getDistrict() . "<br> \n");
                                }
                                if ($shippingAddress->isSetStateOrRegion()) 
                                {
                                    echo("                            StateOrRegion :  \n");
                                    echo("                                " . $shippingAddress->getStateOrRegion() . "<br> \n");
                                }
                                if ($shippingAddress->isSetPostalCode()) 
                                {
                                    echo("                            PostalCode :  \n");
                                    echo("                                " . $shippingAddress->getPostalCode() . "<br> \n");
                                }
                                if ($shippingAddress->isSetCountryCode()) 
                                {
                                    echo("                            CountryCode :  \n");
                                    echo("                                " . $shippingAddress->getCountryCode() . "<br> \n");
                                }
                                if ($shippingAddress->isSetPhone()) 
                                {
                                    echo("                            Phone :  \n");
                                    echo("                                " . $shippingAddress->getPhone() . "<br> \n");
                                }
                            } 
                            if ($order->isSetOrderTotal()) { 
                                echo("                        OrderTotal<br> \n");
                                $orderTotal = $order->getOrderTotal();
                                if ($orderTotal->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode :  \n");
                                    echo("                                " . $orderTotal->getCurrencyCode() . "<br> \n");
                                }
                                if ($orderTotal->isSetAmount()) 
                                {
                                    echo("                            Amount :  \n");
                                    echo("                                " . $orderTotal->getAmount() . "<br> \n");
                                }
                            } 
                            if ($order->isSetNumberOfItemsShipped()) 
                            {
                                echo("                        NumberOfItemsShipped :  \n");
                                echo("                            " . $order->getNumberOfItemsShipped() . "<br> \n");
                            }
                            if ($order->isSetNumberOfItemsUnshipped()) 
                            {
                                echo("                        NumberOfItemsUnshipped :  \n");
                                echo("                            " . $order->getNumberOfItemsUnshipped() . "<br> \n");
                            }
                            if ($order->isSetPaymentExecutionDetail()) { 
                                echo("                        PaymentExecutionDetail<br> \n");
                                $paymentExecutionDetail = $order->getPaymentExecutionDetail();
                                $paymentExecutionDetailItemList = $paymentExecutionDetail->getPaymentExecutionDetailItem();
                                foreach ($paymentExecutionDetailItemList as $paymentExecutionDetailItem) {
                                    echo("                            PaymentExecutionDetailItem<br> \n");
                                    if ($paymentExecutionDetailItem->isSetPayment()) { 
                                        echo("                                Payment<br> \n");
                                        $payment = $paymentExecutionDetailItem->getPayment();
                                        if ($payment->isSetCurrencyCode()) 
                                        {
                                            echo("                                    CurrencyCode :  \n");
                                            echo("                                        " . $payment->getCurrencyCode() . "<br> \n");
                                        }
                                        if ($payment->isSetAmount()) 
                                        {
                                            echo("                                    Amount :  \n");
                                            echo("                                        " . $payment->getAmount() . "<br> \n");
                                        }
                                    } 
                                    if ($paymentExecutionDetailItem->isSetSubPaymentMethod()) 
                                    {
                                        echo("                                SubPaymentMethod :  \n");
                                        echo("                                    " . $paymentExecutionDetailItem->getSubPaymentMethod() . "<br> \n");
                                    }
                                }
                            } 
                            if ($order->isSetPaymentMethod()) 
                            {
                                echo("                        PaymentMethod :  \n");
                                echo("                            " . $order->getPaymentMethod() . "<br> \n");
                            }
                            if ($order->isSetMarketplaceId()) 
                            {
                                echo("                        MarketplaceId :  \n");
                                echo("                            " . $order->getMarketplaceId() . "<br> \n");
                            }
                            if ($order->isSetBuyerEmail()) 
                            {
                                echo("                        BuyerEmail :  \n");
                                echo("                            " . $order->getBuyerEmail() . "<br> \n");
                            }
                            if ($order->isSetBuyerName()) 
                            {
                                echo("                        BuyerName :  \n");
                                echo("                            " . $order->getBuyerName() . "<br> \n");
                            }
                            if ($order->isSetShipmentServiceLevelCategory()) 
                            {
                                echo("                        ShipmentServiceLevelCategory :  \n");
                                echo("                            " . $order->getShipmentServiceLevelCategory() . "<br>  \n");
                            }



//******************************************************* traitement  enregistrement commandes */
$id_commande_amazon=$order->getAmazonOrderId();

			$orders_sql = tep_db_query("SELECT orders_id , date_purchased,market_p_id_com FROM  " . TABLE_ORDERS . "  WHERE market_p_id_com = '" . $id_commande_amazon ."' ORDER BY date_purchased DESC LIMIT 200 ");

			if (mysql_num_rows($orders_sql)<1){

		//	  	echo  $row_orders["orders_id"];
				echo  "___pas trouv";

			$pays_query= tep_db_query("SELECT countries_name FROM countries_orgine WHERE countries_iso_code_2 = '" . $shippingAddress->getCountryCode() . "'");
  		    $pays_values = tep_db_fetch_array($pays_query);
        	$pays = $pays_values['countries_name'];


  $sql_data_array = array('customers_id' => $customer_id,
                          'customers_name' =>  utf8_decode($shippingAddress->getName()),
                          'customers_company' => '',
                          'customers_street_address' => utf8_decode($shippingAddress->getAddressLine1()),
                          'customers_suburb' =>  utf8_decode($shippingAddress->getAddressLine2())." " . utf8_decode($shippingAddress->getAddressLine3()),
                          'customers_city' => utf8_decode($shippingAddress->getCity()),
                          'customers_postcode' =>  utf8_decode($shippingAddress->getPostalCode()),
                          'customers_state' => '',
                          'customers_country' =>  $pays,
                          'customers_telephone' => $shippingAddress->getPhone(),
                          'customers_email_address' => $order->getBuyerEmail(),
                          'customers_address_format_id' => '1',

                          'delivery_name' =>  utf8_decode($shippingAddress->getName()),
                          'delivery_company' => '',
                          'delivery_street_address' =>  utf8_decode($shippingAddress->getAddressLine1()),
                          'delivery_suburb' =>  utf8_decode($shippingAddress->getAddressLine2())." " . utf8_decode($shippingAddress->getAddressLine3()),
                          'delivery_city' =>  utf8_decode($shippingAddress->getCity()),
                          'delivery_postcode' =>   utf8_decode($shippingAddress->getPostalCode()),
                          'delivery_state' => '',
                          'delivery_country' =>   $pays,
                          'delivery_address_format_id' => '1',

                          'billing_name' => utf8_decode($shippingAddress->getName()),
                          'billing_company' => '',
                          'billing_street_address' =>  utf8_decode($shippingAddress->getAddressLine1()),
                          'billing_suburb' =>  utf8_decode($shippingAddress->getAddressLine2())." " . utf8_decode($shippingAddress->getAddressLine3()),
                          'billing_city' =>  utf8_decode($shippingAddress->getCity()),
                          'billing_postcode' => utf8_decode($shippingAddress->getPostalCode()),
                          'billing_state' => '',
                          'billing_country' =>  $pays,
                          'billing_address_format_id' => '1',

                          'payment_method' =>  $payment_method,
                          'payment_info' => '',
                          'date_purchased' => 'now()',
                          'last_modified' => 'now()',
                          'orders_status' => $status_commande,
                          'currency' => $currency,
                          'currency_value' => $currency_value,
                          'ipaddy' => '',
						  'market_p_id_com' => $id_commande_amazon,
						  'market_p_id_fux' => '',
						  'market_p_nom_flux' => $info_flux ."<br>taux : " . $coef_livre,  
 					       'ipisp' => '');
              
						// EOF: WebMakers.com Added: Downloads Controller
						  if ($mode_test<>1)  tep_db_perform(TABLE_ORDERS, $sql_data_array);
						  $insert_id = tep_db_insert_id();




//******************************************************* preparation enregistrement commandes */







 $request2 = new MarketplaceWebServiceOrders_Model_ListOrderItemsRequest();
 $request2->setSellerId(MERCHANT_ID);
 //$request->setAmazonOrderId("<AMAZON ORDER ID>");
$request2->setAmazonOrderId($id_commande_amazon);
echo ("====================================== detail commande produits =============================<br> \n");

 // @TODO: set request. Action can be passed as MarketplaceWebServiceOrders_Model_ListOrderItemsRequest
 // object or array of parameters
 invokeListOrderItems($service, $request2 , $insert_id);

			}
			else {
				echo  "___commande amazon trouv___";

			}

//******************************************************* preparation enregistrement commandes */
                        }
                    } 
                } 
                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata<br> \n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId<br> \n");
                        echo("                    " . $responseMetadata->getRequestId() . "<br> \n");
                    }
                } 

     } catch (MarketplaceWebServiceOrders_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "<br> \n");
         echo("Response Status Code: " . $ex->getStatusCode() . "<br> \n");
         echo("Error Code: " . $ex->getErrorCode() . "<br> \n");
         echo("Error Type: " . $ex->getErrorType() . "<br> \n");
         echo("Request ID: " . $ex->getRequestId() . "<br> \n");
         echo("XML: " . $ex->getXML() . "<br> \n");
     }
 }

  function invokeListOrderItems(MarketplaceWebServiceOrders_Interface $service, $request2 , $insert_id) 
  {
	  global $now,$tva,$en_prod_test,$status_commande,$coef_livre;

      try {
              $response = $service->listOrderItems($request2);
              
                echo ("Service Response\n");
                echo ("=============================================================================\n");

                echo("        ListOrderItemsResponse\n");
                if ($response->isSetListOrderItemsResult()) { 
                    echo("            ListOrderItemsResult<br>\n");
                    $listOrderItemsResult = $response->getListOrderItemsResult();
                    if ($listOrderItemsResult->isSetNextToken()) 
                    {
                        echo("                NextToken :  \n");
                        echo("                    " . $listOrderItemsResult->getNextToken() . "<br> \n");
                    }
                    if ($listOrderItemsResult->isSetAmazonOrderId()) 
                    {
                        echo("                AmazonOrderId :  \n");
                        echo("                    " . $listOrderItemsResult->getAmazonOrderId() . "<br> \n");
                    }


                    if ($listOrderItemsResult->isSetOrderItems()) { 
                        echo("                OrderItems\n");
                        $orderItems = $listOrderItemsResult->getOrderItems();
                        $orderItemList = $orderItems->getOrderItem();
echo "<hr>";

echo "<pre>";
 print_r($orderItemList);
echo "</pre>";
echo "<hr>";
$frais_port_ttc=0;

                        foreach ($orderItemList as $orderItem) {
                            echo("                    OrderItem<br>\n");
                            if ($orderItem->isSetASIN()) 
                            {
                                echo("                        ASIN :  \n");
                                echo("                            " . $orderItem->getASIN() . "<br> \n");
                            }
                            if ($orderItem->isSetSellerSKU()) 
                            {
                                echo("                        SellerSKU :  \n");
                                echo("                            " . $orderItem->getSellerSKU() . "<br> \n");
                            }
                            if ($orderItem->isSetOrderItemId()) 
                            {
                                echo("                        OrderItemId :  \n");
                                echo("                            " . $orderItem->getOrderItemId() . "<br> \n");
                            }
                            if ($orderItem->isSetTitle()) 
                            {
                                echo("                        Title :  \n");
                                echo("                            " . $orderItem->getTitle() . "<br> \n");
                            }
                            if ($orderItem->isSetQuantityOrdered()) 
                            {
                                echo("                        QuantityOrdered :  \n");
                                echo("                            " . $orderItem->getQuantityOrdered() . "<br> \n");
                            }
                            if ($orderItem->isSetQuantityShipped()) 
                            {
                                echo("                        QuantityShipped :  \n");
                                echo("                            " . $orderItem->getQuantityShipped() . "<br> \n");
                            }
                            if ($orderItem->isSetItemPrice()) { 
                                echo("                        ItemPrice :  \n");
                                $itemPrice = $orderItem->getItemPrice();
                                if ($itemPrice->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode :  \n");
                                    echo("                                " . $itemPrice->getCurrencyCode() . "<br> \n");
                                }
                                if ($itemPrice->isSetAmount()) 
                                {
                                    echo("                            Amount :  \n");
                                    echo("                                " . $itemPrice->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetShippingPrice()) { 
                                echo("                        ShippingPrice<br>\n");
                                $shippingPrice = $orderItem->getShippingPrice();
                                if ($shippingPrice->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode :  \n");
                                    echo("                                " . $shippingPrice->getCurrencyCode() . "<br> \n");
                                }
                                if ($shippingPrice->isSetAmount()) 
                                {
                                    echo("                            Amount :  \n");
                                    echo("                                " . $shippingPrice->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetGiftWrapPrice()) { 
                                echo("                        GiftWrapPrice<br>\n");
                                $giftWrapPrice = $orderItem->getGiftWrapPrice();
                                if ($giftWrapPrice->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode :  \n");
                                    echo("                                " . $giftWrapPrice->getCurrencyCode() . "<br> \n");
                                }
                                if ($giftWrapPrice->isSetAmount()) 
                                {
                                    echo("                            Amoun :  t\n");
                                    echo("                                " . $giftWrapPrice->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetItemTax()) { 
                                echo("                        ItemTax\n");
                                $itemTax = $orderItem->getItemTax();
                                if ($itemTax->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode :  \n");
                                    echo("                                " . $itemTax->getCurrencyCode() . "<br> \n");
                                }
                                if ($itemTax->isSetAmount()) 
                                {
                                    echo("                            Amount :  \n");
                                    echo("                                " . $itemTax->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetShippingTax()) { 
                                echo("                        ShippingTax<br> \n");
                                $shippingTax = $orderItem->getShippingTax();
                                if ($shippingTax->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode :  \n");
                                    echo("                                " . $shippingTax->getCurrencyCode() . "<br> \n");
                                }
                                if ($shippingTax->isSetAmount()) 
                                {
                                    echo("                            Amount :  \n");
                                    echo("                                " . $shippingTax->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetGiftWrapTax()) { 
                                echo("                        GiftWrapTax<br>\n");
                                $giftWrapTax = $orderItem->getGiftWrapTax();
                                if ($giftWrapTax->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode : \n");
                                    echo("                                " . $giftWrapTax->getCurrencyCode() . "<br> \n");
                                }
                                if ($giftWrapTax->isSetAmount()) 
                                {
                                    echo("                            Amount : \n");
                                    echo("                                " . $giftWrapTax->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetShippingDiscount()) { 
                                echo("                        ShippingDiscount<br>\n");
                                $shippingDiscount = $orderItem->getShippingDiscount();
                                if ($shippingDiscount->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode : \n");
                                    echo("                                " . $shippingDiscount->getCurrencyCode() . "<br> \n");
                                }
                                if ($shippingDiscount->isSetAmount()) 
                                {
                                    echo("                            Amount : \n");
                                    echo("                                " . $shippingDiscount->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetPromotionDiscount()) { 
                                echo("                        PromotionDiscount<br>\n");
                                $promotionDiscount = $orderItem->getPromotionDiscount();
                                if ($promotionDiscount->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode : \n");
                                    echo("                                " . $promotionDiscount->getCurrencyCode() . "<br> \n");
                                }
                                if ($promotionDiscount->isSetAmount()) 
                                {
                                    echo("                            Amount : \n");
                                    echo("                                " . $promotionDiscount->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetPromotionIds()) { 
                                echo("                        PromotionIds<br>\n");
                                $promotionIds = $orderItem->getPromotionIds();
                                $promotionIdList  =  $promotionIds->getPromotionId();
                                foreach ($promotionIdList as $promotionId) { 
                                    echo("                            PromotionId\n");
                                    echo("                                " . $promotionId . "<br> \n");
                                }    
                            } 
                            if ($orderItem->isSetCODFee()) { 
                                echo("                        CODFee<br>\n");
                                $CODFee = $orderItem->getCODFee();
                                if ($CODFee->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode : \n");
                                    echo("                                " . $CODFee->getCurrencyCode() . "<br> \n");
                                }
                                if ($CODFee->isSetAmount()) 
                                {
                                    echo("                            Amount : \n");
                                    echo("                                " . $CODFee->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetCODFeeDiscount()) { 
                                echo("                        CODFeeDiscount\n");
                                $CODFeeDiscount = $orderItem->getCODFeeDiscount();
                                if ($CODFeeDiscount->isSetCurrencyCode()) 
                                {
                                    echo("                            CurrencyCode : \n");
                                    echo("                                " . $CODFeeDiscount->getCurrencyCode() . "<br> \n");
                                }
                                if ($CODFeeDiscount->isSetAmount()) 
                                {
                                    echo("                            Amount : \n");
                                    echo("                                " . $CODFeeDiscount->getAmount() . "<br> \n");
                                }
                            } 
                            if ($orderItem->isSetGiftMessageText()) 
                            {
                                echo("                        GiftMessageText : \n");
                                echo("                            " . $orderItem->getGiftMessageText() . "<br> \n");
                            }
                            if ($orderItem->isSetGiftWrapLevel()) 
                            {
                                echo("                        GiftWrapLevel : \n");
                                echo("                            " . $orderItem->getGiftWrapLevel() . "<br> \n");
                            }


/********************************************* traitement produits base SQL ******************************/	
	
								$prix_unitaire_ht= (floatval(  ($itemPrice->getAmount()* $coef_livre)  )/  $orderItem->getQuantityOrdered()  ) / (($tva/100)+1);
								$total_ht=	($prix_unitaire_ht * $orderItem->getQuantityOrdered()) +	$total_ht;

								$prix_unitaire_ttc= (floatval(  ($itemPrice->getAmount()* $coef_livre) ) /  $orderItem->getQuantityOrdered()  );
								$total_ttc=	($prix_unitaire_ttc * $orderItem->getQuantityOrdered()  ) +	$total_ttc;

$frais_port_ttc  = $frais_port_ttc + $shippingPrice->getAmount();

  						  $sql_data_array = array('orders_id' => $insert_id,
						                            'products_id' => '',
						                            'products_model' => $orderItem->getSellerSKU() ,
						                            'products_name' => utf8_decode($orderItem->getTitle()) ,
						                            'products_price' =>	$prix_unitaire_ht,
													'ecotax_rates_id' => '0',
						                            'final_price' => $prix_unitaire_ht,
						                            'products_tax' => $tva,
						                            'products_ecotax' => '',
						                            'products_quantity' => $orderItem->getQuantityOrdered() );
						    if ($mode_test<>1)  tep_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
						   // $order_products_id = tep_db_insert_id();
/********************************************* traitement produits base SQL ******************************/		

                        }

/********************************************* traitement produits base SQL ******************************/				

						//  statut history
						  $customer_notification = (SEND_EMAILS == 'false') ? '1' : '0';
						  $sql_data_array = array('orders_id' => $insert_id,
						                          'orders_status_id' => $status_commande,
						                          'date_added' => 'now()',
						                          'customer_notified' => $customer_notification,
						                          'comments' => 'commande AMAZON');
						 if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
						
		
						// order total
						
						
						  	$total_ht_txt= round($total_ht, 2);
							$total_ht_txt= str_replace(".", ",", $total_ht_txt) . "";
						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => 'Sous-Total HT :',
						                            'text' =>   $total_ht_txt,
						                            'value' => 	$total_ht, 
						                            'class' => "ot_subtotal_ht", 
						                            'sort_order' => "1");
						    tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
						
						
						  	$total_ttc_txt= round($total_ttc, 2);
							$total_ttc_txt= str_replace(".", ",", $total_ttc_txt)  . "";
						   $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => '<b>Sous-Total</b>:',
						                            'text' => 	$total_ttc_txt,
						                            'value' => 	$total_ttc,
						                            'class' => "ot_subtotal",
						                            'sort_order' => "2");
						  if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

							$mode_livraison = "Colissimo";
//							if (strval($order->getShipmentServiceLevelCategory()) == "Express" ) $mode_livraison = "UPS";
							
							$frais_port_ttc=floatval($frais_port_ttc)*$coef_livre;
							$frais_port_ttc_txt= round($frais_port_ttc, 2);	
							$frais_port_ttc_txt=  str_replace(".", ",", $frais_port_ttc_txt)  . "";
						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' =>  $mode_livraison,
						                            'text' => $frais_port_ttc_txt,
						                            'value' => 	$frais_port_ttc, 
						                            'class' => "ot_shipping", 
						                            'sort_order' => "4");
						    if ($mode_test<>1)  tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

	
							$montant_total_ttc=floatval($frais_port_ttc+$total_ttc);
							$montant_tva= $montant_total_ttc - ($montant_total_ttc/ (($tva/100)+1) );
			
		
					    	$montant_tva_txt= round($montant_tva, 2);	
							$montant_tva_txt=  str_replace(".", ",", $montant_tva_txt) . "";

							
						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => 'TVA:',
						                            'text' => 	$montant_tva_txt,
						                            'value' => 	$montant_tva, 
						                            'class' => "ot_tax", 
						                            'sort_order' => "4");
						    tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

					    	$montant_total_ttc_txt= round($montant_total_ttc, 2);	
							$montant_total_ttc_txt=  "<b>" .str_replace(".", ",", $montant_total_ttc_txt)  . "</b>";

						    $sql_data_array = array('orders_id' => $insert_id,
						                            'title' => 'Montant total TTC  rgler:',
						                            'text' => 	$montant_total_ttc_txt,
						                            'value' => 	$montant_total_ttc, 
						                            'class' => "ot_total", 
						                            'sort_order' => "800");
						   if ($mode_test<>1)   tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

/********************************************* traitement produits base SQL ******************************/	

                    } 
                } 
                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId\n");
                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

     } catch (MarketplaceWebServiceOrders_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
     }
 }
            
