<?php
if (!class_exists('DateTime')) {
class DateTime {
    public $date;
   
    public function __construct($date) {
        $this->date = strtotime($date);
    }
   
    public function setTimeZone($timezone) {
        return;
    }
   
    private function __getDate() {
        return date(DATE_ATOM, $this->date);   
    }
   
    public function modify($multiplier) {
        $this->date = strtotime($this->__getDate() . ' ' . $multiplier);
    }
   
    public function format($format) {
        return date($format, $this->date);
    }
}
}

/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2009 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2009-01-01
 */
/******************************************************************************* 

 *  Marketplace Web Service PHP5 Library
 *  Generated: Thu May 07 13:07:36 PDT 2009
 * 
 */

/**
 * Submit Feed  Sample
 */

include_once ('.config.inc.php'); 

/************************************************************************
* Uncomment to configure the client instance. Configuration settings
* are:
*
* - MWS endpoint URL
* - Proxy host and port.
* - MaxErrorRetry.
***********************************************************************/
// IMPORTANT: Uncomment the approiate line for the country you wish to
// sell in:
// United States:
//$serviceUrl = "https://mws.amazonservices.com";
// United Kingdom
//$serviceUrl = "https://mws.amazonservices.co.uk";
// Germany
//$serviceUrl = "https://mws.amazonservices.de";
// France
$serviceUrl = "https://mws.amazonservices.fr";
// Italy
//$serviceUrl = "https://mws.amazonservices.it";
// Japan
//$serviceUrl = "https://mws.amazonservices.jp";
// China
//$serviceUrl = "https://mws.amazonservices.com.cn";
// Canada
//$serviceUrl = "https://mws.amazonservices.ca";
// India
//$serviceUrl = "https://mws.amazonservices.in";

$config = array (
  'ServiceURL' => $serviceUrl,
  'ProxyHost' => null,
  'ProxyPort' => -1,
  'MaxErrorRetry' => 3,
);

/************************************************************************
 * Instantiate Implementation of MarketplaceWebService
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
 $service = new MarketplaceWebService_Client(
     AWS_ACCESS_KEY_ID, 
     AWS_SECRET_ACCESS_KEY, 
     $config,
     APPLICATION_NAME,
     APPLICATION_VERSION);
 
/************************************************************************
 * Uncomment to try out Mock Service that simulates MarketplaceWebService
 * responses without calling MarketplaceWebService service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under MarketplaceWebService/Mock tree
 *
 ***********************************************************************/
 // $service = new MarketplaceWebService_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for Submit Feed Action
 ***********************************************************************/
 // @TODO: set request. Action can be passed as MarketplaceWebService_Model_SubmitFeedRequest
 // object or array of parameters

// Note that PHP memory streams have a default limit of 2M before switching to disk. While you
// can set the limit higher to accomidate your feed in memory, it's recommended that you store
// your feed on disk and use traditional file streams to submit your feeds. For conciseness, this
// examples uses a memory stream.




/**************************************************************** traitement produits ******************************************************/

//  Header( 'Content-Type: text/xml' ); 
  define ('DISPLAY_PRICE_WITH_TAX', true);

  define ('DEFAULT_CURRENCY','EUR');

  require('import_top_special.php');
 // require('../../includes/application_top.php');

$string='';
$info_string = '<table border="1" width="100%" cellspacing="0" cellpadding="2" style="	font-family: Arial, Helvetica, sans-serif;font-size:10px;">';
  // On vrifie la langue utilise dans le catalogue
  $language_code = (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) ? $HTTP_GET_VARS['language'] : DEFAULT_LANGUAGE;

// langue Francais
$languages_id=1;

  // Requte pour identifier les catgories existantes dans le catalogue
  $included_categories_query = tep_db_query("SELECT c.categories_id, c.parent_id, cd.categories_name FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd 

WHERE 

c.categories_id = cd.categories_id 

AND cd.language_id = FLOOR($languages_id)

");

  $inc_cat = array();

  // Identification du nom de la catgorie, et l'id de la catgorie parent
  while ($included_categories = tep_db_fetch_array($included_categories_query)) {
  $inc_cat[] = array (
     'id' => $included_categories['categories_id'],
     'parent' => $included_categories['parent_id'],
     'name' => $included_categories['categories_name']);
  }

  $cat_info = array();
  for ($i=0; $i < sizeof($inc_cat); $i++)
    $cat_info[$inc_cat[$i]['id']] = array (
    'parent'=> $inc_cat[$i]['parent'],
    'name'  => $inc_cat[$i]['name'],
    'path'  => $inc_cat[$i]['id'],
    'link'  => '' );

  for ($i=0; $i < sizeof($inc_cat); $i++) {
  $cat_id = $inc_cat[$i]['id'];
  while ($cat_info[$cat_id]['parent'] != 0){
    $cat_info[$inc_cat[$i]['id']]['path'] = $cat_info[$cat_id]['parent'] . '_' . $cat_info[$inc_cat[$i]['id']]['path'];
    $cat_id = $cat_info[$cat_id]['parent'];
    }
  $link_array = split('_', $cat_info[$inc_cat[$i]['id']] ['path']);
  for ($j=0; $j < sizeof($link_array); $j++) {
    $cat_info[$inc_cat[$i]['id']]['link'] .= '&nbsp;<a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $cat_info[$link_array[$j]]['path']) . '"><nobr>' . $cat_info[$link_array[$j]]['name'] . '</nobr></a>&nbsp;&raquo;&nbsp;';
    }
  }

  // Requte identifiant les produits disponibles dans le catalogue


//AND pc.categories_id <> '505830'
//AND pc.categories_id <> '707860'
//AND pc.categories_id <> '505840'

  $products_query = tep_db_query("SELECT p.*, pd.products_name, pd.products_description, pc.categories_id, pcat.categorie_id_amazon_fr ,pcatdesc.categories_name  FROM " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS_TO_CATEGORIES . " pc , " . TABLE_CATEGORIES . " pcat , " . TABLE_CATEGORIES_DESCRIPTION . " pcatdesc 

WHERE 
p.products_id = pd.products_id 

AND p.products_id = pc.products_id 
AND pc.categories_id = pcat.categories_id
AND pc.categories_id = pcatdesc.categories_id
AND pcatdesc.language_id  = FLOOR($languages_id)

AND 
  (pc.categories_id = '17'
OR pc.categories_id = '80'
OR pc.categories_id = '82'
OR pc.categories_id = '76'
OR pc.categories_id = '77'
OR pc.categories_id = '81'
OR pc.categories_id = '75'
OR pc.categories_id = '79'
OR pc.categories_id = '78'
OR pc.categories_id = '16'
OR pc.categories_id = '146'

OR pc.categories_id = '95'
)





AND pd.language_id = FLOOR($languages_id) 

ORDER BY pc.categories_id, pd.products_name");

  $product_num = 0;
  $liste_produits='';

  while($products = tep_db_fetch_array($products_query)) {

  if (intval($products['manufacturers_id']) > 0) {
  	$manufacturers_query = tep_db_query("SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS_INFO . " WHERE manufacturers_id = " . $products['manufacturers_id'] ." and languages_id = ".FLOOR($languages_id));
  	$manufacturers_result = tep_db_fetch_array($manufacturers_query);
  	$products['manufacturers_name'] = $manufacturers_result['manufacturers_name'];
 }

  $special_query = tep_db_query("SELECT specials_new_products_price  FROM " . TABLE_SPECIALS . " WHERE products_id = " . $products['products_id'] ." AND status = 1 ");
  if ($special_result = tep_db_fetch_array($special_query))
  	$products['products_price'] = $special_result['specials_new_products_price'];

$prixprod =tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));
$description = substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,2000);
$nom_produit = html_entity_decode($products['products_name']);

//$prix_marketplace =  round(tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']))*1.22,2);
//$prix_marketplace = tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));

$prix_marketplace = round((($products['products_price']) * (1+(tep_get_tax_rate($products['products_tax_class_id'])/100))) *1.15,2);

$qty = $products['products_quantity'];

 if (( strlen($products['products_ean']) == 13 ) 
    && ( $products['categorie_id_amazon_fr'] <> 0 )

	)
{
//////////////////////////////

  $product_num++;

if ($qty <= 0 ) { 
					$qty =0;
					$update_or_delete="Delete";
				} else {
					$update_or_delete="Update";
						}


  $info_string.= 	
					"<tr><td width=50>". 
					"<font color=red>". 
					"" . $products['products_id'] . 
					"</font>". 
					"</td><td width=130>". 
					"ean : " . $products['products_ean'] .
					"</td><td width=70>".  
					"<font color=red><b>". 
					"" . $prix_marketplace . 	"</b></font>  | q : ".  $qty .
					"" .  
					"</td><td width=100>". 
					"<font color=red><b>". 
					"node : " . $products['categorie_id_amazon_fr'] . 
					"</b></font>". 
					"</td><td>". 
					"" . $description . 
					"</td>".
					"<td width=200>". 
					"cat CB: " . $products['categories_id'] . "<font color=red><b>  " . $products['categories_name'] . "<font color=red><b>".
					"</td></tr>";

  $string.= '<offer>';
  $string.= '<product_reference type="Ean"><![CDATA['. $products['products_ean'] .']]></product_reference>';
  $string.= '<offer_reference type="SellerSku"><![CDATA['. $products['products_id'] .']]></offer_reference>';
  $string.= '<price><![CDATA['. $prix_marketplace .']]></price>';
  $string.= '<product_state>11</product_state>';
  $string.= '<quantity><![CDATA['.$qty.']]></quantity>';
  $string.= '<description><![CDATA['. substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,250) .'.]]></description>';
  $string.= '<internal_comment></internal_comment>';
  $string.= '<showcase><![CDATA[100]]></showcase>';



/************************************** frais de transport **************************************/
/************************************** pour les market place ***********************************/



		$prix_transport = (5.4347  + (floatval($products['products_weight']) * 3));
	//	echo round($prix_transport,2) ;


if ( $products['products_image_med'] == '' ){ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image'] ; }
else{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image_med'] ; }
	

$productType= "FurnitureAndDecor";

/************************************** frais de transport FIN ***********************************/
  

/********************************************************  produits ********************************************************************/


$sku=$products['products_ean'];
$product_id=$products['products_ean'];
$product_id_type='EAN';
$product_name=filter_text($nom_produit);
$brand=filter_text($products['manufacturers_name']);
$manufacturer=filter_text($products['manufacturers_name']);
$product_description=filter_text($description);
$bullet_point1=filter_text($nom_produit);
$bullet_point2='';
$bullet_point3='';
$bullet_point4='';
$bullet_point5='';
$recommended_browse_node1=$products['categorie_id_amazon_fr'];
$recommended_browse_node2='';
$clothing_type='Accessory';
$item_price=$prix_marketplace;
$currency='EUR';
$quantity=$qty;
$condition_type='New';
$condition_note='Vendeur professionnel, livraison rapide et soigne.';
$country_of_origin='Fr';
$country_name='';
$sale_price='';
$sale_from_date='';
$sale_through_date='';
$rebate_name1_rebate_name2='';
$rebate_message1_rebate_message2='';
$rebate_start_date1='';
$rebate_start_date2='';
$rebate_end_date1='';
$rebate_end_date2='';
$mfr_part_number='';
$search_terms1=filter_text($products['manufacturers_name']);
$search_terms2='';
$search_terms3='';
$search_terms4='';
$search_terms5='';
$platinum_keywords1='';
$platinum_keywords2='';
$platinum_keywords3='';
$platinum_keywords4='';
$platinum_keywords5='';
$main_image_url=$image;
$other_image_url1='';
$other_image_url2='';
$other_image_url3='';
$other_image_url4='';
$other_image_url5='';
$other_image_url6='';
$other_image_url7='';
$other_image_url8='';
$swatch_image_url='';
$fulfillment_center_id='';
$package_height='';
$package_width='';
$package_length='';
$package_length_unit_of_measure='';
$package_weight='';
$package_weight_unit_of_measure='';
$parent_child='';
$parent_sku='';
$relationship_type='';
$variation_theme='';
$color='multicolore';
$color_map='';
$size='';
$apparel_closure_type='';
$laptop_capacity='';
$belt_style='';
$bottom_style='';
$button_quantity='';
$care_instructions='';
$external_testing_certification1_external_testing_certification5='';
$character='';
$chest_size='';
$chest_size_unit_of_measure='';
$collar_type='';
$control_type='';
$cuff_type='';
$cup_size='';
$department1='Mixte adulte';
$department2='';
$department3='';
$department4='';
$department5='';
$fabric_type='';
$fabric_wash='';
$fit_type='';
$front_pleat_type='';
$heel_height='';
$heel_height_unit_of_measure='';
$heel_type='';
$inner_material='';
$inseam_length='';
$inseam_length_unit_of_measure='';
$item_rise='';
$item_rise_unit_of_measure='';
$item_package_quantity='';
$leg_style='';
$leg_diameter='';
$material_composition='';
$material_type='';
$opacity='';
$model_name='';
$model_number='';
$model_year='';
$neck_size='';
$neck_size_unit_of_measure='';
$neck_style='';
$number_of_items='';
$occasion_lifestyle1='';
$occasion_lifestyle2='';
$occasion_lifestyle3='';
$occasion_lifestyle4='';
$occasion_lifestyle5='';
$outer_material='Textile et synthtique';
$performance_rating1='';
$performance_rating2='';
$performance_rating3='';
$pattern_style='';
$pocket_description='';
$rise_style='';
$season='';
$shaft_diameter='';
$shaft_height='';
$shoe_closure_type='';
$shoe_width='';
$size_map='';
$size_modifier='';
$sleeve_length='';
$sleeve_length_unit_of_measure='';
$sleeve_type='';
$sole_material='';
$special_feature1='';
$special_feature2='';
$specific_uses1='';
$specific_uses2='';
$specific_uses3='';
$strap_type='';
$style_keyword1='';
$style_keyword2='';
$style_keyword3='';
$style_keyword4='';
$style_keyword5='';
$style_name='';
$theme='';
$toe_shape='';
$top_style='';
$underwire_type='';
$waist_size='';
$waist_size_unit_of_measure='';
$waist_style='';
$water_resistance_level='';
$wheel_type='';
$legal_disclaimer='';
$safety_warning='';
$mfr_warranty_description_type='';
$mfr_warranty_description_labor='';
$mfr_warranty_description_parts='';
$seller_warranty_description='';
$shipping_weight=$products['products_weight'];
$shipping_weight_unit_measure='KG';
$item_length='';
$item_length_unit_of_measure='';
$item_width='';
$item_height='';
$item_weight='';
$item_weight_unit_of_measure='';
$display_weight='';
$display_weight_unit_of_measure='';
$display_volume='';
$display_volume_unit_of_measure='';
$display_length='';
$display_length_unit_of_measure='';
$product_tax_code='';
$launch_date='';
$release_date='';
$leadtime_to_ship='2';
$restock_date='';
$max_aggregate_ship_quantity='';
$is_gift_message_available='';
$is_gift_wrap_available='';
$is_discontinued_by_manufacturer='';
$registered_parameter='';
$update_delete=$update_or_delete;



$line = $sku . chr(9);
$line.= $product_id . chr(9);
$line.= $product_id_type . chr(9);
$line.= $product_name . chr(9);
$line.= $brand . chr(9);
$line.= $manufacturer . chr(9);
$line.= $product_description . chr(9);
$line.= $bullet_point1 . chr(9);
$line.= $bullet_point2 . chr(9);
$line.= $bullet_point3 . chr(9);
$line.= $bullet_point4 . chr(9);
$line.= $bullet_point5 . chr(9);
$line.= $recommended_browse_node1 . chr(9);
$line.= $recommended_browse_node2 . chr(9);
$line.= $clothing_type . chr(9);
$line.= $item_price . chr(9);
$line.= $currency . chr(9);
$line.= $quantity . chr(9);
$line.= $condition_type . chr(9);
$line.= $condition_note . chr(9);
$line.= $country_of_origin . chr(9);
$line.= $country_name . chr(9);
$line.= $sale_price . chr(9);
$line.= $sale_from_date . chr(9);
$line.= $sale_through_date . chr(9);
$line.= $rebate_name1_rebate_name2 . chr(9);
$line.= $rebate_message1_rebate_message2 . chr(9);
$line.= $rebate_start_date1 . chr(9);
$line.= $rebate_start_date2 . chr(9);
$line.= $rebate_end_date1 . chr(9);
$line.= $rebate_end_date2 . chr(9);
$line.= $mfr_part_number . chr(9);
$line.= $search_terms1 . chr(9);
$line.= $search_terms2 . chr(9);
$line.= $search_terms3 . chr(9);
$line.= $search_terms4 . chr(9);
$line.= $search_terms5 . chr(9);
$line.= $platinum_keywords1 . chr(9);
$line.= $platinum_keywords2 . chr(9);
$line.= $platinum_keywords3 . chr(9);
$line.= $platinum_keywords4 . chr(9);
$line.= $platinum_keywords5 . chr(9);
$line.= $main_image_url . chr(9);
$line.= $other_image_url1 . chr(9);
$line.= $other_image_url2 . chr(9);
$line.= $other_image_url3 . chr(9);
$line.= $other_image_url4 . chr(9);
$line.= $other_image_url5 . chr(9);
$line.= $other_image_url6 . chr(9);
$line.= $other_image_url7 . chr(9);
$line.= $other_image_url8 . chr(9);
$line.= $swatch_image_url . chr(9);
$line.= $fulfillment_center_id . chr(9);
$line.= $package_height . chr(9);
$line.= $package_width . chr(9);
$line.= $package_length . chr(9);
$line.= $package_length_unit_of_measure . chr(9);
$line.= $package_weight . chr(9);
$line.= $package_weight_unit_of_measure . chr(9);
$line.= $parent_child . chr(9);
$line.= $parent_sku . chr(9);
$line.= $relationship_type . chr(9);
$line.= $variation_theme . chr(9);
$line.= $color . chr(9);
$line.= $color_map . chr(9);
$line.= $size . chr(9);
$line.= $apparel_closure_type . chr(9);
$line.= $laptop_capacity . chr(9);
$line.= $belt_style . chr(9);
$line.= $bottom_style . chr(9);
$line.= $button_quantity . chr(9);
$line.= $care_instructions . chr(9);
$line.= $external_testing_certification1_external_testing_certification5 . chr(9);
$line.= $character . chr(9);
$line.= $chest_size . chr(9);
$line.= $chest_size_unit_of_measure . chr(9);
$line.= $collar_type . chr(9);
$line.= $control_type . chr(9);
$line.= $cuff_type . chr(9);
$line.= $cup_size . chr(9);
$line.= $department1 . chr(9);
$line.= $department2 . chr(9);
$line.= $department3 . chr(9);
$line.= $department4 . chr(9);
$line.= $department5 . chr(9);
$line.= $fabric_type . chr(9);
$line.= $fabric_wash . chr(9);
$line.= $fit_type . chr(9);
$line.= $front_pleat_type . chr(9);
$line.= $heel_height . chr(9);
$line.= $heel_height_unit_of_measure . chr(9);
$line.= $heel_type . chr(9);
$line.= $inner_material . chr(9);
$line.= $inseam_length . chr(9);
$line.= $inseam_length_unit_of_measure . chr(9);
$line.= $item_rise . chr(9);
$line.= $item_rise_unit_of_measure . chr(9);
$line.= $item_package_quantity . chr(9);
$line.= $leg_style . chr(9);
$line.= $leg_diameter . chr(9);
$line.= $material_composition . chr(9);
$line.= $material_type . chr(9);
$line.= $opacity . chr(9);
$line.= $model_name . chr(9);
$line.= $model_number . chr(9);
$line.= $model_year . chr(9);
$line.= $neck_size . chr(9);
$line.= $neck_size_unit_of_measure . chr(9);
$line.= $neck_style . chr(9);
$line.= $number_of_items . chr(9);
$line.= $occasion_lifestyle1 . chr(9);
$line.= $occasion_lifestyle2 . chr(9);
$line.= $occasion_lifestyle3 . chr(9);
$line.= $occasion_lifestyle4 . chr(9);
$line.= $occasion_lifestyle5 . chr(9);
$line.= $outer_material . chr(9);
$line.= $performance_rating1 . chr(9);
$line.= $performance_rating2 . chr(9);
$line.= $performance_rating3 . chr(9);
$line.= $pattern_style . chr(9);
$line.= $pocket_description . chr(9);
$line.= $rise_style . chr(9);
$line.= $season . chr(9);
$line.= $shaft_diameter . chr(9);
$line.= $shaft_height . chr(9);
$line.= $shoe_closure_type . chr(9);
$line.= $shoe_width . chr(9);
$line.= $size_map . chr(9);
$line.= $size_modifier . chr(9);
$line.= $sleeve_length . chr(9);
$line.= $sleeve_length_unit_of_measure . chr(9);
$line.= $sleeve_type . chr(9);
$line.= $sole_material . chr(9);
$line.= $special_feature1 . chr(9);
$line.= $special_feature2 . chr(9);
$line.= $specific_uses1 . chr(9);
$line.= $specific_uses2 . chr(9);
$line.= $specific_uses3 . chr(9);
$line.= $strap_type . chr(9);
$line.= $style_keyword1 . chr(9);
$line.= $style_keyword2 . chr(9);
$line.= $style_keyword3 . chr(9);
$line.= $style_keyword4 . chr(9);
$line.= $style_keyword5 . chr(9);
$line.= $style_name . chr(9);
$line.= $theme . chr(9);
$line.= $toe_shape . chr(9);
$line.= $top_style . chr(9);
$line.= $underwire_type . chr(9);
$line.= $waist_size . chr(9);
$line.= $waist_size_unit_of_measure . chr(9);
$line.= $waist_style . chr(9);
$line.= $water_resistance_level . chr(9);
$line.= $wheel_type . chr(9);
$line.= $legal_disclaimer . chr(9);
$line.= $safety_warning . chr(9);
$line.= $mfr_warranty_description_type . chr(9);
$line.= $mfr_warranty_description_labor . chr(9);
$line.= $mfr_warranty_description_parts . chr(9);
$line.= $seller_warranty_description . chr(9);
$line.= $shipping_weight . chr(9);
$line.= $shipping_weight_unit_measure . chr(9);
$line.= $item_length . chr(9);
$line.= $item_length_unit_of_measure . chr(9);
$line.= $item_width . chr(9);
$line.= $item_height . chr(9);
$line.= $item_weight . chr(9);
$line.= $item_weight_unit_of_measure . chr(9);
$line.= $display_weight . chr(9);
$line.= $display_weight_unit_of_measure . chr(9);
$line.= $display_volume . chr(9);
$line.= $display_volume_unit_of_measure . chr(9);
$line.= $display_length . chr(9);
$line.= $display_length_unit_of_measure . chr(9);
$line.= $product_tax_code . chr(9);
$line.= $launch_date . chr(9);
$line.= $release_date . chr(9);
$line.= $leadtime_to_ship . chr(9);
$line.= $restock_date . chr(9);
$line.= $max_aggregate_ship_quantity . chr(9);
$line.= $is_gift_message_available . chr(9);
$line.= $is_gift_wrap_available . chr(9);
$line.= $is_discontinued_by_manufacturer . chr(9);
$line.= $registered_parameter . chr(9);
$line.= $update_delete . chr(9);

$line.= chr(13).chr(10);

$liste_produits .= $line;



/********************************************************  produits ********************************************************************/


////////////////produits suprieur  15 euro ///////////////
}// fin if is ( tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id'])) >= 15 ) {
//////////////////////////////
  }
$info_string.='</table>';
echo $info_string;
/******************************************************** Fin traitement de produits ********************************************************************/




$feed = "";

$feed = <<<EOD
TemplateType=Clothing	Version=1.4	This row for Amazon.com use only.  Do not modify or delete.													Offer Information - These attributes are required to make your item buyable for customers on the site							Sales Price & Rebate information - for a sales promotion you can specify a reduced price with these attributes.											Item discovery information - These attributes have an effect on how customers can find your product on the site.											Image Information - see Image Info tab for details.										FBA - make use of these columns if you are participating in the 
sku	product-id	product-id-type	product-name	brand	manufacturer	product-description	bullet-point1	bullet-point2	bullet-point3	bullet-point4	bullet-point5	recommended-browse-node1	recommended-browse-node2	clothing-type	item-price	currency	quantity	condition-type	condition-note	country-of-origin	country-name	sale-price	sale-from-date	sale-through-date	rebate-name1 -rebate-name2	rebate-message1 -rebate-message2	rebate-start-date1	rebate-start-date2	rebate-end-date1	rebate-end-date2	mfr-part-number	search-terms1	search-terms2	search-terms3	search-terms4	search-terms5	platinum-keywords1	platinum-keywords2	platinum-keywords3	platinum-keywords4	platinum-keywords5	main-image-url	other-image-url1	other-image-url2	other-image-url3	other-image-url4	other-image-url5	other-image-url6	other-image-url7	other-image-url8	swatch-image-url	fulfillment-center-id	package-height	package-width	package-length	package-length-unit-of-measure	package-weight	package-weight-unit-of-measure	parent-child	parent-sku	relationship-type	variation-theme	color	color-map	size	apparel-closure-type	laptop-capacity	belt-style	bottom-style	button-quantity	care-instructions	external-testing-certification1-external-testing-certification5	character	chest-size	chest-size-unit-of-measure	collar-type	control-type	cuff-type	cup-size	department1	department2	department3	department4	department5	fabric-type	fabric-wash	fit-type	front-pleat-type	heel-height	heel-height-unit-of-measure	heel-type	inner-material	inseam-length	inseam-length-unit-of-measure	item-rise	item-rise-unit-of-measure	item-package-quantity	leg-style	leg-diameter	material-composition	material-type	opacity	model-name	model-number	model-year	neck-size	neck-size-unit-of-measure	neck-style	number-of-items	occasion-lifestyle1	occasion-lifestyle2	occasion-lifestyle3	occasion-lifestyle4	occasion-lifestyle5	outer-material	performance-rating1	performance-rating2	performance-rating3	pattern-style	pocket-description	rise-style	season	shaft-diameter	shaft-height	shoe-closure-type	shoe-width	size-map	size-modifier	sleeve-length	sleeve-length-unit-of-measure	sleeve-type	sole-material	special-feature1	special-feature2	specific-uses1	specific-uses2	specific-uses3	strap-type	style-keyword1	style-keyword2	style-keyword3	style-keyword4	style-keyword5	style-name	theme	toe-shape	top-style	underwire-type	waist-size	waist-size-unit-of-measure	waist-style	water-resistance-level	wheel-type	legal-disclaimer	safety-warning	mfr-warranty-description-type	mfr-warranty-description-labor	mfr-warranty-description-parts	seller-warranty-description	shipping-weight	shipping-weight-unit-measure	item-length	item-length-unit-of-measure	item-width	item-height	item-weight	item-weight-unit-of-measure	display-weight	display-weight-unit-of-measure	display-volume	display-volume-unit-of-measure	display-length	display-length-unit-of-measure	product-tax-code	launch-date	release-date	leadtime-to-ship	restock-date	max-aggregate-ship-quantity	is-gift-message-available	is-gift-wrap-available	is-discontinued-by-manufacturer	registered-parameter	update-delete	
$liste_produits
EOD;

// Constructing the MarketplaceId array which will be passed in as the the MarketplaceIdList 
// parameter to the SubmitFeedRequest object.
//$marketplaceIdArray = array("Id" => array('<Marketplace_Id_1>','<Marketplace_Id_2>'));
$marketplaceIdArray = array("Id" => array('A13V1IB3VIYZZH'));
     
 // MWS request objects can be constructed two ways: either passing an array containing the 
 // required request parameters into the request constructor, or by individually setting the request
 // parameters via setter methods.
 // Uncomment one of the methods below.
 

/********* Begin Comment Block *********/
//$feedHandle = fopen('php://memory', 'rw+');
//$feedHandle = fopen('php://memory', 'rw+');

$feedHandle = fopen('amazon-chaussures-access-fr.txt', 'w+');


echo "<hr>";
fwrite($feedHandle, $feed);
rewind($feedHandle);


//$feedHandle = @fopen('php://memory', 'rw+');
//fwrite($feedHandle, $fileContent);
rewind($feedHandle);
$parameters = array (
'Marketplace' => MARKETPLACE_ID,
'Merchant' => MERCHANT_ID,
'FeedType' => '_POST_FLAT_FILE_LISTINGS_DATA_',
'FeedContent' => $feedHandle,

'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true)),
);

$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);

/********* End Comment Block *********/

 invokeSubmitFeed($service, $request); // appel pour transmettre le fichier

echo "<hr>";
echo "<pre>";
print_r($request);
echo "</pre>";


@fclose($feedHandle);
                                        
/**
  * Submit Feed Action Sample
  * Uploads a file for processing together with the necessary
  * metadata to process the file, such as which type of feed it is.
  * PurgeAndReplace if true means that your existing e.g. inventory is
  * wiped out and replace with the contents of this feed - use with
  * caution (the default is false).
  *   
  * @param MarketplaceWebService_Interface $service instance of MarketplaceWebService_Interface
  * @param mixed $request MarketplaceWebService_Model_SubmitFeed or array of parameters
  */
  function invokeSubmitFeed(MarketplaceWebService_Interface $service, $request) 
  {
      try {
              $response = $service->submitFeed($request);
              

echo "<hr>response";
echo "<pre>";
 print_r($response);
echo "</pre>";
echo "<hr>";
                echo ("Service Response\n");
                echo ("=============================================================================\n");

                echo("        SubmitFeedResponse\n");

                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId\n");
                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

                echo("ResponseHeaderMetadata: " . $response->getResponseHeaderMetadata() . "\n");
     } catch (MarketplaceWebService_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
         echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
     }
 }
             
function filter_text($CatList) {
  $CatList = html_entity_decode ($CatList);
  $CatList = strip_tags ($CatList);
  $CatList = trim ($CatList);
  // $CatList = strtolower ($CatList);
  $CatList = str_replace("&nbsp;","",$CatList);
  $CatList = str_replace("&#39;","'",$CatList);
  $CatList = str_replace("&#150;","-",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("&eacute;","e",$CatList);
  $CatList = str_replace("&agrave;","",$CatList);
  $CatList = str_replace("&egrave;","e",$CatList);

  $CatList = str_replace("&nbsp","",$CatList);
  $CatList = str_replace("&#39","'",$CatList);
  $CatList = str_replace("&#150","-",$CatList);
  $CatList = str_replace("&eacute","e",$CatList);
  $CatList = str_replace("&agrave","",$CatList);
  $CatList = str_replace("&egrave","e",$CatList);
  $CatList = str_replace("&hellip","...",$CatList);
  $CatList = str_replace("&rsquo","'",$CatList);

  $CatList = str_replace("&ecirc;;","e",$CatList);
//  $CatList = str_replace(";"," ",$CatList);

  $CatList = str_replace("","i",$CatList);
  $CatList = str_replace(""," graden",$CatList);
  $CatList = str_replace("","'",$CatList);
  $CatList = str_replace("","'",$CatList);
  $CatList = str_replace('"',' ',$CatList);
  $CatList = str_replace(chr(9)," ",$CatList); 
  $CatList = str_replace(chr(10)," ",$CatList);
  $CatList = str_replace(chr(13)," ",$CatList);
  $CatList = preg_replace("[<(.*?)>]","",$CatList);
//  if (strlen($CatList) > $length) {
//    $CatList = substr($CatList, 0, $length-3) . "";
//  }
  return $CatList;  
} // function for the filter
                 