<?php



/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2009 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2009-01-01
 */
/******************************************************************************* 

 *  Marketplace Web Service PHP5 Library
 *  Generated: Thu May 07 13:07:36 PDT 2009
 * 
 */

/**
 * Submit Feed  Sample
 */

include_once ('.config.inc.php'); 
include_once ('fonctions_amazon.php'); 

envoie_fichier('Home');

function envoie_fichier($template){
					/************************************************************************
					* Uncomment to configure the client instance. Configuration settings
					* are:
					*
					* - MWS endpoint URL
					* - Proxy host and port.
					* - MaxErrorRetry.
					***********************************************************************/
					// IMPORTANT: Uncomment the approiate line for the country you wish to
					// sell in:
					// United States:
					//$serviceUrl = "https://mws.amazonservices.com";
					// United Kingdom
					//$serviceUrl = "https://mws.amazonservices.co.uk";
					// Germany
					//$serviceUrl = "https://mws.amazonservices.de";
					// France
					$serviceUrl = "https://mws.amazonservices.fr";
					// Italy
					//$serviceUrl = "https://mws.amazonservices.it";
					// Japan
					//$serviceUrl = "https://mws.amazonservices.jp";
					// China
					//$serviceUrl = "https://mws.amazonservices.com.cn";
					// Canada
					//$serviceUrl = "https://mws.amazonservices.ca";
					// India
					//$serviceUrl = "https://mws.amazonservices.in";
					
					$config = array (
					  'ServiceURL' => $serviceUrl,
					  'ProxyHost' => null,
					  'ProxyPort' => -1,
					  'MaxErrorRetry' => 3,
					);
					
					/************************************************************************
					 * Instantiate Implementation of MarketplaceWebService
					 * 
					 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
					 * are defined in the .config.inc.php located in the same 
					 * directory as this sample
					 ***********************************************************************/
					 $service = new MarketplaceWebService_Client(
					     AWS_ACCESS_KEY_ID, 
					     AWS_SECRET_ACCESS_KEY, 
					     $config,
					     APPLICATION_NAME,
					     APPLICATION_VERSION);
					 
					/************************************************************************
					 * Uncomment to try out Mock Service that simulates MarketplaceWebService
					 * responses without calling MarketplaceWebService service.
					 *
					 * Responses are loaded from local XML files. You can tweak XML files to
					 * experiment with various outputs during development
					 *
					 * XML files available under MarketplaceWebService/Mock tree
					 *
					 ***********************************************************************/
					 // $service = new MarketplaceWebService_Mock();
					
					/************************************************************************
					 * Setup request parameters and uncomment invoke to try out 
					 * sample for Submit Feed Action
					 ***********************************************************************/
					 // @TODO: set request. Action can be passed as MarketplaceWebService_Model_SubmitFeedRequest
					 // object or array of parameters
					
					// Note that PHP memory streams have a default limit of 2M before switching to disk. While you
					// can set the limit higher to accomidate your feed in memory, it's recommended that you store
					// your feed on disk and use traditional file streams to submit your feeds. For conciseness, this
					// examples uses a memory stream.
					
					
					
					
					/**************************************************************** traitement produits ******************************************************/
					
					//  Header( 'Content-Type: text/xml' ); 
					  define ('DISPLAY_PRICE_WITH_TAX', true);
					
					  define ('DEFAULT_CURRENCY','EUR');
					
					  require('import_top_special.php');
					 // require('../../includes/application_top.php');
					
					$string='';
					$info_string = '<table border="1" width="100%" cellspacing="0" cellpadding="2" style="	font-family: Arial, Helvetica, sans-serif;font-size:10px;">';
					  // On vrifie la langue utilise dans le catalogue
					  $language_code = (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) ? $HTTP_GET_VARS['language'] : DEFAULT_LANGUAGE;
					
					// langue Francais
					$languages_id=1;
					
					  // Requte pour identifier les catgories existantes dans le catalogue
					  $included_categories_query = tep_db_query("SELECT c.categories_id, c.parent_id, cd.categories_name FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd 
					
					WHERE 
					
					c.categories_id = cd.categories_id 
					
					AND cd.language_id = FLOOR($languages_id)
					
					");
					
					  $inc_cat = array();
					
					  // Identification du nom de la catgorie, et l'id de la catgorie parent
					  while ($included_categories = tep_db_fetch_array($included_categories_query)) {
					  $inc_cat[] = array (
					     'id' => $included_categories['categories_id'],
					     'parent' => $included_categories['parent_id'],
					     'name' => $included_categories['categories_name']);
					  }
					
					  $cat_info = array();
					  for ($i=0; $i < sizeof($inc_cat); $i++)
					    $cat_info[$inc_cat[$i]['id']] = array (
					    'parent'=> $inc_cat[$i]['parent'],
					    'name'  => $inc_cat[$i]['name'],
					    'path'  => $inc_cat[$i]['id'],
					    'link'  => '' );
					
					  for ($i=0; $i < sizeof($inc_cat); $i++) {
					  $cat_id = $inc_cat[$i]['id'];
					  while ($cat_info[$cat_id]['parent'] != 0){
					    $cat_info[$inc_cat[$i]['id']]['path'] = $cat_info[$cat_id]['parent'] . '_' . $cat_info[$inc_cat[$i]['id']]['path'];
					    $cat_id = $cat_info[$cat_id]['parent'];
					    }
					  $link_array = split('_', $cat_info[$inc_cat[$i]['id']] ['path']);
					  for ($j=0; $j < sizeof($link_array); $j++) {
					    $cat_info[$inc_cat[$i]['id']]['link'] .= '&nbsp;<a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $cat_info[$link_array[$j]]['path']) . '"><nobr>' . $cat_info[$link_array[$j]]['name'] . '</nobr></a>&nbsp;&raquo;&nbsp;';
					    }
					  }
					
					  // Requte identifiant les produits disponibles dans le catalogue
					
					
					//AND pc.categories_id <> '505830'
					//AND pc.categories_id <> '707860'
					//AND pc.categories_id <> '505840'
					
					// AND p.products_id = '3831' ;
					
					  $products_query = tep_db_query("SELECT 	p.*, 
																pd.products_name, 
																pd.products_description, 
																pc.categories_id, 
																pcat.categorie_productType_amazon_fr , 
																pcat.categorie_id_amazon_fr ,
																pcatdesc.categories_name  FROM " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS_TO_CATEGORIES . " pc , " . TABLE_CATEGORIES . " pcat , " . TABLE_CATEGORIES_DESCRIPTION . " pcatdesc 
					
					
					WHERE 
					p.products_id = pd.products_id 
					
					AND p.products_id = pc.products_id 
					AND pc.categories_id = pcat.categories_id
					AND pc.categories_id = pcatdesc.categories_id
					AND pcatdesc.language_id  = FLOOR($languages_id)
					
					AND pcat.amazon_template_alias = '". $template ."'
					
					
					AND pd.language_id = FLOOR($languages_id) 
					
					ORDER BY pc.categories_id, pd.products_name");
					
					  $product_num = 0;
					  $liste_produits='';
					
					  while($products = tep_db_fetch_array($products_query)) {
					
					  if (intval($products['manufacturers_id']) > 0) {
					  	$manufacturers_query = tep_db_query("SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS_INFO . " WHERE manufacturers_id = " . $products['manufacturers_id'] ." and languages_id = ".FLOOR($languages_id));
					  	$manufacturers_result = tep_db_fetch_array($manufacturers_query);
					  	$products['manufacturers_name'] = $manufacturers_result['manufacturers_name'];
					 }
					
					  $special_query = tep_db_query("SELECT specials_new_products_price  FROM " . TABLE_SPECIALS . " WHERE products_id = " . $products['products_id'] ." AND status = 1 ");
					  if ($special_result = tep_db_fetch_array($special_query))
					  	$products['products_price'] = $special_result['specials_new_products_price'];
					
					$prixprod =tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));
					//$description = substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,2000);
					$description = netoyage_html_utf8($products['products_description'],2000);
					$nom_produit = html_entity_decode($products['products_name']);
					
					//$prix_marketplace =  round(tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']))*1.22,2);
					//$prix_marketplace = tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));
					
					$prix_marketplace = round((($products['products_price']) * (1+(tep_get_tax_rate($products['products_tax_class_id'])/100))) *1.15,2);
					
					$qty = $products['products_quantity'];
					
					 if (( strlen($products['products_ean']) == 13 ) 
					    && ( $products['categorie_id_amazon_fr'] <> 0 )
					
						)
					{
					//////////////////////////////
					
					  $product_num++;
					
					if ($qty <= 0 ) { 
										$qty =0;
										$update_or_delete="Delete";
									} else {
										$update_or_delete="Update";
											}
					
					  $info_string.= 	
										"<tr><td width=50>". 
										"<font color=red>". 
										"" . $products['products_id'] . 
										"</font>". 
										"</td><td width=130>". 
										"ean : " . $products['products_ean'] .
										"</td><td width=70>".  
										"<font color=red><b>". 
										"" . $prix_marketplace . 	"</b></font>  | q : ".  $qty .
										"" .  
										"</td><td width=100>". 
										"<font color=red><b>". 
										"node : " . $products['categorie_id_amazon_fr'] . 
										"</b></font>". 
										"</td><td>". 
										"" . $description . 
										"</td>".
										"<td width=200>". 
										"cat CB: " . $products['categories_id'] . "<font color=red><b>  " . $products['categories_name'] . "<font color=red><b>".
										"</td></tr>";
					
					  $string.= '<offer>';
					  $string.= '<product_reference type="Ean"><![CDATA['. $products['products_ean'] .']]></product_reference>';
					  $string.= '<offer_reference type="SellerSku"><![CDATA['. $products['products_id'] .']]></offer_reference>';
					  $string.= '<price><![CDATA['. $prix_marketplace .']]></price>';
					  $string.= '<product_state>11</product_state>';
					  $string.= '<quantity><![CDATA['.$qty.']]></quantity>';
					  $string.= '<description><![CDATA['. substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,250) .'.]]></description>';
					  $string.= '<internal_comment></internal_comment>';
					  $string.= '<showcase><![CDATA[100]]></showcase>';
					
					
					
					/************************************** frais de transport **************************************/
					/************************************** pour les market place ***********************************/
					
					
					
							$prix_transport = (5.4347  + (floatval($products['products_weight']) * 3));
						//	echo round($prix_transport,2) ;
					
					
					if ( $products['products_image_med'] == '' )
					{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image'] ; }
					else
					{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image_med'] ; }
						
					
					$productType= $products['categorie_productType_amazon_fr'];
					
					/************************************** frais de transport FIN ***********************************/
					  
					include('template/'.$template.'_tpl.php');
					
					////////////////produits suprieur  15 euro ///////////////
					}// fin if is ( tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id'])) >= 15 ) {
					//////////////////////////////
					  }
					$info_string.='</table>';
					echo $info_string;
					/******************************************************** Fin traitement de produits ********************************************************************/
					
					// Constructing the MarketplaceId array which will be passed in as the the MarketplaceIdList 
					// parameter to the SubmitFeedRequest object.
					//$marketplaceIdArray = array("Id" => array('<Marketplace_Id_1>','<Marketplace_Id_2>'));
					$marketplaceIdArray = array("Id" => array('A13V1IB3VIYZZH'));
					     
					 // MWS request objects can be constructed two ways: either passing an array containing the 
					 // required request parameters into the request constructor, or by individually setting the request
					 // parameters via setter methods.
					 // Uncomment one of the methods below.
					 
					
					/********* Begin Comment Block *********/
					//$feedHandle = fopen('php://memory', 'rw+');
					//$feedHandle = fopen('php://memory', 'rw+');
					
					$feedHandle = fopen('amazon-'.$template.'-fr.txt', 'w+');
					
					echo "<hr>";
					fwrite($feedHandle, $feed);
					rewind($feedHandle);
					
					
					//$feedHandle = @fopen('php://memory', 'rw+');
					//fwrite($feedHandle, $fileContent);
					rewind($feedHandle);
					$parameters = array (
					'Marketplace' => MARKETPLACE_ID,
					'Merchant' => MERCHANT_ID,
					'FeedType' => '_POST_FLAT_FILE_LISTINGS_DATA_',
					'FeedContent' => $feedHandle,
					
					'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true)),
					);
					
					$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);
					
					/********* End Comment Block *********/
					
					//  invokeSubmitFeed($service, $request); // appel pour transmettre le fichier
					
					echo "<hr>";
					echo "<pre>";
					print_r($request);
					echo "</pre>";
					
					
					@fclose($feedHandle);
}                                        
?>