<?php
 set_time_limit (0);

if (!class_exists('DateTime')) {
class DateTime {
    public $date;
   
    public function __construct($date) {
        $this->date = strtotime($date);
    }
   
    public function setTimeZone($timezone) {
        return;
    }
   
    private function __getDate() {
        return date(DATE_ATOM, $this->date);   
    }
   
    public function modify($multiplier) {
        $this->date = strtotime($this->__getDate() . ' ' . $multiplier);
    }
   
    public function format($format) {
        return date($format, $this->date);
    }
}
}

/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2009 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2009-01-01
 */
/******************************************************************************* 

 *  Marketplace Web Service PHP5 Library
 *  Generated: Thu May 07 13:07:36 PDT 2009
 * 
 */

/**
 * Submit Feed  Sample
 */

include_once ('.config.inc.php'); 

/************************************************************************
* Uncomment to configure the client instance. Configuration settings
* are:
*
* - MWS endpoint URL
* - Proxy host and port.
* - MaxErrorRetry.
***********************************************************************/
// IMPORTANT: Uncomment the approiate line for the country you wish to
// sell in:
// United States:
//$serviceUrl = "https://mws.amazonservices.com";
// United Kingdom
//$serviceUrl = "https://mws.amazonservices.co.uk";
// Germany
//$serviceUrl = "https://mws.amazonservices.de";
// France
$serviceUrl = "https://mws.amazonservices.fr";
// Italy
//$serviceUrl = "https://mws.amazonservices.it";
// Japan
//$serviceUrl = "https://mws.amazonservices.jp";
// China
//$serviceUrl = "https://mws.amazonservices.com.cn";
// Canada
//$serviceUrl = "https://mws.amazonservices.ca";
// India
//$serviceUrl = "https://mws.amazonservices.in";

$config = array (
  'ServiceURL' => $serviceUrl,
  'ProxyHost' => null,
  'ProxyPort' => -1,
  'MaxErrorRetry' => 3,
);

/************************************************************************
 * Instantiate Implementation of MarketplaceWebService
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
 $service = new MarketplaceWebService_Client(
     AWS_ACCESS_KEY_ID, 
     AWS_SECRET_ACCESS_KEY, 
     $config,
     APPLICATION_NAME,
     APPLICATION_VERSION);
 
/************************************************************************
 * Uncomment to try out Mock Service that simulates MarketplaceWebService
 * responses without calling MarketplaceWebService service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under MarketplaceWebService/Mock tree
 *
 ***********************************************************************/
 // $service = new MarketplaceWebService_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for Submit Feed Action
 ***********************************************************************/
 // @TODO: set request. Action can be passed as MarketplaceWebService_Model_SubmitFeedRequest
 // object or array of parameters

// Note that PHP memory streams have a default limit of 2M before switching to disk. While you
// can set the limit higher to accomidate your feed in memory, it's recommended that you store
// your feed on disk and use traditional file streams to submit your feeds. For conciseness, this
// examples uses a memory stream.




/**************************************************************** traitement produits ******************************************************/

//  Header( 'Content-Type: text/xml' ); 
  define ('DISPLAY_PRICE_WITH_TAX', true);

  define ('DEFAULT_CURRENCY','EUR');

  require('import_top_special.php');
 // require('../../includes/application_top.php');

$string='';
$info_string = '<table border="1" width="100%" cellspacing="0" cellpadding="2" style="	font-family: Arial, Helvetica, sans-serif;font-size:10px;">';
  // On vrifie la langue utilise dans le catalogue
  $language_code = (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) ? $HTTP_GET_VARS['language'] : DEFAULT_LANGUAGE;

// langue Francais
$languages_id=1;

  // Requte pour identifier les catgories existantes dans le catalogue
  $included_categories_query = tep_db_query("SELECT c.categories_id, c.parent_id, cd.categories_name FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd 

WHERE 

c.categories_id = cd.categories_id 

AND cd.language_id = FLOOR($languages_id)

");

  $inc_cat = array();

  // Identification du nom de la catgorie, et l'id de la catgorie parent
  while ($included_categories = tep_db_fetch_array($included_categories_query)) {
  $inc_cat[] = array (
     'id' => $included_categories['categories_id'],
     'parent' => $included_categories['parent_id'],
     'name' => $included_categories['categories_name']);
  }

  $cat_info = array();
  for ($i=0; $i < sizeof($inc_cat); $i++)
    $cat_info[$inc_cat[$i]['id']] = array (
    'parent'=> $inc_cat[$i]['parent'],
    'name'  => $inc_cat[$i]['name'],
    'path'  => $inc_cat[$i]['id'],
    'link'  => '' );

  for ($i=0; $i < sizeof($inc_cat); $i++) {
  $cat_id = $inc_cat[$i]['id'];
  while ($cat_info[$cat_id]['parent'] != 0){
    $cat_info[$inc_cat[$i]['id']]['path'] = $cat_info[$cat_id]['parent'] . '_' . $cat_info[$inc_cat[$i]['id']]['path'];
    $cat_id = $cat_info[$cat_id]['parent'];
    }
  $link_array = split('_', $cat_info[$inc_cat[$i]['id']] ['path']);
  for ($j=0; $j < sizeof($link_array); $j++) {
    $cat_info[$inc_cat[$i]['id']]['link'] .= '&nbsp;<a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $cat_info[$link_array[$j]]['path']) . '"><nobr>' . $cat_info[$link_array[$j]]['name'] . '</nobr></a>&nbsp;&raquo;&nbsp;';
    }
  }

  // Requte identifiant les produits disponibles dans le catalogue


//AND pc.categories_id <> '505830'
//AND pc.categories_id <> '707860'
//AND pc.categories_id <> '505840'


  $products_query = tep_db_query("SELECT 	p.*, 
											pd.products_name, 
											pd.products_description, 
											pc.categories_id, 
											pcat.categorie_id_amazon_fr ,
											pcatdesc.categories_name , 
											pcat.amazon_template_alias , 
											pd.products_bullet_point1,
											pd.products_bullet_point2,
											pd.products_bullet_point3,
											pd.products_bullet_point4,
											pd.products_bullet_point5,
											pcat.categorie_productType_amazon_fr   FROM " . TABLE_PRODUCTS . " p, 
																						" . TABLE_PRODUCTS_DESCRIPTION . " pd, 
																						" . TABLE_PRODUCTS_TO_CATEGORIES . " pc , 
																						" . TABLE_CATEGORIES . " pcat , 
																						" . TABLE_CATEGORIES_DESCRIPTION . " pcatdesc 


											WHERE 
											p.products_id = pd.products_id 
											
											AND p.products_id = pc.products_id 
											AND pc.categories_id = pcat.categories_id
											AND pc.categories_id = pcatdesc.categories_id
											AND pcatdesc.language_id  = FLOOR($languages_id)

											AND 
											  (pc.categories_id = '17'
											OR pc.categories_id = '80'
											OR pc.categories_id = '82'
											OR pc.categories_id = '76'
											OR pc.categories_id = '77'
											OR pc.categories_id = '81'
											OR pc.categories_id = '75'
											OR pc.categories_id = '79'
											OR pc.categories_id = '78'
											OR pc.categories_id = '16'
											OR pc.categories_id = '146'
											
											OR pc.categories_id = '95'
											)


											AND pcat.categorie_id_amazon_fr <> ''

											AND pd.language_id = FLOOR($languages_id) 

											ORDER BY pc.categories_id, pd.products_name");

  $product_num = 0;
  $liste_produits='';

  while($products = tep_db_fetch_array($products_query)) {

  if (intval($products['manufacturers_id']) > 0) {
  	$manufacturers_query = tep_db_query("SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS_INFO . " WHERE manufacturers_id = " . $products['manufacturers_id'] ." and languages_id = ".FLOOR($languages_id));
  	$manufacturers_result = tep_db_fetch_array($manufacturers_query);
  	$products['manufacturers_name'] = $manufacturers_result['manufacturers_name'];
 }

  $special_query = tep_db_query("SELECT specials_new_products_price  FROM " . TABLE_SPECIALS . " WHERE products_id = " . $products['products_id'] ." AND status = 1 ");
  if ($special_result = tep_db_fetch_array($special_query))
  	$products['products_price'] = $special_result['specials_new_products_price'];

$prixprod =tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));
$description = substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,2000);
$nom_produit = html_entity_decode($products['products_name']);

//$prix_marketplace =  round(tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']))*1.22,2);
//$prix_marketplace = tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));

$prix_marketplace = round((($products['products_price']) * (1+(tep_get_tax_rate($products['products_tax_class_id'])/100))) *1.05,2);

$qty = $products['products_quantity'];

 if (( strlen($products['products_ean']) == 13 ) 
    && ( $products['categorie_id_amazon_fr'] <> 0 )

	)
{
//////////////////////////////

  $product_num++;

if ($qty <= 0 ) { 
					$qty =0;
					$update_or_delete="Delete";
				} else {
					$update_or_delete="Update";
						}


  $info_string.= 	
					"<tr><td width=50>". 
					"<font color=red>". 
					"" . $products['products_id'] . 
					"</font>". 
					"</td><td width=130>". 
					"ean : " . $products['products_ean'] .
					"</td><td width=70>".  
					"<font color=red><b>". 
					"" . $prix_marketplace . 	"</b></font>  | q : ".  $qty .
					"" .  
					"</td><td width=100>". 
					"<font color=red><b>". 
					"node : " . $products['categorie_id_amazon_fr'] . 
					"</b></font>". 
					"</td><td>". 
					"" . $description . 
					"</td>".
					"<td width=200>". 
					"cat CB: " . $products['categories_id'] . "<font color=red><b>  " . $products['categories_name'] . "<font color=red><b>".
					"</td></tr>";

  $string.= '<offer>';
  $string.= '<product_reference type="Ean"><![CDATA['. $products['products_ean'] .']]></product_reference>';
  $string.= '<offer_reference type="SellerSku"><![CDATA['. $products['products_id'] .']]></offer_reference>';
  $string.= '<price><![CDATA['. $prix_marketplace .']]></price>';
  $string.= '<product_state>11</product_state>';
  $string.= '<quantity><![CDATA['.$qty.']]></quantity>';
  $string.= '<description><![CDATA['. substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,250) .'.]]></description>';
  $string.= '<internal_comment></internal_comment>';
  $string.= '<showcase><![CDATA[100]]></showcase>';



/************************************** frais de transport **************************************/
/************************************** pour les market place ***********************************/



		$prix_transport = (5.4347  + (floatval($products['products_weight']) * 3));
	//	echo round($prix_transport,2) ;


if ( $products['products_image_med'] == '' )
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image'] ; }
else
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image_med'] ; }
	

$productType= "FurnitureAndDecor";

/************************************** frais de transport FIN ***********************************/
  

/********************************************************  produits ********************************************************************/


$department_name_line = 'adulte (homme ou femme)';
if ($product_type =='Handbag') $department_name_line = 'mixte enfant';

$item_sku=$products['products_ean'];
$item_name=filter_text($nom_produit);
$external_product_id=$products['products_ean'];
$external_product_id_type='EAN';
$feed_product_type=$product_type;
$brand_name=filter_text($products['manufacturers_name']);
$manufacturer=filter_text($products['manufacturers_name']);
$product_description=filter_text($description);
$update_delete=$update_or_delete;
$part_number='';
$model='';
$standard_price=$prix_marketplace;
$currency='EUR';
$quantity=$qty;
$fulfillment_latency='';
$sale_price='';
$sale_from_date='';
$sale_end_date='';
$product_tax_code='';
$product_site_launch_date='';
$merchant_release_date='';
$restock_date='';
$is_discontinued_by_manufacturer='';
$item_package_quantity='';
$max_aggregate_ship_quantity='';
$offering_can_be_gift_messaged='';
$offering_can_be_giftwrapped='';
$missing_keyset_reason='';
$volume_capacity_name='';
$website_shipping_weight='';
$website_shipping_weight_unit_of_measure='';
$item_weight_unit_of_measure='KG';
$item_weight=$products['products_weight'];
$item_dimensions_unit_of_measure='';
$item_length='';
$item_width='';
$item_height='';
$recommended_browse_nodes1=$products['categorie_id_amazon_fr'];
$recommended_browse_nodes2='';
$bullet_point1=filter_text($products['products_bullet_point1']);
$bullet_point2=filter_text($products['products_bullet_point2']);
$bullet_point3=filter_text($products['products_bullet_point3']);
$bullet_point4=filter_text($products['products_bullet_point4']);
$bullet_point5=filter_text($products['products_bullet_point5']);
$generic_keywords1='';
$generic_keywords2='';
$generic_keywords3='';
$generic_keywords4='';
$generic_keywords5='';
$style_keywords1='';
$style_keywords2='';
$style_keywords3='';
$platinum_keywords1='';
$platinum_keywords2='';
$platinum_keywords3='';
$platinum_keywords4='';
$platinum_keywords5='';
$main_image_url=$image;
$other_image_url1='';
$other_image_url2='';
$other_image_url3='';
$other_image_url4='';
$other_image_url5='';
$other_image_url6='';
$other_image_url7='';
$other_image_url8='';
$swatch_image_url='';
$fulfillment_center_id='';
$package_height='';
$package_width='';
$package_length='';
$package_dimensions_unit_of_measure='';
$package_weight=$products['products_weight'];
$package_weight_unit_of_measure='KG';
$parent_child='';
$parent_sku='';
$relationship_type='';
$variation_theme='';
$eu_toys_safety_directive_age_warning='';
$eu_toys_safety_directive_warning1='';
$eu_toys_safety_directive_warning2='';
$eu_toys_safety_directive_warning3='';
$eu_toys_safety_directive_warning4='';
$eu_toys_safety_directive_warning5='';
$eu_toys_safety_directive_warning6='';
$eu_toys_safety_directive_warning7='';
$eu_toys_safety_directive_warning8='';
$eu_toys_safety_directive_language1='';
$eu_toys_safety_directive_language2='';
$eu_toys_safety_directive_language3='';
$eu_toys_safety_directive_language4='';
$eu_toys_safety_directive_language5='';
$eu_toys_safety_directive_language6='';
$eu_toys_safety_directive_language7='';
$eu_toys_safety_directive_language8='';
$country_of_origin='';
$department_name=$department_name_line;
$color_name='';
$color_map='multicolore';
$size_name='';
$outer_material_type='';
$inner_material_type='';
$sole_material='';
$seasons='';
$model_year='';
$style_name='';
$model_name='';
$closure_type='';
$heel_type='';
$height_map='';
$toe_style='';
$special_features1='';
$special_features2='';
$special_features3='';
$arch_type='';
$water_resistance_level='';
$cleat_description='';
$cleat_material_type='';
$lifestyle='';
$team_name='';
$insole_type='';
$leather_type='';
$pronation_correction='';
$shoe_safety_code_iso_20345='';
$collection_name='';
$surface_recommendation='';
$number_of_wheels='';
$sport_type='';
$shoulder_strap_drop='';
$shoulder_strap_drop_unit_of_measure='';
$shell_type='';
$shoe_width='';
$shaft_height='';
$minimum_circumference='';
$maximum_circumference='';
$heel_height='';
$platform_height='';
$is_stain_resistant='';
$strap_type='';
$lining_description='';
$shaft_diameter='';
$shoe_dimension_unit_of_measure='';
$batteries_required='';
$are_batteries_included='';
$battery_cell_composition='';
$battery_description='';
$battery_form_factor='';
$lithium_battery_weight='';
$battery_weight='';
$seller_warranty_description='';
$pattern_name='';
$size_map='';



$line = $item_sku . chr(9);
$line.= $item_name . chr(9);
$line.= $external_product_id . chr(9);
$line.= $external_product_id_type . chr(9);
$line.= $feed_product_type . chr(9);
$line.= $brand_name . chr(9);
$line.= $manufacturer . chr(9);
$line.= $product_description . chr(9);
$line.= $update_delete . chr(9);
$line.= $part_number . chr(9);
$line.= $model . chr(9);
$line.= $standard_price . chr(9);
$line.= $currency . chr(9);
$line.= $quantity . chr(9);
$line.= $fulfillment_latency . chr(9);
$line.= $sale_price . chr(9);
$line.= $sale_from_date . chr(9);
$line.= $sale_end_date . chr(9);
$line.= $product_tax_code . chr(9);
$line.= $product_site_launch_date . chr(9);
$line.= $merchant_release_date . chr(9);
$line.= $restock_date . chr(9);
$line.= $is_discontinued_by_manufacturer . chr(9);
$line.= $item_package_quantity . chr(9);
$line.= $max_aggregate_ship_quantity . chr(9);
$line.= $offering_can_be_gift_messaged . chr(9);
$line.= $offering_can_be_giftwrapped . chr(9);
$line.= $missing_keyset_reason . chr(9);
$line.= $volume_capacity_name . chr(9);
$line.= $website_shipping_weight . chr(9);
$line.= $website_shipping_weight_unit_of_measure . chr(9);
$line.= $item_weight_unit_of_measure . chr(9);
$line.= $item_weight . chr(9);
$line.= $item_dimensions_unit_of_measure . chr(9);
$line.= $item_length . chr(9);
$line.= $item_width . chr(9);
$line.= $item_height . chr(9);
$line.= $recommended_browse_nodes1 . chr(9);
$line.= $recommended_browse_nodes2 . chr(9);
$line.= $bullet_point1 . chr(9);
$line.= $bullet_point2 . chr(9);
$line.= $bullet_point3 . chr(9);
$line.= $bullet_point4 . chr(9);
$line.= $bullet_point5 . chr(9);
$line.= $generic_keywords1 . chr(9);
$line.= $generic_keywords2 . chr(9);
$line.= $generic_keywords3 . chr(9);
$line.= $generic_keywords4 . chr(9);
$line.= $generic_keywords5 . chr(9);
$line.= $style_keywords1 . chr(9);
$line.= $style_keywords2 . chr(9);
$line.= $style_keywords3 . chr(9);
$line.= $platinum_keywords1 . chr(9);
$line.= $platinum_keywords2 . chr(9);
$line.= $platinum_keywords3 . chr(9);
$line.= $platinum_keywords4 . chr(9);
$line.= $platinum_keywords5 . chr(9);
$line.= $main_image_url . chr(9);
$line.= $other_image_url1 . chr(9);
$line.= $other_image_url2 . chr(9);
$line.= $other_image_url3 . chr(9);
$line.= $other_image_url4 . chr(9);
$line.= $other_image_url5 . chr(9);
$line.= $other_image_url6 . chr(9);
$line.= $other_image_url7 . chr(9);
$line.= $other_image_url8 . chr(9);
$line.= $swatch_image_url . chr(9);
$line.= $fulfillment_center_id . chr(9);
$line.= $package_height . chr(9);
$line.= $package_width . chr(9);
$line.= $package_length . chr(9);
$line.= $package_dimensions_unit_of_measure . chr(9);
$line.= $package_weight . chr(9);
$line.= $package_weight_unit_of_measure . chr(9);
$line.= $parent_child . chr(9);
$line.= $parent_sku . chr(9);
$line.= $relationship_type . chr(9);
$line.= $variation_theme . chr(9);
$line.= $eu_toys_safety_directive_age_warning . chr(9);
$line.= $eu_toys_safety_directive_warning1 . chr(9);
$line.= $eu_toys_safety_directive_warning2 . chr(9);
$line.= $eu_toys_safety_directive_warning3 . chr(9);
$line.= $eu_toys_safety_directive_warning4 . chr(9);
$line.= $eu_toys_safety_directive_warning5 . chr(9);
$line.= $eu_toys_safety_directive_warning6 . chr(9);
$line.= $eu_toys_safety_directive_warning7 . chr(9);
$line.= $eu_toys_safety_directive_warning8 . chr(9);
$line.= $eu_toys_safety_directive_language1 . chr(9);
$line.= $eu_toys_safety_directive_language2 . chr(9);
$line.= $eu_toys_safety_directive_language3 . chr(9);
$line.= $eu_toys_safety_directive_language4 . chr(9);
$line.= $eu_toys_safety_directive_language5 . chr(9);
$line.= $eu_toys_safety_directive_language6 . chr(9);
$line.= $eu_toys_safety_directive_language7 . chr(9);
$line.= $eu_toys_safety_directive_language8 . chr(9);
$line.= $country_of_origin . chr(9);
$line.= $department_name . chr(9);
$line.= $color_name . chr(9);
$line.= $color_map . chr(9);
$line.= $size_name . chr(9);
$line.= $outer_material_type . chr(9);
$line.= $inner_material_type . chr(9);
$line.= $sole_material . chr(9);
$line.= $seasons . chr(9);
$line.= $model_year . chr(9);
$line.= $style_name . chr(9);
$line.= $model_name . chr(9);
$line.= $closure_type . chr(9);
$line.= $heel_type . chr(9);
$line.= $height_map . chr(9);
$line.= $toe_style . chr(9);
$line.= $special_features1 . chr(9);
$line.= $special_features2 . chr(9);
$line.= $special_features3 . chr(9);
$line.= $arch_type . chr(9);
$line.= $water_resistance_level . chr(9);
$line.= $cleat_description . chr(9);
$line.= $cleat_material_type . chr(9);
$line.= $lifestyle . chr(9);
$line.= $team_name . chr(9);
$line.= $insole_type . chr(9);
$line.= $leather_type . chr(9);
$line.= $pronation_correction . chr(9);
$line.= $shoe_safety_code_iso_20345 . chr(9);
$line.= $collection_name . chr(9);
$line.= $surface_recommendation . chr(9);
$line.= $number_of_wheels . chr(9);
$line.= $sport_type . chr(9);
$line.= $shoulder_strap_drop . chr(9);
$line.= $shoulder_strap_drop_unit_of_measure . chr(9);
$line.= $shell_type . chr(9);
$line.= $shoe_width . chr(9);
$line.= $shaft_height . chr(9);
$line.= $minimum_circumference . chr(9);
$line.= $maximum_circumference . chr(9);
$line.= $heel_height . chr(9);
$line.= $platform_height . chr(9);
$line.= $is_stain_resistant . chr(9);
$line.= $strap_type . chr(9);
$line.= $lining_description . chr(9);
$line.= $shaft_diameter . chr(9);
$line.= $shoe_dimension_unit_of_measure . chr(9);
$line.= $batteries_required . chr(9);
$line.= $are_batteries_included . chr(9);
$line.= $battery_cell_composition . chr(9);
$line.= $battery_description . chr(9);
$line.= $battery_form_factor . chr(9);
$line.= $lithium_battery_weight . chr(9);
$line.= $battery_weight . chr(9);
$line.= $seller_warranty_description . chr(9);
$line.= $pattern_name . chr(9);
$line.= $size_map . chr(9);


$line.= chr(13).chr(10);

$liste_produits .= $line;



/********************************************************  produits ********************************************************************/


////////////////produits suprieur  15 euro ///////////////
}// fin if is ( tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id'])) >= 15 ) {
//////////////////////////////
  }
$info_string.='</table>';
echo $info_string;
/******************************************************** Fin traitement de produits ********************************************************************/




$feed = "";

$feed = <<<EOD
TemplateType=Shoes	Version=2014.0814	Les 3 lignes suprieures sont rserves  Amazon.com. Ne pas modifier ou supprimer les 3 lignes suprieures.								Informations sur l'offre - Informations sur l'offre : ces attributs sont requis pour que votre article puisse tre achet par les clients sur le site.																	Dimensions - Dimensions du produit : ces attributs spcifient la taille et le poids d'un produit.									Dcouverte d'article - Informations de dcouverte d'article : ces attributs ont un effet sur la manire dont les clients peuvent trouver votre produit sur le site  l'aide du navigateur ou de la fonction de recherche.																				Image - Informations d'image : voir l'onglet Instructions sur l'image pour plus de dtails.										Expdition - Ces colonnes sont destines  toute information concernant lexpdition de commandes traites par Expdi par Amazon ou par le vendeur.						Variation - Informations de variation : diffusez ces attributs si votre produit est disponible en diffrents modles (par exemple, couleur ou puissance en watts).				Compliance - Conformit - Informations de conformit : attributs utiliss pour la conformit avec les lois en matire de consommation dans le pays ou la rgion o l'article est vendu																		Ces attributs crent des listes de produits bien fournies pour vos acheteurs.																																																									
SKU	Titre	ID du produit	Type d'ID du produit	Type de produit	Marque	Fabricant	Description du produit	Mettre  jour Supprimer	Numro de pice fabricant	Numro du modle	Prix ??standard	Devise	quantit	Dlai de traitement	Prix rduit	Date de dbut de la remise	Date de fin de la remise	Code d'imposition du produit	Date de sortie	Date de publication	Date de remise en stock	Le fabricant a arrt la production du produit	Quantit de lot	Nombre d'articles pouvant tre expdis ensemble	Message cadeau disponible	Emballage cadeau disponible	Paramtre d'enregistrement	Capacit Volume	Poids de lexpdition	Unit de mesure du poids de lexpdition du site internet	Unit de mesure du poids de l'article.	Poids de l'article	Unit de mesure des dimensions de larticle	Longueur de l'article	Largeur de l'article	Hauteur de l'article	Catgorie de produits (Code arborescence recommand)1	Catgorie de produits (Code arborescence recommand)2	Caractristiques cls du produit1	Caractristiques cls du produit2	Caractristiques cls du produit3	Caractristiques cls du produit4	Caractristiques cls du produit5	Termes de recherche1	Termes de recherche2	Termes de recherche3	Termes de recherche4	Termes de recherche5	Mot cl Style1	Mot cl Style2	Mot cl Style3	Mots-cls platinum1	Mots-cls platinum2	Mots-cls platinum3	Mots-cls platinum4	Mots-cls platinum5	URL de l'image principale	URL d'une autre image1	URL d'une autre image2	URL d'une autre image3	URL d'une autre image4	URL d'une autre image5	URL d'une autre image6	URL d'une autre image7	URL d'une autre image8	URL de limage chantillon	ID du centre de distribution	Hauteur colis	Largeur colis	Longueur colis	Unit de mesure des dimensions du paquet	Poids colis	Unit de mesure du poids du paquet	Parent	SKU Parent	Type de relation	Thme variation	Directive EU relative  la Scurit des Jouets - Avertissement  propos de lge	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge1	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge2	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge3	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge4	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge5	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge6	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge7	Directive EU relative  la Scurit des Jouets - Avertissement non relatif  lge8	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue1	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue2	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue3	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue4	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue5	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue6	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue7	Directive EU relative  la Scurit des Jouets - Avertissement relatif  la langue8	Pays dorigine	Dpartement	Couleur fabricant	Nom de couleur standardis	Taille	Matire extrieure	inner-material-type	Matire Semelle	Saison	Anne du Modle	Nom Style	Nom du Modle	Type de fermeture	Type de Talon	Shoe Height Map	Style du bout	Caractristique particulire1	Caractristique particulire2	Caractristique particulire3	Arch Type	Impermabilit	Description Forme	Matire Forme	Occasion	Nom dquipe	Type semelle intrieure	Type de cuir	Correction Pronation	Code de scurit Iso 20345	Collection (Saison + Anne)	Surface de course recommande	Nombre de roues	Type de Sport	Shoulder Strap Drop strap	Hauteur bandoulire unite de mesure	Revtement extrieur (bagage)	Largeur Chaussure	Hauteur de la Tige	Circonfrence minimale	Circonfrence maximale	Hauteur Talon	Hauteur Plateforme	Est anti-tche	Type dattache	lining-description	Diamtre Tige	Unit de mesure pour dimension de la chaussure	Est-ce que les batteries sont ncessaires	Les batteries sont incluses	Type de batterie	Description batterie	Est-ce que la batterie est dtachable?	Poids de la batterie au lithium	Poids batterie	Description de la garantie	Dessin	Taille Taille standardise (valeur valide)
item_sku	item_name	external_product_id	external_product_id_type	feed_product_type	brand_name	manufacturer	product_description	update_delete	part_number	model	standard_price	currency	quantity	fulfillment_latency	sale_price	sale_from_date	sale_end_date	product_tax_code	product_site_launch_date	merchant_release_date	restock_date	is_discontinued_by_manufacturer	item_package_quantity	max_aggregate_ship_quantity	offering_can_be_gift_messaged	offering_can_be_giftwrapped	missing_keyset_reason	volume_capacity_name	website_shipping_weight	website_shipping_weight_unit_of_measure	item_weight_unit_of_measure	item_weight	item_dimensions_unit_of_measure	item_length	item_width	item_height	recommended_browse_nodes1	recommended_browse_nodes2	bullet_point1	bullet_point2	bullet_point3	bullet_point4	bullet_point5	generic_keywords1	generic_keywords2	generic_keywords3	generic_keywords4	generic_keywords5	style_keywords1	style_keywords2	style_keywords3	platinum_keywords1	platinum_keywords2	platinum_keywords3	platinum_keywords4	platinum_keywords5	main_image_url	other_image_url1	other_image_url2	other_image_url3	other_image_url4	other_image_url5	other_image_url6	other_image_url7	other_image_url8	swatch_image_url	fulfillment_center_id	package_height	package_width	package_length	package_dimensions_unit_of_measure	package_weight	package_weight_unit_of_measure	parent_child	parent_sku	relationship_type	variation_theme	eu_toys_safety_directive_age_warning	eu_toys_safety_directive_warning1	eu_toys_safety_directive_warning2	eu_toys_safety_directive_warning3	eu_toys_safety_directive_warning4	eu_toys_safety_directive_warning5	eu_toys_safety_directive_warning6	eu_toys_safety_directive_warning7	eu_toys_safety_directive_warning8	eu_toys_safety_directive_language1	eu_toys_safety_directive_language2	eu_toys_safety_directive_language3	eu_toys_safety_directive_language4	eu_toys_safety_directive_language5	eu_toys_safety_directive_language6	eu_toys_safety_directive_language7	eu_toys_safety_directive_language8	country_of_origin	department_name	color_name	color_map	size_name	outer_material_type	inner_material_type	sole_material	seasons	model_year	style_name	model_name	closure_type	heel_type	height_map	toe_style	special_features1	special_features2	special_features3	arch_type	water_resistance_level	cleat_description	cleat_material_type	lifestyle	team_name	insole_type	leather_type	pronation_correction	shoe_safety_code_iso_20345	collection_name	surface_recommendation	number_of_wheels	sport_type	shoulder_strap_drop	shoulder_strap_drop_unit_of_measure	shell_type	shoe_width	shaft_height	minimum_circumference	maximum_circumference	heel_height	platform_height	is_stain_resistant	strap_type	lining_description	shaft_diameter	shoe_dimension_unit_of_measure	batteries_required	are_batteries_included	battery_cell_composition	battery_description	battery_form_factor	lithium_battery_weight	battery_weight	seller_warranty_description	pattern_name	size_map
$liste_produits
EOD;

// Constructing the MarketplaceId array which will be passed in as the the MarketplaceIdList 
// parameter to the SubmitFeedRequest object.
//$marketplaceIdArray = array("Id" => array('<Marketplace_Id_1>','<Marketplace_Id_2>'));
$marketplaceIdArray = array("Id" => array('A13V1IB3VIYZZH'));
     
 // MWS request objects can be constructed two ways: either passing an array containing the 
 // required request parameters into the request constructor, or by individually setting the request
 // parameters via setter methods.
 // Uncomment one of the methods below.
 

/********* Begin Comment Block *********/
//$feedHandle = fopen('php://memory', 'rw+');
//$feedHandle = fopen('php://memory', 'rw+');

$feedHandle = fopen('amazon-chaussures-access-fr.txt', 'w+');


echo "<hr>";
fwrite($feedHandle, $feed);
rewind($feedHandle);


//$feedHandle = @fopen('php://memory', 'rw+');
//fwrite($feedHandle, $fileContent);
rewind($feedHandle);
$parameters = array (
'Marketplace' => MARKETPLACE_ID,
'Merchant' => MERCHANT_ID,
'FeedType' => '_POST_FLAT_FILE_LISTINGS_DATA_',
'FeedContent' => $feedHandle,

'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true)),
);

$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);

/********* End Comment Block *********/

// invokeSubmitFeed($service, $request); // appel pour transmettre le fichier

echo "<hr>";
echo "<pre>";
print_r($request);
echo "</pre>";


@fclose($feedHandle);
                                        
/**
  * Submit Feed Action Sample
  * Uploads a file for processing together with the necessary
  * metadata to process the file, such as which type of feed it is.
  * PurgeAndReplace if true means that your existing e.g. inventory is
  * wiped out and replace with the contents of this feed - use with
  * caution (the default is false).
  *   
  * @param MarketplaceWebService_Interface $service instance of MarketplaceWebService_Interface
  * @param mixed $request MarketplaceWebService_Model_SubmitFeed or array of parameters
  */
  function invokeSubmitFeed(MarketplaceWebService_Interface $service, $request) 
  {
      try {
              $response = $service->submitFeed($request);
              

echo "<hr>response";
echo "<pre>";
 print_r($response);
echo "</pre>";
echo "<hr>";
                echo ("Service Response\n");
                echo ("=============================================================================\n");

                echo("        SubmitFeedResponse\n");

                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId\n");
                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

                echo("ResponseHeaderMetadata: " . $response->getResponseHeaderMetadata() . "\n");
     } catch (MarketplaceWebService_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
         echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
     }
 }
             
function filter_text($CatList) {
  $CatList = html_entity_decode ($CatList);
  $CatList = strip_tags ($CatList);
  $CatList = trim ($CatList);
  // $CatList = strtolower ($CatList);
  $CatList = str_replace("&nbsp;","",$CatList);
  $CatList = str_replace("&#39;","'",$CatList);
  $CatList = str_replace("&#150;","-",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("&eacute;","e",$CatList);
  $CatList = str_replace("&agrave;","",$CatList);
  $CatList = str_replace("&egrave;","e",$CatList);

  $CatList = str_replace("&nbsp","",$CatList);
  $CatList = str_replace("&#39","'",$CatList);
  $CatList = str_replace("&#150","-",$CatList);
  $CatList = str_replace("&eacute","e",$CatList);
  $CatList = str_replace("&agrave","",$CatList);
  $CatList = str_replace("&egrave","e",$CatList);
  $CatList = str_replace("&hellip","...",$CatList);
  $CatList = str_replace("&rsquo","'",$CatList);

  $CatList = str_replace("&ecirc;;","e",$CatList);
//  $CatList = str_replace(";"," ",$CatList);

  $CatList = str_replace("","i",$CatList);
  $CatList = str_replace(""," graden",$CatList);
  $CatList = str_replace("","'",$CatList);
  $CatList = str_replace("","'",$CatList);
  $CatList = str_replace('"',' ',$CatList);
  $CatList = str_replace(chr(9)," ",$CatList); 
  $CatList = str_replace(chr(10)," ",$CatList);
  $CatList = str_replace(chr(13)," ",$CatList);
  $CatList = preg_replace("[<(.*?)>]","",$CatList);
//  if (strlen($CatList) > $length) {
//    $CatList = substr($CatList, 0, $length-3) . "";
//  }
  return $CatList;  
} // function for the filter
                 