<?php
if (!class_exists('DateTime')) {
class DateTime {
    public $date;
   
    public function __construct($date) {
        $this->date = strtotime($date);
    }
   
    public function setTimeZone($timezone) {
        return;
    }
   
    private function __getDate() {
        return date(DATE_ATOM, $this->date);   
    }
   
    public function modify($multiplier) {
        $this->date = strtotime($this->__getDate() . ' ' . $multiplier);
    }
   
    public function format($format) {
        return date($format, $this->date);
    }
}
}

/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2009 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2009-01-01
 */
/******************************************************************************* 

 *  Marketplace Web Service PHP5 Library
 *  Generated: Thu May 07 13:07:36 PDT 2009
 * 
 */

/**
 * Submit Feed  Sample
 */

include_once ('.config.inc.php'); 

/************************************************************************
* Uncomment to configure the client instance. Configuration settings
* are:
*
* - MWS endpoint URL
* - Proxy host and port.
* - MaxErrorRetry.
***********************************************************************/
// IMPORTANT: Uncomment the approiate line for the country you wish to
// sell in:
// United States:
//$serviceUrl = "https://mws.amazonservices.com";
// United Kingdom
//$serviceUrl = "https://mws.amazonservices.co.uk";
// Germany
//$serviceUrl = "https://mws.amazonservices.de";
// France
$serviceUrl = "https://mws.amazonservices.fr";
// Italy
//$serviceUrl = "https://mws.amazonservices.it";
// Japan
//$serviceUrl = "https://mws.amazonservices.jp";
// China
//$serviceUrl = "https://mws.amazonservices.com.cn";
// Canada
//$serviceUrl = "https://mws.amazonservices.ca";
// India
//$serviceUrl = "https://mws.amazonservices.in";

$config = array (
  'ServiceURL' => $serviceUrl,
  'ProxyHost' => null,
  'ProxyPort' => -1,
  'MaxErrorRetry' => 3,
);

/************************************************************************
 * Instantiate Implementation of MarketplaceWebService
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
 $service = new MarketplaceWebService_Client(
     AWS_ACCESS_KEY_ID, 
     AWS_SECRET_ACCESS_KEY, 
     $config,
     APPLICATION_NAME,
     APPLICATION_VERSION);
 
/************************************************************************
 * Uncomment to try out Mock Service that simulates MarketplaceWebService
 * responses without calling MarketplaceWebService service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under MarketplaceWebService/Mock tree
 *
 ***********************************************************************/
 // $service = new MarketplaceWebService_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for Submit Feed Action
 ***********************************************************************/
 // @TODO: set request. Action can be passed as MarketplaceWebService_Model_SubmitFeedRequest
 // object or array of parameters

// Note that PHP memory streams have a default limit of 2M before switching to disk. While you
// can set the limit higher to accomidate your feed in memory, it's recommended that you store
// your feed on disk and use traditional file streams to submit your feeds. For conciseness, this
// examples uses a memory stream.




/**************************************************************** traitement produits ******************************************************/

//  Header( 'Content-Type: text/xml' ); 
  define ('DISPLAY_PRICE_WITH_TAX', true);

  define ('DEFAULT_CURRENCY','EUR');

  require('import_top_special.php');
 // require('../../includes/application_top.php');

$string='';
$info_string = '<table border="1" width="100%" cellspacing="0" cellpadding="2" style="	font-family: Arial, Helvetica, sans-serif;font-size:10px;">';
  // On vrifie la langue utilise dans le catalogue
  $language_code = (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) ? $HTTP_GET_VARS['language'] : DEFAULT_LANGUAGE;

// langue anglais
$languages_id=2;
$coef_livre=1.16822;

  // Requte pour identifier les catgories existantes dans le catalogue
  $included_categories_query = tep_db_query("SELECT c.categories_id, c.parent_id, cd.categories_name FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd 

WHERE 

c.categories_id = cd.categories_id 

AND cd.language_id = FLOOR($languages_id)

");

  $inc_cat = array();

  // Identification du nom de la catgorie, et l'id de la catgorie parent
  while ($included_categories = tep_db_fetch_array($included_categories_query)) {
  $inc_cat[] = array (
     'id' => $included_categories['categories_id'],
     'parent' => $included_categories['parent_id'],
     'name' => $included_categories['categories_name']);
  }

  $cat_info = array();
  for ($i=0; $i < sizeof($inc_cat); $i++)
    $cat_info[$inc_cat[$i]['id']] = array (
    'parent'=> $inc_cat[$i]['parent'],
    'name'  => $inc_cat[$i]['name'],
    'path'  => $inc_cat[$i]['id'],
    'link'  => '' );

  for ($i=0; $i < sizeof($inc_cat); $i++) {
  $cat_id = $inc_cat[$i]['id'];
  while ($cat_info[$cat_id]['parent'] != 0){
    $cat_info[$inc_cat[$i]['id']]['path'] = $cat_info[$cat_id]['parent'] . '_' . $cat_info[$inc_cat[$i]['id']]['path'];
    $cat_id = $cat_info[$cat_id]['parent'];
    }
  $link_array = split('_', $cat_info[$inc_cat[$i]['id']] ['path']);
  for ($j=0; $j < sizeof($link_array); $j++) {
    $cat_info[$inc_cat[$i]['id']]['link'] .= '&nbsp;<a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $cat_info[$link_array[$j]]['path']) . '"><nobr>' . $cat_info[$link_array[$j]]['name'] . '</nobr></a>&nbsp;&raquo;&nbsp;';
    }
  }

  // Requte identifiant les produits disponibles dans le catalogue


//AND pc.categories_id <> '505830'
//AND pc.categories_id <> '707860'
//AND pc.categories_id <> '505840'

  $products_query = tep_db_query("SELECT p.*, pd.products_name, pd.products_description, pc.categories_id, pcat.categorie_id_amazon_uk ,pcatdesc.categories_name  FROM " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS_TO_CATEGORIES . " pc , " . TABLE_CATEGORIES . " pcat , " . TABLE_CATEGORIES_DESCRIPTION . " pcatdesc 

WHERE 
p.products_id = pd.products_id 

AND p.products_id = pc.products_id 
AND pc.categories_id = pcat.categories_id
AND pc.categories_id = pcatdesc.categories_id
AND pcatdesc.language_id  = FLOOR($languages_id)

AND 
  (pc.categories_id = '87'
OR pc.categories_id = '58'
OR pc.categories_id = '59'
OR pc.categories_id = '84'
OR pc.categories_id = '60'
OR pc.categories_id = '72'
OR pc.categories_id = '61'
OR pc.categories_id = '71'
OR pc.categories_id = '63'
OR pc.categories_id = '89'
OR pc.categories_id = '67'
OR pc.categories_id = '68'
OR pc.categories_id = '86'
OR pc.categories_id = '66'
OR pc.categories_id = '57'
OR pc.categories_id = '73'
OR pc.categories_id = '65'
OR pc.categories_id = '69'
OR pc.categories_id = '70'
OR pc.categories_id = '74'
OR pc.categories_id = '85'
OR pc.categories_id = '83'
OR pc.categories_id = '64'
OR pc.categories_id = '62'
OR pc.categories_id = '52'
OR pc.categories_id = '88'
OR pc.categories_id = '50'

OR pc.categories_id = '112'

OR pc.categories_id = '131'
OR pc.categories_id = '132'
OR pc.categories_id = '135'
OR pc.categories_id = '134'
OR pc.categories_id = '133'
OR pc.categories_id = '130'
OR pc.categories_id = '145'
OR pc.categories_id = '148'
OR pc.categories_id = '147'

)




AND pd.language_id = FLOOR($languages_id) 

ORDER BY pc.categories_id, pd.products_name");

  $product_num = 0;
  $liste_produits='';

  while($products = tep_db_fetch_array($products_query)) {

  if (intval($products['manufacturers_id']) > 0) {
  	$manufacturers_query = tep_db_query("SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS_INFO . " WHERE manufacturers_id = " . $products['manufacturers_id'] ." and languages_id = ".FLOOR($languages_id));
  	$manufacturers_result = tep_db_fetch_array($manufacturers_query);
  	$products['manufacturers_name'] = $manufacturers_result['manufacturers_name'];
 }

  $special_query = tep_db_query("SELECT specials_new_products_price  FROM " . TABLE_SPECIALS . " WHERE products_id = " . $products['products_id'] ." AND status = 1 ");
  if ($special_result = tep_db_fetch_array($special_query))
  	$products['products_price'] = $special_result['specials_new_products_price'];

$prixprod =tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));
$description = substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P> \n<P>",html_entity_decode($products['products_description']))),0,2000);
$nom_produit = html_entity_decode($products['products_name']);

$prix_marketplace =  round(tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']))*1.10,2);
$prix_marketplace = tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));

$prix_marketplace = round((($products['products_price']) * (1+(tep_get_tax_rate($products['products_tax_class_id'])/100))) *1.22,2);
$prix_marketplace= round(($prix_marketplace / $coef_livre),2);
$qty = $products['products_quantity'];

 if (( strlen($products['products_ean']) == 13 ) 
    && ( $products['categorie_id_amazon_uk'] <> 0 )

	)
{
//////////////////////////////

  $product_num++;

if ($qty <= 0 ) { 
					$qty =0;
					$update_or_delete="Delete";
				} else {
					$update_or_delete="Update";
						}

  $info_string.= 	
					"<tr><td width=50>". 
					"<font color=red>". 
					"" . $products['products_id'] . 
					"</font>". 
					"</td><td width=130>". 
					"ean : " . $products['products_ean'] .
					"</td><td width=70>".  
					"<font color=red><b>". 
					"" . $prix_marketplace . 	"</b></font>  | q : ".  $qty .
					"" .  
					"</td><td width=100>". 
					"<font color=red><b>". 
					"node : " . $products['categorie_id_amazon_uk'] . 
					"</b></font>". 
					"</td><td>". 
					"" . $description . 
					"</td>".
					"<td width=200>". 
					"cat CB: " . $products['categories_id'] . "<font color=red><b>  " . $products['categories_name'] . "<font color=red><b>".
					"</td></tr>";

  $string.= '<offer>';
  $string.= '<product_reference type="Ean"><![CDATA['. $products['products_ean'] .']]></product_reference>';
  $string.= '<offer_reference type="SellerSku"><![CDATA['. $products['products_id'] .']]></offer_reference>';
  $string.= '<price><![CDATA['. $prix_marketplace .']]></price>';
  $string.= '<product_state>11</product_state>';
  $string.= '<quantity><![CDATA['.$qty.']]></quantity>';
  $string.= '<description><![CDATA['. substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,250) .'.]]></description>';
  $string.= '<internal_comment></internal_comment>';
  $string.= '<showcase><![CDATA[100]]></showcase>';



/************************************** frais de transport **************************************/
/************************************** pour les market place ***********************************/



		$prix_transport = (5.4347  + (floatval($products['products_weight']) * 3));
	//	echo round($prix_transport,2) ;


if ( $products['products_image_med'] == '' )
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image'] ; }
else
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image_med'] ; }
	

$productType= "FurnitureAndDecor";

/************************************** frais de transport FIN ***********************************/
  

/********************************************************  produits ********************************************************************/
$SKU=$products['products_ean'];
$StandardProductID=$products['products_ean'];
$ProductIDType='EAN';
$ProductName=filter_text($nom_produit);
$Brand=filter_text($products['manufacturers_name']);
$Manufacturer=filter_text($products['manufacturers_name']);
$ProductType=$productType;
$RecommendedBrowseNode1=$products['categorie_id_amazon_uk'];
$RecommendedBrowseNode2='';
$MainImageURL=$image;
$LaunchDate='';
$ItemPrice=$prix_marketplace;
$Currency='GBP';
$Quantity=$qty;
$ShippingWeight=$products['products_weight'];
$ShippingWeightUnitOfMeasure='KG';
$ManufacturerPartNumber='';
$MerchantCatalogNumber='';
$BulletPoint1='';
$BulletPoint2='';
$BulletPoint3='';
$BulletPoint4='';
$BulletPoint5='';
$Description=filter_text($description);
$SearchTerms1=filter_text(substr($nom_produit,50));
$SearchTerms2=filter_text($products['manufacturers_name']);
$SearchTerms3='';
$SearchTerms4='';
$SearchTerms5='';
$SwatchImageURL='';
$OtherImageURL1='';
$OtherImageURL2='';
$OtherImageURL3='';
$OtherImageURL4='';
$OtherImageURL5='';
$OtherImageURL6='';
$OtherImageURL7='';
$OtherImageURL8='';
$DisplayLength='';
$DisplayLengthUnitOfMeasure='';
$DisplayWidth='';
$DisplayWidthUnitOfMeasure='';
$DisplayHeight='';
$DisplayHeightUnitOfMeasure='';
$DisplayDepth='';
$DisplayDepthUnitOfMeasure='';
$DisplayDiameter='';
$DisplayDiameterUnitOfMeasure='';
$DisplayWeight='';
$DisplayWeightUnitOfMeasure='';
$Volume='';
$VolumeUnitOfMeasure='';
$ItemPackageQuantity='';
$Parentage='';
$ParentSKU='';
$RelationshipType='';
$BB_Color='';
$BB_ColorMap='';
$BB_Size='';
$BB_Scent='';
$BB_VariationTheme='';
$BB_ThreadCount='';
$BB_Material='';
$BB_IsStainResistant='';
$BB_NumberOfSets='';
$BB_Wattage='';
$FD_Color='';
$FD_ColorMap='';
$FD_Size='';
$FD_Scent='';
$FD_VariationTheme='';
$FD_ThreadCount='';
$FD_Material='';
$FD_IsStainResistant='';
$FD_NumberOfSets='';
$FD_Wattage='';
$FD_AreBatteriesIncluded='';
$FD_AreBatteriesRequired='';
$FD_BatteryType1='';
$FD_BatteryType2='';
$FD_BatteryType3='';
$FD_NumberOfBatteries1='';
$FD_NumberOfBatteries2='';
$FD_NumberOfBatteries3='';
$K_Color='';
$K_ColorMap='';
$K_Size='';
$K_VariationTheme='';
$K_ThreadCount='';
$K_Material='';
$K_NumberOfSets='';
$K_Wattage='';
$K_AreBatteriesIncluded='';
$K_AreBatteriesRequired='';
$K_BatteryType1='';
$K_BatteryType2='';
$K_BatteryType3='';
$K_NumberOfBatteries1='';
$K_NumberOfBatteries2='';
$K_NumberOfBatteries3='';
$OL_Color='';
$OL_ColorMap='';
$OL_Size='';
$OL_VariationTheme='';
$OL_Material='';
$OL_IsStainResistant='';
$OL_Wattage='';
$OL_AreBatteriesIncluded='';
$OL_AreBatteriesRequired='';
$OL_BatteryType1='';
$OL_BatteryType2='';
$OL_BatteryType3='';
$OL_NumberOfBatteries1='';
$OL_NumberOfBatteries2='';
$OL_NumberOfBatteries3='';
$SP_Color='';
$SP_ColorMap='';
$SP_Size='';
$SP_VariationTheme='';
$SP_SunlightExposure='';
$SP_MoistureNeeds='';
$SP_USDAHardinessZone1='';
$SP_USDAHardinessZone2='';
$SP_USDAHardinessZone3='';
$SP_USDAHardinessZone4='';
$SP_USDAHardinessZone5='';
$SP_USDAHardinessZone6='';
$SP_USDAHardinessZone7='';
$SP_USDAHardinessZone8='';
$SP_USDAHardinessZone9='';
$SP_USDAHardinessZone10='';
$SP_USDAHardinessZone11='';
$SP_SunsetClimateZone1='';
$SP_SunsetClimateZone2='';
$SP_SunsetClimateZone3='';
$SP_SunsetClimateZone4='';
$SP_SunsetClimateZone5='';
$SP_SunsetClimateZone6='';
$SP_SunsetClimateZone7='';
$SP_SunsetClimateZone8='';
$SP_SunsetClimateZone9='';
$SP_SunsetClimateZone10='';
$SP_SunsetClimateZone11='';
$SP_SunsetClimateZone12='';
$SP_SunsetClimateZone13='';
$SP_SunsetClimateZone14='';
$SP_SunsetClimateZone15='';
$SP_SunsetClimateZone16='';
$SP_SunsetClimateZone17='';
$SP_SunsetClimateZone18='';
$SP_SunsetClimateZone19='';
$SP_SunsetClimateZone20='';
$SP_SunsetClimateZone21='';
$SP_SunsetClimateZone22='';
$SP_SunsetClimateZone23='';
$SP_SunsetClimateZone24='';
$SP_Spread='';
$SP_SpreadUnitOfMeasure='';
$ManufacturerWarranty='';
$CountryProducedIn='';
$ProductTaxCode='';
$ReleaseDate='';
$SalesPrice='';
$FulfillmentCenterID='';
$SaleStartDate='';
$SaleEndDate='';
$ConditionType='New';
$ConditionNote='';
$leadtime_to_ship='1';
$RestockDate='';
$MaxAggregateShipQuantity='';
$IsGiftMessageAvailable='';
$IsGiftWrapAvailable='';
$IsDiscontinuedByManufacturer='';
$RegisteredParameter='';
$PlatinumKeyword1='';
$PlatinumKeyword2='';
$PlatinumKeyword3='';
$PlatinumKeyword4='';
$PlatinumKeyword5='';
$update_delete=$update_or_delete;



$line = $SKU . chr(9);
$line.= $StandardProductID . chr(9);
$line.= $ProductIDType . chr(9);
$line.= $ProductName . chr(9);
$line.= $Brand . chr(9);
$line.= $Manufacturer . chr(9);
$line.= $ProductType . chr(9);
$line.= $RecommendedBrowseNode1 . chr(9);
$line.= $RecommendedBrowseNode2 . chr(9);
$line.= $MainImageURL . chr(9);
$line.= $LaunchDate . chr(9);
$line.= $ItemPrice . chr(9);
$line.= $Currency . chr(9);
$line.= $Quantity . chr(9);
$line.= $ShippingWeight . chr(9);
$line.= $ShippingWeightUnitOfMeasure . chr(9);
$line.= $ManufacturerPartNumber . chr(9);
$line.= $MerchantCatalogNumber . chr(9);
$line.= $BulletPoint1 . chr(9);
$line.= $BulletPoint2 . chr(9);
$line.= $BulletPoint3 . chr(9);
$line.= $BulletPoint4 . chr(9);
$line.= $BulletPoint5 . chr(9);
$line.= $Description . chr(9);
$line.= $SearchTerms1 . chr(9);
$line.= $SearchTerms2 . chr(9);
$line.= $SearchTerms3 . chr(9);
$line.= $SearchTerms4 . chr(9);
$line.= $SearchTerms5 . chr(9);
$line.= $SwatchImageURL . chr(9);
$line.= $OtherImageURL1 . chr(9);
$line.= $OtherImageURL2 . chr(9);
$line.= $OtherImageURL3 . chr(9);
$line.= $OtherImageURL4 . chr(9);
$line.= $OtherImageURL5 . chr(9);
$line.= $OtherImageURL6 . chr(9);
$line.= $OtherImageURL7 . chr(9);
$line.= $OtherImageURL8 . chr(9);
$line.= $DisplayLength . chr(9);
$line.= $DisplayLengthUnitOfMeasure . chr(9);
$line.= $DisplayWidth . chr(9);
$line.= $DisplayWidthUnitOfMeasure . chr(9);
$line.= $DisplayHeight . chr(9);
$line.= $DisplayHeightUnitOfMeasure . chr(9);
$line.= $DisplayDepth . chr(9);
$line.= $DisplayDepthUnitOfMeasure . chr(9);
$line.= $DisplayDiameter . chr(9);
$line.= $DisplayDiameterUnitOfMeasure . chr(9);
$line.= $DisplayWeight . chr(9);
$line.= $DisplayWeightUnitOfMeasure . chr(9);
$line.= $Volume . chr(9);
$line.= $VolumeUnitOfMeasure . chr(9);
$line.= $ItemPackageQuantity . chr(9);
$line.= $Parentage . chr(9);
$line.= $ParentSKU . chr(9);
$line.= $RelationshipType . chr(9);
$line.= $BB_Color . chr(9);
$line.= $BB_ColorMap . chr(9);
$line.= $BB_Size . chr(9);
$line.= $BB_Scent . chr(9);
$line.= $BB_VariationTheme . chr(9);
$line.= $BB_ThreadCount . chr(9);
$line.= $BB_Material . chr(9);
$line.= $BB_IsStainResistant . chr(9);
$line.= $BB_NumberOfSets . chr(9);
$line.= $BB_Wattage . chr(9);
$line.= $FD_Color . chr(9);
$line.= $FD_ColorMap . chr(9);
$line.= $FD_Size . chr(9);
$line.= $FD_Scent . chr(9);
$line.= $FD_VariationThem . chr(9);e . chr(9);
$line.= $FD_ThreadCount . chr(9);
$line.= $FD_Material . chr(9);
$line.= $FD_IsStainResistant . chr(9);
$line.= $FD_NumberOfSets . chr(9);
$line.= $FD_Wattage . chr(9);
$line.= $FD_AreBatteriesIncluded . chr(9);
$line.= $FD_AreBatteriesRequired . chr(9);
$line.= $FD_BatteryType1 . chr(9);
$line.= $FD_BatteryType2 . chr(9);
$line.= $FD_BatteryType3 . chr(9);
$line.= $FD_NumberOfBatteries1 . chr(9);
$line.= $FD_NumberOfBatteries2 . chr(9);
$line.= $FD_NumberOfBatteries3 . chr(9);
$line.= $K_Color . chr(9);
$line.= $K_ColorMap . chr(9);
$line.= $K_Size . chr(9);
$line.= $K_VariationTheme . chr(9);
$line.= $K_ThreadCount . chr(9);
$line.= $K_Material . chr(9);
$line.= $K_NumberOfSets . chr(9);
$line.= $K_Wattage . chr(9);
$line.= $K_AreBatteriesIncluded . chr(9);
$line.= $K_AreBatteriesRequired . chr(9);
$line.= $K_BatteryType1 . chr(9);
$line.= $K_BatteryType2 . chr(9);
$line.= $K_BatteryType3 . chr(9);
$line.= $K_NumberOfBatteries1 . chr(9);
$line.= $K_NumberOfBatteries2 . chr(9);
$line.= $K_NumberOfBatteries3 . chr(9);
$line.= $OL_Color . chr(9);
$line.= $OL_ColorMap . chr(9);
$line.= $OL_Size . chr(9);
$line.= $OL_VariationTheme . chr(9);
$line.= $OL_Material . chr(9);
$line.= $OL_IsStainResistant . chr(9);
$line.= $OL_Wattage . chr(9);
$line.= $OL_AreBatteriesIncluded . chr(9);
$line.= $OL_AreBatteriesRequired . chr(9);
$line.= $OL_BatteryType1 . chr(9);
$line.= $OL_BatteryType2 . chr(9);
$line.= $OL_BatteryType3 . chr(9);
$line.= $OL_NumberOfBatteries1 . chr(9);
$line.= $OL_NumberOfBatteries2 . chr(9);
$line.= $OL_NumberOfBatteries3 . chr(9);
$line.= $SP_Color . chr(9);
$line.= $SP_ColorMap . chr(9);
$line.= $SP_Size . chr(9);
$line.= $SP_VariationTheme . chr(9);
$line.= $SP_SunlightExposure . chr(9);
$line.= $SP_MoistureNeeds . chr(9);
$line.= $SP_USDAHardinessZone1 . chr(9);
$line.= $SP_USDAHardinessZone2 . chr(9);
$line.= $SP_USDAHardinessZone3 . chr(9);
$line.= $SP_USDAHardinessZone4 . chr(9);
$line.= $SP_USDAHardinessZone5 . chr(9);
$line.= $SP_USDAHardinessZone6 . chr(9);
$line.= $SP_USDAHardinessZone7 . chr(9);
$line.= $SP_USDAHardinessZone8 . chr(9);
$line.= $SP_USDAHardinessZone9 . chr(9);
$line.= $SP_USDAHardinessZone10 . chr(9);
$line.= $SP_USDAHardinessZone11 . chr(9);
$line.= $SP_SunsetClimateZone1 . chr(9);
$line.= $SP_SunsetClimateZone2 . chr(9);
$line.= $SP_SunsetClimateZone3 . chr(9);
$line.= $SP_SunsetClimateZone4 . chr(9);
$line.= $SP_SunsetClimateZone5 . chr(9);
$line.= $SP_SunsetClimateZone6 . chr(9);
$line.= $SP_SunsetClimateZone7 . chr(9);
$line.= $SP_SunsetClimateZone8 . chr(9);
$line.= $SP_SunsetClimateZone9 . chr(9);
$line.= $SP_SunsetClimateZone10 . chr(9);
$line.= $SP_SunsetClimateZone11 . chr(9);
$line.= $SP_SunsetClimateZone12 . chr(9);
$line.= $SP_SunsetClimateZone13 . chr(9);
$line.= $SP_SunsetClimateZone14 . chr(9);
$line.= $SP_SunsetClimateZone15 . chr(9);
$line.= $SP_SunsetClimateZone16 . chr(9);
$line.= $SP_SunsetClimateZone17 . chr(9);
$line.= $SP_SunsetClimateZone18 . chr(9);
$line.= $SP_SunsetClimateZone19 . chr(9);
$line.= $SP_SunsetClimateZone20 . chr(9);
$line.= $SP_SunsetClimateZone21 . chr(9);
$line.= $SP_SunsetClimateZone22 . chr(9);
$line.= $SP_SunsetClimateZone23 . chr(9);
$line.= $SP_SunsetClimateZone24 . chr(9);
$line.= $SP_Spread . chr(9);
$line.= $SP_SpreadUnitOfMeasure . chr(9);
$line.= $ManufacturerWarranty . chr(9);
$line.= $CountryProducedIn . chr(9);
$line.= $ProductTaxCode . chr(9);
$line.= $ReleaseDate . chr(9);
$line.= $SalesPrice . chr(9);
$line.= $FulfillmentCenterID . chr(9);
$line.= $SaleStartDate . chr(9);
$line.= $SaleEndDate . chr(9);
$line.= $ConditionType . chr(9);
$line.= $ConditionNote . chr(9);
$line.= $leadtime_to_ship . chr(9);
$line.= $RestockDate . chr(9);
$line.= $MaxAggregateShipQuantity . chr(9);
$line.= $IsGiftMessageAvailable . chr(9);
$line.= $IsGiftWrapAvailable . chr(9);
$line.= $IsDiscontinuedByManufacturer . chr(9);
$line.= $RegisteredParameter . chr(9);
$line.= $PlatinumKeyword1 . chr(9);
$line.= $PlatinumKeyword2 . chr(9);
$line.= $PlatinumKeyword3 . chr(9);
$line.= $PlatinumKeyword4 . chr(9);
$line.= $PlatinumKeyword5 . chr(9);
$line.= chr(9);
$line.= $update_delete . chr(9);
$line.= chr(13);

$liste_produits .= $line;



/********************************************************  produits ********************************************************************/


////////////////produits suprieur  15 euro ///////////////
}// fin if is ( tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id'])) >= 15 ) {
//////////////////////////////
  }
$info_string.='</table>';
echo $info_string;
/******************************************************** Fin traitement de produits ********************************************************************/




$feed = "";

$feed = <<<EOD
TemplateType=Home	Version=1.4	This row for Amazon.com use only.  Do not modify or delete.																																																																							BED AND BATH SPECIFIC FIELDS										FURNITURE AND DCOR SPECIFIC FIELDS																		KITCHEN SPECIFIC FIELDS																OUTDOOR LIVING SPECIFIC FIELDS															SEEDS AND PLANTS SPECIFIC FIELDS																																																																		 
SKU	StandardProductID	ProductIDType	ProductName	Brand	Manufacturer	ProductType	RecommendedBrowseNode1	RecommendedBrowseNode2	MainImageURL	LaunchDate	ItemPrice	Currency	Quantity	ShippingWeight	ShippingWeightUnitOfMeasure	ManufacturerPartNumber	MerchantCatalogNumber	BulletPoint1	BulletPoint2	BulletPoint3	BulletPoint4	BulletPoint5	Description	SearchTerms1	SearchTerms2	SearchTerms3	SearchTerms4	SearchTerms5	SwatchImageURL	OtherImageURL1	OtherImageURL2	OtherImageURL3	OtherImageURL4	OtherImageURL5	OtherImageURL6	OtherImageURL7	OtherImageURL8	DisplayLength	DisplayLengthUnitOfMeasure	DisplayWidth	DisplayWidthUnitOfMeasure	DisplayHeight	DisplayHeightUnitOfMeasure	DisplayDepth	DisplayDepthUnitOfMeasure	DisplayDiameter	DisplayDiameterUnitOfMeasure	DisplayWeight	DisplayWeightUnitOfMeasure	Volume	VolumeUnitOfMeasure	ItemPackageQuantity	Parentage	ParentSKU	RelationshipType	BB_Color	BB_ColorMap	BB_Size	BB_Scent	BB_VariationTheme	BB_ThreadCount	BB_Material	BB_IsStainResistant	BB_NumberOfSets	BB_Wattage	FD_Color	FD_ColorMap	FD_Size	FD_Scent	FD_VariationTheme	FD_ThreadCount	FD_Material	FD_IsStainResistant	FD_NumberOfSets	FD_Wattage	FD_AreBatteriesIncluded	FD_AreBatteriesRequired	FD_BatteryType1	FD_BatteryType2	FD_BatteryType3	FD_NumberOfBatteries1	FD_NumberOfBatteries2	FD_NumberOfBatteries3	K_Color	K_ColorMap	K_Size	K_VariationTheme	K_ThreadCount	K_Material	K_NumberOfSets	K_Wattage	K_AreBatteriesIncluded	K_AreBatteriesRequired	K_BatteryType1	K_BatteryType2	K_BatteryType3	K_NumberOfBatteries1	K_NumberOfBatteries2	K_NumberOfBatteries3	OL_Color	OL_ColorMap	OL_Size	OL_VariationTheme	OL_Material	OL_IsStainResistant	OL_Wattage	OL_AreBatteriesIncluded	OL_AreBatteriesRequired	OL_BatteryType1	OL_BatteryType2	OL_BatteryType3	OL_NumberOfBatteries1	OL_NumberOfBatteries2	OL_NumberOfBatteries3	SP_Color	SP_ColorMap	SP_Size	SP_VariationTheme	SP_SunlightExposure	SP_MoistureNeeds	SP_USDAHardinessZone1	SP_USDAHardinessZone2	SP_USDAHardinessZone3	SP_USDAHardinessZone4	SP_USDAHardinessZone5	SP_USDAHardinessZone6	SP_USDAHardinessZone7	SP_USDAHardinessZone8	SP_USDAHardinessZone9	SP_USDAHardinessZone10	SP_USDAHardinessZone11	SP_SunsetClimateZone1	SP_SunsetClimateZone2	SP_SunsetClimateZone3	SP_SunsetClimateZone4	SP_SunsetClimateZone5	SP_SunsetClimateZone6	SP_SunsetClimateZone7	SP_SunsetClimateZone8	SP_SunsetClimateZone9	SP_SunsetClimateZone10	SP_SunsetClimateZone11	SP_SunsetClimateZone12	SP_SunsetClimateZone13	SP_SunsetClimateZone14	SP_SunsetClimateZone15	SP_SunsetClimateZone16	SP_SunsetClimateZone17	SP_SunsetClimateZone18	SP_SunsetClimateZone19	SP_SunsetClimateZone20	SP_SunsetClimateZone21	SP_SunsetClimateZone22	SP_SunsetClimateZone23	SP_SunsetClimateZone24	SP_Spread	SP_SpreadUnitOfMeasure	ManufacturerWarranty	CountryProducedIn	ProductTaxCode	ReleaseDate	SalesPrice	FulfillmentCenterID	SaleStartDate	SaleEndDate	ConditionType	ConditionNote	leadtime-to-ship	RestockDate	MaxAggregateShipQuantity	NumberOfPieces	IsGiftMessageAvailable	IsGiftWrapAvailable	IsDiscontinuedByManufacturer	RegisteredParameter	PlatinumKeyword1	PlatinumKeyword2	PlatinumKeyword3	PlatinumKeyword4	PlatinumKeyword5	update-delete	
$liste_produits
EOD;

// Constructing the MarketplaceId array which will be passed in as the the MarketplaceIdList 
// parameter to the SubmitFeedRequest object.
//$marketplaceIdArray = array("Id" => array('<Marketplace_Id_1>','<Marketplace_Id_2>'));
$marketplaceIdArray = array("Id" => array('A1F83G8C2ARO7P'));
     
 // MWS request objects can be constructed two ways: either passing an array containing the 
 // required request parameters into the request constructor, or by individually setting the request
 // parameters via setter methods.
 // Uncomment one of the methods below.
 

/********* Begin Comment Block *********/
//$feedHandle = fopen('php://memory', 'rw+');
//$feedHandle = fopen('php://memory', 'rw+');

$feedHandle = fopen('amazon-maison-uk.txt', 'w+');

echo "<hr>";
fwrite($feedHandle, $feed);
rewind($feedHandle);


//$feedHandle = @fopen('php://memory', 'rw+');
//fwrite($feedHandle, $fileContent);
rewind($feedHandle);
$parameters = array (
'Marketplace' => MARKETPLACE_ID,
'Merchant' => MERCHANT_ID,
'FeedType' => '_POST_FLAT_FILE_LISTINGS_DATA_',
'FeedContent' => $feedHandle,

'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true)),
);

$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);

/********* End Comment Block *********/

  invokeSubmitFeed($service, $request); // appel pour transmettre le fichier

echo "<hr>";
echo "<pre>";
print_r($request);
echo "</pre>";


@fclose($feedHandle);
                                        
/**
  * Submit Feed Action Sample
  * Uploads a file for processing together with the necessary
  * metadata to process the file, such as which type of feed it is.
  * PurgeAndReplace if true means that your existing e.g. inventory is
  * wiped out and replace with the contents of this feed - use with
  * caution (the default is false).
  *   
  * @param MarketplaceWebService_Interface $service instance of MarketplaceWebService_Interface
  * @param mixed $request MarketplaceWebService_Model_SubmitFeed or array of parameters
  */
  function invokeSubmitFeed(MarketplaceWebService_Interface $service, $request) 
  {
      try {
              $response = $service->submitFeed($request);
              

echo "<hr>response";
echo "<pre>";
 print_r($response);
echo "</pre>";
echo "<hr>";
                echo ("Service Response\n");
                echo ("=============================================================================\n");

                echo("        SubmitFeedResponse\n");

                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId\n");
                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

                echo("ResponseHeaderMetadata: " . $response->getResponseHeaderMetadata() . "\n");
     } catch (MarketplaceWebService_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
         echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
     }
 }
             
function filter_text($text) {
$filter_array = array(";","\r","\n","\t",chr(34),chr(13),chr(10));
return str_replace($filter_array," ",$text);
} // function for the filter
                 