<?php
if (!class_exists('DateTime')) {
class DateTime {
    public $date;
   
    public function __construct($date) {
        $this->date = strtotime($date);
    }
   
    public function setTimeZone($timezone) {
        return;
    }
   
    private function __getDate() {
        return date(DATE_ATOM, $this->date);   
    }
   
    public function modify($multiplier) {
        $this->date = strtotime($this->__getDate() . ' ' . $multiplier);
    }
   
    public function format($format) {
        return date($format, $this->date);
    }
}
}

/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2009 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2009-01-01
 */
/******************************************************************************* 

 *  Marketplace Web Service PHP5 Library
 *  Generated: Thu May 07 13:07:36 PDT 2009
 * 
 */

/**
 * Submit Feed  Sample
 */

include_once ('.config.inc.php'); 

/************************************************************************
* Uncomment to configure the client instance. Configuration settings
* are:
*
* - MWS endpoint URL
* - Proxy host and port.
* - MaxErrorRetry.
***********************************************************************/
// IMPORTANT: Uncomment the approiate line for the country you wish to
// sell in:
// United States:
//$serviceUrl = "https://mws.amazonservices.com";
// United Kingdom
//$serviceUrl = "https://mws.amazonservices.co.uk";
// Germany
//$serviceUrl = "https://mws.amazonservices.de";
// France
$serviceUrl = "https://mws.amazonservices.fr";
// Italy
//$serviceUrl = "https://mws.amazonservices.it";
// Japan
//$serviceUrl = "https://mws.amazonservices.jp";
// China
//$serviceUrl = "https://mws.amazonservices.com.cn";
// Canada
//$serviceUrl = "https://mws.amazonservices.ca";
// India
//$serviceUrl = "https://mws.amazonservices.in";

$config = array (
  'ServiceURL' => $serviceUrl,
  'ProxyHost' => null,
  'ProxyPort' => -1,
  'MaxErrorRetry' => 3,
);

/************************************************************************
 * Instantiate Implementation of MarketplaceWebService
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
 $service = new MarketplaceWebService_Client(
     AWS_ACCESS_KEY_ID, 
     AWS_SECRET_ACCESS_KEY, 
     $config,
     APPLICATION_NAME,
     APPLICATION_VERSION);
 
/************************************************************************
 * Uncomment to try out Mock Service that simulates MarketplaceWebService
 * responses without calling MarketplaceWebService service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under MarketplaceWebService/Mock tree
 *
 ***********************************************************************/
 // $service = new MarketplaceWebService_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for Submit Feed Action
 ***********************************************************************/
 // @TODO: set request. Action can be passed as MarketplaceWebService_Model_SubmitFeedRequest
 // object or array of parameters

// Note that PHP memory streams have a default limit of 2M before switching to disk. While you
// can set the limit higher to accomidate your feed in memory, it's recommended that you store
// your feed on disk and use traditional file streams to submit your feeds. For conciseness, this
// examples uses a memory stream.




/**************************************************************** traitement produits ******************************************************/

//  Header( 'Content-Type: text/xml' ); 
  define ('DISPLAY_PRICE_WITH_TAX', true);

  define ('DEFAULT_CURRENCY','EUR');

  require('import_top_special.php');
 // require('../../includes/application_top.php');

$string='';
$info_string = '<table border="1" width="100%" cellspacing="0" cellpadding="2" style="	font-family: Arial, Helvetica, sans-serif;font-size:10px;">';
  // On vrifie la langue utilise dans le catalogue
  $language_code = (isset($HTTP_GET_VARS['language']) && tep_not_null($HTTP_GET_VARS['language'])) ? $HTTP_GET_VARS['language'] : DEFAULT_LANGUAGE;

// langue anglais
$languages_id=2;
$coef_livre=1.16822;

  // Requte pour identifier les catgories existantes dans le catalogue
  $included_categories_query = tep_db_query("SELECT c.categories_id, c.parent_id, cd.categories_name FROM " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd 

WHERE 

c.categories_id = cd.categories_id 

AND cd.language_id = FLOOR($languages_id)

");

  $inc_cat = array();

  // Identification du nom de la catgorie, et l'id de la catgorie parent
  while ($included_categories = tep_db_fetch_array($included_categories_query)) {
  $inc_cat[] = array (
     'id' => $included_categories['categories_id'],
     'parent' => $included_categories['parent_id'],
     'name' => $included_categories['categories_name']);
  }

  $cat_info = array();
  for ($i=0; $i < sizeof($inc_cat); $i++)
    $cat_info[$inc_cat[$i]['id']] = array (
    'parent'=> $inc_cat[$i]['parent'],
    'name'  => $inc_cat[$i]['name'],
    'path'  => $inc_cat[$i]['id'],
    'link'  => '' );

  for ($i=0; $i < sizeof($inc_cat); $i++) {
  $cat_id = $inc_cat[$i]['id'];
  while ($cat_info[$cat_id]['parent'] != 0){
    $cat_info[$inc_cat[$i]['id']]['path'] = $cat_info[$cat_id]['parent'] . '_' . $cat_info[$inc_cat[$i]['id']]['path'];
    $cat_id = $cat_info[$cat_id]['parent'];
    }
  $link_array = split('_', $cat_info[$inc_cat[$i]['id']] ['path']);
  for ($j=0; $j < sizeof($link_array); $j++) {
    $cat_info[$inc_cat[$i]['id']]['link'] .= '&nbsp;<a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $cat_info[$link_array[$j]]['path']) . '"><nobr>' . $cat_info[$link_array[$j]]['name'] . '</nobr></a>&nbsp;&raquo;&nbsp;';
    }
  }

  // Requte identifiant les produits disponibles dans le catalogue


//AND pc.categories_id <> '505830'
//AND pc.categories_id <> '707860'
//AND pc.categories_id <> '505840'

  $products_query = tep_db_query("SELECT p.*, pd.products_name, pd.products_description, pc.categories_id, pcat.categorie_id_amazon_uk ,pcatdesc.categories_name  FROM " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS_TO_CATEGORIES . " pc , " . TABLE_CATEGORIES . " pcat , " . TABLE_CATEGORIES_DESCRIPTION . " pcatdesc 

WHERE 
p.products_id = pd.products_id 

AND p.products_id = pc.products_id 
AND pc.categories_id = pcat.categories_id
AND pc.categories_id = pcatdesc.categories_id
AND pcatdesc.language_id  = FLOOR($languages_id)

AND 
  (pc.categories_id = '45'
OR pc.categories_id = '15'
OR pc.categories_id = '47'
OR pc.categories_id = '49'
OR pc.categories_id = '46'
OR pc.categories_id = '30'
OR pc.categories_id = '29'
OR pc.categories_id = '128'
OR pc.categories_id = '95'
)




AND pd.language_id = FLOOR($languages_id) 

ORDER BY pc.categories_id, pd.products_name");

  $product_num = 0;
  $liste_produits='';

  while($products = tep_db_fetch_array($products_query)) {

  if (intval($products['manufacturers_id']) > 0) {
  	$manufacturers_query = tep_db_query("SELECT manufacturers_name FROM " . TABLE_MANUFACTURERS_INFO . " WHERE manufacturers_id = " . $products['manufacturers_id'] ." and languages_id = ".FLOOR($languages_id));
  	$manufacturers_result = tep_db_fetch_array($manufacturers_query);
  	$products['manufacturers_name'] = $manufacturers_result['manufacturers_name'];
 }

  $special_query = tep_db_query("SELECT specials_new_products_price  FROM " . TABLE_SPECIALS . " WHERE products_id = " . $products['products_id'] ." AND status = 1 ");
  if ($special_result = tep_db_fetch_array($special_query))
  	$products['products_price'] = $special_result['specials_new_products_price'];

$prixprod =tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));
$description = substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,2000);
$nom_produit = ($products['products_name']);

$prix_marketplace =  round(tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']))*1.22,2);
$prix_marketplace = tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id']));

$prix_marketplace = round((($products['products_price']) * (1+(tep_get_tax_rate($products['products_tax_class_id'])/100))) *1.22,2);
$prix_marketplace= round(($prix_marketplace / $coef_livre),2);

$qty = $products['products_quantity'];

 if (( strlen($products['products_ean']) == 13 ) 
    && ( $products['categorie_id_amazon_uk'] <> 0 )

	)
{
//////////////////////////////

  $product_num++;

if ($qty <= 0 ) { 
					$qty =0;
					$update_or_delete="Delete";
				} else {
					$update_or_delete="Update";
						}

  $info_string.= 	
					"<tr><td width=50>". 
					"<font color=red>". 
					"" . $products['products_id'] . 
					"</font>". 
					"</td><td width=130>". 
					"ean : " . $products['products_ean'] .
					"</td><td width=70>".  
					"<font color=red><b>". 
					"" . $prix_marketplace . 	"</b></font>  | q : ".  $qty .
					"" .  
					"</td><td width=100>". 
					"<font color=red><b>". 
					"node : " . $products['categorie_id_amazon_uk'] . 
					"</b></font>". 
					"</td><td>". 
					"" . $description . 
					"</td>".
					"<td width=200>". 
					"cat CB: " . $products['categories_id'] . "<font color=red><b>  " . $products['categories_name'] . "<font color=red><b>".
					"</td></tr>";

  $string.= '<offer>';
  $string.= '<product_reference type="Ean"><![CDATA['. $products['products_ean'] .']]></product_reference>';
  $string.= '<offer_reference type="SellerSku"><![CDATA['. $products['products_id'] .']]></offer_reference>';
  $string.= '<price><![CDATA['. $prix_marketplace .']]></price>';
  $string.= '<product_state>11</product_state>';
  $string.= '<quantity><![CDATA['.$qty.']]></quantity>';
  $string.= '<description><![CDATA['. substr(strip_tags(str_replace(array('<BR>','<br>','<br />'), "</P>\n<P>",html_entity_decode($products['products_description']))),0,250) .'.]]></description>';
  $string.= '<internal_comment></internal_comment>';
  $string.= '<showcase><![CDATA[100]]></showcase>';



/************************************** frais de transport **************************************/
/************************************** pour les market place ***********************************/



		$prix_transport = (5.4347  + (floatval($products['products_weight']) * 3));
	//	echo round($prix_transport,2) ;


if ( $products['products_image_med'] == '' )
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image'] ; }
else
{ $image =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image_med'] ; }
	

$productType= "ToysAndGames";

/************************************** frais de transport FIN ***********************************/
  

/********************************************************  produits ********************************************************************/


$sku=$products['products_ean'];
$title=filter_text($nom_produit);
$standard_product_id=$products['products_ean'];
$product_id_type='EAN';
$product_type=$productType;
$brand=filter_text($products['manufacturers_name']);
$manufacturer=filter_text($products['manufacturers_name']);
$mfr_part_number='';
$description=filter_text($description);
$bullet_point1='';
$bullet_point2='';
$bullet_point3='';
$bullet_point4='';
$bullet_point5='';
$quantity=$qty;
$item_price=$prix_marketplace;
$currency='EUR';
$condition_type='New';
$condition_note='';
$legal_disclaimer='';
$launch_date='';
$leadtime_to_ship='';
$shipping_weight=$products['products_weight'];
$shipping_weight_unit_of_measure='KG';
$release_date='';
$restock_date='';
$sale_price='';
$sale_start_date='';
$sale_end_date='';
$recommended_browse_node1=$products['categorie_id_amazon_uk'];
$recommended_browse_node2='';
$search_terms1=filter_text(substr($nom_produit,50));
$search_terms2=filter_text($products['manufacturers_name']);
$search_terms3='';
$search_terms4='';
$search_terms5='';
$main_image_url=$image;
$swatch_image_url='';
$other_image_url1='';
$other_image_url2='';
$other_image_url3='';
$other_image_url4='';
$other_image_url5='';
$other_image_url6='';
$other_image_url7='';
$other_image_url8='';
$fulfillment_center_id='';
$package_height='';
$package_width='';
$package_length='';
$package_length_unit_of_measure='';
$package_weight='';
$package_weight_unit_of_measure='';
$parentage='';
$relationship_type='';
$parent_sku='';
$variation_theme='';
$color='';
$color_map='';
$size='';
$size_map='';
$manufacturer_safety_warning='';
$manufacturer_warranty_description='';
$material_type='';
$care_instructions1='';
$care_instructions2='';
$care_instructions3='';
$is_assembly_required='';
$assembly_instructions='';
$assembly_time='';
$assembly_time_unit_of_measure='';
$country_of_origin='';
$minimum_manufacturer_age_recommended='';
$minimum_manufacturer_age_recommended_unit_of_measure='';
$maximum_manufacturer_age_recommended='';
$maximum_manufacturer_age_recommended_unit_of_measure='';
$minimum_manufacturer_weight_recommended='';
$minimum_manufacturer_weight_recommended_unit_of_measure='';
$maximum_manufacturer_weight_recommended='';
$maximum_manufacturer_weight_recommended_unit_of_measure='';
$target_gender='';
$special_features1='';
$special_features2='';
$special_features3='';
$seller_warranty_description='';
$subject_character='';
$subject='';
$material_composition='';
$scale='';
$rail_gauge='';
$remote_control_technology='';
$includes_remote='';
$number_of_frequency_channels='';
$number_of_control_channels='';
$frequency_bands_supported='';
$engine_type='';
$recommended_use='';
$educational_value='';
$language='';
$number_of_players='';
$number_of_pieces='';
$awards_won='';
$handle_height='';
$handle_height_unit_of_measure='';
$seat_length='';
$seat_length_unit_of_measure='';
$seat_width='';
$seat_width_unit_of_measure='';
$tire_material='';
$tire_diameter='';
$tire_diameter_unit_of_measure='';
$item_length='';
$item_height='';
$item_width='';
$item_weight='';
$item_weight_unit_of_measure='';
$item_dimension_unit_of_measure='';
$number_of_items='';
$display_weight='';
$display_weight_unit_of_measure='';
$display_volume='';
$display_volume_unit_of_measure='';
$display_length='';
$display_length_unit_of_measure='';
$are_batteries_included='';
$are_batteries_required='';
$battery_type1='';
$battery_type2='';
$battery_type3='';
$number_of_batteries1='';
$number_of_batteries2='';
$number_of_batteries3='';
$battery_type_lithium_ion='';
$battery_type_lithium_metal='';
$lithium_battery_energy_content='';
$lithium_battery_voltage='';
$number_of_lithium_ion_cells='';
$number_of_lithium_metal_cells='';
$lithium_battery_weight='';
$lithium_battery_packaging='';
$discontinue_date='';
$max_aggregate_ship_quantity='';
$product_tax_code='';
$merchant_catalog_number='';
$is_gift_message_available='';
$is_giftwrap_available='';
$registered_parameter='';
$is_discontinued_by_manufacturer='';
$platinum_keywords1='';
$platinum_keywords2='';
$platinum_keywords3='';
$platinum_keywords4='';
$platinum_keywords5='';
$specification_met='';
$update_delete=$update_or_delete;




$line =$sku . chr(9);
$line .=$title . chr(9);
$line .=$standard_product_id . chr(9);
$line .=$product_id_type . chr(9);
$line .=$product_type . chr(9);
$line .=$brand . chr(9);
$line .=$manufacturer . chr(9);
$line .=$mfr_part_number . chr(9);
$line .=$description . chr(9);
$line .=$bullet_point1 . chr(9);
$line .=$bullet_point2 . chr(9);
$line .=$bullet_point3 . chr(9);
$line .=$bullet_point4 . chr(9);
$line .=$bullet_point5 . chr(9);
$line .=$quantity . chr(9);
$line .=$item_price . chr(9);
$line .=$currency . chr(9);
$line .=$condition_type . chr(9);
$line .=$condition_note . chr(9);
$line .=$legal_disclaimer . chr(9);
$line .=$launch_date . chr(9);
$line .=$leadtime_to_ship . chr(9);
$line .=$shipping_weight . chr(9);
$line .=$shipping_weight_unit_of_measure . chr(9);
$line .=$release_date . chr(9);
$line .=$restock_date . chr(9);
$line .=$sale_price . chr(9);
$line .=$sale_start_date . chr(9);
$line .=$sale_end_date . chr(9);
$line .=$recommended_browse_node1 . chr(9);
$line .=$recommended_browse_node2 . chr(9);
$line .=$search_terms1 . chr(9);
$line .=$search_terms2 . chr(9);
$line .=$search_terms3 . chr(9);
$line .=$search_terms4 . chr(9);
$line .=$search_terms5 . chr(9);
$line .=$main_image_url . chr(9);
$line .=$swatch_image_url . chr(9);
$line .=$other_image_url1 . chr(9);
$line .=$other_image_url2 . chr(9);
$line .=$other_image_url3 . chr(9);
$line .=$other_image_url4 . chr(9);
$line .=$other_image_url5 . chr(9);
$line .=$other_image_url6 . chr(9);
$line .=$other_image_url7 . chr(9);
$line .=$other_image_url8 . chr(9);
$line .=$fulfillment_center_id . chr(9);
$line .=$package_height . chr(9);
$line .=$package_width . chr(9);
$line .=$package_length . chr(9);
$line .=$package_length_unit_of_measure . chr(9);
$line .=$package_weight . chr(9);
$line .=$package_weight_unit_of_measure . chr(9);
$line .=$parentage . chr(9);
$line .=$relationship_type . chr(9);
$line .=$parent_sku . chr(9);
$line .=$variation_theme . chr(9);
$line .=$color . chr(9);
$line .=$color_map . chr(9);
$line .=$size . chr(9);
$line .=$size_map . chr(9);
$line .=$manufacturer_safety_warning . chr(9);
$line .=$manufacturer_warranty_description . chr(9);
$line .=$material_type . chr(9);
$line .=$care_instructions1 . chr(9);
$line .=$care_instructions2 . chr(9);
$line .=$care_instructions3 . chr(9);
$line .=$is_assembly_required . chr(9);
$line .=$assembly_instructions . chr(9);
$line .=$assembly_time . chr(9);
$line .=$assembly_time_unit_of_measure . chr(9);
$line .=$country_of_origin . chr(9);
$line .=$minimum_manufacturer_age_recommended . chr(9);
$line .=$minimum_manufacturer_age_recommended_unit_of_measure . chr(9);
$line .=$maximum_manufacturer_age_recommended . chr(9);
$line .=$maximum_manufacturer_age_recommended_unit_of_measure . chr(9);
$line .=$minimum_manufacturer_weight_recommended . chr(9);
$line .=$minimum_manufacturer_weight_recommended_unit_of_measure . chr(9);
$line .=$maximum_manufacturer_weight_recommended . chr(9);
$line .=$maximum_manufacturer_weight_recommended_unit_of_measure . chr(9);
$line .=$target_gender . chr(9);
$line .=$special_features1 . chr(9);
$line .=$special_features2 . chr(9);
$line .=$special_features3 . chr(9);
$line .=$seller_warranty_description . chr(9);
$line .=$subject_character . chr(9);
$line .=$subject . chr(9);
$line .=$material_composition . chr(9);
$line .=$scale . chr(9);
$line .=$rail_gauge . chr(9);
$line .=$remote_control_technology . chr(9);
$line .=$includes_remote . chr(9);
$line .=$number_of_frequency_channels . chr(9);
$line .=$number_of_control_channels . chr(9);
$line .=$frequency_bands_supported . chr(9);
$line .=$engine_type . chr(9);
$line .=$recommended_use . chr(9);
$line .=$educational_value . chr(9);
$line .=$language . chr(9);
$line .=$number_of_players . chr(9);
$line .=$number_of_pieces . chr(9);
$line .=$awards_won . chr(9);
$line .=$handle_height . chr(9);
$line .=$handle_height_unit_of_measure . chr(9);
$line .=$seat_length . chr(9);
$line .=$seat_length_unit_of_measure . chr(9);
$line .=$seat_width . chr(9);
$line .=$seat_width_unit_of_measure . chr(9);
$line .=$tire_material . chr(9);
$line .=$tire_diameter . chr(9);
$line .=$tire_diameter_unit_of_measure . chr(9);
$line .=$item_length . chr(9);
$line .=$item_height . chr(9);
$line .=$item_width . chr(9);
$line .=$item_weight . chr(9);
$line .=$item_weight_unit_of_measure . chr(9);
$line .=$item_dimension_unit_of_measure . chr(9);
$line .=$number_of_items . chr(9);
$line .=$display_weight . chr(9);
$line .=$display_weight_unit_of_measure . chr(9);
$line .=$display_volume . chr(9);
$line .=$display_volume_unit_of_measure . chr(9);
$line .=$display_length . chr(9);
$line .=$display_length_unit_of_measure . chr(9);
$line .=$are_batteries_included . chr(9);
$line .=$are_batteries_required . chr(9);
$line .=$battery_type1 . chr(9);
$line .=$battery_type2 . chr(9);
$line .=$battery_type3 . chr(9);
$line .=$number_of_batteries1 . chr(9);
$line .=$number_of_batteries2 . chr(9);
$line .=$number_of_batteries3 . chr(9);
$line .=$battery_type_lithium_ion . chr(9);
$line .=$battery_type_lithium_metal . chr(9);
$line .=$lithium_battery_energy_content . chr(9);
$line .=$lithium_battery_voltage . chr(9);
$line .=$number_of_lithium_ion_cells . chr(9);
$line .=$number_of_lithium_metal_cells . chr(9);
$line .=$lithium_battery_weight . chr(9);
$line .=$lithium_battery_packaging . chr(9);
$line .=$discontinue_date . chr(9);
$line .=$max_aggregate_ship_quantity . chr(9);
$line .=$product_tax_code . chr(9);
$line .=$merchant_catalog_number . chr(9);
$line .=$is_gift_message_available . chr(9);
$line .=$is_giftwrap_available . chr(9);
$line .=$registered_parameter . chr(9);
$line .=$is_discontinued_by_manufacturer . chr(9);
$line .=$platinum_keywords1 . chr(9);
$line .=$platinum_keywords2 . chr(9);
$line .=$platinum_keywords3 . chr(9);
$line .=$platinum_keywords4 . chr(9);
$line .=$platinum_keywords5 . chr(9);
$line .=$specification_met . chr(9);
$line .=$update_delete . chr(9);


$line.= chr(13);

$liste_produits .= $line;



/********************************************************  produits ********************************************************************/


////////////////produits suprieur  15 euro ///////////////
}// fin if is ( tep_add_tax($products['products_price'], tep_get_tax_rate($products['products_tax_class_id'])) >= 15 ) {
//////////////////////////////
  }
$info_string.='</table>';
echo $info_string;
/******************************************************** Fin traitement de produits ********************************************************************/




$feed = "";

$feed = <<<EOD
TemplateType=ToysBaby	Version=1.7/1.2.11	This row for Amazon.com use only.  Do not modify or delete.																													Offer related information												Sale price related information			Item discovery information							Image information										FBA-related information							Variation information								Attributes for both Baby & Toy Products																							Attributes for ToysAndGames																		Attribute for BabyProducts									Product dimension attributes						Price Per Unit							Battery Information																Common infrequently used attributes														 
sku	title	standard-product-id	product-id-type	product-type	brand	manufacturer	mfr-part-number	description	bullet-point1	bullet-point2	bullet-point3	bullet-point4	bullet-point5	quantity	item-price	currency	condition-type	condition-note	legal-disclaimer	launch-date	leadtime-to-ship	shipping-weight	shipping-weight-unit-of-measure	release-date	restock-date	sale-price	sale-start-date	sale-end-date	recommended-browse-node1	recommended-browse-node2	search-terms1	search-terms2	search-terms3	search-terms4	search-terms5	main-image-url	swatch-image-url	other-image-url1	other-image-url2	other-image-url3	other-image-url4	other-image-url5	other-image-url6	other-image-url7	other-image-url8	fulfillment-center-id	package-height	package-width	package-length	package-length-unit-of-measure	package-weight	package-weight-unit-of-measure	parentage	relationship-type	parent-sku	variation-theme	color	color-map	size	size-map	manufacturer-safety-warning	manufacturer-warranty-description	material-type	care-instructions1	care-instructions2	care-instructions3	is-assembly-required	assembly-instructions	assembly-time	assembly-time-unit-of-measure	country-of-origin	minimum-manufacturer-age-recommended	minimum-manufacturer-age-recommended-unit-of-measure	maximum-manufacturer-age-recommended	maximum-manufacturer-age-recommended-unit-of-measure	minimum-manufacturer-weight-recommended	minimum-manufacturer-weight-recommended-unit-of-measure	maximum-manufacturer-weight-recommended	maximum-manufacturer-weight-recommended-unit-of-measure	target-gender	special-features1	special-features2	special-features3	seller-warranty-description	subject-character	subject	material-composition	scale	rail-gauge	remote-control-technology	includes-remote	number-of-frequency-channels	number-of-control-channels	frequency-bands-supported	engine-type	recommended_use	educational-value	language	number-of-players	number-of-pieces	awards-won	handle-height	handle-height-unit-of-measure	seat-length	seat-length-unit-of-measure	seat-width	seat-width-unit-of-measure	tire-material	tire-diameter	tire-diameter-unit-of-measure	item-length	item-height	item-width	item-weight	item-weight-unit-of-measure	item-dimension-unit-of-measure	number-of-items	display-weight	display-weight-unit-of-measure	display-volume	display-volume-unit-of-measure	display-length	display-length-unit-of-measure	are-batteries-included	are-batteries-required	battery-type1	battery-type2	battery-type3	number-of-batteries1	number-of-batteries2	number-of-batteries3	battery-type-lithium-ion	battery-type-lithium-metal	lithium-battery-energy-content	lithium-battery-voltage	number-of-lithium-ion-cells	number-of-lithium-metal-cells	lithium-battery-weight	lithium-battery-packaging	discontinue-date	max-aggregate-ship-quantity	product-tax-code	merchant-catalog-number	is-gift-message-available	is-giftwrap-available	registered-parameter	is-discontinued-by-manufacturer	platinum-keywords1	platinum-keywords2	platinum-keywords3	platinum-keywords4	platinum-keywords5	specification-met	update-delete	
$liste_produits
EOD;

// Constructing the MarketplaceId array which will be passed in as the the MarketplaceIdList 
// parameter to the SubmitFeedRequest object.
//$marketplaceIdArray = array("Id" => array('<Marketplace_Id_1>','<Marketplace_Id_2>'));
$marketplaceIdArray = array("Id" => array('A1F83G8C2ARO7P'));
     
 // MWS request objects can be constructed two ways: either passing an array containing the 
 // required request parameters into the request constructor, or by individually setting the request
 // parameters via setter methods.
 // Uncomment one of the methods below.
 

/********* Begin Comment Block *********/
//$feedHandle = fopen('php://memory', 'rw+');
//$feedHandle = fopen('php://memory', 'rw+');

$feedHandle = fopen('amazon-jeux-jouets-puericulture-uk.txt', 'w+');


echo "<hr>";
fwrite($feedHandle, $feed);
rewind($feedHandle);


//$feedHandle = @fopen('php://memory', 'rw+');
//fwrite($feedHandle, $fileContent);
rewind($feedHandle);
$parameters = array (
'Marketplace' => MARKETPLACE_ID,
'Merchant' => MERCHANT_ID,
'FeedType' => '_POST_FLAT_FILE_LISTINGS_DATA_',
'FeedContent' => $feedHandle,

'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true)),
);

$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);

/********* End Comment Block *********/

 invokeSubmitFeed($service, $request); // appel pour transmettre le fichier

echo "<hr>";
echo "<pre>";
print_r($request);
echo "</pre>";


@fclose($feedHandle);
                                        
/**
  * Submit Feed Action Sample
  * Uploads a file for processing together with the necessary
  * metadata to process the file, such as which type of feed it is.
  * PurgeAndReplace if true means that your existing e.g. inventory is
  * wiped out and replace with the contents of this feed - use with
  * caution (the default is false).
  *   
  * @param MarketplaceWebService_Interface $service instance of MarketplaceWebService_Interface
  * @param mixed $request MarketplaceWebService_Model_SubmitFeed or array of parameters
  */
  function invokeSubmitFeed(MarketplaceWebService_Interface $service, $request) 
  {
      try {
              $response = $service->submitFeed($request);
              

echo "<hr>response";
echo "<pre>";
 print_r($response);
echo "</pre>";
echo "<hr>";
                echo ("Service Response\n");
                echo ("=============================================================================\n");

                echo("        SubmitFeedResponse\n");

                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId\n");
                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

                echo("ResponseHeaderMetadata: " . $response->getResponseHeaderMetadata() . "\n");
     } catch (MarketplaceWebService_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
         echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
     }
 }
             
function filter_text($text) {
$filter_array = array(";","\r","\n","\t",chr(34),chr(13),chr(10));
return str_replace($filter_array," ",$text);
} // function for the filter
                 