<?php

/******************************************* *********************************************/
function createUploadJobRequest($jobType, $uuid) 
{
  global $debug;
  $request  = '<createUploadJobRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
  $request .= '<uploadJobType>' . $jobType . '</uploadJobType>';
  $request .= '<UUID>' . $uuid . '</UUID>';
  $request .= '</createUploadJobRequest>';

  return $request;
}
/******************************************* *********************************************/

	function createDownloadRequest($taskReferenceId, $fileReferenceId)
	{
		$request  = '<downloadFileRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
        $request .= '<taskReferenceId>' . $taskReferenceId . '</taskReferenceId>';
        $request .= '<fileReferenceId>' . $fileReferenceId . '</fileReferenceId>';
        $request .= '</downloadFileRequest>';
        
        return $request;
	}
	
	/**
	 * Parses for the Error Message in the MIME multipart message.
	 * @param $response MIME multipart message
	 * @return string XML Error Message Response
	 */
	/****************************************************************************************/
function parseForErrorMessage($response)
	{
		$beginErrorMessage = strpos($response, '<?xml');
		$endErrorMessage = strpos($response, '</errorMessage>', $beginErrorMessage);
		$endErrorMessage += strlen('</errorMessage>');
		
		return substr($response, $beginErrorMessage, $endErrorMessage - $beginErrorMessage);
	}
	
	/**
	 * Parses for the XML Response in the MIME multipart message.
	 * @param string $response MIME multipart message
	 * @return string XML Response
	 */
	/****************************************************************************************/
function parseForResponseXML($response)
	{
		$beginResponseXML = strpos($response, '<?xml');
		
		$endResponseXML = strpos($response, '</downloadFileResponse>',
			$beginResponseXML);
		
		//Assume a service level error and die.
		if($endResponseXML === FALSE) {
			$errorXML = parseForErrorMessage($response);
			PrintUtils::printXML($errorXML);
			die();
		}	
		
		$endResponseXML += strlen('</downloadFileResponse>');
		
		return substr($response, $beginResponseXML,
			$endResponseXML - $beginResponseXML);
	}

	/**
	 * Parses for the file bytes between the MIME boundaries.
	 * @param $uuid UUID corresponding to the Content-ID of the file bytes.
	 * @param string $response MIME multipart message
	 * @return string bytes of the file
	 */
	/****************************************************************************************/
function parseForFileBytes($uuid, $response)
	{
		$contentId = 'Content-ID: <' . $uuid . '>';
		
		$mimeBoundaryPart = strpos($response,'--MIMEBoundaryurn_uuid_');
		
		$beginFile = strpos($response, $contentId, $mimeBoundaryPart);
		$beginFile += strlen($contentId);
		
		//Accounts for the standard 2 CRLFs.
		$beginFile += 4;
		
		$endFile = strpos($response,'--MIMEBoundaryurn_uuid_',$beginFile);
		
		//Accounts for the standard 1 CRLFs.
		$endFile -= 2;
		
		$fileBytes = substr($response, $beginFile, $endFile - $beginFile);
		
		return $fileBytes;
	}
	
	/**
	 * Parses the XML Response for the UUID to ascertain the
	 * index of the file bytes in the MIME Message.
	 * @param DomDocument $responseDOM DOM of the XML Response.
	 * @return string UUID referring to the message body
	 */
	/****************************************************************************************/
function parseForXopIncludeUUID($responseDOM)
	{
		$xopInclude = $responseDOM->getElementsByTagName('Include')->item(0);
		$uuid = $xopInclude->getAttributeNode('href')->nodeValue;
		$uuid = substr($uuid, strpos($uuid,'urn:uuid:'));
		
		return $uuid;
	}

	/**
	 * Writes the response file's bytes to disk.
	 * @param string $bytes bytes comprising a file
	 * @param string $zipFilename name of the zip to be created
	 */
	/****************************************************************************************/
function writeZipFile($bytes, $zipFilename)
	{
		echo "<p><b>Writing File to $zipFilename : ";
		
		$handler = fopen($zipFilename, 'wb') 
			or die("Failed. Cannot Open $zipFilename to Write!</b></p>");
		fwrite($handler, $bytes);
		fclose($handler);
		
		echo 'Success.</b></p>';
	}

	
	/****************************************************************************************/
function readRequestFile()
{
  global $fichier_zip_maj;
  $file = $fichier_zip_maj;
  $handle = fopen($file, 'r');
  $fileData = fread( $handle, filesize($file) );
  fclose($handle);

  return $fileData;
}

/****************************************************************************************/
function createUploadFileRequest($taskReferenceId, $fileReferenceId, $fileSize)
{
  $request  = '<uploadFileRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
  $request .= '<taskReferenceId>' . $taskReferenceId . '</taskReferenceId>';
  $request .= '<fileReferenceId>' . $fileReferenceId . '</fileReferenceId>';
  $request .= '<fileFormat>zip</fileFormat>';
  $request .= '<fileAttachment>';
  $request .= '<Size>' . $fileSize . '</Size>';
  $request .= '<Data><xop:Include xmlns:xop="http://www.w3.org/2004/08/xop/include" href="cid:' . MultiPartMessage::$URN_UUID_ATTACHMENT . '" /></Data>';
  $request .= '</fileAttachment>';
  $request .= '</uploadFileRequest>';

  return $request;
}


/****************************************************************************************/
function createStartUploadJobRequest($jobId)
{
  $request  = '<startUploadJobRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
  $request .= '<jobId>' . $jobId . '</jobId>';
  $request .= '</startUploadJobRequest>';

  return $request;
}

/****************************************************************************************/
function parseResponseAndPrintExamples(SimpleXMLElement $xml)
{
  echo '<p><b>Parsing Example</b></p>';

  $ack = (string)$xml->ack;

  if($ack === 'Success')
  {
    $jobId = (string)$xml->jobId;
    $timestamp = (string)$xml->timestamp;
     
    echo $ack . '. Job #' . $jobId . ' started at ' . $timestamp;
  }
  else
  {
    $error = (string)$xml->error;
    $errorMessage = (string)$error->message;

    echo 'Error. ' . $errorMessage;
  }
}

/****************************************************************************************/
function getRequest()
{
  ini_set('magic_quotes_gpc', false);
  global $debug,$userRequest;

  $request = $userRequest;

  if( get_magic_quotes_gpc() ) {
    $request = stripslashes( $request );
  }

  return $request;
}

/****************************************************************************************/
function createGetJobStatusRequest($jobId)
{
  $request  = '<getJobStatusRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
  $request .= '<jobId>' . $jobId . '</jobId>';
  $request .= '</getJobStatusRequest>';

  return $request;
}

/****************************************************************************************/
function readRequestFile_newprod()
{
  global $fichier_zip_nouveaux_produits;
  $file = $fichier_zip_nouveaux_produits;
  $handle = fopen($file, 'r');
  $fileData = fread( $handle, filesize($file) );
  fclose($handle);

  return $fileData;
}

/****************************************************************************************/
function readRequestFile_0()
{
  global $fichier_zip_maj_0;
  $file = $fichier_zip_maj_0;
  $handle = fopen($file, 'r');
  $fileData = fread( $handle, filesize($file) );
  fclose($handle);

  return $fileData;
}

/****************************************************************************************/
/****************************************************************************************/
function products_in_ebay($tab_inventaire,$type_sku = 'products_model') 
{
// echo date('l jS \of F Y h:i:s A');
$heure = date('G');
echo 'il est ' . $heure  . ' heure';

if ($type_sku <> 'products_model') $type_sku = 'products_id';

	if (( $heure >= 5 ) && ($heure <= 20)) {
		   $products_query = tep_db_query("SELECT  " . $type_sku . "  as SKU FROM " . TABLE_PRODUCTS . "");
		   
			//	echo '<pre>'; print_r($tab_inventaire); echo '</pre>';
				
		    while($products = tep_db_fetch_array($products_query)) {
		//			echo 'OKKKKK ' . $products['SKU'] . '<br>';			
				if (array_key_exists($products['SKU'], $tab_inventaire)) {
		//			echo 'OKKKKK ' . $products['SKU'] . '<br>';
							$tab = array(
												'MonPrix' => round(floatval($tab_inventaire[$products['SKU']]['mon_prix']),2),
												'quantite' => $tab_inventaire[$products['SKU']]['quantity'],		
												'ID_ebay' => $tab_inventaire[$products['SKU']]['ID_ebay'],													
												'date_maj' => date("\l\e d-m-Y \a H:i:s"),
										);
	//			echo '<pre>'; print_r($tab); echo '</pre>';
				$tab_s = serialize($tab);													
				} else {$tab_s = '';}
				if ($type_sku == 'products_model') 	tep_db_query("update " . TABLE_PRODUCTS . " set products_in_ebay_fr = '" . $tab_s  . "' where " . $type_sku . " LIKE '" . $products['SKU'] . "'");
				else tep_db_query("update " . TABLE_PRODUCTS . " set products_in_ebay_fr = '" . $tab_s  . "' where " . $type_sku . " = '" . $products['SKU'] . "'");				
			}		
	}
}

/****************************************************************************************/
function EndFixedPriceItem($xml_content)
{			
				$headers = array(
								'X-EBAY-API-DEV-NAME: ' . _EBAY_DEVID_,
								'X-EBAY-API-APP-NAME: ' . _EBAY_APPID_,
								'X-EBAY-API-CERT-NAME: ' . _EBAY_CERTID_,
								'X-EBAY-API-CALL-NAME: EndFixedPriceItem',
								'X-EBAY-API-SITEID: 71',
								'X-EBAY-API-COMPATIBILITY-LEVEL: 615'
				);
				//$sessionID = getsessionID();
                $post  = $xml_content;
				
				
                $ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.ebay.com/ws/api.dll');
			//	curl_setopt($ch, CURLOPT_URL, 'https://api.sandbox.ebay.com/ws/api.dll');
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_POST, true );
				curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
				
                $response = curl_exec($ch);
                curl_close($ch);

				$xml = simplexml_load_string($response);
				echo '<pre>suppr' ;var_dump($xml); echo'</pre>';
				//$sessionID = $xml->SessionID;
				//return $sessionID;
				
    //return $response;

}


/****************************************************************************************/
function ReviseFixedPriceItemRequest($xml_content)
{			
				$headers = array(
								'X-EBAY-API-DEV-NAME: ' . _EBAY_DEVID_,
								'X-EBAY-API-APP-NAME: ' . _EBAY_APPID_,
								'X-EBAY-API-CERT-NAME: ' . _EBAY_CERTID_,
								'X-EBAY-API-CALL-NAME: ReviseFixedPriceItemRequest',
								'X-EBAY-API-SITEID: 71',
								'X-EBAY-API-COMPATIBILITY-LEVEL: 741'
				);
				//$sessionID = getsessionID();
                $post  = $xml_content;
				
				
                $ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.ebay.com/ws/api.dll');
			//	curl_setopt($ch, CURLOPT_URL, 'https://api.sandbox.ebay.com/ws/api.dll');
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_POST, true );
				curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
				
                $response = curl_exec($ch);
                curl_close($ch);

				$xml = simplexml_load_string($response);
			//	echo '<pre>' ;var_dump($xml); echo'</pre>';
				//$sessionID = $xml->SessionID;
				//return $sessionID;
				
    //return $response;

}
/********************************************************************************/
function getItemSpecifics_ebay($param = array()){
	// catID   categorie ID
	$return = "";
	if (empty($param)) return;
		$query = tep_db_query("SELECT  	category_ebay_itemspecifics FROM `ebay_category` 
								WHERE 	CategoryID_ebay  = '".$param['catID']."' 
		");
		if (tep_db_num_rows($query)>0){
			$res = tep_db_fetch_array($query);
			if (!empty($res['category_ebay_itemspecifics']))
				$return = unserialize($res['category_ebay_itemspecifics']);
		}
return $return;
}
/********************************************************************************/
function getItemSpecifics_xml_ebay($param = array()){
	// catID   categorie ID	
	// typeItem   variation ou Item
	// marque
	$xml = '';
	$info = getItemSpecifics_ebay($param);
	$rt = chr(13);
	print_r($info);
	if (empty($info)) return;
	$xml ='				<'.$param['typeItem'].'>'.$rt;	
	foreach($info as $v){
		$xml .='					<NameValueList>'.$rt;															
		$xml .='						<Name><![CDATA['.($v).']]></Name>'.$rt;
		$value = 'non applicable';
		if ($v == 'Marque') $value = $param['marque'];
		$xml .='						<Value><![CDATA['.($value).']]></Value>'.$rt;	
		$xml .='					</NameValueList>'.$rt;															
	}
	$xml.='					</'.$param['typeItem'].'>'.$rt;	
return $xml;	
	
}
/********************************************************************************/
function getItemSpecifics_xml_for_all_ebay($param = array()){
	// catID   categorie ID	
	// typeItem   variation ou Item
	// marque
	$xml = '';
	$rt = chr(13);
	$xml ='			<'.$param['typeItem'].'>'.$rt;	
	$xml .='				<NameValueList>'.$rt;															
	$xml .='					<Name><![CDATA[Marque]]></Name>'.$rt;
	if ($v == 'Marque') $value = $param['marque'];
	$xml .='					<Value><![CDATA['.($param['marque']).']]></Value>'.$rt;	
	$xml .='				</NameValueList>'.$rt;		
	$xml .='				<NameValueList>'.$rt;															
	$xml .='					<Name><![CDATA['.('Numéro de pièce fabricant').']]></Name>'.$rt;
	$xml .='					<Value><![CDATA[non applicable]]></Value>'.$rt;	
	$xml .='				</NameValueList>'.$rt;		
	$xml.='			</'.$param['typeItem'].'>'.$rt;	
return $xml;	
	
}

?>