<?php
class ebayCalls extends ebayTradingApi{
	
	private	$mailPaypal;
	private $PaymentMethods;
	private	$postCode;
	private $cr;
	private	$isVariant = FALSE;
	private	$token		= Ebay_userToken;	
	private	$PaymentInstructions;
	private $descriptionConditionsRetour;
	private $post = TRUE ;
	
	/**********************************************************************************************/
	function __construct($data = array()) {
		$this->mailPaypal = $data['mailPaypal'];
		$this->PaymentMethods = $data['PaymentMethods'];
		$this->postCode = $data['postCode'];
		$this->cr = chr(13);		
	}
	/**********************************************************************************************/
	public function setPaymentInstructions($v){
		$this->PaymentInstructions = $v;
	}
	/**********************************************************************************************/
	public function setDescriptionConditionsRetour($v){
		$this->descriptionConditionsRetour = $v;
	}	
	/**********************************************************************************************/
	public function setPost($v){
		$this->post = $v;
	}		
	/**********************************************************************************************/	
	private function getPayementMethods(){	
		if (empty($this->PaymentMethods)) return;
		$xml = '';
		foreach ($this->PaymentMethods as $v) {
			$xml .= "				<PaymentMethods>$v</PaymentMethods>".$this->cr; 
		}
		$xml = '';  // supprimé pour KoutiqueKBC le 26 06 2021
	return $xml;
	}
	/**********************************************************************************************/	
	private function ShippingDetails($data = array()){	
		if (empty($data)) return;
		$xml = "";
		foreach ($data as $k => $v) {
			foreach ( $v  as $v2){
			$xml .= "					<$k>".$this->cr; 				
				foreach ( $v2  as $k3=>$v3){	$xml .= "						<$k3>$v3</$k3>".$this->cr; }
			$xml .= "					</$k>".$this->cr; 				
			}
		}
	return $xml;
	}	
	/**********************************************************************************************/	
	private function getItemSpecifics($p,$type){	
		$param = array( 'catID' => $categorie_ebay_fr,
						'typeItem' => $type,
						'marque'	=> $p['manufacturer'],
						'Type' => $p['categories_name'],
		);	
		$xml = ebay_fonctions::getItemSpecifics_xml_for_all_ebay($param);	
	return $xml;
	}	
	/**********************************************************************************************/	
	private function getItemSpecifics_2021($p,$type){	
	
		$xml = "";
		$tab_attrib_ebay = array();
		if (!empty($p['products_ebay_attributs'])) {
			$xml .= '<'.$type.'>'.$this->cr;	
			$tab_attrib_ebay = unserialize($p['products_ebay_attributs']);
			foreach ($tab_attrib_ebay  as $k=>$v){ 
				if (!empty($v)){
					$xml .='					<NameValueList>'.$this->cr;															
					$xml .='						<Name><![CDATA['.utf8_encode($k).']]></Name>'.$this->cr;
					$xml .='						<Value><![CDATA['.utf8_encode($v).']]></Value>'.$this->cr;
					$xml .='					</NameValueList>'.$this->cr;
				}
			}
			$xml .= '</'.$type.'>'.$this->cr;				
		}	
		

		
	return $xml;
	}		
	/**********************************************************************************************/	
	private function getPictureDetails($p){
		$xml = '';
		foreach ($p['images'] as $urlImg){
			if (!empty($urlImg)) $xml .= "					<PictureURL>$urlImg</PictureURL>".$this->cr;
		}
	return $xml;
	}
	/**********************************************************************************************/	
	private function getTax($p){
		$xml = '';
		$xml = 	'
				<SalesTax>
        			<SalesTaxPercent>'.$p['price']['TAX_val_pourcent'].'</SalesTaxPercent>
       				<SalesTaxState>FR</SalesTaxState>
       				<ShippingIncludedInTax>false</ShippingIncludedInTax>					
				</SalesTax>	';
				
	return $xml;
	}	
	/**********************************************************************************************/	
	private function getVatDetails($p){
		$xml = '';
		$xml = 	'
				<VATDetails>
        			<VATPercent>'.$p['price']['TAX_val_pourcent'].'</VATPercent>					
				</VATDetails>	';
				
	return $xml;
	}		
	/**********************************************************************************************/
	private function ProductListingDetails($p){
		$xml='';
		if ((!$this->isVariant)&&(!empty($p['ean']))) { 
			$xml = '					
				<ProductListingDetails>
					<EAN>'.trim($p['ean']).'</EAN>		
				</ProductListingDetails>'.$this->cr;
		}
	return $xml;
	}
	/**********************************************************************************************/
	private function SetGetProductIsVariant($p){
		$typeVariant = 'products_stock_ean';
		if (_TYPE_REF_VARIANT_ == 'MODEL') $typeVariant = 'products_stock_model';
		$tabVariant = product_id_variant($p['id'], 'Taille unique', 'voir image', $typeVariant);
		if ($tabVariant['variant']) $this->isVariant = TRUE; else $this->isVariant = FALSE;
	return $tabVariant;
	}	
	/**********************************************************************************************/	
	private function getPiceNotVariant($v){
		//if ($this->isVariant) return '';
	return '				<StartPrice>'.$v.'</StartPrice>';
	}
	/**********************************************************************************************/		
	private function getVariant($p){
		$variant = '';
		if ($this->isVariant) { 
		$tabVariant = $this->SetGetProductIsVariant($p);	
			$tab_tailles 	= array();
			$tab_couleurs 	= array();			
			foreach ($tabVariant['sku_enfant'] as $refs => $v ){
				if (!empty($v['taille'])) $tab_tailles[$v['taille_interne']] = 'taille_interne' ;
				if (!empty($v['couleur']))$tab_couleurs[$v['couleur_interne']] = 'couleur_interne' ;			
			}
			
				$variant ='				<Variations>'.$this->cr;
				$variant .='				<VariationSpecificsSet>'.$this->cr;
				$variant .='					<NameValueList>'.$this->cr;

				$variant .='						<Name><![CDATA[Taille]]></Name>'.$this->cr;
				foreach ($tab_tailles as $k => $v ){
				$variant .='							<Value><![CDATA['.utf8_encode($k).']]></Value>'.$this->cr;
				}										
				$variant .='					</NameValueList>'.$this->cr;

				$variant .='					<NameValueList>'.$this->cr;
				$variant .='						<Name><![CDATA[Couleur]]></Name>'.$this->cr;
				foreach ($tab_couleurs as $k => $v ){
				$variant .='							<Value><![CDATA['.utf8_encode($k).']]></Value>'.$this->cr;
				}										
				$variant .='					</NameValueList>'.$this->cr;								
		
				$variant .='					</VariationSpecificsSet>'.$this->cr;	
				
				foreach ($tabVariant['sku_enfant'] as $refs => $v ){							
				$prixVariant = ($p['price']['final_price'] + $v['additional_price']);
				
				$variant .='					<Variation>'.$this->cr;
				$variant .='						<SKU><![CDATA['.$refs.']]></SKU>'.$this->cr;
				$variant .='						<StartPrice>'.$prixVariant.'</StartPrice>'.$this->cr;
				$variant .='						<Quantity>'.$v['quantity'].'</Quantity>'.$this->cr;
				$variant .='						<VariationSpecifics>'.$this->cr;
				$variant .='							<NameValueList>'.$this->cr;
				$variant .='								<Name><![CDATA[Taille]]></Name>'.$this->cr;
				$variant .='								<Value><![CDATA['.utf8_encode($v['taille_interne']).']]></Value>'.$this->cr;
				$variant .='							</NameValueList>'.$this->cr;
				$variant .='							<NameValueList>'.$this->cr;
				$variant .='								<Name><![CDATA[Couleur]]></Name>'.$this->cr;
				$variant .='								<Value><![CDATA['.utf8_encode($v['couleur_interne']).']]></Value>'.$this->cr;
				$variant .='							</NameValueList>'.$this->cr;	
				$variant .='						</VariationSpecifics>'.$this->cr;
			if (!empty($v['ean'])) {
				$variant .='						<VariationProductListingDetails>'.$this->cr;		
				$variant .='							<EAN><![CDATA['.trim($v['ean']).']]></EAN>'.$this->cr;				
				$variant .='						</VariationProductListingDetails>'.$this->cr;				
			}else {
				$variant .='						<VariationProductListingDetails>'.$this->cr;		
				$variant .='							<EAN><![CDATA[non applicable]]></EAN>'.$this->cr;				
				$variant .='						</VariationProductListingDetails>'.$this->cr;					
			}				
				//$variant .= $this->getItemSpecifics($p,'VariationSpecificsSet');	
				$variant .= $this->getItemSpecifics_2021($p,'VariationSpecificsSet');					
				$variant .='					</Variation>'.$this->cr;		
											
			}				

				$variant .='					<Pictures>'.$this->cr;
				
				$el = end($tabVariant['sku_enfant']);

				if ($el['couleur_interne'] != 'multicolor'){
					$variant .='						<VariationSpecificName><![CDATA[Couleur]]></VariationSpecificName>'.$this->cr;						
					// images variant
					foreach ($tabVariant['sku_enfant'] as $refs => $v ){
						if (!empty($v['img_variant'])){	
							$variant .='						<VariationSpecificPictureSet>'.$this->cr;				
							$variant .='							<PictureURL><![CDATA['.$v['img_variant'].']]></PictureURL>'.$this->cr;		
							$variant .='							<VariationSpecificValue><![CDATA['.utf8_encode($v['couleur_interne']).']]></VariationSpecificValue>'.$this->cr;	
							$variant .='						</VariationSpecificPictureSet>'.$this->cr;							
						}
					}
				}	
		/*		
				if ($el['taille_interne'] != 'taille unique'){
					$variant .='						<VariationSpecificName><![CDATA[Taille]]></VariationSpecificName>'.$this->cr;						
					// images variant
					foreach ($tabVariant['sku_enfant'] as $refs => $v ){
						if (!empty($v['img_variant'])){	
							$variant .='						<VariationSpecificPictureSet>'.$this->cr;				
							$variant .='							<PictureURL><![CDATA['.$v['img_variant'].']]></PictureURL>'.$this->cr;		
							$variant .='							<VariationSpecificValue><![CDATA['.utf8_encode($v['taille_interne']).']]></VariationSpecificValue>'.$this->cr;	
							$variant .='						</VariationSpecificPictureSet>'.$this->cr;							
						}
					}
				}					
		*/		
				$variant .='					</Pictures>'.$this->cr;			
				$variant .='				</Variations>	'.$this->cr;		
	
		}		
	return $variant;
	}
	/**********************************************************************************************/
	public function AddFixedPriceItem($data = array()){
		
		$now   = time();
		//$date2 = strtotime(_DATE_RETURN_HOLIDAYS_);
		//$FulfillmentLatency = dateDiff( $date2 , $now ) + 2;
 		$FulfillmentLatency = 2;
 
		$call = 'AddFixedPriceItem';
		$p = $data['product'];
		$needToken = '';
		$xml = '';		
		$param_post = array(	'version' 	=> '663',
								'name'		=> $call,
				);	
				
		if ($data['method'] == 'tradApi') {
			$needToken = '		
					<RequesterCredentials>
						<eBayAuthToken>'.$this->token.'</eBayAuthToken>
					</RequesterCredentials>';
			$xml = '<?xml version="1.0" encoding="utf-8"?>';
		}
		//printr($p);

		$sku = $p['id'];
		if (_TYPE_REF_VARIANT_ == 'MODEL') 	$sku = $p['model'];
		$this->SetGetProductIsVariant($p);
		$xml .=' 
		<'.$call.' xmlns="urn:ebay:apis:eBLBaseComponents">
			<ErrorLanguage>fr_FR</ErrorLanguage>
			<WarningLevel>High</WarningLevel>
			<Version>'.$param_post['version'].'</Version>
			<MessageID>'.$sku.'</MessageID>		
'.$needToken.'			
			<Item>
				<SKU>'.$sku.'</SKU>
				<Country>FR</Country>
				<Currency>EUR</Currency>
				<DispatchTimeMax>'. $FulfillmentLatency . '</DispatchTimeMax>
				<InventoryTrackingMethod>SKU</InventoryTrackingMethod>
				<ListingDuration>GTC</ListingDuration>
				<ListingType>FixedPriceItem</ListingType>
				<PostalCode>'.$this->postCode.'</PostalCode>			

				<PayPalEmailAddress>'.$this->mailPaypal.'</PayPalEmailAddress>
				<PrimaryCategory>
					<CategoryID>'.$p['categorie_ebay_fr'].'</CategoryID>
				</PrimaryCategory>
				<Quantity>'.$p['qty'].'</Quantity>
				<ReturnPolicy>
					<ReturnsAcceptedOption>ReturnsAccepted</ReturnsAcceptedOption>
					<Description><![CDATA['.$this->descriptionConditionsRetour.']]></Description>
					<ReturnsWithinOption>Days_14</ReturnsWithinOption>
					<ShippingCostPaidByOption>Buyer</ShippingCostPaidByOption>
				</ReturnPolicy>				
'.$this->getItemSpecifics_2021($p,"ItemSpecifics").'
'.$this->getPiceNotVariant($p['price']['final_price']).'
				<Storefront>
					<StoreCategoryID>'.$p['categorie_ebay_fr_store'].'</StoreCategoryID>
				</Storefront>
				<ShippingDetails>
					<ShippingType>Flat</ShippingType>
'.$this->ShippingDetails($p['shipping']) .'
				</ShippingDetails>
				<PictureDetails>
'.$this->getPictureDetails($p).'
				</PictureDetails>
'.$this->ProductListingDetails($p).'

				<Title><![CDATA['.utf8_encode($p['name']).']]></Title>
				<ConditionID>1000</ConditionID>
'.$this->getVariant($p).'	
'.$this->getVatDetails($p).'
				<Description><![CDATA['.utf8_encode(getTemplateEbay($p)).']]></Description>		
			</Item>
		</'.$call.'>
	';	
	
	if ($this->post) {
		if ($data['method'] == 'tradApi') {
			$param_post['post'] = $xml;
			$xml2 = $this->post_request($param_post);	
			if ($this->getErrorApi($xml2)) {
				$txt = 'Erreur sur le SKU <strong>' . $sku .'</strong> sur un appel type ' .$param_post['name']; 
				$this->printError($txt,$xml2);
				//printr($xml2);
			}			
		}		
	}
	return $xml;
	}
	/**********************************************************************************************/
	public function ReviseFixedPriceItem($data = array()){
		
		$now   = time();
		$date2 = strtotime(_DATE_RETURN_HOLIDAYS_);
		$FulfillmentLatency = dateDiff( $date2 , $now ) + 2 ;
		$FulfillmentLatency = 2 ;		
		
		$call = 'ReviseFixedPriceItem';		
		$p = $data['product'];
		$needToken = '';
		$xml = '';		
		$param_post = array(	'version' 	=> '663',
								'name'		=> $call,
				);	
				
		if ($data['method'] == 'tradApi') {
			$needToken = '		
					<RequesterCredentials>
						<eBayAuthToken>'.$this->token.'</eBayAuthToken>
					</RequesterCredentials>';
			$xml = '<?xml version="1.0" encoding="utf-8"?>';
		}
		//printr($p);

		$sku = $p['id'];
		if (_TYPE_REF_VARIANT_ == 'MODEL') 	$sku = $p['model'];
		$this->SetGetProductIsVariant($p);
		$xml .=' 
		<'.$call.' xmlns="urn:ebay:apis:eBLBaseComponents">
			<ErrorLanguage>fr_FR</ErrorLanguage>
			<WarningLevel>High</WarningLevel>
			<Version>'.$param_post['version'].'</Version>
			<MessageID>'.$sku.'</MessageID>		
'.$needToken.'			
			<Item>
				<SKU>'.$sku.'</SKU>
				<Country>FR</Country>
				<Currency>EUR</Currency>
				<DispatchTimeMax>'. $FulfillmentLatency . '</DispatchTimeMax>
				<InventoryTrackingMethod>SKU</InventoryTrackingMethod>
				<ListingDuration>GTC</ListingDuration>
				<ListingType>FixedPriceItem</ListingType>
				<PostalCode>'.$this->postCode.'</PostalCode>			

				<PayPalEmailAddress>'.$this->mailPaypal.'</PayPalEmailAddress>
				<PrimaryCategory>
					<CategoryID>'.$p['categorie_ebay_fr'].'</CategoryID>
				</PrimaryCategory>
				<Quantity>'.$p['qty'].'</Quantity>
				<ReturnPolicy>
					<ReturnsAcceptedOption>ReturnsAccepted</ReturnsAcceptedOption>
					<Description><![CDATA['.$this->descriptionConditionsRetour.']]></Description>
					<ReturnsWithinOption>Days_14</ReturnsWithinOption>
					<ShippingCostPaidByOption>Buyer</ShippingCostPaidByOption>
				</ReturnPolicy>				
'.$this->getItemSpecifics_2021($p,"ItemSpecifics").'
				<StartPrice>'.$p['price']['final_price'].'</StartPrice>
				<Storefront>
					<StoreCategoryID>'.$p['categorie_ebay_fr_store'].'</StoreCategoryID>
				</Storefront>
				<ShippingDetails>
					<ShippingType>Flat</ShippingType>
'.$this->ShippingDetails($p['shipping']) .'
				</ShippingDetails>
				<PictureDetails>
'.$this->getPictureDetails($p).'
				</PictureDetails>
'.$this->ProductListingDetails($p).'

				<Title><![CDATA['.utf8_encode($p['name']).']]></Title>
				<ConditionID>1000</ConditionID>
'.$this->getVariant($p).'
'.$this->getVatDetails($p).'
				<Description><![CDATA['.utf8_encode(getTemplateEbay($p)).']]></Description>		
			</Item>
		</'.$call.'>
	';	
	if ($this->post) {		
		if ($data['method'] == 'tradApi') {
			$param_post['post']  = $xml;
			$xml2 = $this->post_request($param_post);	
			
			if ($this->getErrorApi($xml2)) {
				$txt = 'Erreur sur le SKU <strong>' . $sku .'</strong> sur un appel type ' .$param_post['name']; 
				$this->printError($txt,$xml2);
				//printr($xml2);
			}			
		}		
	}
	return $xml;
	}
	/**********************************************************************************************/
	
	
	
}
?>