<?php
    
    class EbayAPI2022
    {
        protected $devID;
        protected $appID;
        protected $certID;
        protected $clientID;
        protected $serverUrl;
        public 	  $userToken;
        protected $paypalEmailAddress;
        protected $ruName;
        
        
        public function __construct()
        {
            $this->devID 	= Ebay_devID ;//'<your-dev-id>'; // these prod keys are different from sandbox keys
            $this->appID 	= Ebay_appID ; //'<your-app-id>';
            $this->certID 	= Ebay_certID ; //'<your-cert-id>';
            $this->clientID = Ebay_appID; //'<your-client-id>';
            //set the Server to use (Sandbox or Production)
            $this->serverUrl = 'https://api.ebay.com/ws/api.dll';      // server URL different for prod and sandbox
            //the token representing the eBay user to assign the call with
            
            //   $this->authCode = Ebay_userToken ; //'<paste here your authorization code>';
            
            $this->authCode = "v^1.1%23i^1%23p^3%23I^3%23r^1%23f^0%23t^Ul41Xzc6MzI2RkU2OUNFQ0RDQURGRTM4RDU2OEZBM0EwMTg5RjFfMl8xI0VeMjYw"; // 
            //  $this->authToken = Ebay_userToken;
            //$this->authCode  = "v^1.1#i^1#I^3#r^1#p^3#f^0#t^Ul4xMF84OjNCNTJEQzc1QTZGQUJGQzhDRTZENUFDNzM2NUY5MDc0XzJfMSNFXjI2MA==";
            $this->refreshToken ="";
            $this->ruName= "ARToisWEB-ARToisWE-a331-4-voqagyhev";
            
            $this->paypalEmailAddress= 'PAYPAL_EMAIL_ADDRESS';
            
        }
        //_________________________________________________________________________________________________________________________
        public function firstAuthAppToken() {
            $url = "https://auth.ebay.com/oauth2/authorize?client_id=".$this->clientID."&response_type=code&redirect_uri=".$this->ruName."&scope=https://api.ebay.com/oauth/api_scope https://api.ebay.com/oauth/api_scope/sell.marketing.readonly https://api.ebay.com/oauth/api_scope/sell.marketing https://api.ebay.com/oauth/api_scope/sell.inventory.readonly https://api.ebay.com/oauth/api_scope/sell.inventory https://api.ebay.com/oauth/api_scope/sell.account.readonly https://api.ebay.com/oauth/api_scope/sell.account https://api.ebay.com/oauth/api_scope/sell.fulfillment.readonly https://api.ebay.com/oauth/api_scope/sell.fulfillment https://api.ebay.com/oauth/api_scope/sell.analytics.readonly";
            return $url;     
        }
        //_________________________________________________________________________________________________________________________
        public function authorizationToken()
        {
            $link = "https://api.ebay.com/identity/v1/oauth2/token";
            $authCode = base64_encode($this->clientID.':'.$this->certID);
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/x-www-form-urlencoded',
            'Authorization: Basic '.$authCode
            ));
            // curl_setopt($ch, CURLHEADER_SEPARATE, true);
            // curl_setopt($ch, CURLHEADER_UNIFIED, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=authorization_code&code=".$this->authCode."&redirect_uri=".$this->ruName);
            $response = curl_exec($ch);
            $err = curl_error($ch);
            if ($err) {
                echo "cURL Error #:" . $err;
            }
            $json = json_decode($response, true);
            
            $info = curl_getinfo($ch);
            curl_close($ch);
            if($json != null)
            {
                $this->authToken = $json["access_token"];
                $this->refreshToken = $json["refresh_token"];
                return $json;
            }
        }
        //_________________________________________________________________________________________________________________________
        public function refreshToken($RToken)
        {
            $link = "https://api.ebay.com/identity/v1/oauth2/token";
            $codeAuth = base64_encode($this->clientID.':'.$this->certID);
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/x-www-form-urlencoded',
            'Authorization: Basic '.$codeAuth
            ));
            //echo $this->refreshToken;
            // curl_setopt($ch, CURLHEADER_SEPARATE, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=refresh_token&refresh_token=".$RToken."&scope=https://api.ebay.com/oauth/api_scope https://api.ebay.com/oauth/api_scope/sell.marketing.readonly https://api.ebay.com/oauth/api_scope/sell.marketing https://api.ebay.com/oauth/api_scope/sell.inventory.readonly https://api.ebay.com/oauth/api_scope/sell.inventory https://api.ebay.com/oauth/api_scope/sell.account.readonly https://api.ebay.com/oauth/api_scope/sell.account https://api.ebay.com/oauth/api_scope/sell.fulfillment.readonly https://api.ebay.com/oauth/api_scope/sell.fulfillment https://api.ebay.com/oauth/api_scope/sell.analytics.readonly");
            $response = curl_exec($ch);
            $json = json_decode($response, true);
            $info = curl_getinfo($ch);
            curl_close($ch);
            if($json != null)
            {
                $this->authToken = $json["access_token"];
                return $json;
            }
        }
        //_________________________________________________________________________________________________________________________	
        public function createInventoryTask()
        {
            $link = "https://api.ebay.com/sell/feed/v1/inventory_task";
            //$appConfig = parse_ini_file("config.ini");
            
            //payload
            $payload = json_encode(array("schemaVersion"=>"1.0","feedType"=>"LMS_ACTIVE_INVENTORY_REPORT"));
            
            
            //$appConfig['user_token'] = 'mehboob';
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization:Bearer ' .  $this->authToken,
            'Accept:application/json',
            'Content-Type:application/json',
            'X-EBAY-C-MARKETPLACE-ID:EBAY_FR'
            ));
            //curl_setopt($ch, CURLHEADER_SEPARATE, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_HEADER, 1);
            //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headers = substr($response, 0, $header_size);
            $body = substr($response, $header_size);
            $info = curl_getinfo($ch);  
            
            echo($body);
            curl_close($ch);
        }
   
        //_________________________________________________________________________________________________________________________		
        public function getInventoryTasks($feedType='LMS_ACTIVE_INVENTORY_REPORT')
        {
            $link = "https://api.ebay.com/sell/feed/v1/inventory_task?feed_type=LMS_ACTIVE_INVENTORY_REPORT";
            //$appConfig = parse_ini_file("config.ini");
            
            //payload
            
            
            //$appConfig['user_token'] = 'mehboob';
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization:Bearer ' . $this->authToken,
            'Accept:application/json',
            'Content-Type:application/json',
            'X-EBAY-C-MARKETPLACE-ID:EBAY_FR'
            ));
            //curl_setopt($ch, CURLHEADER_SEPARATE, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HEADER, 1);
            //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
            curl_setopt($ch,  CURLOPT_HTTPGET, true);
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headers = substr($response, 0, $header_size);
            $body = substr($response, $header_size);
            $info = curl_getinfo($ch);  
            
            // echo($body);
            curl_close($ch);
            
            if ($err) {
                echo "cURL Error #:" . $err;
                return false;
                } else {
                //echo $response."\n";
                return Json_decode($body,true);
            }		
        }
        //_________________________________________________________________________________________________________________________		
        public function getCategoryTree($id_p='71')
        {
            $link = "https://api.ebay.com/commerce/taxonomy/v1/category_tree/".$id_p;
            //$appConfig = parse_ini_file("config.ini");
            
            //payload
            
            
            //$appConfig['user_token'] = 'mehboob';
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization:Bearer ' . $this->authToken,
            'Accept:application/json',
            'Content-Type:application/json',
            'X-EBAY-C-MARKETPLACE-ID:EBAY_FR'
            ));
            //curl_setopt($ch, CURLHEADER_SEPARATE, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HEADER, 1);
            //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
            curl_setopt($ch,  CURLOPT_HTTPGET, true);
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headers = substr($response, 0, $header_size);
            $body = substr($response, $header_size);
            $info = curl_getinfo($ch);  
            
            // echo($body);
            curl_close($ch);
            
            if ($err) {
                echo "cURL Error #:" . $err;
                return false;
                } else {
                //echo $response."\n";
                return Json_decode($body,true);
            }		
        }        
        //_________________________________________________________________________________________________________________________		
        public function getItemAspectsForCategory($catId,$id_p='71')
        {
            $link = "https://api.ebay.com/commerce/taxonomy/v1/category_tree/".$id_p."/get_item_aspects_for_category?category_id=".$catId;
            //$appConfig = parse_ini_file("config.ini");
            
            //payload
            
            //$appConfig['user_token'] = 'mehboob';
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization:Bearer ' . $this->authToken,
            'Accept:application/json',
            'Content-Type:application/json',
            'X-EBAY-C-MARKETPLACE-ID:EBAY_FR',
            ));
            //curl_setopt($ch, CURLHEADER_SEPARATE, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HEADER, 1);
            //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
            curl_setopt($ch,  CURLOPT_HTTPGET, true);
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headers = substr($response, 0, $header_size);
            $body = substr($response, $header_size);
            $info = curl_getinfo($ch);  
            
             //echo($body);
            curl_close($ch);
            
            if ($err) {
                echo "cURL Error #:" . $err;
                return false;
                } else {
                //echo $response."\n";
                return Json_decode($body,true);
            }		
        }               
        //_________________________________________________________________________________________________________________________		
        public function getInventoryTask($taskId)
        {
            $link = "https://api.ebay.com/sell/feed/v1/inventory_task/".$taskId;
            //$appConfig = parse_ini_file("config.ini");
            
            //payload
            
            
            //$appConfig['user_token'] = 'mehboob';
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization:Bearer ' . $this->authToken,
            'Accept:application/json',
            'Content-Type:application/json',
            'X-EBAY-C-MARKETPLACE-ID:EBAY_FR'
            ));
            //curl_setopt($ch, CURLHEADER_SEPARATE, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HEADER, 1);
            //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
            curl_setopt($ch,  CURLOPT_HTTPGET, true);
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headers = substr($response, 0, $header_size);
            $body = substr($response, $header_size);
            $info = curl_getinfo($ch);  
            
            // echo($body);
            curl_close($ch);
            
            if ($err) {
                echo "cURL Error #:" . $err;
                return false;
                } else {
                //echo $response."\n";
                return Json_decode($body,true);
            }		
        }
        //_________________________________________________________________________________________________________________________			
        public function getResultFile($task)
        {
            $link = "https://api.ebay.com/sell/feed/v1/task/".$task."/download_result_file";
            //$appConfig = parse_ini_file("config.ini");
            
            //payload
            
            
            //$appConfig['user_token'] = 'mehboob';
            $ch = curl_init($link);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Authorization:Bearer ' . $this->authToken,
			'Content-Type:application/json',
            'X-EBAY-C-MARKETPLACE-ID:EBAY_FR'
            ));
            //curl_setopt($ch, CURLHEADER_SEPARATE, true);
            $destination_file = "DownloadFileInventory_v2.zip";
            $file_resource = fopen($destination_file, "wb");
            
            //  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            //    curl_setopt($ch, CURLOPT_HEADER, 1);
            //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            
            curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
            curl_setopt($ch, CURLOPT_FILE, $file_resource);
            
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headers = substr($response, 0, $header_size);
            $body = substr($response, $header_size);
            $info = curl_getinfo($ch);  
            
            
            
            //echo($body);
            curl_close($ch);
            
            if ($err) {
                echo "cURL Error #:" . $err;
                return false;
                } else {
                
                $archive = new PclZip('DownloadFileInventory_v2.zip');
                // printr($archive);
                if (($v_result_list = $archive->extract()) == 0) {
                    die("Error : ".$archive->errorInfo(true));
                }
                //echo $response."\n";
                //echo "<pre>";   var_dump($v_result_list);   echo "</pre>";	
                // printr($v_result_list);
                $fichier_sotck_entrant = $v_result_list[0]["filename"];
                if (file_exists($fichier_sotck_entrant)) {
                    
                    $xml = simplexml_load_file($fichier_sotck_entrant);
                    foreach($xml->ActiveInventoryReport->SKUDetails as  $SKUDetails){
                        //   echo "<pre>";print_r($SKUDetails);   echo "</pre>";
                        $tab_sku = strval($SKUDetails->SKU);
                        $tab_inventaire[$tab_sku]['mon_prix'] = strval($SKUDetails->Price);
                        $tab_inventaire[$tab_sku]['quantity'] = (int)$SKUDetails->Quantity;
                        $tab_inventaire[$tab_sku]['ID_ebay'] = 	strval($SKUDetails->ItemID);
                        if (isset($SKUDetails->Variations)) {
                            foreach($SKUDetails->Variations->Variation as  $Variation){
                                $sku_var = strval($Variation->SKU);
                                $tab_inventaire[$tab_sku]['variation'][$sku_var]['quantity'] = 	strval($Variation->Quantity);
                                $tab_inventaire[$tab_sku]['mon_prix'] = 	'Variant';
                                $tab_inventaire[$tab_sku]['variation'][$sku_var]['mon_prix'] = 	strval($Variation->Price);					
                            }
                        }
                    }
                    //printr($xml);;
                    } else {
                    exit('Echec lors de l\'ouverture du fichier xml.');
                }            
                unlink($fichier_sotck_entrant);
                return $tab_inventaire;
                
            }		
        }
        //_________________________________________________________________________________________________________________________		
        
    }
