<?php require_once('get-common/ServiceEndpointsAndTokens.php') ?>
<?php require_once('get-common/LargeMerchantServiceSession.php') ?>
<?php require_once('get-common/DOMUtils.php') ?>
<?php require_once('get-common/PrintUtils.php') ?>
<?php require_once('MultiPartMessage.php')?>
<?php 
class ebayLarge{
	
	public $debug = 0 ;
	
	public function createGetJobStatusRequest($jobId)
	{
	  $request  = '<getJobStatusRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
	  $request .= '<jobId>' . $jobId . '</jobId>';
	  $request .= '</getJobStatusRequest>';

	  return $request;
	}
	/************************************************************************************************/
	public function createStartUploadJobRequest($jobId)
	{
	  $request  = '<startUploadJobRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
	  $request .= '<jobId>' . $jobId . '</jobId>';
	  $request .= '</startUploadJobRequest>';

	  return $request;
	}
	/************************************************************************************************/
	public function createUploadFileRequest($taskReferenceId, $fileReferenceId, $fileSize)
	{
	  $request  = '<uploadFileRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
	  $request .= '<taskReferenceId>' . $taskReferenceId . '</taskReferenceId>';
	  $request .= '<fileReferenceId>' . $fileReferenceId . '</fileReferenceId>';
	  $request .= '<fileFormat>zip</fileFormat>';
	  $request .= '<fileAttachment>';
	  $request .= '<Size>' . $fileSize . '</Size>';
	  $request .= '<Data><xop:Include xmlns:xop="http://www.w3.org/2004/08/xop/include" href="cid:' . MultiPartMessage::$URN_UUID_ATTACHMENT . '" /></Data>';
	  $request .= '</fileAttachment>';
	  $request .= '</uploadFileRequest>';

	  return $request;
	}
	/************************************************************************************************/
	public function createUploadJobRequest($jobType, $uuid)
	{
	  $request  = '<createUploadJobRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
	  $request .= '<uploadJobType>' . $jobType . '</uploadJobType>';
	  $request .= '<UUID>' . $uuid . '</UUID>';
	  $request .= '</createUploadJobRequest>';

	  return $request;
	}
	/************************************************************************************************/
	public function createDownloadRequest($taskReferenceId, $fileReferenceId)
	{
		$request  = '<downloadFileRequest xmlns:sct="http://www.ebay.com/soaframework/common/types" xmlns="http://www.ebay.com/marketplace/services">';
        $request .= '<taskReferenceId>' . $taskReferenceId . '</taskReferenceId>';
        $request .= '<fileReferenceId>' . $fileReferenceId . '</fileReferenceId>';
        $request .= '</downloadFileRequest>';
        
        return $request;
	}
	/************************************************************************************************/	
	/**
	 * Parses for the Error Message in the MIME multipart message.
	 * @param $response MIME multipart message
	 * @return string XML Error Message Response
	 */
	public function parseForErrorMessage($response)
	{
		$beginErrorMessage = strpos($response, '<?xml');
		$endErrorMessage = strpos($response, '</errorMessage>', $beginErrorMessage);
		$endErrorMessage += strlen('</errorMessage>');
		
		return substr($response, $beginErrorMessage, $endErrorMessage - $beginErrorMessage);
	}
	/************************************************************************************************/	
	/**
	 * Parses for the XML Response in the MIME multipart message.
	 * @param string $response MIME multipart message
	 * @return string XML Response
	 */
	public function parseForResponseXML($response)
	{
		$beginResponseXML = strpos($response, '<?xml');
		
		$endResponseXML = strpos($response, '</downloadFileResponse>',
			$beginResponseXML);
		
		//Assume a service level error and die.
		if($endResponseXML === FALSE) {
			$errorXML = parseForErrorMessage($response);
			PrintUtils::printXML($errorXML);
			die();
		}	
		
		$endResponseXML += strlen('</downloadFileResponse>');
		
		return substr($response, $beginResponseXML,
			$endResponseXML - $beginResponseXML);
	}
	/************************************************************************************************/	
	/**
	 * Parses for the file bytes between the MIME boundaries.
	 * @param $uuid UUID corresponding to the Content-ID of the file bytes.
	 * @param string $response MIME multipart message
	 * @return string bytes of the file
	 */
	public function parseForFileBytes($uuid, $response)
	{
		$contentId = 'Content-ID: <' . $uuid . '>';
		
		$mimeBoundaryPart = strpos($response,'--MIMEBoundaryurn_uuid_');
		
		$beginFile = strpos($response, $contentId, $mimeBoundaryPart);
		$beginFile += strlen($contentId);
		
		//Accounts for the standard 2 CRLFs.
		$beginFile += 4;
		
		$endFile = strpos($response,'--MIMEBoundaryurn_uuid_',$beginFile);
		
		//Accounts for the standard 1 CRLFs.
		$endFile -= 2;
		
		$fileBytes = substr($response, $beginFile, $endFile - $beginFile);
		
		return $fileBytes;
	}
	/************************************************************************************************/	
	/**
	 * Parses the XML Response for the UUID to ascertain the
	 * index of the file bytes in the MIME Message.
	 * @param DomDocument $responseDOM DOM of the XML Response.
	 * @return string UUID referring to the message body
	 */
	public function parseForXopIncludeUUID($responseDOM)
	{
		$xopInclude = $responseDOM->getElementsByTagName('Include')->item(0);
		$uuid = $xopInclude->getAttributeNode('href')->nodeValue;
		$uuid = substr($uuid, strpos($uuid,'urn:uuid:'));
		
		return $uuid;
	}
	/************************************************************************************************/	
	/**
	 * Writes the response file's bytes to disk.
	 * @param string $bytes bytes comprising a file
	 * @param string $zipFilename name of the zip to be created
	 */
	public function writeZipFile($bytes, $zipFilename)
	{
		if ($this->debug) echo "<p><b>Writing File to $zipFilename : ";
		
		$handler = fopen($zipFilename, 'wb') 
			or die("Failed. Cannot Open $zipFilename to Write!</b></p>");
		fwrite($handler, $bytes);
		fclose($handler);
		
		if ($this->debug) echo 'Success.</b></p>';
	}
	/************************************************************************************************/	
	private function parseResponseAndPrintExamples(SimpleXMLElement $xml)
	{
	  echo '<p><b>Parsing Example</b></p>';

	  $ack = (string)$xml->ack;

	  if($ack === 'Success')
	  {
		$jobId = (string)$xml->jobId;
		$timestamp = (string)$xml->timestamp;
		 
		echo $ack . '. Job #' . $jobId . ' started at ' . $timestamp;
	  }
	  else
	  {
		$error = (string)$xml->error;
		$errorMessage = (string)$error->message;

		echo 'Error. ' . $errorMessage;
	  }
	}
	/************************************************************************************************/	
	private function getRequest($userRequest)
	{
	  ini_set('magic_quotes_gpc', false);

	  $request = $userRequest;

	  if( get_magic_quotes_gpc() ) {
		$request = stripslashes( $request );
	  }

	  return $request;
	}
	/************************************************************************************************/	
	private function downloadFileApi($taskReferenceId,$fileReferenceId,$fileName)
	{
		if( isset( $taskReferenceId) && isset( $fileReferenceId ) )	{
			//       $session = new LargeMerchantServiceSession('XML','XML', ENV_SANDBOX);
			$session = new LargeMerchantServiceSession('XML','XML', ENV_PRODUCTION);
			
			$request = $this->createDownloadRequest($taskReferenceId, $fileReferenceId);
			$response = $session->sendFileTransferServiceDownloadRequest($request);			
			//$debug = $response;			
			$responseXML = $this->parseForResponseXML($response);			
			$responseDOM = DOMUtils::createDOM($responseXML);			
			if ($this->debug) PrintUtils::printDOM($responseDOM);			
			$uuid = $this->parseForXopIncludeUUID($responseDOM);			
			$fileBytes = $this->parseForFileBytes($uuid, $response);
			$this->writeZipFile($fileBytes, $fileName);

			$archive = new PclZip($fileName);
			if (($v_result_list = $archive->extract()) == 0) {
				die("Error : ".$archive->errorInfo(true));
			}
		   //echo "<pre>";   var_dump($v_result_list);   echo "</pre>";			
		}
	
	}	
	/************************************************************************************************/	
	private function jobIsCompleted($jobId)
	{
		if( isset( $jobId ) ){
			$wait=0;
			while ($wait == 0){
			   sleep(10);
			 // $session = new LargeMerchantServiceSession('XML','XML', ENV_SANDBOX);
			  $session = new LargeMerchantServiceSession('XML','XML', ENV_PRODUCTION);
			  $request = $this->createGetJobStatusRequest( $jobId );
			  $response = $session->sendBulkDataExchangeRequest('getJobStatus', $request);
			  $xml = simplexml_load_string($response);
			  if(!empty($xml) && 'Success' == (string)$xml->ack) {
					$id_array_job = array(	"JobID"		=>(string)$xml->jobProfile->jobId,
											"UploadID"	=>(string)$xml->jobProfile->inputFileReferenceId,
											"DownloadID"=>(string)$xml->jobProfile->fileReferenceId);
			  }
			  if ($this->debug) PrintUtils::printXML($response);
			  echo '<br>'.$xml->jobProfile->jobStatus;
				if  ( $xml ->jobProfile->jobStatus == "Completed"){	$wait=1;  } 
			}
			  if ($this->debug) PrintUtils::printXML($response);
		}
	return $id_array_job;
	
	}	
	/************************************************************************************************/	
	private function startDownloadJob($JobType)
	{
		$uniqid=uniqid("",true);
		$userRequest =  '<?xml version="1.0" encoding="utf-8"?>';
		$userRequest.=  '<startDownloadJobRequest xmlns="http://www.ebay.com/marketplace/services">';
		$userRequest.=  '<downloadJobType>'.$JobType.'</downloadJobType>';
		$userRequest.=  '<UUID>' . $uniqid . '</UUID>';
		$userRequest.=  '</startDownloadJobRequest>';
		
		if ($this->debug) PrintUtils::printXML($userRequest);
		if( isset( $userRequest ) )
		{
		//  $session = new LargeMerchantServiceSession('XML','XML', ENV_SANDBOX);
		  $session = new LargeMerchantServiceSession('XML','XML', ENV_PRODUCTION);
		  $request = $this->getRequest($userRequest);
		  $responseXML = $session->sendBulkDataExchangeRequest('startDownloadJob', $request);
		  $xml = simplexml_load_string($responseXML);
		  if(!empty($xml) && 'Success' == (string)$xml->ack)  {	$id_array = array("JobID"=>(string)$xml->jobId); }
		  PrintUtils::printXML($responseXML);
		  $this->parseResponseAndPrintExamples($xml);
		}
	return $id_array;
	
	}	
	/************************************************************************************************/		
	/**********************************  partie gestion    ******************************************/		
	/************************************************************************************************/
	/************************************************************************************************/	
	public function getInventory($test = False){
		
		if ($test) echo '<div class="alert alert-danger" role="alert">ATTENTION FICHIER INVENTAIRE DE TEST</div>';
		if (!$test){
			$id_array = $this->startDownloadJob('ActiveInventoryReport');
				/////////////////////////////////////////  get job status
			$jobId = $id_array['JobID'] ;
			$id_array_job = $this->jobIsCompleted($jobId);
				/////////////////////// download fichier  
			$taskReferenceId=$id_array_job['JobID'];
			$fileReferenceId=$id_array_job['DownloadID'];
			$fileName = 'DownloadFileInventory.zip';
			$this->downloadFileApi($taskReferenceId,$fileReferenceId,$fileName);
		}
		
		///////download fichier FIN*********************************************/
		/******************************************* traitement du stock et mise a jour vers Ebay *********************************************/
		$fichier_sotck_entrant = $taskReferenceId . "_report.xml";
		if ($test) $fichier_sotck_entrant = $taskReferenceId . "test_report.xml";
		if (file_exists($fichier_sotck_entrant)) {

			$xml = simplexml_load_file($fichier_sotck_entrant);
			//echo "<pre>";print_r($xml); echo "</pre>";
		} else {
			exit('Echec lors de l\'ouverture du fichier xml.');
		}
		foreach($xml->ActiveInventoryReport->SKUDetails as  $SKUDetails){
			//   echo "<pre>";print_r($SKUDetails);   echo "</pre>";
			$tab_sku = strval($SKUDetails->SKU);
			$tab_inventaire[$tab_sku]['mon_prix'] = strval($SKUDetails->Price);
			$tab_inventaire[$tab_sku]['quantity'] = (int)$SKUDetails->Quantity;
			$tab_inventaire[$tab_sku]['ID_ebay'] = 	strval($SKUDetails->ItemID);
			if (isset($SKUDetails->Variations)) {
				foreach($SKUDetails->Variations->Variation as  $Variation){
					$sku_var = strval($Variation->SKU);
					$tab_inventaire[$tab_sku]['variation'][$sku_var]['quantity'] = 	strval($Variation->Quantity);
					$tab_inventaire[$tab_sku]['mon_prix'] = 	'Variant';
					$tab_inventaire[$tab_sku]['variation'][$sku_var]['mon_prix'] = 	strval($Variation->Price);					
				}
			}
		}
		if (!$test) unlink($fichier_sotck_entrant);
	return $tab_inventaire;			
	}
	/************************************************************************************************/		
	
}


?>