<?php

class ebayTradingApi{
	
	private $devID 		= Ebay_devID;
	private $appID 		= Ebay_appID;
	private	$certID		= Ebay_certID;
	private	$siteID		= '71';
	private	$token		= Ebay_userToken;
	private $URI		= 'https://api.ebay.com/ws/api.dll';
	
	/************************************************************************************/	
	function __construct($data = array()) {
	}
	/************************************************************************************/	
	public function post_request($param){
		$headers = array(
						'X-EBAY-API-COMPATIBILITY-LEVEL:' .	$param['version'],				
						'X-EBAY-API-DEV-NAME:' .	 		$this->devID,
						'X-EBAY-API-APP-NAME:' . 			$this->appID,
						'X-EBAY-API-CERT-NAME:' . 			$this->certID,
						'X-EBAY-API-SITEID:' . 				$this->siteID,
						'X-EBAY-API-CALL-NAME:' . 			$param['name'],

		);				
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->URI);
		//curl_setopt($ch, CURLOPT_URL, 'https://api.sandbox.ebay.com/ws/api.dll');
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, true );
		curl_setopt($ch, CURLOPT_POSTFIELDS, $param['post']);	
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		$response = curl_exec($ch);
		if(curl_exec($ch) === false){
  		  echo 'Erreur Curl : ' . curl_error($ch);
		}		
		curl_close($ch);
		$xml = simplexml_load_string($response);
		//printr($xml);

	return $xml;		
	}
	/************************************************************************************/
	public function getErrorApi($xml){
		if ($xml->Ack == 'Failure') return TRUE;
		else return FALSE;
	}
	/************************************************************************************/
	public function printError($txt,$xml){
		$html = '<div class="panel panel-primary">
				  <div class="panel-heading">'.$txt.'</div>';
		$html .= '<div class="panel-body">';	
	//	if (!is_array($xml->Errors)) $html .= '<p class="list-group-item-text">'.utf8_decode($xml->Errors->LongMessage).'</p>';
	//	else {
			foreach($xml->Errors as $v){
				$html.= '<p class="list-group-item-text">'.utf8_decode($v->SeverityCode).' '.utf8_decode($v->LongMessage).'</p>';
				
			}
			
	//	}
		$html .= '</div>';		
		$html .= '</div>';
		echo $html;
	}	
	/************************************************************************************/
	public function getItem($param = array()){
		if (empty($param)) return;
		$param_post = array(	'version' 	=> '945',
								'name'		=> 'getItem',
		);

		$post  ='	<?xml version="1.0" encoding="utf-8"?>';
		$post .='	<GetItemRequest xmlns="urn:ebay:apis:eBLBaseComponents">';
		$post .='		<RequesterCredentials>';
		$post .='			<eBayAuthToken>'.$this->token.'</eBayAuthToken>';				
		$post .='		</RequesterCredentials>';				
		$post .='		<SKU>'.$param['sku'].'</SKU>';
		$post .='		<DetailLevel>ReturnAll</DetailLevel>';
//		$post .='		<DetailLevel>ItemReturnDescription</DetailLevel>';				
		$post .='		<MessageID>'.$param['sku'].'</MessageID>';
		$post .='		<Version>'.$param_post['version'].'</Version>';
		$post .='		<WarningLevel>High</WarningLevel>';
		$post .='	</GetItemRequest>';
		$param_post['post'] = $post;
		$xml = $this->post_request($param_post);
		echo '<pre>' ;print_r($xml); echo'</pre>';;		
	return $xml;	
	}
	/************************************************************************************/
	public function GetCategories($param = array()){
	//	if (empty($param)) return;
		$param_post = array(	'version' 	=> '951',
								'name'		=> 'GetCategories',
		);
		$post  ='	<?xml version="1.0" encoding="utf-8"?>';
		$post .='	<GetCategoriesRequest xmlns="urn:ebay:apis:eBLBaseComponents">';
		$post .='		<RequesterCredentials>';
		$post .='			<eBayAuthToken>'.$this->token.'</eBayAuthToken>';				
		$post .='		</RequesterCredentials>';	
		$post .='		<ViewAllNodes>true</ViewAllNodes>';				
		$post .='		<DetailLevel>ReturnAll</DetailLevel>';
		$post .='		<WarningLevel>High</WarningLevel>';
		$post .='	</GetCategoriesRequest>';				
		$param_post['post'] = $post;				
		$xml = $this->post_request($param_post);				
	//	echo '<pre>' ;print_r($xml); echo'</pre>';;				
	return $xml;		
	}
	/************************************************************************************/
	public function GetCategorySpecifics($param = array()){
		
		if (empty($param)) return;
			$param_post = array(	'version' 	=> '951',
									'name'		=> 'GetCategorySpecifics',
			);
			$post  ='	<?xml version="1.0" encoding="utf-8"?>';
			$post .='	<GetCategorySpecificsRequest xmlns="urn:ebay:apis:eBLBaseComponents">';
			$post .='		<RequesterCredentials>';
			$post .='			<eBayAuthToken>'.$this->token.'</eBayAuthToken>';				
			$post .='		</RequesterCredentials>';	
			$post .='		<CategoryID>'.$param['catID'].'</CategoryID>';				
			$post .='	</GetCategorySpecificsRequest>';
			$param_post['post'] = $post;
			$xml = $this->post_request($param_post);
	return $xml;		
	}
	/************************************************************************************/	
	public function  EndFixedPriceItem($param = array()){

		$param_post = array(	'version' 	=> '951',
								'name'		=> 'EndFixedPriceItem',
				);	
		$post= '
				<?xml version="1.0" encoding="utf-8"?>
				<EndFixedPriceItemRequest xmlns="urn:ebay:apis:eBLBaseComponents">
					<RequesterCredentials>
						<eBayAuthToken>'.$this->token.'</eBayAuthToken>
					</RequesterCredentials>
					<EndingReason EnumType="EndReasonCodeType">NotAvailable</EndingReason>
					<ItemID>' . $param['idEbay']  . '</ItemID>
					<ErrorLanguage>fr_FR</ErrorLanguage>
					<Version>'.$param_post['version'].'</Version>	
					<WarningLevel>High</WarningLevel>
				</EndFixedPriceItemRequest>';
		$param_post['post'] = $post;
		if (!$param['test']) $xml = $this->post_request($param_post);
		if ($this->getErrorApi($xml)) {
			$txt = 'Erreur sur le SKU <strong>' . $param['sku'] .'</strong> sur un appel type ' .$param_post['name']; 
			$this->printError($txt,$xml);
			//printr($xml);
		}
	return $xml;		
	}
	/************************************************************************************/	
	public function  GetTokenStatus($param = array()){

		$param_post = array(	'version' 	=> '557',
								'name'		=> 'GetTokenStatus',
				);	
		$post= '
				<?xml version="1.0" encoding="utf-8"?>
				<GetTokenStatusRequest xmlns="urn:ebay:apis:eBLBaseComponents">
					<RequesterCredentials>
						<eBayAuthToken>'.$this->token.'</eBayAuthToken>
					</RequesterCredentials>
					<ErrorLanguage>fr_FR</ErrorLanguage>
					<Version>'.$param_post['version'].'</Version>					
					<WarningLevel>High</WarningLevel>
				</GetTokenStatusRequest>';
				
		$param_post['post'] = $post;
		$xml = $this->post_request($param_post);	
		$this->getErrorApi($xml);
		printr($xml);		
	return $xml;		
	}	
	/************************************************************************************/		
}

?>