<?php 
	
	class ws_colissimo_affr {
		
		public $SERVER_NAME = "https://ws.colissimo.fr"; //TODO : Change server name
		public $LABEL_FOLDER =  "colissimo_api/pdf/"; //TODO : Change OutPut Folder: this is where the label will be saved
		public $BORDEREAUX_FOLDER =  "colissimo_api/pdf_bordereaux/";
		public $MY_LOGIN = "887490";
		public $MY_PASSWORD = "gainsbourg";
		
		public $reponse_bordereau = array();
		
		public $etiquette_ok = false;
		public $message_erreur_etiquette = "";
		public $num_etiquette_genere = "";
		
		const DEST_FR = 'FRANCE';
		const DEST_OM = 'OM';
		const DEST_EU = 'EUROPE';
		const DEST_WORLD = 'WORLDWIDE';
		const FIRSTNAME_LEN = 29;
		const LASTNAME_LEN = 35;
		const COMPANY_LEN = 35;
		const ADDRESS_LINE_LEN = 35;
		const ZIPCODE = 5;
		const CITY_LEN = 35;
		const ISO_GUADELOUPE = 'GP';
		const ISO_MARTINIQUE = 'MQ';
		
		//____________________________________________________________________________
		public function __construct() {
			$this->LABEL_FOLDER = DIR_FS_ADMIN . $this->LABEL_FOLDER ;
			$this->BORDEREAUX_FOLDER = DIR_FS_ADMIN . $this->BORDEREAUX_FOLDER ;			
		}
		//____________________________________________________________________________
		public function get_etiquette_ok() {	return $this->etiquette_ok; }		
		//____________________________________________________________________________
		public function get_message_erreur_etiquette() {	return $this->message_erreur_etiquette; }		
		//____________________________________________________________________________
		public function get_num_etiquette_genere() {	return $this->num_etiquette_genere; }	
		//____________________________________________________________________________
		public function get_reponse_bordereau() {	return $this->reponse_bordereau; }		
		//____________________________________________________________________________
		public function reset_info() {	
			$this->etiquette_ok = false; 
			$this->message_erreur_etiquette = "";
			$this->num_etiquette_genere = "";
			$this->reponse_bordereau = array();
		}			
		//____________________________________________________________________________		
		public function ote_accent($str){
			$ch = strtr($str,
				  'ÀÁÂÃÄÅÇÈÉÊËÌÍÎÏÒÓÔÕÖÙÚÛÜÝàáâãäåçèéêëìíîïðòóôõöùúûüýÿ',
				  'AAAAAACEEEEIIIIOOOOOUUUUYaaaaaaceeeeiiiioooooouuuuyy');
			//$ch = $this->enleverCaracteresSpeciaux($ch);
			return $ch;
		}	
		//____________________________________________________________________________				
		public function  skip_accents( $str, $charset='utf-8' ) {
		 
			$str = htmlentities( $str, ENT_NOQUOTES, $charset );
			
			$str = preg_replace( '#&([A-za-z])(?:acute|cedil|caron|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str );
			$str = preg_replace( '#&([A-za-z]{2})(?:lig);#', '\1', $str );
			$str = preg_replace( '#&[^;]+;#', '', $str );
			
			return $str;	
		}
				//____________________________________________________________________________		
		public function enleverCaracteresSpeciaux($text) {
			$utf8 = array(
					'/[áàâãªä]/u' => 'a',
					'/[ÁÀÂÃÄ]/u' => 'A',
					'/[ÍÌÎÏ]/u' => 'I',
					'/[íìîï]/u' => 'i',
					'/[éèêë]/u' => 'e',
					'/[ÉÈÊË]/u' => 'E',
					'/[óòôõºö]/u' => 'o',
					'/[ÓÒÔÕÖ]/u' => 'O',
					'/[úùûü]/u' => 'u',
					'/[ÚÙÛÜ]/u' => 'U',
					'/ç/' => 'c',
					'/Ç/' => 'C',
					'/ñ/' => 'n',
					'/Ñ/' => 'N',
					'//' => '-', // conversion d'un tiret UTF-8 en un tiret simple
					'/[]/u' => ' ', // guillemet simple
					'/[«»]/u' => ' ', // guillemet double
					'/ /' => ' ', // espace insécable (équiv. à 0x160)
					'/"/' => ' ', // 		
					"/'/" => ' ', // 	
				
					);
			return preg_replace(array_keys($utf8), array_values($utf8), $text);
		}		
		//____________________________________________________________________________				
		private function array_to_xml($soapRequest, $soapRequestXml) {
			foreach($soapRequest as $key => $value) {
				if(is_array($value)) {
					if(!is_numeric($key)){
						$subnode = $soapRequestXml->addChild("$key");
						$this->array_to_xml($value, $subnode);
					}
					else{
						$subnode = $soapRequestXml->addChild("item$key");
						$this->array_to_xml($value, $subnode);
					}
				}
				else {
					//$soapRequestXml->addChild("$key",'<![CDATA['.htmlspecialchars("$value").']]>');
					$soapRequestXml->addChild("$key",htmlspecialchars("$value"));					
				}
			}
		}	
		//____________________________________________________________________________		
		private function Traite_chaine($p) {

			$p = mb_strtoupper($p);
			$p = utf8_encode($p);
			$p =  str_replace("'"," ",$p);
			
			return($p);
		}		
		//____________________________________________________________________________		
		private function email_ajust($p) {
			
			$flag = false;
			if(strpos($p,"@") !== false){
					$flag = true;
			}
			if (!$flag)  $p = "charlotteboutik@orange.fr";
			if (!$flag)  $p = "";			
			return($p);
		}	
		//____________________________________________________________________________		
		private function phone_ajuste_fr($p) {
			
			$flag = false;
			$tel_tab = array("06","07","+336","+337");
			$p =  str_replace(".","",$p);
			$p =  str_replace(" ","",$p);	
			$p =  str_replace("/","",$p);
			$p =  str_replace("-","",$p);			
			foreach ($tel_tab as $t){
				if(strpos($p,$t) !== false){
					$flag = true;
				}
			}
			if (!$flag) $p = "";
			
			return($p);
		}		
		//_____________________________________________________________________________________________________
		public function adresse_ajuste($a) {  // $a delivery adresse de classe order
		/*
			line0 AN1…35 F Etage, couloir, escalier, appartement
			line1 AN1…35 F Entrée, bâtiment, immeuble, résidence.
			line2 AN1…35 C
								Numéro et libellé de voie.
								Exemple : « 5 rue du Bellay ».
								Doit comporter impérativement au moins un caractère si la
								balise <zipCode> n’affiche pas un code CEDEX.
								Peut être laissée vide si la balise <zipCode> indique un
								code Cedex. *
			line3 AN1…35 F Lieu-dit ou autre mention.
			*/
			$ADDRESS_LINE_LEN = 34;
			
			$r = array( "line0" =>  '', "line1" =>  '',"line2" =>  '',"line3" =>  '');

			$r['line2'] = $a['street_address'];
			$r['line3'] = $a['suburb'];
			$taille_l2 = strlen($r['line2']);
			if ($taille_l2 > $ADDRESS_LINE_LEN ) {
				$r['line3'] = trim(substr($r['line2'],$ADDRESS_LINE_LEN,$taille_l2) . ' ' . $r['line3']);
				$r['line2'] = substr($r['line2'],0,$ADDRESS_LINE_LEN);
			}
			
			$taille_l3 = strlen($r['line3']);
			if ($taille_l3 > $ADDRESS_LINE_LEN ) {		
				$r['line0'] = substr($r['line3'],$ADDRESS_LINE_LEN,$taille_l3);
				$r['line3'] = substr($r['line3'],0,$ADDRESS_LINE_LEN);

			}
	
			return($r);
		}			
		//____________________________________________________________________________	
		public function etiquette_nationnal($o = array() , $check = true ){
			
			$productCode = 'DOS';
			
			$address = $this->adresse_ajuste($o->delivery);
			
			if  (preg_match("/express/i", $o->info['shipping_method'])) $productCode = 'J+1';
			
			$requestParameter = array(
				'contractNumber' => $this->MY_LOGIN, //TODO : Change contractNumber
				'password' => $this->MY_PASSWORD, //TODO : Change password
				'outputFormat' => array(
					'outputPrintingType' => 'PDF_10x15_300dpi'
				),
				'letter' => array(
					'service' => array(
						'productCode' => $productCode,
						'depositDate' => date("Y-m-d")  //'2019-10-07' //TODO : Change depositDate (must be at least equal to current date)
					),
					'parcel' => array(
						'weight' => $o->delivery['poids_commande'],
					),
					'sender' => array(
						'address' => array(
							'companyName' => 'CHARLOTTE BOUTIK',
							'line2' => 'BP 11, HAMEAU les imberts',
							'countryCode' => 'FR',
							'city' => 'Cabrieres d Avignon',
							'zipCode' => '84220'
						)
					),
					'addressee' => array(
						'address' => array(
						'lastName' => $this->Traite_chaine(substr($o->delivery['name'],LASTNAME_LEN)),
						'line0' => $this->Traite_chaine($address['line0']),							
						'line1' => '',			
						'line2' => $this->Traite_chaine($address['line2']),
						'line3' => $this->Traite_chaine($address['line3']),			
						'countryCode' => $o->delivery['code_iso2'],
						'city' => $this->Traite_chaine(substr($o->delivery['city'],CITY_LEN)),
						'zipCode' => $o->delivery['postcode'],
						'mobileNumber' => $this->phone_ajuste_fr($o->customer['telephone']),				
						'email' => $this->email_ajust($o->customer['email_address']),					
						)
					)
				)
			);
			//printr($requestParameter);
			$this->Generate_SOAPRequestl($requestParameter,$check,$o->info['order_id']);
		}		
		//____________________________________________________________________________	
		public function etiquette_unionEuHorsFrance($o = array() , $check = true ){
			
			$productCode = 'DOS';
			
			if  (preg_match("/express/i", $o->info['shipping_method'])) $productCode = 'COLI';
			
			$address = $this->adresse_ajuste($o->delivery);
			
			$requestParameter = array(
				'contractNumber' => $this->MY_LOGIN, //TODO : Change contractNumber
				'password' => $this->MY_PASSWORD, //TODO : Change password
				'outputFormat' => array(
					'outputPrintingType' => 'PDF_10x15_300dpi'
				),
				'letter' => array(
					'service' => array(
						'productCode' => $productCode,
						'depositDate' => date("Y-m-d")  //'2019-10-07' //TODO : Change depositDate (must be at least equal to current date)
					),
					'parcel' => array(
						'weight' => $o->delivery['poids_commande'],
					),
					'sender' => array(
						'address' => array(
							'companyName' => 'CHARLOTTE BOUTIK',
							'line2' => 'BP 11, HAMEAU les imberts',
							'countryCode' => 'FR',
							'city' => 'Cabrieres d Avignon',
							'zipCode' => '84220'
						)
					),
					'addressee' => array(
						'address' => array(
							'lastName' => $this->Traite_chaine(substr($o->delivery['name'],LASTNAME_LEN)),
							'firstName' => '',
							'line0' => '',							
							'line1' => '',			
							'line2' => $this->Traite_chaine(substr($o->delivery['street_address'],ADDRESS_LINE_LEN)),
							'line3' => $this->Traite_chaine(substr($o->delivery['suburb'],ADDRESS_LINE_LEN)),			
							'countryCode' => $o->delivery['code_iso2'],
							'city' => $this->Traite_chaine(substr($o->delivery['city'],CITY_LEN)),
							'zipCode' => $o->delivery['postcode'],
							'mobileNumber' => $this->phone_ajuste_fr($o->customer['telephone']),				
							'email' => $this->email_ajust($o->customer['email_address']),					
						)
					)
				)
			);
			//printr($requestParameter);
			$this->Generate_SOAPRequestl($requestParameter,$check,$o->info['order_id']);
		}		
		//____________________________________________________________________________	
		public function Generate_SOAPRequestl($requestParameter,$check,$order_id){
			
			$call_type  = "generateLabel";
			if ($check) $call_type  = "checkGenerateLabel";
			
			//+ Generate SOAPRequest
			$xml = new SimpleXMLElement('<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" />');
			$xml->addChild("soapenv:Header");
			$children = $xml->addChild("soapenv:Body");
			$children = $children->addChild("sls:".$call_type, null, 'http://sls.ws.coliposte.fr');
			$children = $children->addChild($call_type."Request", null, "");
			$this->array_to_xml($requestParameter,$children);
			$requestSoap = $xml->asXML();
			//printr($requestSoap);
			//- Generate SOAPRequest
			//+ Call Web Service
			$resp = new SoapClient ( $this->SERVER_NAME .'/sls-ws/SlsServiceWS?wsdl' );
			$response = $resp->__doRequest ( $requestSoap, $this->SERVER_NAME .'/sls-ws/SlsServiceWS', $call_type, '2.0', 0 );
			
			//printr($response);
			//- Call Web Service
			//+ Parse Web Service Response
			$parseResponse = new MTOM_ResponseReader($response);
			$resultat_tmp = $parseResponse->soapResponse;			
			$soap_result = $resultat_tmp["data"];
			printr($resultat_tmp);
			$error_code = explode("<id>", $soap_result);
			$error_code = explode("</id>", $error_code[1]);
			printr($error_code);
			//- Parse Web Service Response
			//+ Error handling and label saving
			
			
		//	if (file_exists($filename)) {
		//		echo "Le fichier $filename existe.";
		//	} else {
		//		echo "Le fichier $filename n'existe pas.";
		//	}

			
			if (($error_code[0]=="0")&&(!$check)) {
				//+ Write result to file <parcel number>.extension in defined folder (ex: ./labels/6A12091920617.zpl)
				$resultat_tmp = $parseResponse->soapResponse;
				$soap_result = $resultat_tmp["data"];
				$resultat_tmp = $parseResponse->attachments;
				$label_content = $resultat_tmp[0];
				$my_datas = $label_content["data"];
				//Save the label
				$my_extension_tmp = $requestParameter["outputFormat"]["outputPrintingType"];
				$my_extension = strtolower(substr($my_extension_tmp,0,3));
				$pieces = explode("<parcelNumber>", $soap_result);
				$pieces = explode("</parcelNumber>", $pieces[1]);
				$parcelNumber = $pieces[0]; //Extract the parcel number
				$my_file_name = $this->LABEL_FOLDER.$order_id."_".$parcelNumber.".".$my_extension;
				$my_file = fopen($my_file_name, 'a');
				if (fputs($my_file, $my_datas)){ //Save the label in defined folder
					fclose($my_file);
					echo "fichier ".$my_file_name." ok <br>";
					$this->etiquette_ok = true;
					$this->message_erreur_etiquette = $error_message[0];	
					$this->num_etiquette_genere = $parcelNumber;					
					} else {
					echo "erreur ecriture etiquette <br>";
				}
				} else { //Display errors if exist
				$error_message = explode("<messageContent>", $soap_result);
				$error_message = explode("</messageContent>", $error_message[1]);
				echo 'error code : '.$error_code[0]."\n";
				echo 'error message : '.$error_message[0]."\n";

			}
			
		}
		//____________________________________________________________________________	
		public function bordereau_create($c = array()){
		
			
			$requestParameter  = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"xmlns:sls="http://sls.ws.coliposte.fr">';			
			$requestParameter .= '<soapenv:Header/>';
			$requestParameter .= '<soapenv:Body>';		
			$requestParameter .= '<sls:generateBordereauByParcelsNumbers>';	
			
			
			$requestParameter .= '<contractNumber>'.$this->MY_LOGIN.'</contractNumber>';
			$requestParameter .= '<password>'.$this->MY_PASSWORD.'</password>';	
			
			$requestParameter .= '<generateBordereauParcelNumberList>';		
						
			foreach($c as $t){
				$requestParameter .= '<parcelsNumbers>'.$t.'</parcelsNumbers>';
			}
			$requestParameter .= '</generateBordereauParcelNumberList>';	
			
			
			$requestParameter .= '</sls:generateBordereauByParcelsNumbers>';	
			$requestParameter .= '</soapenv:Body>';	
			$requestParameter .= '</soapenv:Envelope>';			
			
			//printr($requestParameter);
			$this->Generate_SOAPRequestl_bordereau($requestParameter, "generateBordereauByParcelsNumbers");
		}		
		//____________________________________________________________________________	
		public function Generate_SOAPRequestl_bordereau($requestParameter , $call_type  ){
			
			
			//+ Generate SOAPRequest
			$xml = new SimpleXMLElement($requestParameter);
			
			//$this->array_to_xml($requestParameter,$children);
			$requestSoap = $xml->asXML();
			//printr($xml);
			//printr($requestSoap);
			//die();
			//- Generate SOAPRequest
			//+ Call Web Service
			$resp = new SoapClient ( $this->SERVER_NAME .'/sls-ws/SlsServiceWS?wsdl' );
			$response = $resp->__doRequest ( $requestSoap, $this->SERVER_NAME .'/sls-ws/SlsServiceWS', $call_type, '2.0', 0 );
			//- Call Web Service
			//+ Parse Web Service Response
			//printr($response);
			//die();
			$parseResponse = new MTOM_ResponseReader($response);
			$resultat_tmp = $parseResponse->soapResponse;			
			$soap_result = $resultat_tmp["data"];
			//printr($resultat_tmp);
			$error_code = explode("<id>", $soap_result);
			$error_code = explode("</id>", $error_code[1]);
			//printr($error_code);
			//- Parse Web Service Response
			//+ Error handling and label saving
			
			
			$this->reponse_bordereau['error_code'] = $error_code[0];
			
			if ($error_code[0]=="0") {
				//+ Write result to file <parcel number>.extension in defined folder (ex: ./labels/6A12091920617.zpl)
				$resultat_tmp = $parseResponse->soapResponse;
				$soap_result = $resultat_tmp["data"];
				$resultat_tmp = $parseResponse->attachments;
				$label_content = $resultat_tmp[0];
				$my_datas = $label_content["data"];
				//Save the label
				$pieces = explode("<bordereauNumber>", $soap_result);
				$pieces = explode("</bordereauNumber>", $pieces[1]);
				$number = $pieces[0]; //Extract the parcel number
				
				$pieces = explode("<numberOfParcels>", $soap_result);
				$pieces = explode("</numberOfParcels>", $pieces[1]);
				$numberOfParcels = $pieces[0]; //Extract the parcel number
				
				$my_file_name = $this->BORDEREAUX_FOLDER.$number.".pdf";
				$my_file = fopen($my_file_name, 'a');
				if (fputs($my_file, $my_datas)){ //Save the label in defined folder
					fclose($my_file);
					//echo "fichier ".$my_file_name." ok <br>";	
					
					$this->reponse_bordereau['num_bordereau'] = $number;
					$this->reponse_bordereau['nb_colis'] = $numberOfParcels;
					
					
					} else {
					//echo "erreur ecriture etiquette <br>";
				}
				} else { //Display errors if exist
				$error_message = explode("<messageContent>", $soap_result);
				$error_message = explode("</messageContent>", $error_message[1]);
				echo 'error code : '.$error_code[0]."\n";
				echo 'error message : '.$error_message[0]."\n";

			}
			
		}	
	}		
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////		
	class MTOM_ResponseReader {
		const CONTENT_TYPE = 'Content-Type: application/xop+xml;';
		const UUID = '/--uuid:/'; //This is the separator of each part of the response
		const CONTENT = 'Content-';
		public $attachments = array ();
		public $soapResponse = array ();
		public $uuid = null;
		public function __construct($response) {
			if (strpos ( $response, self::CONTENT_TYPE ) !== FALSE) {
				$this->parseResponse( $response );
				} else {
				throw new Exception ( 'This response is not : ' . CONTENT_TYPE );
			}
		}
		private function parseResponse($response) {
			$content = array ();
			$matches = array ();
			preg_match_all ( self::UUID, $response, $matches, PREG_OFFSET_CAPTURE );
			for($i = 0; $i < count ( $matches [0] ) -1; $i ++) {
				if ($i + 1 < count ( $matches [0] )) {
					$content [$i] = substr ( $response, $matches [0] [$i] [1], $matches [0] [$i + 1] [1] - $matches [0]
					[$i] [1] );
					} else {
					$content [$i] = substr ( $response, $matches [0] [$i] [1], strlen ( $response ) );
				}
			}
			foreach ( $content as $part ) {
				if($this->uuid == null){
					$uuidStart = 0;
					$uuidEnd = 0;
					$uuidStart = strpos($part, self::UUID, 0)+strlen(self::UUID);
					$uuidEnd = strpos($part, "\r\n", $uuidStart);
					$this->uuid = substr($part, $uuidStart, $uuidEnd-$uuidStart);
				}
				$header = $this->extractHeader($part);
				if(count($header) > 0){
					if(strpos($header['Content-Type'], 'type="text/xml"')!==FALSE){
						$this->soapResponse['header'] = $header;
						$this->soapResponse['data'] = trim(substr($part, $header['offsetEnd']));
						} else {
						$attachment['header'] = $header;
						$attachment['data'] = trim(substr($part, $header['offsetEnd']));
						array_push($this->attachments, $attachment);
					}
				}
			}
		}
		/**
			* Exclude the header from the Web Service response
			* @param string $part
			* @return array $header
		*/
		private function extractHeader($part){
			$header = array();
			$headerLineStart = strpos($part, self::CONTENT, 0);
			
			$endLine = 0;
			while($headerLineStart !== FALSE){
				$header['offsetStart'] = $headerLineStart;
				$endLine = strpos($part, "\r\n", $headerLineStart);
				$headerLine = explode(': ', substr($part, $headerLineStart, $endLine-$headerLineStart));
				$header[$headerLine[0]] = $headerLine[1];
				$headerLineStart = strpos($part, self::CONTENT, $endLine);
			}
			$header['offsetEnd'] = $endLine;
			return $header;
		}
	}
	
?>