<?php 
	
	class ws_gls {
		
		public $SERVER_NAME = "https://api-qs.gls-group.eu/public/v1/"; //TODO : Change server name
		public $LABEL_FOLDER =  "glspi/pdf/"; //TODO : Change OutPut Folder: this is where the label will be saved

		public $LOGIN = "250test";
		public $PASSWORD = "250testpwd";
		public $CustomerID = "2505400034";
		public $ContactID = "250aaawbn6";		
		
		public $reponse_bordereau = array();
		
		public $etiquette_ok = false;
		public $message_erreur_etiquette = "";
		public $num_etiquette_genere = "";
		
		const DEST_FR = 'FRANCE';
		const DEST_OM = 'OM';
		const DEST_EU = 'EUROPE';
		const DEST_WORLD = 'WORLDWIDE';
		const FIRSTNAME_LEN = 29;
		const LASTNAME_LEN = 35;
		const COMPANY_LEN = 35;
		const ADDRESS_LINE_LEN = 35;
		const ZIPCODE = 5;
		const CITY_LEN = 35;
		const ISO_GUADELOUPE = 'GP';
		const ISO_MARTINIQUE = 'MQ';
		
		//____________________________________________________________________________
		public function __construct() {
			$this->LABEL_FOLDER = DIR_FS_ADMIN . $this->LABEL_FOLDER ;
		}
		//____________________________________________________________________________
		public function get_etiquette_ok() {	return $this->etiquette_ok; }		
		//____________________________________________________________________________
		public function get_message_erreur_etiquette() {	return $this->message_erreur_etiquette; }		
		//____________________________________________________________________________
		public function get_num_etiquette_genere() {	return $this->num_etiquette_genere; }	
		//____________________________________________________________________________
		public function get_reponse_bordereau() {	return $this->reponse_bordereau; }		
		//____________________________________________________________________________
		public function reset_info() {	
			$this->etiquette_ok = false; 
			$this->message_erreur_etiquette = "";
			$this->num_etiquette_genere = "";
			$this->reponse_bordereau = array();
		}			
		//____________________________________________________________________________		
		public function ote_accent($str){
			$ch = strtr($str,
				  'ÀÁÂÃÄÅÇÈÉÊËÌÍÎÏÒÓÔÕÖÙÚÛÜÝàáâãäåçèéêëìíîïðòóôõöùúûüýÿ',
				  'AAAAAACEEEEIIIIOOOOOUUUUYaaaaaaceeeeiiiioooooouuuuyy');
			//$ch = $this->enleverCaracteresSpeciaux($ch);
			return $ch;
		}	
		//____________________________________________________________________________				
		public function  skip_accents( $str, $charset='utf-8' ) {
		 
			$str = htmlentities( $str, ENT_NOQUOTES, $charset );
			
			$str = preg_replace( '#&([A-za-z])(?:acute|cedil|caron|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str );
			$str = preg_replace( '#&([A-za-z]{2})(?:lig);#', '\1', $str );
			$str = preg_replace( '#&[^;]+;#', '', $str );
			
			return $str;	
		}
				//____________________________________________________________________________		
		public function enleverCaracteresSpeciaux($text) {
			$utf8 = array(
					'/[áàâãªä]/u' => 'a',
					'/[ÁÀÂÃÄ]/u' => 'A',
					'/[ÍÌÎÏ]/u' => 'I',
					'/[íìîï]/u' => 'i',
					'/[éèêë]/u' => 'e',
					'/[ÉÈÊË]/u' => 'E',
					'/[óòôõºö]/u' => 'o',
					'/[ÓÒÔÕÖ]/u' => 'O',
					'/[úùûü]/u' => 'u',
					'/[ÚÙÛÜ]/u' => 'U',
					'/ç/' => 'c',
					'/Ç/' => 'C',
					'/ñ/' => 'n',
					'/Ñ/' => 'N',
					'//' => '-', // conversion d'un tiret UTF-8 en un tiret simple
					'/[]/u' => ' ', // guillemet simple
					'/[«»]/u' => ' ', // guillemet double
					'/ /' => ' ', // espace insécable (équiv. à 0x160)
					'/"/' => ' ', // 		
					"/'/" => ' ', // 	
				
					);
			return preg_replace(array_keys($utf8), array_values($utf8), $text);
		}		
		//____________________________________________________________________________				
		private function array_to_xml($soapRequest, $soapRequestXml) {
			foreach($soapRequest as $key => $value) {
				if(is_array($value)) {
					if(!is_numeric($key)){
						$subnode = $soapRequestXml->addChild("$key");
						$this->array_to_xml($value, $subnode);
					}
					else{
						$subnode = $soapRequestXml->addChild("item$key");
						$this->array_to_xml($value, $subnode);
					}
				}
				else {
					//$soapRequestXml->addChild("$key",'<![CDATA['.htmlspecialchars("$value").']]>');
					$soapRequestXml->addChild("$key",htmlspecialchars("$value"));					
				}
			}
		}	
		//____________________________________________________________________________		
		private function Traite_chaine($p) {

			$p = mb_strtoupper($p);
			$p = utf8_encode($p);
			$p =  str_replace("'"," ",$p);
			
			return($p);
		}		
		//____________________________________________________________________________		
		private function email_ajust($p) {
			
			$flag = false;
			if(strpos($p,"@") !== false){
					$flag = true;
			}
			if (!$flag)  $p = "charlotteboutik@orange.fr";
			if (!$flag)  $p = "";			
			return($p);
		}	
		//____________________________________________________________________________		
		private function phone_ajuste_fr($p) {
			
			$flag = false;
			$tel_tab = array("06","07","+336","+337");
			$p =  str_replace(".","",$p);
			$p =  str_replace(" ","",$p);	
			$p =  str_replace("/","",$p);
			$p =  str_replace("-","",$p);			
			foreach ($tel_tab as $t){
				if(strpos($p,$t) !== false){
					$flag = true;
				}
			}
			if (!$flag) $p = "";
			
			return($p);
		}		
		//_____________________________________________________________________________________________________
		public function adresse_ajuste($a) {  // $a delivery adresse de classe order
		/*
			line0 AN1…35 F Etage, couloir, escalier, appartement
			line1 AN1…35 F Entrée, bâtiment, immeuble, résidence.
			line2 AN1…35 C
								Numéro et libellé de voie.
								Exemple : « 5 rue du Bellay ».
								Doit comporter impérativement au moins un caractère si la
								balise <zipCode> n’affiche pas un code CEDEX.
								Peut être laissée vide si la balise <zipCode> indique un
								code Cedex. *
			line3 AN1…35 F Lieu-dit ou autre mention.
			*/
			$ADDRESS_LINE_LEN = 34;
			
			$r = array( "line0" =>  '', "line1" =>  '',"line2" =>  '',"line3" =>  '');

			$r['line2'] = $a['street_address'];
			$r['line3'] = $a['suburb'];
			$taille_l2 = strlen($r['line2']);
			if ($taille_l2 > $ADDRESS_LINE_LEN ) {
				$r['line3'] = trim(substr($r['line2'],$ADDRESS_LINE_LEN,$taille_l2) . ' ' . $r['line3']);
				$r['line2'] = substr($r['line2'],0,$ADDRESS_LINE_LEN);
			}
			
			$taille_l3 = strlen($r['line3']);
			if ($taille_l3 > $ADDRESS_LINE_LEN ) {		
				$r['line0'] = substr($r['line3'],$ADDRESS_LINE_LEN,$taille_l3);
				$r['line3'] = substr($r['line3'],0,$ADDRESS_LINE_LEN);

			}
	
			return($r);
		}			
	

	}		
	
?>