<?php 

class miraklWebservice{ 
	
	private $key;
	private	$url_mirakl ;
	private $debug = 0;
	private	$offset = 0;
	private $pagination	= 100;
	private $nbProducts = 0;
	private $nbrLineAff = 3;		
	private $type_reponse  = "xml";
/************************************************************************************/	
	public function __construct($key){
		$this->key = $key;
	}
/************************************************************************************/		
	public function setPreProdUrl($p){
		$this->url_mirakl = $p;
	}
/************************************************************************************/		
	public function setReponseType($p='xml'){
		$this->type_reponse = $p;  // xml ou json
	}	
/************************************************************************************/	
	public function display_xml($xml){
		header("Content-type: text/xml");
		echo $xml;
	}
/************************************************************************************/		
	static public function display_xml_object($xml){
		echo '<pre>' ; print_r ($xml); echo '</pre>' ;
	}	
/************************************************************************************/
	public function setDebug($debug){
		$this->debug = $debug;	
	}
/************************************************************************************/
	public function getProductsNumber(){
		$service  	 = "/api/offers";
		$param = '';
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url,'json'));
		if (isset($reponse->total_count)) 	$this->nbProducts = $reponse->total_count;		
		return $this->nbProducts;	
	}	
/************************************************************************************/
	public function getOffset(){
		return $this->offset;	
	}	
/************************************************************************************/
	public function setOffset($v){
		$this->offset = $v ;	
	}		
/************************************************************************************/		
	private function curlMiraklGet($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, str_replace ( ' ', '%20',$url));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER , false);	
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/'.$this->type_reponse,'Content-Type: multipart/form-data','Authorization: '.$this->key));
		curl_setopt($ch, CURLOPT_HTTPGET, true);	
		$response = curl_exec($ch);
		if(curl_exec($ch) === false)
		{
			echo 'Erreur Curl : ' . curl_error($ch);
		}
		curl_close($ch);
		//$this->display_xml_object($response);			
		return $response;			
	}
/************************************************************************************/		
	private function curlMiraklGetJson($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, str_replace ( ' ', '%20',$url));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER , false);	
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json','Content-Type: multipart/form-data','Authorization: '.$this->key));
		curl_setopt($ch, CURLOPT_HTTPGET, true);	
		$response = curl_exec($ch); 
		if(curl_exec($ch) === false)
		{
			echo 'Erreur Curl : ' . curl_error($ch);
		}
		curl_close($ch);
		//$this->display_xml_object($response);			
		return $response;			
	}
/************************************************************************************/		
	private function curlMiraklGetFile($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, str_replace ( ' ', '%20',$url));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER , false);	
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: text/csv','Content-Disposition: attachment; filename=products.csv','Content-Type: application/force-download','Authorization: '.$this->key));
		curl_setopt($ch, CURLOPT_HTTPGET, true);	
		$response = curl_exec($ch); 
		if(curl_exec($ch) === false)
		{
			echo 'Erreur Curl : ' . curl_error($ch);
		}
		curl_close($ch);
		//$this->display_xml_object($response);	
			
		return $response;			
	}		
/************************************************************************************/		
	private function curlMiraklPutXml($url,$put){
			
		$ch = curl_init();
		//curl_setopt($ch, CURLOPT_URL, $url);	
		curl_setopt($ch, CURLOPT_URL, $url);			
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_ENCODING, '');		
		curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);		
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml','Authorization: '.$this->key));
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");		
		curl_setopt($ch, CURLOPT_POSTFIELDS,$put);
		//printr($put);
		if(curl_exec($ch) === false)
		{
			echo '<br>Erreur Curl : ' . curl_error($ch);
		}		
		$response = curl_exec($ch);
		curl_close($ch);
		//$this->display_xml_object($response);
		return $response;		
	}	
/************************************************************************************/		
	private function curlMiraklPut($url,$put = array()){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/xml','Content-Type: application/xml','Authorization: '.$this->key));
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");		
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);			
		curl_setopt($ch, CURLOPT_POSTFIELDS,http_build_query($put));
		if(curl_exec($ch) === false)
		{
			echo '<br>Erreur Curl : ' . curl_error($ch);
		}

		$response = curl_exec($ch);
		curl_close($ch);
		//$this->display_xml_object($response);
		return $response;		
	}	
/************************************************************************************/		
	private function curlMiraklPost($url,$post){

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);	
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);	
	
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER , false);			
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/xml','Content-Type: multipart/form-data','Authorization: '.$this->key));
		curl_setopt($ch, CURLOPT_POST, true);	
	
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
		$response = curl_exec($ch);
		if($response === false)  echo 'erreur curl ' . curl_error($ch) . '<br/>';
 		//$this->display_xml_object($response);
		
		$header_info = curl_getinfo($ch,CURLINFO_HEADER_OUT);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($result, 0, $header_size);
		$body = substr($result, $header_size);	
	
		curl_close($ch);
		
		//echo 	'header info ' .$header_info;	

		return $response;		
	}	
/************************************************************************************/		
	public function getOffers($offset = 0){
		$service  	 = "/api/offers";
		$param 		 = '?max='. $this->pagination ;
		$param 		.= '&offset='. $offset ;		
		
	//	$url = "https://gstk-recette.mirakl.net/api/offers?api_key=".$key."&max=100";
		$url 		= $this->url_mirakl . $service  . $param;

		$response	= $this->curlMiraklGet($url);	
		return $response;
	}
/************************************************************************************/			
	public function getAllOffers(){

		$offset = 0;
		
		$offers = simplexml_load_string($this->getOffers());
		$nbOffres = (int)$offers->total_count;
		echo $nbOffres;
		while ($nbOffres > $offset) {
			$offers = simplexml_load_string($this->getOffers($offset));
			$offset += $this->pagination ;
			foreach ($offers->offers->offer as $offer){
				//echo $offer->product_title; echo '<hr>';				
				$tabOffers[] = $offer;
			}
		}
	//$this->display_xml_object($tabOffers);	
	return $tabOffers;
	}
/************************************************************************************/	
	public function getOrderList($offset = 0){
		$service  	 = "/api/orders";
		$param 		 = '?max='. $this->pagination ;
		$param		.= '&order=desc';
		$param 		.= '&offset='. $offset ;	
//		$url = "https://gstk-recette.mirakl.net/api/orders?api_key=".$key;
           				
				
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklGet($url,'json');
		$orders = simplexml_load_string($reponse);		
		//$this->display_xml_object($orders);	
		return $orders;

	}
/************************************************************************************/			
	public function getAllOrdersList($offset = 0 ){
		
		$Orders = $this->getOrderList($offset);
		$Orders = json_decode( json_encode($Orders) , 1); // array transform
		return $Orders;	
	}	
/************************************************************************************/	
	public function exportProducts($file = 'produits.xml'){
		$service  	 = "/api/products/imports";
		$param = '';
		//$url = "https://gstk-recette.mirakl.net/api/products/imports?api_key=".$key;
		
		$post = array(	
						'file' => '@export/'.$file,					
						
		
		);
			
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklPost($url,$post);	
		return $reponse;
	
	}
/************************************************************************************/	
	public function exportOffers($file = 'offres.xml',$typeExport = "NORMAL"){
		$service  	 = "/api/offers/imports";
		$param = '';
		//$url = "https://gstk-recette.mirakl.net/api/offers/imports?api_key=".$key;
		
		$post = array('file' => '@export/'.$file,'import_mode' => $typeExport);
			
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklPost($url,$post);
		return $reponse;
	
	}	
/************************************************************************************/	
	public function orderTracking($order , $c_trackNum , $c_code=''  , $c_name ='' , $c_url =''){
		$service  	 = "/api/orders/".$order."/tracking";
		$param = '';
		
		$request_xml = "<?xml version='1.0' encoding='utf-8'?>";
		$put ="<tracking>";
		if (!empty($c_code)) 		$put.="		<carrier_code>".$c_code."</carrier_code>";
		if (!empty($c_name)) 		$put.="	 	<carrier_name>".$c_name."</carrier_name>";
		if (!empty($c_url)) 		$put.="		<carrier_url><![CDATA[".$c_url."]]></carrier_url>";
		$put.="  	<tracking_number>".$c_trackNum."</tracking_number>";		
		$put.="</tracking>";
		$put = $request_xml .$put;
		//echo "<br>";

		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklPutXml($url , $put);	
		//$ret = simplexml_load_string($reponse);	
		return $reponse;


	}
/************************************************************************************/	
	public function orderAccept($order = "" , $accepted , $tab_prod){
		$service  	 = "/api/orders/".$order."/accept";
		$param = '';
		
		$request_xml = "<?xml version='1.0' encoding='utf-8'?>";
		
		
		$put ="<order>";
		$put.="	<order_lines>";
		foreach ($tab_prod  as $p) {
			$put.="		<order_line>";
			$put.="			<accepted>".$p[accepted]."</accepted>";
			$put.="			<id>".$p[id]."</id>";
			$put.="		</order_line>";
		}
		$put.="	</order_lines>";
		$put.="</order>";
		$put = $request_xml .$put;  

		$url 		= $this->url_mirakl . $service  . $param;
		//die();
		$reponse	= $this->curlMiraklPutXml($url , $put);	
		return $reponse;
	}	
/************************************************************************************/	
public function orderRefund($order = "" , $reason_code ){  // pas utilis pour l instant
		$service  	 = "/api/orders/".$order."/accept";
		$param = '';
		
		$request_xml = "<?xml version='1.0' encoding='utf-8'?>";
		$put ="<order>";
		$put.="	<order_lines>";
		$put.="		<order_line>";
		$put.="			<reason_code>".$accepted."</reason_code>";
		$put.="			<id></id>";
		$put.="		</order_line>";
		$put.="	</order_lines>";
		$put.="</order>";
		$put = $request_xml .$put;
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklPutXml($url , $put);	
		return $reponse;


	}	
/************************************************************************************/		
	public function validOrderShip($order = ""){
		
		$service  	 = "/api/orders/".$order."/ship";
		$param = '';
			
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklPut($url);	
		return $reponse;

	}
/************************************************************************************/
	public function getReasonsList(){

		$service  	 = "api/reasons/refund";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklGet($url);	
		return $reponse;	
		
	}
/************************************************************************************/
	public function getCarriersList(){

		$service  	 = "/api/shipping/carriers";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklGet($url);	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getInvoicesList(){

		$service  	 = "api/invoices";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	= $this->curlMiraklGet($url);	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getHierarchies(){

		$service  	 = "/api/hierarchies";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url));	
		return $reponse;	
		
	}
/************************************************************************************/
	public function getProductsAttributes(){

		$service  	 = "/api/products/attributes";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url));	
		return $reponse;	
		
	}
/************************************************************************************/
	public function getProductsAttributesValuesList($listeCode){

	//	$service  	 = "/api/products/attributes/values_list/";
	//	$service	.= $listeCode;	
		$service  	 = "/api/values_lists";		
		$service	.= '?code=' . $listeCode;
		$param = '';

		sleep(5);
		$url 		= $this->url_mirakl . $service  . $param;		
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url));	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getProductsAttributesValuesListAll(){

	//	$service  	 = "/api/products/attributes/values_list/";
	//	$service	.= $listeCode;	
		$service  	 = "/api/values_lists";		
		$param = '';

		$url 		= $this->url_mirakl . $service  . $param;		
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url));	
		return $reponse;	
		
	}		
/************************************************************************************/
	public function getApiVersion(){

		$service  	 = "/api/version";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url));	
		return $reponse;	
		
	}		
/************************************************************************************/
	public function getOffersList(){

		$service  	 = "/api/offers";
		$param 	= '?offset='.$this->offset;
		$param .= '&max='.$this->pagination ;
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url,'json'));
		sleep(10); // reporisation bloquage delai
		return $reponse;			
	}	
/************************************************************************************/
	public function getApiCarriers(){

		$service  	 = "/api/shipping/carriers";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url));	
		return $reponse;	
		
	}
/************************************************************************************/
	public function logistic_classes(){

		$service  	 = "/api/shipping/logistic_classes";
		$param = '';
		
		$url 		= $this->url_mirakl . $service  . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGet($url));	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function RetrieveThread($thread_id = "",$shop_id='' ){
		$service  	 = "/api/inbox/threads/";
		$url 		= $this->url_mirakl . $service .$thread_id;
		$reponse	= json_decode($this->curlMiraklGet($url),true);

		//$this->display_xml_object($reponse);
		return $reponse ; 
	}
/************************************************************************************/	
	public function ListAllThreads($page_token='',$param_entity_type  = '', $param_entity_id  = '',$shop_id = ''){
		$service     ="/api/inbox/threads"  ; 
		 $url	= $this->url_mirakl . $service.'&page_token='.$page_token  ;

		$reponse	= json_decode($this->curlMiraklGet($url),true);
		//$this->display_xml_object($reponse);

		return $reponse ; 
	}
/************************************************************************************/	
	public function DownloadAttachment($attachment_id = '' ,$shop_id = '' ){
		$service = "/api/inbox/threads/" ; 
		 $url = $this->url_mirakl.$service.$attachment_id."/download" ; 
		
		$reponse	= json_decode($this->curlMiraklget($url),true);

		//$this->display_xml_object($reponse);
		//return $reponse ; 
	}
/************************************************************************************/	
	public function ReplyThread($post,$thread_id = '' , $shop_id = ''){
		$service = "/api/inbox/threads/" ;
		 $url = $this->url_mirakl.$service.$thread_id."/message".'&shop_id='.$shop_id ; 
		 
		
		$reponse	= $this->curlMiraklPost($url,$post,'json');
		//$this->display_xml_object($reponse);
	}
/************************************************************************************/	
	public function CreateOrderThread($order_id = '' , $shop_id = ''){
		$service = "/api/orders/" ;
		$url = $this->url_mirakl.$service.$order_id."/threads".'&shop_id='.$shop_id ;
		
		$reponse	= $this->curlMiraklPost($url,'json');
		$this->display_xml_object($reponse);
	}
	/************************************************************************************/
	public function getAdditionalFields(){

		$service  	 = "/api/additional_fields";
		$param = '';
		
		$url 		= $this->url_mirakl . $service . $param;
		$reponse	=  json_decode($this->curlMiraklGetJson($url));	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getImportStatusProductImport(){

		$service  	 = "/api/products/imports";
		$param		.= '?sort=dateCreated&order=desc&max='.$this->nbrLineAff;
		
		$url 		= $this->url_mirakl . $service . $param;
		$reponse	=  json_decode($this->curlMiraklGetJson($url));	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getImportStatusOfferImport(){

		$service  	 = "/api/offers/imports";
		$param		.= '?sort=dateCreated,desc&limit='.$this->nbrLineAff;
		
		$url 		= $this->url_mirakl . $service . $param;
		$reponse	=  json_decode($this->curlMiraklGetJson($url));	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getShopInformations(){

		$service  	 = "/api/account";
		$param		.= '';
		
		$url 		= $this->url_mirakl . $service . $param;
		$reponse	=  json_decode($this->curlMiraklGetJson($url));	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getTransformationReportFileProduct($idFile){

		$service  	 = "/api/products/imports/".$idFile."/transformation_error_report";
		$param		.= '';
		
		$url 		= $this->url_mirakl . $service . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGetFile($url));	
		return $reponse;	
		
	}	
/************************************************************************************/
	public function getTransformationReportFileOffer($idFile){

		$service  	 = "/api/offers/imports/".$idFile."/error_report";
		$param		.= '';
		
		$url 		= $this->url_mirakl . $service . $param;
		$reponse	=  simplexml_load_string($this->curlMiraklGetFile($url));	
		return $reponse;	
		
	}	
/************************************************************************************/	
static public function FormatDateMirakl($value){

	    	$nb = preg_split('#\D#', $value )  ;
	      	return $nb[2].'/'.$nb[1].'/'.$nb[0].' '.$nb[3].'h'.$nb[4] ;  
	  }
/************************************************************************************/
static public function FormatTxt($value){	 
	return utf8_decode($value) ;
	}
/************************************************************************************/
	public function __destruct() {
       // print "Destruction de " . $this->name . "\n";
    }	
}
?>