<?php

class ProductExport{
	
	private $i 						= 0;  // compteur lignes produits
	private $nbrProd   				= 0;
	private $nbrProdVariants 		= 0;
	private $t						= array();
	private $DelaiModif				= 0;
		
	/*************************************************************************************/	
	public function getNbrProductsLine(){
		return $this->i;
	}	
	/*************************************************************************************/	
	public function getNbrProducts(){
		return $this->nbrProd;
	}
	/*************************************************************************************/	
	public function getNbrProductsVariants(){
		return $this->nbrProdVariants;
	}	
	/*************************************************************************************/	
	public function SetNbrDayToSend($v){
		$this->DelaiModif = $v;
	}		
	/*************************************************************************************/
	public function SqlListProd(){
		$languages_id = 1;
		set_time_limit(0);
		$insRequete = "";
		if ($this->DelaiModif > 0 ) {
			$date_delai_modif = date("Y-m-d", strtotime("-".$this->DelaiModif." days")) . " 00:00:00";
			echo $date_delai_modif;
			$insRequete = ("				   AND     	products_last_modified >= '".$date_delai_modif."' " );
		}
		

		$products_query = tep_db_query("SELECT 
													p.products_id,
													p.products_quantity,
													p.products_model,
													p.products_image,
													p.products_image_med,
													p.products_image_lrg,
													p.products_image_xl_1,
													p.products_image_xl_2,
													p.products_image_xl_3,
													p.products_image_xl_4,
													p.products_image_xl_5,
													p.products_image_xl_6,
													p.products_price,
													p.products_weight,
													p.products_status,
													p.products_tax_class_id,
													p.manufacturers_id,
													p.fournisseurs_id,
													p.ecotax_rates_id,
													p.products_ean,
													p.products_laredoute_attributs,		
													p.goto_laredoute,
													pd.products_name, 
													pd.products_description,
													pc.categories_id, 
													c.categorie_id_laredoute_fr,
													pcd.language_id 


												   FROM (
												   " . TABLE_PRODUCTS . " p, 
												   " . TABLE_PRODUCTS_DESCRIPTION . " pd, 
												   " . TABLE_PRODUCTS_TO_CATEGORIES . " pc, 
												   " . TABLE_CATEGORIES_DESCRIPTION . " pcd, 
												   " . TABLE_CATEGORIES . " c)

												   WHERE p.products_id = pd.products_id 
												   AND p.products_id = pc.products_id
												   AND pd.language_id = FLOOR($languages_id)
												   AND pcd.language_id = FLOOR($languages_id)


													$insRequete

												   AND    pc.categories_id = pcd.categories_id
												   AND    pc.categories_id = c.categories_id
												   AND 	  p.products_status = 1
												   AND 	  p.goto_laredoute = 1
												   AND 	  p.products_quantity > 0
												   AND 	  p.products_laredoute_attributs <> ''
												   
												   AND	  c.categorie_id_laredoute_fr <> ''
										   
												
												   
												   ORDER BY pc.categories_id, pd.products_name
												  
												   
												   ");

												// AND p.products_in_laredoute  <> '' 2857
		
		while($products = tep_db_fetch_array($products_query)) {
			$p = product_id_variant($products['products_id'], '', '', $typeRef = 'products_stock_ean','laredoute');
			if (!$p['variant'])	{    
			
				if ($this->RedouteIsExportable($products)) $this->SqlProdNotVariant($products);  
			}
			else { 
				if ($this->RedouteIsExportable($products,true)) $this->SqlProdvariant($products,$p);
			}

		}
	$this->usetProduct();
//	die('STOP');
	return $this->t;
	}
	/*************************************************************************************/
	private function SqlProdVariant($products,$tabVariant){

		foreach ($tabVariant['sku_enfant'] as $id => $values){
			
			$this->nbrProdVariants++;
			$this->i++;	
			$this->t[$this->i]['VendorId'] 				=  _VENDOR_ID_REDOUTE_ ;		
			$this->t[$this->i]['ProductID'] 			=  $products['products_id'] ;	 
			$this->t[$this->i]['EAN'] 					=  $values['ean'] ;	
//			$this->t[$this->i]['Title'] 				=  netoyage_html_utf8($products['products_name'],200) . ' ' . $values['taille'] . ' ' .  $values['couleur'] ;				
		//	$this->t[$this->i]['Title'] 				=  netoyage_html_utf8($products['products_name'],200);		
			$this->t[$this->i]['Title'] 				=  netoyage_html_utf8($this->extra_titre_name($products),200);		
			$this->t[$this->i]['Description'] 			=  netoyage_html_utf8($products['products_description'],2000) ;			
			$this->t[$this->i]['Locale'] 				=  'fr' ;	
//			$this->t[$this->i]['BrandId'] 				=  $this->BrandIdManufacture($products) ;		
			$this->t[$this->i]['BrandId'] 				=  $this->BrandId($products) ;				
			$this->t[$this->i]['Subfamily'] 			=  $this->SubFamily($products['categorie_id_laredoute_fr']) ;
			$this->t[$this->i]['media'][1]['CheckSumType'] 		=  'MD5' ;				
			$this->t[$this->i]['media'][1]['URL'] 				=  $img = $this->RedouteMainImg('products_image' , $products) ;
			$this->t[$this->i]['media'][1]['Rank'] 	   			= 	1 ;			
			$this->t[$this->i]['media'][1]['CheckSum'] 			=  $this->RedouteMd5Img($img) ;
			$this->t[$this->i]['media'][1]['Contenttype'] 		=  'Photo';
			$this->t[$this->i]['media'][1]['typeFile'] 			=  pathinfo($img, PATHINFO_EXTENSION);		
			
			
			for ($i = 2; $i <= 7; $i++) {
				if (!empty($products['products_image_xl_'.strval($i-1)])) {
					$this->t[$this->i]['media'][$i]['CheckSumType'] =  'MD5' ;					
					$this->t[$this->i]['media'][$i]['URL'] 		   	= $img =  $this->RedouteMoreImg('products_image_xl_'.strval($i-1) , $products) ;	
					$this->t[$this->i]['media'][$i]['Rank'] 	   	= $i ;				
					$this->t[$this->i]['media'][$i]['CheckSum'] 	= $this->RedouteMd5Img($img) ;
					$this->t[$this->i]['media'][$i]['Contenttype'] 	=  'Photo';	
					$this->t[$this->i]['media'][$i]['typeFile'] 	=  pathinfo($img, PATHINFO_EXTENSION);
				}
			}
			
			if (!empty($values['img_variant'])){
			// dclinaison en dehors de product
				$this->t[$this->i]['media_declinaison']['CheckSumType'] 		=  'MD5' ;				
				$this->t[$this->i]['media_declinaison']['URL'] 					=  $values['img_variant'] ;
				$this->t[$this->i]['media_declinaison']['Rank'] 	   			= 	1 ;			
				$this->t[$this->i]['media_declinaison']['CheckSum'] 			=  $this->RedouteMd5Img($values['img_variant']) ;
				$this->t[$this->i]['media_declinaison']['Contenttype'] 			=  'Photo';
				$this->t[$this->i]['media_declinaison']['typeFile'] 			=  pathinfo($values['img_variant'], PATHINFO_EXTENSION);		
			}
			//printr($products);
			//printr($tabVariant);
			$this->RedouteAttributes($products,$values);
		}
	}
	/*************************************************************************************/
	private function SqlProdNotVariant($products){

			$this->nbrProd++;	
			$this->i++;
			$this->t[$this->i]['VendorId'] 				=  _VENDOR_ID_REDOUTE_ ;		
			$this->t[$this->i]['ProductID'] 			=  $products['products_id'] ;
			$this->t[$this->i]['EAN'] 					=  $products['products_ean'] ;	
//			$this->t[$this->i]['Title'] 				=  netoyage_html_utf8($products['products_name'],200) ;	
			$this->t[$this->i]['Title'] 				=  netoyage_html_utf8($this->extra_titre_name($products),200);				
			$this->t[$this->i]['Description'] 			=  netoyage_html_utf8($products['products_description'],2000) ;	
			$this->t[$this->i]['Locale'] 				=  'fr' ;				
//			$this->t[$this->i]['BrandId'] 				=  $this->BrandIdManufacture($products) ;
			$this->t[$this->i]['BrandId'] 				=  $this->BrandId($products) ;			
			$this->t[$this->i]['Subfamily'] 			=  $this->SubFamily($products['categorie_id_laredoute_fr']) ;
			$this->t[$this->i]['media'][1]['CheckSumType'] 		=  'MD5' ;				
			$this->t[$this->i]['media'][1]['URL'] 				=  $img = $this->RedouteMainImg('products_image' , $products) ;
			$this->t[$this->i]['media'][1]['Rank'] 	   			= 	1 ;			
			$this->t[$this->i]['media'][1]['CheckSum'] 			=  $this->RedouteMd5Img($img) ;
			$this->t[$this->i]['media'][1]['Contenttype'] 		=  'Photo';
			$this->t[$this->i]['media'][1]['typeFile'] 			=  pathinfo($img, PATHINFO_EXTENSION);		
			
			for ($i = 2; $i <= 7; $i++) {
				if (!empty($products['products_image_xl_'.strval($i-1)])) {
					$this->t[$this->i]['media'][$i]['CheckSumType'] =  'MD5' ;					
					$this->t[$this->i]['media'][$i]['URL'] 		   	= $img =  $this->RedouteMoreImg('products_image_xl_'.strval($i-1) , $products) ;	
					$this->t[$this->i]['media'][$i]['Rank'] 	   	= $i ;				
					$this->t[$this->i]['media'][$i]['CheckSum'] 	= $this->RedouteMd5Img($img) ;
					$this->t[$this->i]['media'][$i]['Contenttype'] 	=  'Photo';	
					$this->t[$this->i]['media'][$i]['typeFile'] 	=  pathinfo($img, PATHINFO_EXTENSION);
				}
			}
			
			$this->RedouteAttributes($products);
		
	}
	/*************************************************************************************/	
	private function RedouteMainImg($index , $products){
		
		if ( $products[$index] == '' )
			{ $img =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image'] ; }
		else
			{ $img =  HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES . $products['products_image_med'] ; }	
	return $img;
	}
	/*************************************************************************************/	
	private function RedouteMoreImg($index , $products){
		$img = HTTP_SERVER . DIR_WS_HTTP_CATALOG . DIR_WS_IMAGES .$products[$index];	
	return $img;
	}
	/*************************************************************************************/	
	private function RedouteAttributes($products,$tabVariant = ''){
		$pos = 1 ;
		$sf = $this->SubFamily($products['categorie_id_laredoute_fr']);
		$f = $this->Family($products['categorie_id_laredoute_fr']);	
		$tab_att_famille_taille_coul = array();
		if ((!empty($tabVariant))&&(is_array($tabVariant))){
			//printr($tabVariant);
			$infoRedouteVariant = $this->infoRedouteVariant($tabVariant,$sf);
			//printr($infoRedouteVariant);			
			if (!empty($tabVariant['taille_id_redoute'])) $infoRedouteVariant = $this->infoRedouteVariantID($tabVariant,$sf);
				else $infoRedouteVariant = $infoRedouteVariant = $this->infoRedouteVariant($tabVariant,$sf);
			$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= $infoRedouteVariant['attribut_id'];
			$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= $infoRedouteVariant['attribut_name']; // on peut laisser vide
			$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'TRUE';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= $infoRedouteVariant['attribut_value_id'];
			$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = $tabVariant['taille']; // on peut laisser vide		
			$pos++;
			// Grille de Coloris gnrique
			$infoRedouteVariant = $this->infoRedouteVariantcouleur($tabVariant,'A0485');					
			$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= 'A0485';
			$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= 'Grille de Coloris gnrique'; // on peut laisser vide
			$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'TRUE';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= $infoRedouteVariant['attribut_value_id'];
			$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = $tabVariant['couleur']; // on peut laisser vide		
			$pos++;		
			// couleur commerciale obliguatoire
			$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= 'A1114';
			$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= 'Couleurs commerciales'; // on peut laisser vide
			$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'TRUE';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= '';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = $tabVariant['couleur_interne']; // on peut laisser vide		
			$pos++;				
		}
		else {
			// Grille de Coloris gnrique
			/*
			$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= 'A0485';
			$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= 'Grille de Coloris gnrique'; // on peut laisser vide
			$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'FALSE';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= 'V019845';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = 'MULTICOLORE'; // on peut laisser vide		
			$pos++;				
			// couleur commerciale obliguatoire
			$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= 'A1114';
			$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= 'Couleurs commerciales'; // on peut laisser vide
			$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'FALSE';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= '';
			$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = 'Multicolore'; // on peut laisser vide		
			$pos++;							
			*/
			$tab_laredoute_famille = leRedouteAttributs($f);
			//printr($tab_laredoute_famille);
			foreach($tab_laredoute_famille as $val){
				if($val['attribut_id'] == 'A0485' ) $tab_att_famille_taille_coul['A0485'] = $val['IsMandatory'];
				if($val['attribut_id'] == 'A1114' ) $tab_att_famille_taille_coul['A1114'] = $val['IsMandatory'];				
			}
			//printr($tab_att_famille_taille_coul);
		}
		


		$t_un = unserialize($products['products_laredoute_attributs']);
		//printr($t_un);
		$t = $t_un['laredoute_lst_attrib_f_Contrained'];
		if (empty($t)) $t = array();
		//printr($products['products_id']);	
		if (array_key_exists('A0485',$tab_att_famille_taille_coul)){
			if ($tab_att_famille_taille_coul['A0485'] == 1 )  {
				if (!array_key_exists('A0485',$t))  $t['A0485'] = 'V019845';
			}
		}
		//printr($t);	
		if (!empty($t)){
			foreach ($t as $k=>$v){
				$flag = 1 ;
				
				if ((!empty($tabVariant))&&(is_array($tabVariant))){
					// variant
					if($k == 'A0485') { $flag = 0 ; }
				} else {
					// non variant
					
				}
					
				if ($flag) {
				
					$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= $k;
				//	$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= ''; // on peut laisser vide
					$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= $this->attributsName($k); // on peut laisser vide			
					$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'FALSE';
					$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= $v;
				//	$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = ''; // on peut laisser vide
					$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = $this->attributsValueName($v); // on peut laisser vide					
					$pos ++;
				}
			}
		}
		
		$t = $t_un['laredoute_lst_attrib_f_noContrained'];
		if (empty($t)) $t = array();
		if (array_key_exists('A1114',$tab_att_famille_taille_coul)) {
			if ($tab_att_famille_taille_coul['A1114'] == 1 )  {
				if (!array_key_exists('A1114',$t))  $t['A1114'] = 'MULTICOLORE';
			}
		}		
		if (!empty($t)){
			foreach ($t as $k=>$v){
				

				$flag = 1 ;
				
				if ((!empty($tabVariant))&&(is_array($tabVariant))){
					if($k == 'A1114') { $flag = 0 ; }
				}
					
				if ($flag) {
				
					$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= $k;
				//	$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= ''; // on peut laisser vide
					$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= $this->attributsName($k); // on peut laisser vide			
					$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'FALSE';
					$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= '';
				//	$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = ''; // on peut laisser vide
					$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = $v; // on peut laisser vide					
					$pos ++;
				}
			}
		}
				
		$t = $t_un['laredoute_lst_attrib_sf_Contrained'];
		//printr($t);	
		if (!empty($t)){		
			foreach ($t as $k=>$v){
				
				$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= $k;
			//	$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= ''; // on peut laisser vide
				$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= $this->attributsName($k); // on peut laisser vide			
				$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'FALSE';
				$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= $v;
			//	$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = ''; // on peut laisser vide
				$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = $this->attributsValueName($v); // on peut laisser vide					
				$pos ++;
			}
		}	
		
		$t = $t_un['laredoute_lst_attrib_sf_noContrained'];
		//printr($t);	
		if (!empty($t)){		
			foreach ($t as $k=>$v){
				
				$this->t[$this->i]['Attributes'][$pos]['AttribCode'] 			= $k;
			//	$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= ''; // on peut laisser vide
				$this->t[$this->i]['Attributes'][$pos]['AttribDescription'] 	= $this->attributsName($k); // on peut laisser vide			
				$this->t[$this->i]['Attributes'][$pos]['Declinable'] 	   		= 'FALSE';
				$this->t[$this->i]['Attributes'][$pos]['ValAttribCode'] 	   	= '';
			//	$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = ''; // on peut laisser vide
				$this->t[$this->i]['Attributes'][$pos]['ValAttribDescription']  = $v; // on peut laisser vide					
				$pos ++;
			}
		}			
		
		//printr($this->t[$this->i]);
	}
	/*************************************************************************************/	
	private function RedouteMd5Img($url){
		if (empty($url)) return;
		$url = str_replace( ".mp.charlotteboutik", ".charlotteboutik", $url);
		if (!empty($url)) $md5 = @md5_file($url);
	return $md5;
	}
	/*************************************************************************************/	
	private function RedouteIsExportable($p,$variant = False){
		
		
		$exportable = TRUE;
	//	if (empty($p['products_laredoute_attributs'])) $exportable =  false;
	//	if (empty($p['categorie_id_laredoute_fr'])) $exportable =  false;		
		$sf = $this->SubFamily($p['categorie_id_laredoute_fr']);
		$attLst = $this->attributsIdSousFammille($sf);
		$attLstFamille = $this->attributsIdFammille($this->Family($p['categorie_id_laredoute_fr']));
		//printr($sf);		
		//printr($attLst);
		$t = array();
		
		$t = unserialize($p['products_laredoute_attributs']);
		//printr($t);
		if (empty($t)) {
				printr("ATTENTION le SKU ". $p['products_id'] . "  aucun attribut (non envoye dans FLUX)");
					$exportable =  false;		
		}
		$t_f = $t['laredoute_lst_attrib_f_Contrained'];
		//printr($t_sf);		
		if (!empty($t_f)) {
			foreach($t_f as $v) {
				if (empty($v)){
					printr("ATTENTION le SKU ". $p['products_id'] . "  a un attribut FAMILLE obligatoire non renseigne, mettez 1 attribut sinon laredoute cree une erreur XSD et le produit n est pas traite (non envoye dans FLUX)");
					$exportable =  false;
					break;
				}
			}
		} else { //$exportable =  false; 
		
		}

		//printr($t);
		$t_sf = $t['laredoute_lst_attrib_sf_Contrained'];
		//printr($t_sf);		
		if (!empty($t_sf)) {
			foreach($t_sf as $v) {
				if (empty($v)){
					printr("ATTENTION le SKU ". $p['products_id'] . "  a un attribut SOUS FAMILLE obligatoire non renseigne, mettez 1 attribut sinon laredoute cree une erreur XSD et le produit n est pas traite (non envoye dans FLUX)");
					$exportable =  false;
					break;
				}
			}
			
		} else { 
			//$exportable =  false; 
		}
		
		
		
		if 		 (empty($t['laredoute_lst_attrib_f_noContrained']) 
				&& (empty($t['laredoute_lst_attrib_f_Contrained'])) 
				&& (empty($t['laredoute_lst_attrib_sf_noContrained']))
				&& (empty($t['laredoute_lst_attrib_sf_Contrained']))
				) { 
					printr("ATTENTION le SKU ". $p['products_id'] . "  n a aucun attribut  renseigne, mettez au moins 1 attribut sinon laredoute cree une erreur XSD et le produit n est pas traite (non envoye dans FLUX)");				
					$exportable =  false; 
					
					}
		
		if (empty($t)&&(!$variant)) $exportable =  false;
		//printr($t);
/*		
		foreach ($attLst as $v){
			//printr($attLst);
			//printr($t_sf);
			if ( !array_key_exists($v, $t_sf) ) $exportable =  false;
			if (empty($t_sf[$v])) $exportable =  false;
			
		}
		
		foreach ($attLstFamille as $v){
			//printr($attLstFamille);
		//	printr($t_f);
			if ( !array_key_exists($v, $t_f) ) $exportable =  false;
			if (empty($t_f[$v])) $exportable =  false;	
		}
*/		
		if (!$exportable) { 
			//printr("non exportable");
			//printr($p);	
			//printr($t);
			//echo "<hr>";
		}
		//echo "<hr>";
	return $exportable;
	}
	/*************************************************************************************/	
	private function attributsIdSousFammille($c){  // on recupere les attributs pour vrifier l exportation
		$t = array();
		$q= tep_db_query("	SELECT 		attribut_id 
							FROM 		laredoute_attribut 
							WHERE 		famille_ou_sous_famille_id LIKE '" . $c. "'
							AND			IsDeclinable = 0
							AND			IsMandatory = 1
							
						");
		while ($r = tep_db_fetch_array($q)){
				$t[] = $r['attribut_id'];
			
		}
		
	return $t;
	}
	/*************************************************************************************/	
	private function attributsIdFammille($c){  // on recupere les attributs pour vrifier l exportation
		$t = array();
		$q= tep_db_query("	SELECT 		attribut_id 
							FROM 		laredoute_attribut 
							WHERE 		famille_ou_sous_famille_id LIKE '" . $c. "'
							AND			IsDeclinable = 0
							AND			IsMandatory = 1
							
						");
		while ($r = tep_db_fetch_array($q)){
				$t[] = $r['attribut_id'];
			
		}		
	return $t;
	}	
	/*************************************************************************************/	
	private function BrandId($prod){
		$r = array();
		$q= tep_db_query("	SELECT 		id_marque_redoute
							FROM 		fournisseurs
							WHERE 		fournisseurs_id = '" . $prod['fournisseurs_id']. "'
							
						");
		$r = tep_db_fetch_array($q);
		if (empty($r['id_marque_redoute']))  $r['id_marque_redoute'] = 'B004669';  // DIVERS
	return $r['id_marque_redoute'];
	}	
	/*************************************************************************************/	
	private function BrandIdManufacture($prod){
		$r = array();
		$q= tep_db_query("	SELECT 		id_marque_redoute
							FROM 		manufacturers
							WHERE 		manufacturers_id = '" . $prod['manufacturers_id']. "'
							
						");
		$r = tep_db_fetch_array($q);
		if (empty($r['id_marque_redoute']))  $r['id_marque_redoute'] = 'B004669';  // DIVERS
	return $r['id_marque_redoute'];
	return 'a traiter';
	}		
	/*************************************************************************************/	
	private function SubFamily($v){
		if (empty($v)) return;
		$t = explode('-',$v);
	return $t[1];
	}	
	/*************************************************************************************/		
	private function Family($v){
		if (empty($v)) return;
		$t = explode('-',$v);
	return $t[0];
	}	
	/*************************************************************************************/	
	private function attributsName($id){  // on recupere les attributs pour vrifier l exportation
		$q= tep_db_query("	SELECT 		attribut_name	 
							FROM 		laredoute_attribut
							WHERE 		attribut_id LIKE '" . $id. "'
							
						");
		$r = tep_db_fetch_array($q);
		
	return $r['attribut_name'];
	}	
	/*************************************************************************************/
	private function attributsValueName($id){  // on recupere les attributs pour vrifier l exportation
		$q= tep_db_query("	SELECT 		attribut_value_name	 
							FROM 		laredoute_attribut_value
							WHERE 		attribut_value_id LIKE '" . $id. "'
							
						");
		$r = tep_db_fetch_array($q);
		
	return $r['attribut_value_name'];
	}	
	/*************************************************************************************/
	private function infoRedouteVariant($tabVariant,$fsf){

		$q= tep_db_query("	SELECT 		lav.attribut_value_id ,
										lav.attribut_id,
										la.attribut_name
							FROM 		laredoute_attribut_value lav,
										laredoute_attribut la
							WHERE 		lav.attribut_value_name LIKE '" . $tabVariant['taille'] . "'
							AND			lav.attribut_id = la.attribut_id
							AND			la.famille_ou_sous_famille_id LIKE '".$fsf."'
							
						");
		$r = tep_db_fetch_array($q);
		
	return $r;
	}	
	/*************************************************************************************/
	private function infoRedouteVariantID($tabVariant,$fsf){

		$q= tep_db_query("	SELECT 		lav.attribut_value_id ,
										lav.attribut_id,
										la.attribut_name
							FROM 		laredoute_attribut_value lav,
										laredoute_attribut la
							WHERE 		lav.attribut_value_id LIKE '" . $tabVariant['taille_id_redoute'] . "'
							AND			lav.attribut_id = la.attribut_id
							AND			la.famille_ou_sous_famille_id LIKE '".$fsf."'
							
						");
		$r = tep_db_fetch_array($q);
		
	return $r;
	}
	/*************************************************************************************/
	private function infoRedouteVariantcouleur($tabVariant,$attribut_id){

		$q= tep_db_query("	SELECT 		lav.attribut_value_id ,
										lav.attribut_id
							FROM 		laredoute_attribut_value lav
							WHERE 		lav.attribut_value_name LIKE '" . $tabVariant['couleur'] . "'
							
						");
		$r = tep_db_fetch_array($q);
		
	return $r;
	}		
	/*************************************************************************************/		
	private function usetProduct(){
		$tabExtImg = array('AAC', 'gif', 'H-264', 'jpg', 'MP3', 'MPEG-4', 'ogg', 'pdf', 'png', 'xml', 'XviD');
		$charOutUrl = array('&',' ');
		foreach ($this->t as $k => $v){
			foreach ($v['media'] as $m){
				if (!in_array($m['typeFile'],$tabExtImg)){
					echo "<br> produit ref " . $v['ProductID'] . "  format image non admis par Laredoute";
					unset($this->t[$k]);
					continue;
				}	
				if ($this->strpos_array($m['URL'],$charOutUrl)){
					echo "<br> produit ref " . $v['ProductID'] . "  image avec caractere interdit ";
					unset($this->t[$k]);
					continue;
				}					
				
			}
		}
		
	}
	/*************************************************************************************/
	private function strpos_array($haystack, $needles) {
		
		if ( is_array($needles) ) {
			foreach ($needles as $str) {
				if ( is_array($str) ) {
					$pos = strpos_array($haystack, $str);
				} else {
					$pos = strpos($haystack, $str);
				}
				if ($pos !== FALSE) {
					return TRUE ;
				}
			}
		} else {
			return strpos($haystack, $needles);
		}
	}
	/*************************************************************************************/
	private function extra_titre_name($p){
		
		$titre = $p['products_name'];
		$codeCaracteristique = 6 ; //  code redoute titre
		
		$query = tep_db_query("SELECT products_extra_fields_value  FROM " . TABLE_PRODUCTS_TO_PRODUCTS_EXTRA_FIELDS . " WHERE products_id = '" . $p['products_id'] ."' AND products_extra_fields_id = '".$codeCaracteristique."'");
		$res = tep_db_fetch_array($query);
		
		if (!empty($res['products_extra_fields_value'])) {
			
			$titre = $res['products_extra_fields_value'];
			

		} 
	
	RETURN $titre;
	}
	
	/*************************************************************************************/	
}	
?>