<?php

/**
 * Cette classe s'occupe de la communication avec les serveurs de la Redoute en V1.2 du service web Orders.
 * 
 * Il faut l'instantier avec un array d'options d'authentification, l'URL à 
 * attaquer et un chemin vers le fichier à publier.
 * 
 * L'array d'authentication doit contient:
 * 
 *  - login
 *  - password
 *  - apikey
 * 
 */
 
class RedouteVendorOrderClient_v1_2
{
	
    private $location;
    private $apiKey;
    private $login;
    private $password;
    
    private $flowId;
    private $flowName;
    private $faultCode;
    private $faultMessage;
    private $hasError;

    public function __construct(array $aOptions=array(), $location=null)
    {
        $this->login = $aOptions['login'];
		$this->password = $aOptions['password'];
		$this->apiKey = $aOptions['apikey'];
        
        $this->location = $location;
    }

    /**
     * Ce fonctionne déclenche l'appel vers les serveurs de la Redoute
     */
    public function getOrderById($orderId)
    {
		error_log($orderId);
		error_log("Building soap client");
		$client     = new SoapClient(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'vendor-wsdl.wsdl',
				array("trace" => 1,
				      "exception" => 1,
					  "login"=>$this->login,
					  "password"=>$this->password,
					  "location"=>$this->location));
		
		
		error_log("Calling soap client");
		try {
			$result = $client->RetrieveByIDRequest(array("apikey"=>$this->apiKey, "OrderID"=>$orderId));
			return $result;
		} catch (SoapFault $fault) {
			$this->hasError=true;
			$this->faultCode = $fault->faultstring;
			$this->faultMessage = $fault->detail->InjectFault->message;
		}
		return null;

    }
    
    public function getOrdersByPeriod($minDate, $maxDate)
    {
		error_log("Building soap client");
		$client = new SoapClient(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'vendor-wsdl.wsdl',
				array("trace" => 1,
				      "exception" => 1,
					  "login"=>$this->login,
					  "password"=>$this->password,
					  "location"=>$this->location));
		
		$period = new stdClass;
		$period->minDate = $minDate->format('c');
		$period->maxDate = $maxDate->format('c');
		
		error_log("Calling soap client");
		try {
			
			$result = $client->RetrieveByPeriodRequest(array("apikey"=>$this->apiKey, "Period"=>$period));
			return $result;
		} catch (SoapFault $fault) {
			$this->hasError=true;
			$this->faultCode = $fault->faultstring;
			$this->faultMessage = $fault->detail->InjectFault->message;
		}
		return null;

    }
	
    public function getOrdersByPeriod2($minDate, $maxDate)
    {
		error_log("Building soap client");
		$client = new SoapClient(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'vendororders1-3.wsdl',
				array("trace" => 1,
				      "exception" => 1,
					  "login"=>$this->login,
					  "password"=>$this->password,
					  "location"=>$this->location));
		
		$period = new stdClass;
		//$period->minDate = '2016-09-09T18:50:24+02:00';
		//$period->maxDate = '2016-09-20T18:50:24+02:00';
		$period->minDate = $minDate;
		$period->maxDate = $maxDate;
		
		error_log("Calling soap client");
		try {
			
			$result = $client->RetrieveByPeriodRequest(array("apikey"=>$this->apiKey, "Period"=>$period));
			return $result;
		} catch (SoapFault $fault) {
			$this->hasError=true;
			$this->faultCode = $fault->faultstring;
			$this->faultMessage = $fault->detail->InjectFault->message;
		}
		return null;

    }	
    
        public function getOrdersByStatus($minDate, $maxDate, $arrayStates)
    {
		error_log("Building soap client");
		$client = new SoapClient(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'vendororders1-3.wsdl',
				array("trace" => 1,
				      "exception" => 1,
					  "login"=>$this->login,
					  "password"=>$this->password,
					  "location"=>$this->location));
		
		$functions = $client->__getFunctions();
		//var_dump($functions[3]);
		//var_dump(gettype($functions["RetrieveByPeriodRequest"]));
		
		/*
		 * 
		 *          <Statuses>
            <!--Zero or more repetitions:-->
            <Status>?</Status>
            <!--Optional:-->
            <Period>
               <!--Optional:-->
               <minDate>?</minDate>
               <!--Optional:-->
               <maxDate>?</maxDate>
            </Period>
         </Statuses>


		 */
		
	//	$period = array(
	//	"minDate" => $minDate->format('c'),
	//	"maxDate" => $maxDate->format('c')
	//	);
		$period->minDate = $minDate;
		$period->maxDate = $maxDate;	
		
		/* $period = new stdClass;
		$period->minDate = $minDate->format('c');
		$period->maxDate = $maxDate->format('c');*/
		
		$statuses = array(
		"Status"=> $arrayStates,
		"Period"=> $period
		);
		
		//var_dump($statuses);
		
		error_log("Calling soap client");
		try {
			
			$requestArray = array("apikey"=>$this->apiKey, "Statuses"=>$statuses);
			
			$result = $client->RetrieveByStatusRequest($requestArray);
			return $result;
		} catch (SoapFault $fault) {
			$this->hasError=true;
			$this->faultCode = $fault->faultstring;
			$this->faultMessage = $fault->detail->InjectFault->message;
		}
		return null;

    }

    public function updateOrders($accepts,     //array of line ids
								 $refuses,     //array of line ids
								 $outofstocks, //array of line ids
								 $ships,	   //array of arrays
								 $refunds      //array of arrays
								 ) {
									 
			$requestAccepts = array();
			foreach ($accepts as $lineId) {
				$requestAccepts[]=new SoapVar("<accept OrderLineID='$lineId'/>", XSD_ANYXML);
			}

			$requestRefuses = array();
			foreach ($refuses as $lineId) {
				$requestRefuses[]=new SoapVar("<refuse OrderLineID='$lineId'/>", XSD_ANYXML);
			}

			$requestOutOfStocks = array();
			foreach ($outofstocks as $lineId) {
				$requestOutOfStocks[]=new SoapVar("<outOfStock OrderLineID='$lineId'/>", XSD_ANYXML);
			}
									 
			$requestShips = array();
			foreach ($ships as $shipArray) {
				$orderLineId = $shipArray["OrderLineID"];
				$shipDate=$shipArray["ShipDate"];
				$carrierContactInformation=$shipArray["CarrierContactInformation"];
				$trackingNumber=$shipArray["TrackingNumber"];
				$trackingURL=$shipArray["TrackingURL"];
				
				$ship = "<ship OrderLineID='$orderLineId'>";
				if(!empty($shipDate)) {
					//$formattedDate = $shipDate->format('c');
					$formattedDate = $shipDate;					
					$ship = $ship . "<shipDate>$formattedDate</shipDate>";
				}
				if(!empty($carrierContactInformation)) {
					$ship = $ship . "<CarrierContactInformation>$carrierContactInformation</CarrierContactInformation>";
				}
				if(!empty($trackingNumber)) {
					$ship = $ship . "<TrackingNumber>$trackingNumber</TrackingNumber>";
				}
				if(!empty($trackingURL)) {
					$ship = $ship . "<TrackingURL>$trackingURL</TrackingURL>";
				}
				
				$ship = $ship . "</ship>";
				$requestShips[]=new SoapVar($ship, XSD_ANYXML);
			}
			
			$requestRefunds = array();
			foreach ($refunds as $refundArray) {
				$orderLineId = $refundArray["OrderLineID"];
				$refundAmount = $refundArray["RefundAmount"];
				$refundType = $refundArray["RefundType"];
				$refund = "<refund OrderLineID='$orderLineId'>";
				if (!empty($refundAmount)) {
					$refund = $refund . "<refundAmount>$refundAmount</refundAmount>";
				}
				if (!empty($refundType)) {
					$refund = $refund . "<refundType>$refundType</refundType>";
				}
				$refund = $refund . "</refund>";
				$requestRefunds[] = $refund;
			}
			
			$client = new SoapClient(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'vendororders1-3.wsdl',
			array("trace" => 1,
				  "exception" => 1,
				  "login"=>$this->login,
				  "password"=>$this->password,
				  "location"=>$this->location));
			$requestArray = array("apikey"=>$this->apiKey,
							      "accept"=>$requestAccepts,
							      "refuse"=>$requestRefuses,
							      "ship"=>$requestShips,
							      "outOfStock"=>$requestOutOfStocks,
							      "refunds"=>$requestRefunds);
								  
			//printr($requestArray);
			try {
				$client->UpdateRequest($requestArray);
			} catch (SoapFault $fault) {
				$this->hasError=true;
				$this->faultCode = $fault->faultstring;
				$this->faultMessage = $fault->detail->InjectFault->message;
			}
	}    
	
	public function hasError() {
		return $this->hasError;
	}
	
	public function faultCode() {
		return $this->faultCode;
	}
	
	public function faultMessage() {
		return $this->faultMessage;
	}
	
}
?>
