<?php

/**
 * Cette classe s'occupe de la communication avec les serveurs de la Redoute en V1.1 du service web Seller Items.
 * 
 * Il faut l'instantier avec un array d'options d'authentification, l'URL à 
 * attaquer et un chemin vers le fichier à publier.
 * 
 * L'array d'authentication doit contient:
 * 
 *  - login
 *  - password
 *  - apikey
 * 
 */
 
class RedouteVendorPublicationClient_v1_1
{
	const MIME_TYPE = "application/xml";
	const REQUEST_BODY = '<?xml version="1.0" encoding="UTF-8"?><SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"><SOAP-ENV:Body><attachment/></SOAP-ENV:Body></SOAP-ENV:Envelope>';
	const REQUEST_BEGIN = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns="http://RedouteFrance/seller/items/1.1"><soapenv:Header/><soapenv:Body><ns:injectItems><api-key>';
	const REQUEST_END = '</api-key></ns:injectItems></soapenv:Body></soapenv:Envelope>';
	
    private $location;
    private $apiKey;
    private $fileName;
    private $login;
    private $password;
    
    private $flowId;
    private $flowName;
    private $faultCode;
    private $faultMessage;
    private $hasError;

    public function __construct(array $aOptions=array(), $location=null, $fileName)
    {
        $this->login = $aOptions['login'];
		$this->password = $aOptions['password'];
		$this->apiKey = $aOptions['apikey'];
        
        $this->location = $location;
        $this->fileName = $fileName;

    }

    /**
     * Ce fonctionne déclenche l'appel vers les serveurs de la Redoute
     */
    public function sendFlow()
    {
		//création de la requête de base
		$request = implode('', explode(PHP_EOL, self::REQUEST_BODY));
		$request = trim(self::createAttachment($request));

		//extraction du boundary pour le mettre dans les headers
		preg_match('/BOUNDARY=".*"/', $request, $aMatches);
		$boundary = 'boundary=' . substr($aMatches[0], strlen('BOUNDARY='));

		//le login/password sont encodés en basic auth
		$basicAuth = base64_encode($this->login . ":" . $this->password);

		//création des headers pour l'appel
		$requestHeaders = array(
			'Method: POST',
			'Connection: keep-alive',
			'Content-Type: Multipart/Related; type="TEXT/XML"; start="<main_envelope>"; ' . $boundary,
			'SOAPAction: "http://RedouteFrance/seller/items/1.1"',
			'Authorization: Basic ' . $basicAuth,
			'expect:', //cette ligne est correcte et indespensable
			'mime-version: 1.0'
		);

		//creation d'une instance curl
		$curlHelper = curl_init($this->location);
		curl_setopt_array(
			$curlHelper,
			array(
				CURLOPT_VERBOSE        => false,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_POST           => true,
				CURLOPT_POSTFIELDS     => $request,
				CURLOPT_HEADER         => false,
				CURLOPT_HTTPHEADER     => $requestHeaders,
				CURLOPT_SSL_VERIFYPEER => false
			)
		);

		//execution de la requête vers le serveur
		$curlResponse = curl_exec($curlHelper);
		curl_close($curlHelper);

		//parsing de la réponse
		$xmlResponse = simplexml_load_string($curlResponse);
		
		//afin de pouvoir effectuer des reqûetes XPATH sur la réponse, les namespaces
		//doivent être identifiés
		foreach($xmlResponse->getNamespaces(true) as $strPrefix => $strNamespace) {
			if(strlen($strPrefix)==0) {
				$strPrefix="a";
			}
			$xmlResponse->registerXPathNamespace($strPrefix,$strNamespace);
		}
        
        //extraction des données
        if (strpos($curlResponse, 'faultstring')) {
			$this->hasError = true;
			$faultStringArray = $xmlResponse->xpath("/S:Envelope/S:Body/S:Fault/faultstring/text()");
			$faultMessageArray = $xmlResponse->xpath("/S:Envelope/S:Body/S:Fault/detail/ns2:InjectFault/message/text()");
			$this->faultCode = $faultStringArray[0][0];
			$this->faultMessage = $faultMessageArray[0][0];
		} else {
			$this->hasError = false;
			$flowIdArray = $xmlResponse->xpath("/soap:Envelope/soap:Body/ns2:injectItemsResponse/flowId/text()");
			$flowNameArray = $xmlResponse->xpath("/soap:Envelope/soap:Body/ns2:injectItemsResponse/flowName/text()");
			$this->flowId = $flowIdArray[0][0];
			$this->flowName = $flowNameArray[0][0];
		}

    }

    private function createAttachment($sXml)
    {
		//le flux à envoyer est ouvert et lu
        $fp       = fopen($this->fileName, 'r');
        $contents = fread($fp, filesize($this->fileName));
        fclose($fp);

        $mime_parts = explode('/', self::MIME_TYPE);

        $part1['type']     = TYPEMULTIPART;
        $part1['subtype']  = 'Related';
     
        //encodage du flux
        $part2['type']             = TYPEAPPLICATION;
        $part2['subtype']          = strtoupper($mime_parts[1]);
        $part2['encoding']         = ENCBASE64;
        $part2['id']               = '<' . basename($this->fileName) . '>';
        $part2["contents.data"]    = base64_encode($contents);

        // création de la requête WS
        $xmlPart['type']             = 'TEXT';
        $xmlPart['subtype']          = 'XML';
        $xmlPart['id']               = '<main_envelope>';
        $contentsData =  self::REQUEST_BEGIN . $this->apiKey . self::REQUEST_END;        
        $xmlPart['contents.data']    = $contentsData;
        
        $body[2] = $part1;
        $body[1] = $xmlPart;
        $body[3] = $part2;

        $envelope = array();
        //composition de la requête
        return imap_mail_compose($envelope, $body);
    }
    
    public function flowId() {
		return $this->flowId;
	}
	
	public function flowName() {
		return $this->flowName;
	}
	
	public function hasError() {
		return $this->hasError;
	}
	
	public function faultCode() {
		return $this->faultCode;
	}
	
	public function faultMessage() {
		return $this->faultMessage;
	}
	
}
?>
