<?php
function toUTF8($param)
{
    if(is_array($param)) {
        array_walk_recursive($param, create_function('&$item, $index', '$item = toUTF8($item);'));
        return $param;
    }
 
    mb_detect_order('UTF-8, ISO-8859-15, ISO-8859-1, Windows-1252');
    //parfois si le dernier caractre de la chaine est accentu, la conversion peut foirer,
    //donc on force avec un caractre qui ne l'est pas.
    //(astuce trouve sur les commentaires de la doc sur php.net)
    $param .= '_';
    $currentCharset = mb_detect_encoding($param);
 
    if ($currentCharset != 'UTF-8') {
        $param = mb_convert_encoding($param, 'UTF-8', $currentCharset);
    }
 
    return substr($param, 0, strlen($param)-1);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
function outputCsv($fileName, $assocDataArray,$rep = 'export')
{

	$fp = fopen($rep .'/'.$fileName, 'w+');
	fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF)); // mettre utf8 au debut du fichier
	fputcsv($fp, array_keys(current($assocDataArray)),';');
	foreach ($assocDataArray as $fields_c) {
	    fputcsv($fp, $fields_c,';');
	}
	
	fclose($fp);

}
//////////////////////////////////////////////////////////////////////////////////////////////////////
function outputRdy($fileName ,$rep = 'export')
{
	$fp = fopen($rep .'/'.$fileName, 'w+');
	fprintf($fp, ''); // fichier vide
	fclose($fp);

}
/*************************************************************************************/
function netoyage_html($CatList, $length) 
{
  $CatList = html_entity_decode ($CatList);
//	$CatList=utf8_encode($CatList);
  // $CatList = strtolower ($CatList);
  $CatList = str_replace("&nbsp;"," ",$CatList);
  $CatList = str_replace("&#39;","'",$CatList);
  $CatList = str_replace("&#150;","-",$CatList);
//  $CatList = str_replace("","e",$CatList);
//  $CatList = str_replace("","e",$CatList);
//  $CatList = str_replace("","e",$CatList);
  $CatList = str_replace("&rsquo;","'",$CatList);
  $CatList = str_replace("&eacute;","",$CatList);
  $CatList = str_replace("&agrave;","",$CatList);
  $CatList = str_replace("&egrave;","",$CatList);
  $CatList = str_replace("&eacute;","",$CatList);
  $CatList = str_replace("&ocirc;","",$CatList);
  $CatList = str_replace("&icirc;","",$CatList);
  $CatList = str_replace("&acirc;","",$CatList);
  $CatList = str_replace("&ccedil;","",$CatList);

  $CatList = str_replace("&ecirc;","e",$CatList);
//  $CatList = str_replace(";"," ",$CatList);

  $CatList = str_replace("","i",$CatList);
  $CatList = str_replace(""," graden",$CatList);
  $CatList = str_replace("","'",$CatList);
  $CatList = str_replace("","'",$CatList);
//  $CatList = str_replace(chr(9)," ",$CatList); 
//  $CatList = str_replace(chr(10)," ",$CatList);
//  $CatList = str_replace(chr(13)," ",$CatList);
//  $CatList = str_replace("<br />"," ",$CatList);
//  $CatList = preg_replace("[<(.*?)>]","",$CatList);

  //$CatList = html_entity_decode ($CatList);
  //$CatList = strip_tags ($CatList);
  $CatList = trim ($CatList);

  if (strlen($CatList) > $length) {
	$CatList = substr($CatList, 0, $length-3) . "...";
  }
  return $CatList;  
}
/*************************************************************************************/
// fonction de nettoyage des donnes si prsence d'un diteur html
function netoyage_html_utf8($CatList, $length) 
{
	$CatList=html_entity_decode($CatList);
//	$CatList=utf8_encode($CatList);
  $CatList = str_replace("&rsquo;","'",$CatList);
  $CatList = str_replace("&eacute;","",$CatList);
  $CatList = str_replace("&agrave;","",$CatList);
  $CatList = str_replace("&egrave;","",$CatList);
  $CatList = str_replace("&eacute;","",$CatList);
  $CatList = str_replace("&ocirc;","",$CatList);
  $CatList = str_replace("&icirc;","",$CatList);
  $CatList = str_replace("&acirc;","",$CatList);
  $CatList = str_replace("&ccedil;","",$CatList);
  $CatList = str_replace("&#39;","'",$CatList);
  $CatList = str_replace("&#39","'",$CatList);
  $CatList = str_replace(";"," ",$CatList);

	$CatList = str_replace('<span style="font-size: 9pt  font-family: Arial  color: black"></span>'," ",$CatList);
	$CatList = str_replace('<span class="Apple-tab-span" style="white-space: pre">	</span>'," ",$CatList);

//  $CatList = str_replace(chr(9)," ",$CatList); 
//  $CatList = str_replace(chr(10)," ",$CatList);
 // $CatList = str_replace(chr(13)," ",$CatList);
 // $CatList = str_replace("</div>"," ",$CatList);  
 // $CatList = str_replace("</DIV>"," ",$CatList);    
//  $CatList = str_replace("<br />"," ",$CatList);
//  $CatList = str_replace("<br/>"," ",$CatList);
 // $CatList = str_replace("<br>"," ",$CatList);

  //$CatList = html_entity_decode ($CatList);
 // $CatList = strip_tags ($CatList); // supprime le HTML
  $CatList = trim ($CatList);
  if (strlen($CatList) > $length) {
	$CatList = substr($CatList, 0, $length-3) . "...";
  }
  return $CatList;  
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
function outputOffresXml($fileName, $assocDataArray,$rep = 'export',$date)
{

	$xml = new DOMDocument('1.0', 'utf-8');
	$xml->formatOutput = true;
	
	$SellerOfferRequestE = $xml->createElement('SellerOfferRequest');
	$SellerOfferRequestE = $xml->appendChild($SellerOfferRequestE);	
	
	$SellerOfferRequestA = $xml->createAttribute('xmlns');
	$SellerOfferRequestA->value = 'http://RedCats/MarketPlace/Partnership/2.0';
	$SellerOfferRequestE ->appendChild($SellerOfferRequestA);	

	$SellerOfferRequestA = $xml->createAttribute('xmlns:xsi');
	$SellerOfferRequestA->value = 'http://www.w3.org/2001/XMLSchema-instance';
	$SellerOfferRequestE ->appendChild($SellerOfferRequestA);
	
	$SellerOfferRequestA = $xml->createAttribute('xmlns:xsd');
	$SellerOfferRequestA->value = 'http://www.w3.org/2001/XMLSchema';
	$SellerOfferRequestE ->appendChild($SellerOfferRequestA);
	
	$HubIDA = $xml->createAttribute('HubID');
	$HubIDA->value = '400';
	$SellerOfferRequestE ->appendChild($HubIDA);	
	
	$SellerIDA = $xml->createAttribute('SellerID');
	$SellerIDA->value = _VENDOR_ID_REDOUTE_;
	$SellerOfferRequestE ->appendChild($SellerIDA);	
	
	$MessageDateA = $xml->createAttribute('MessageDate');
	$MessageDateA->value = $date;
	$SellerOfferRequestE ->appendChild($MessageDateA);	

	$MessageReleaseA = $xml->createAttribute('MessageRelease');
	$MessageReleaseA->value = '1.0';
	$SellerOfferRequestE ->appendChild($MessageReleaseA);		
	
	foreach ($assocDataArray as $v) {
		
		$itemE = $xml->createElement('Item');
		$SellerOfferRequestE ->appendChild($itemE);	
		
			$itemItemIdentificationE = $xml->createElement('ItemIdentification');
			$itemE ->appendChild($itemItemIdentificationE);	

			$ItemStandardIDE = $xml->createElement('ItemStandardID', $v['EAN']);
			$ItemStandardIDE->appendChild($xml->createAttribute( 'Qualifier')); 		
			$ItemStandardIDE->setAttribute('Qualifier', 'EN');			
			$itemItemIdentificationE ->appendChild($ItemStandardIDE);	

		$ItemConditionsE = $xml->createElement('ItemConditions');
		$itemE ->appendChild($ItemConditionsE);		

			$ItemConditionE = $xml->createElement('ItemCondition');
			$ItemConditionE->appendChild($xml->createAttribute( 'Condition')); 		
			$ItemConditionE->setAttribute('Condition', $v['Condition']);				
			$ItemConditionsE ->appendChild($ItemConditionE);

				$AvailabilityE = $xml->createElement('Availability');
				$ItemConditionE ->appendChild($AvailabilityE);	
				
					$StockQuantityE = $xml->createElement('StockQuantity', $v['Quantity'] );
			//		$StockQuantityE->appendChild($xml->createAttribute( 'QuantityQualifie')); 		
			//		$StockQuantityE->setAttribute('QuantityQualifie', '1');					
					$AvailabilityE ->appendChild($StockQuantityE);	

				$SellerOffersE = $xml->createElement('SellerOffers');
				$ItemConditionE ->appendChild($SellerOffersE);			

					$SellerOfferE = $xml->createElement('SellerOffer' );
					$SellerOfferE->appendChild($xml->createAttribute( 'Site')); 		
					$SellerOfferE->setAttribute('Site', 'www.laredoute.fr');	
					$SellerOfferE->appendChild($xml->createAttribute( 'CountryCode')); 		
					$SellerOfferE->setAttribute('CountryCode', 'FR');						
					$SellerOffersE ->appendChild($SellerOfferE);

						$SellerOfferPricesE = $xml->createElement('SellerOfferPrices');
						$SellerOfferE ->appendChild($SellerOfferPricesE);	

							$SellerOfferPriceE = $xml->createElement('SellerOfferPrice');
							$SellerOfferPriceE->appendChild($xml->createAttribute( 'OfferNature')); 		
							$SellerOfferPriceE->setAttribute('OfferNature', 'Standard');
							$SellerOfferPriceE->appendChild($xml->createAttribute( 'SellerOfferID')); 		
							$SellerOfferPriceE->setAttribute('SellerOfferID', $v['SKU']);
							$SellerOfferPriceE->appendChild($xml->createAttribute( 'CustomerTarget')); 		
							$SellerOfferPriceE->setAttribute('CustomerTarget', 'All');					
							$SellerOfferPricesE  ->appendChild($SellerOfferPriceE);	

								$OfferPeriodE = $xml->createElement('OfferPeriod');
								$SellerOfferPriceE ->appendChild($OfferPeriodE);

									$StartDateE = $xml->createElement('StartDate', $v['SalePriceStartDate']);
									$OfferPeriodE ->appendChild($StartDateE);
									
									$EndDateE = $xml->createElement('EndDate', $v['SalePriceEndDate']);
									$OfferPeriodE ->appendChild($EndDateE);

								$SellingPriceE = $xml->createElement('SellingPrice');
								$SellingPriceE->appendChild($xml->createAttribute( 'CurrencyCode')); 		
								$SellingPriceE->setAttribute('CurrencyCode', strtoupper($v['Currency']));
								$SellingPriceE->appendChild($xml->createAttribute( 'PriceType')); 		
								$SellingPriceE->setAttribute('PriceType', 'SellingPrice');								
								$SellerOfferPriceE ->appendChild($SellingPriceE);	

									$AmountE = $xml->createElement('Amount', $v['SalePrice']);
									$SellingPriceE ->appendChild($AmountE);
									
									$VATRateE = $xml->createElement('VATRate', $v['TaxClass']);
									$SellingPriceE ->appendChild($VATRateE);
									// DEEE
									if ($v['DEEE'] > 0 ) {
										$WEEEFee = $xml->createElement('WEEEFee', $v['DEEE']); 
										$SellingPriceE ->appendChild($WEEEFee);								
									}									

						$DeliveriesE = $xml->createElement('Deliveries');
						$SellerOfferE ->appendChild($DeliveriesE);	

							$DeliveryE = $xml->createElement('Delivery');
							$DeliveryE->appendChild($xml->createAttribute( 'DeliveryType')); 		
							$DeliveryE->setAttribute('DeliveryType', $v['ShippingOptionName']);
							$DeliveryE->appendChild($xml->createAttribute( 'DeliveryMode')); 		
							$DeliveryE->setAttribute('DeliveryMode', 'Home');					
							$DeliveriesE  ->appendChild($DeliveryE);
							
								$DeliveryFeeE = $xml->createElement('DeliveryFee', $v['Fee']);
								$DeliveryFeeE->appendChild($xml->createAttribute( 'CurrencyCode')); 		
								$DeliveryFeeE->setAttribute('CurrencyCode', strtoupper($v['Currency']));							
								$DeliveryE ->appendChild($DeliveryFeeE);

								$ShipmentDelayE = $xml->createElement('ShipmentDelay', $v['FulfillmentLatency']);							
								$DeliveryE ->appendChild($ShipmentDelayE);		

								$DeliveryDaysRangeE = $xml->createElement('DeliveryDaysRange');							
								$DeliveryE ->appendChild($DeliveryDaysRangeE);		

									$MinE = $xml->createElement('Min',$v['MinDelivryDays']);							
									$DeliveryDaysRangeE ->appendChild($MinE);	

									$MaxE = $xml->createElement('Max',$v['MaxDelivryDays']);							
									$DeliveryDaysRangeE ->appendChild($MaxE);
									
						$DescriptionsE = $xml->createElement('Descriptions');
						$SellerOfferE ->appendChild($DescriptionsE);	

							$DescriptionE = $xml->createElement('Description');
							$DescriptionE->appendChild($xml->createAttribute( 'LanguageCode')); 		
							$DescriptionE->setAttribute('LanguageCode', 'fr');					
							$DescriptionsE  ->appendChild($DescriptionE);						
								

	}
	
	$strXml = $xml->saveXML();
//	file_put_contents($rep .'/'.$fileName, $strXml);
	file_put_contents($fileName, $strXml);	
	
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
function outputProductsXml($fileName, $assocDataArray,$rep = 'export')
{

//	fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF)); // mettre utf8 au debut du fichier
//	fputcsv($fp, array_keys(current($assocDataArray)),';');
	$xml = new DOMDocument('1.0', 'utf-8');
	$xml->formatOutput = true;
	$VendorItemsElement = $xml->createElement('VendorItems');
	$VendorItemsElement = $xml->appendChild($VendorItemsElement);

	$VendorItemsAttribute = $xml->createAttribute('xmlns:xsi');
	$VendorItemsAttribute->value = 'http://www.w3.org/2001/XMLSchema-instance';
	$VendorItemsElement ->appendChild($VendorItemsAttribute);	



	$VendorItemsAttribute = $xml->createAttribute('xmlns');
	$VendorItemsAttribute->value = 'http://RedouteFrance/CAT-EXT-INTG/Product/VendorItems/1.0';
	$VendorItemsElement ->appendChild($VendorItemsAttribute);	
			
	
	$VendorItemsAttribute = $xml->createAttribute('xsi:schemaLocation');
	$VendorItemsAttribute->value = 'http://RedouteFrance/CAT-EXT-INTG/Product/VendorItems/1.0 VendorItems_1.0.xsd';
	$VendorItemsElement ->appendChild($VendorItemsAttribute);



	
	foreach ($assocDataArray as $v) {
		
		$VendorItemElement = $xml->createElement('VendorItem');
		$VendorItemsElement ->appendChild($VendorItemElement);	

		$EanElement = $xml->createElement('EAN',$v['EAN']); 
		$VendorItemElement ->appendChild($EanElement);

		$ClassificationElement = $xml->createElement('Classification'); 
		$VendorItemElement ->appendChild($ClassificationElement);

			$ClassificationValueElement = $xml->createElement('ClassificationValue',$v['Subfamily']);	 
			$ClassificationElement ->appendChild($ClassificationValueElement);		
			
		$ProductElement = $xml->createElement('Product'); 
		$VendorItemElement ->appendChild($ProductElement);

			$ProductIdElement = $xml->createElement('ProductId',$v['ProductID']); 
			$ProductElement ->appendChild($ProductIdElement);	
		
			$ProductTitlesElement = $xml->createElement('ProductTitles'); 
			$ProductElement ->appendChild($ProductTitlesElement);		

				$ProductTitleElement = $xml->createElement('ProductTitle');
				$ProductTitleElement->appendChild($xml->createCDATASection( $v['Title'] )); 
				$ProductTitleElement->appendChild($xml->createAttribute( 'language')); 		
				$ProductTitleElement->setAttribute('language', $v['Locale']);
				$ProductTitlesElement->appendChild($ProductTitleElement);

			$ProductDescriptionsElement = $xml->createElement('ProductDescriptions');	 
			$ProductElement ->appendChild($ProductDescriptionsElement);		

				$ProductDescriptionElement = $xml->createElement('ProductDescription');
				$ProductDescriptionElement->appendChild($xml->createCDATASection( $v['Description'] )); 
				$ProductDescriptionElement->appendChild($xml->createAttribute( 'language')); 		
				$ProductDescriptionElement->setAttribute('language', $v['Locale']);				
				$ProductDescriptionsElement->appendChild($ProductDescriptionElement);	

			$ProductBrandElement = $xml->createElement('ProductBrand');	 
			$ProductElement ->appendChild($ProductBrandElement);	
			
				$BrandCodeElement = $xml->createElement('BrandCode',$v['BrandId'] );	 
				$ProductBrandElement ->appendChild($BrandCodeElement);	

			$MediasElement = $xml->createElement('Medias'); 
			$ProductElement ->appendChild($MediasElement);
				
				foreach ($v['media'] as $media){
					$MediaElement = $xml->createElement('Media'); 
					$MediasElement ->appendChild($MediaElement);
					$MediaTypeElement = $xml->createElement('MediaType',$media['Contenttype'] ); 
					$MediaElement ->appendChild($MediaTypeElement);	
					$MediaURLElement = $xml->createElement('MediaURL',$media['URL']); 					
			//		$MediaURLElement = $xml->createElement('MediaURL'); 
			//		$MediaURLElement ->appendChild($xml->createCDATASection( $media['URL'] ));  
			//		$MediaURLElement ->appendChild( $media['URL'] );  
					$MediaElement ->appendChild($MediaURLElement);
					$MediaEncodingElement = $xml->createElement('MediaEncoding',$media['typeFile'] ); 
					$MediaElement ->appendChild($MediaEncodingElement);				
					$ChecksumElement = $xml->createElement('Checksum',$media['CheckSum'] ); 
					$MediaElement ->appendChild($ChecksumElement);		
					$ChecksumTypeElement = $xml->createElement('ChecksumType',$media['CheckSumType'] ); 
					$MediaElement ->appendChild($ChecksumTypeElement);		
					$PublicationRankElement = $xml->createElement('PublicationRank',$media['Rank'] ); 
					$MediaElement ->appendChild($PublicationRankElement);		
					break;
				}
			

		
		// fin insert si variant
		$VendorElement = $xml->createElement('Vendor'); 
		$VendorItemElement ->appendChild($VendorElement);		

			$VendorIdElement = $xml->createElement('VendorId',$v['VendorId']); 
			$VendorElement ->appendChild($VendorIdElement);	

		$AttributesElement = $xml->createElement('Attributes'); 
		$VendorItemElement ->appendChild($AttributesElement);
		
		//printr($v['Attributes']);
		//printr($v['ProductID']);
		if (!empty($v['Attributes'])){
			foreach ($v['Attributes'] as $att){
				if (!empty($att['AttribCode'])){
					$AttributeElement = $xml->createElement('Attribute'); 
					$AttributesElement ->appendChild($AttributeElement);
					
					$AttributeCodeElement = $xml->createElement('AttributeCode',$att['AttribCode'] ); 
					$AttributeElement ->appendChild($AttributeCodeElement);	
					
					$AttributeValuesElement = $xml->createElement('AttributeValues'); 
					$AttributeElement ->appendChild($AttributeValuesElement);	

						$AttributeValueCodeElement = $xml->createElement('AttributeValueCode',$att['ValAttribCode'] ); 
						$AttributeValuesElement ->appendChild($AttributeValueCodeElement);	

						$AttributeValueLabelElement = $xml->createElement('AttributeValueLabel',$att['ValAttribDescription'] ); 
					//	$AttributeValueLabelElement = $xml->createElement('AttributeValueLabel' );  				
					//	$AttributeValueLabelElement ->appendChild($xml->createCDATASection($att['ValAttribDescription'])); 
					//	$AttributeValueLabelElement ->appendChild($att['ValAttribDescription']);  
						$AttributeValueLabelElement->appendChild($xml->createAttribute( 'language')); 	
						$AttributeValueLabelElement->setAttribute('language', $v['Locale']);					
						$AttributeValuesElement ->appendChild($AttributeValueLabelElement);							
				}
			}	
		} else { $AttributeElement = $xml->createElement('Attribute');  } // pas d attribut 

// insert si variant	
		if (array_key_exists('media_declinaison',$v)){
			$MediasElement = $xml->createElement('Medias'); 
			$VendorItemElement ->appendChild($MediasElement);			
			$MediaElement = $xml->createElement('Media'); 
			$MediasElement ->appendChild($MediaElement);
			$MediaTypeElement = $xml->createElement('MediaType',$v['media_declinaison']['Contenttype'] ); 
			$MediaElement ->appendChild($MediaTypeElement);	
			$MediaURLElement = $xml->createElement('MediaURL',$v['media_declinaison']['URL']); 					  
			$MediaElement ->appendChild($MediaURLElement);
			$MediaEncodingElement = $xml->createElement('MediaEncoding',$v['media_declinaison']['typeFile'] ); 
			$MediaElement ->appendChild($MediaEncodingElement);				
			$ChecksumElement = $xml->createElement('Checksum',$v['media_declinaison']['CheckSum'] ); 
			$MediaElement ->appendChild($ChecksumElement);		
			$ChecksumTypeElement = $xml->createElement('ChecksumType',$v['media_declinaison']['CheckSumType'] ); 
			$MediaElement ->appendChild($ChecksumTypeElement);		
			$PublicationRankElement = $xml->createElement('PublicationRank',$v['media_declinaison']['Rank'] ); 
			$MediaElement ->appendChild($PublicationRankElement);		
	
		}
		else { 
			$MediasElement = $xml->createElement('Medias'); 
			$VendorItemElement ->appendChild($MediasElement);	
			foreach ($v['media'] as $media){
				$MediaElement = $xml->createElement('Media'); 
				$MediasElement ->appendChild($MediaElement);
				$MediaTypeElement = $xml->createElement('MediaType',$media['Contenttype'] ); 
				$MediaElement ->appendChild($MediaTypeElement);	
				$MediaURLElement = $xml->createElement('MediaURL',$media['URL']); 					
				$MediaElement ->appendChild($MediaURLElement);
				$MediaEncodingElement = $xml->createElement('MediaEncoding',$media['typeFile'] ); 
				$MediaElement ->appendChild($MediaEncodingElement);				
				$ChecksumElement = $xml->createElement('Checksum',$media['CheckSum'] ); 
				$MediaElement ->appendChild($ChecksumElement);		
				$ChecksumTypeElement = $xml->createElement('ChecksumType',$media['CheckSumType'] ); 
				$MediaElement ->appendChild($ChecksumTypeElement);		
				$PublicationRankElement = $xml->createElement('PublicationRank',$media['Rank'] ); 
				$MediaElement ->appendChild($PublicationRankElement);					
				}		
		
		}
		
			
	}
	


	$strXml = $xml->saveXML();
	//file_put_contents($rep .'/'.$fileName, $strXml);
	file_put_contents($fileName, $strXml);	

}
/////////////////////////////////////////////////////////////////////////////////////////////////////
function createMailRedoute($orderMp){
	
	$tab_commande = explode("-", $orderMp);
	$commande_format_redoute = str_replace(".", "", $tab_commande[2]);
	return $mail_redoute_anonyme_45j = 'mpva+' . $commande_format_redoute .'+'. $id_redoute . '@mp.laredoute-marketplace.fr';
	
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
function valueTva($id_tva){
	
	$tva_query= tep_db_query("SELECT tax_rate FROM tax_rates WHERE tax_rates_id = '" . $id_tva . "'");
	$tva_values = tep_db_fetch_array($tva_query);
	return $tva = $tva_values['tax_rate'];
	
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * convert xml string to php array - useful to get a serializable value
 *
 * @param string $xmlstr 
 * @return array
 * @author Adrien aka Gaarf
 */
function xmlstr_to_array($xmlstr) {
  $doc = new DOMDocument();
  $doc->loadXML($xmlstr);
  return domnode_to_array($doc->documentElement);
}
function domnode_to_array($node) {
  $output = array();
  switch ($node->nodeType) {
   case XML_CDATA_SECTION_NODE:
   case XML_TEXT_NODE:
    $output = trim($node->textContent);
   break;
   case XML_ELEMENT_NODE:
    for ($i=0, $m=$node->childNodes->length; $i<$m; $i++) { 
     $child = $node->childNodes->item($i);
     $v = domnode_to_array($child);
     if(isset($child->tagName)) {
       $t = $child->tagName;
       if(!isset($output[$t])) {
        $output[$t] = array();
       }
       $output[$t][] = $v;
     }
     elseif($v) {
      $output = (string) $v;
     }
    }
    if(is_array($output)) {
     if($node->attributes->length) {
      $a = array();
      foreach($node->attributes as $attrName => $attrNode) {
       $a[$attrName] = (string) $attrNode->value;
      }
      $output['@attributes'] = $a;
     }
     foreach ($output as $t => $v) {
      if(is_array($v) && count($v)==1 && $t!='@attributes') {
       $output[$t] = $v[0];
      }
     }
    }
   break;
  }
  return $output;
}


?>