<?php

  require('includes/application_top.php');

  $mp_tab = getMiraklTabCodeUrl();


  if (isset($_GET['mp']))
  {
    $VAR = $_GET['mp'] ; 
  }
  else {
    $VAR = key($mp_tab);
  }
  if (isset($_GET['page_token']))
  {
    $page_token = $_GET['page_token'] ; 
  }
  else {
    $page_token = '';
  }
  




  $test = new miraklWebservice($mp_tab[$VAR]['clef']) ; 
  $test->setReponseType('json');
  $test->setPreProdUrl($mp_tab[$VAR]['url']);
  $response = $test->ListAllThreads($page_token);
//$test->display_xml_object($response);
//print_r($_GET['mp']);
 ?>


<!DOCTYPE html>
<html lang="fr">
  <head>


    <meta name="viewport" content="width=device-width, initial-scale=1">
   <meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
    <title>Service messagerie</title>
    <link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
    <script language="javascript" src="includes/menu.js"></script>
    <script language="javascript" src="includes/general.js"></script>

    
  </head>
  
  
  <body>
   
    <?php require(DIR_WS_INCLUDES . 'header.php'); ?>
    
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-12">
          <h1><?php echo  miraklWebservice::FormatTxt('Service séléctionné : ' .$VAR); ?></h1>
          
            <nav aria-label="...">
              <ul class="pager pull-right">
                <?php  if(isset($response['previous_page_token']))
                  { ?> <li><a href="<?php echo miraklWebservice::FormatTxt($_SERVER['PHP_SELF'])?>?page_token=<?php echo $response['previous_page_token']  ?>" class=""><?php echo miraklWebservice::FormatTxt('50 précédents')?></a></li> <?php } 
                  if(isset($response['next_page_token']))
                  { ?> <li><a href="<?php echo miraklWebservice::FormatTxt($_SERVER['PHP_SELF'])?>?page_token=<?php echo miraklWebservice::FormatTxt($response['next_page_token']) ?>" class="">50 Suivants</a></li>
                <?php  }  ?>
                
              </ul>
            </nav>
        
          <div class="dropdown">
            <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
              Liste des Marketplaces 
              <span class="caret"></span>
            </button>
            <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
              
              <?php
                foreach ($mp_tab as $element => $val) 
                {  ?>
                
                <li><a href="?mp=<?php echo $element ; ?> " ><?php echo miraklWebservice::FormatTxt($element) ?> </a></li>  
              <?php } ?>
              <?php 
                $ListContacts = array();
                
                foreach ($response['data'] as  $data ) 
                {
                  foreach ($data['current_participants'] as $current_participants) 
                  {
                    if (!($current_participants['type'] =='SHOP') && !($current_participants['type'] =='OPERATOR')) 
                    {
                      $var = array(
                      'id' => $data['id'],
                      'nom' => $current_participants['display_name'] ,
                      'topic' =>$data['topic']['value'],
                      'nbMessages' => $data['metadata']['total_count'],
                      'date dernier message' => $test->FormatDateMirakl($data['metadata']['last_message_date']),
                      'date debut discution' => $test->FormatDateMirakl($data['date_created'])
                      
                      ) ; 
                      $ListContacts[] = $var ; 
                    }
                  }
                } 
                
              ?>
              
            </ul>
          </div>
        </div>
      </div>
      
      
      
      <div class="row">
        
        <table class="table table-striped">
          <thead>
            <tr>
              <th>Client</th>
              <th>Sujet</th>
              <th>Date dernier message</th>
              <th><?php echo miraklWebservice::FormatTxt('Date début discussion')?></th>
            </tr>
          </thead>
          
          <?php 
            foreach ($ListContacts as $element) 
            { 
              echo "<tr> " ; 
              foreach ($element as $key => $value) 
              { if ($key == 'id' || $key == 'nbMessages') {}
                else if ($key == 'nom'){echo "<td><a href='mirakl_espacereponse.php?id=".$element['id']."&service=".$VAR."&Client=".$element['nom']."&url=".$mp_tab[$VAR]['url']."'>".miraklWebservice::FormatTxt($value)."</a></td>" ;} 
                elseif ($key == 'topic') {
                  {echo miraklWebservice::FormatTxt("<div class='row'><td>"."<span class='badge' style='background-color:lightblue;'>". $element['nbMessages'] ."</span>"."&nbsp;&nbsp;".$value."</td></div>");}
                }
                else {echo "<div class='row'><td><div class='col-xs-12 col-md-12'>".miraklWebservice::FormatTxt($value)."</div></td></div>";}
              }
              echo "</tr>";  
              
            }
          ?>
          
        </tr>
        
      </table>
    </div>
    
    
    <div align="right">
      <div class="row">
        <div class="col-md-12">
          
          <nav aria-label="..." >
            <ul class="pager pull-right">
              <?php  if(isset($response['previous_page_token']))
                { ?> <li><a href="<?php echo ($_SERVER['PHP_SELF'])?>?page_token=<?php echo miraklWebservice::FormatTxt($response['previous_page_token'] ) ?>" class="">50 précédents</a></li> <?php } 
                if(isset($response['next_page_token']))
                { ?> <li><a href="<?php echo ( $_SERVER['PHP_SELF'])?>?page_token=<?php echo miraklWebservice::FormatTxt($response['next_page_token']) ?>" class="">50 Suivants</a></li>
              <?php  }  ?>
              
            </ul>
          </nav>
        </div>
      </div>
    </div>
    
  
  </div>
      
    </div>
    <?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
    
  </body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>