<?php

function filter_text($text) {
$filter_array = array("",";","\r","\n","\t",chr(34),chr(176));
return str_replace($filter_array,"",$text);
} // function for the filter

function remplace_format_etiquette($text) {
$filter_array = array("format=A4");
return str_replace($filter_array,"format=10x15",$text);
} // function for the filter

class Mondial_Relay

{

	public $enseigne;

	public $reference_marque;

	public $cle_privee;

	public $reference_marque_suivi;

	public $cle_privee_suivi;

	public $lang;

	public $ModeCol;

	public $ModeLiv;

	public $repertoire;

	public $mod_php;

	public $mod_debug;  //( 0 = production; 1 = debug; )

	public $url_webservice;

	public $url_pdf_etiquette_mr;

	

	public function __construct()

    {

        /* paramtres  modifier */

        $this->enseigne = 'EC000046'; // Ce paramtre est un identifiant spcifique  l'enseigne fourni dans le document de paramtrage.

        $this->reference_marque = 'EC00004649'; // Rfrence de marque ( 8 caractres + 2 numriques )

        $this->cle_privee = 'ciOfWuS0'; // Cl prive ( 8 caractres )

        $this->reference_marque_suivi = 'EC00004649'; // Rfrence de marque ( 8 caractres + 2 numriques )

        $this->cle_privee_suivi = 'ciOfWuS0'; // Cl prive ( 8 caractres )

        $this->lang = 'FR'; // Code ISO langue

        $this->ModeCol = 'CCC'; // Mode de Collecte

        $this->ModeLiv = '24R'; // Mode de Livraison

        $this->Expe_Ad1 = 'Frederique Lemay'; // Expditeur (Civilit Nom Prnom) Civilits acceptes = 'MR', 'M.', 'MME', 'MLE' et 'MLLE'

        $this->Expe_Ad2 = STORE_NAME; // Expditeur (Complment) 32 caractres

        $this->Expe_Ad3 = '11 Lot La cerisaie les imberts'; // Expditeur (Rue)

        $this->Expe_Ad4 = ''; // Expditeur (Complment)

        $this->Expe_Ville = 'Gordes'; // Expditeur (Ville) 26 caractres

        $this->Expe_CP = '84220'; // 5 caractres numriques fixes

        $this->Expe_Pays = 'FR'; // Code ISO, pour la France : FR

        $this->Expe_Tel1 = '0033490061115'; // Expditeur (Tlphone Fixe) 13 caractres numriques ^((00|\+)33|0)[0-9][0-9]{8}$

        $this->Expe_Mail = STORE_OWNER_EMAIL_ADDRESS; // Expditeur (Adresse e-mail) 70 caractres Format e-mail RFC2822

        $this->repertoire = '/mondial_relay/'; // rpertoire de la contribution // Ne pas modifier

        $this->mod_php = 5; // Mode PHP de votre serveur

        $this->mod_debug = 0; //( 0 = production; 1 = debug; )

        $this->url_webservice = 'http://www.mondialrelay.fr/WebService/Web_Services.asmx?WSDL'; // Ne pas modifier

        $this->url_pdf_etiquette_mr = 'http://www.mondialrelay.com'; // Ne pas modifier

        $this->url_suivi_colis_mr = 'http://www.mondialrelay.fr/lg_fr/public/suividecolis/exp_suivi.aspx?'; // Ne pas modifier

    }

    

    function Format_Tel($tel)

    {

        $tel = eregi_replace('[^0-9]',"",$tel); // supression sauf chiffres

        $tel = trim($tel);                      // suppression espaces avant et aprs

        return $tel;

    }

    

    function Display_Debug($mr_method, $params, $result, $client)

    {

        if ( $this->mod_debug > 0 )

        {

            // Check for a fault

            echo 'Nom de la mthode Mondial Relay utilise = '.$mr_method;

            print_r($params);

            print_r($result);

            if ($client->fault)

            {

                echo '<h2>Fault</h2><pre>';

                    print_r($result);

                echo '</pre>';

            }

            else

            {

                // Check for errors

                $err = $client->getError();

                if ($err)

                {

                    // Display the error

                    echo '<h2>Error</h2><pre>' . $err . '</pre>';

                }

                else

                {

                    // Display the result

                    echo '<h2>Result</h2><pre>';

                        print_r($result);

                    echo '</pre>';

                }

            }



            // Display the request and response

            echo '<h2>Request</h2>';

            echo '<pre>' . htmlspecialchars($client->request, ENT_QUOTES) . '</pre>';

            echo '<h2>Response</h2>';

            echo '<pre>' . htmlspecialchars($client->response, ENT_QUOTES) . '</pre>';

            // Display the debug messages

            echo '<h2>Debug</h2>';

            echo '<pre>' . htmlspecialchars($client->debug_str, ENT_QUOTES) . '</pre>';

        }

    }



    function Instantiate()

    {

        require_once('lib/nusoap.php');



        if ( $this->mod_php == 5 )

        {

            $client = new nusoapclient($this->url_webservice, true);

        }

        else

        {

            $client = new soapclient($this->url_webservice, true);

        }



        $err = $client->getError();

        if ($err)

        {

            echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';

        }

        else

        {

            return $client;

        }

    }



    function Calcul_Security($params_valid)

    {

        $chaine_security = '';

        foreach($params_valid as $k => $value)

        {

            $chaine_security .= $value;

        }

        $chaine_security .= $this->cle_privee;

        $chaine_security = strtoupper( md5( $chaine_security ) );

        return $chaine_security;

    }



    function Display_Iframe($pays, $cp)

    {

        $url_retour = str_replace("http://", "", HTTP_SERVER).'/'.urlencode('checkout_shipping.php?type=mondial_relay&relais={relais}&pays={pays}');

        $crc = strtoupper(md5('<'.$this->reference_marque.'>'.$cp.$pays.'<'.$this->cle_privee.'>'));

        $src = 'http://www.mondialrelay.fr/lg_fr/espaces/url/frame_pr_kit.aspx?ens='.$this->reference_marque.'&cp='.$cp.'&pays='.$pays.'&crc='.$crc.'&url='.$url_retour;



        echo '<script type="text/javascript" src="mondial_relay/js/jquery-1.3.2.min.js"></script>

        <script type="text/javascript"><!--

        $(document).ready(function(){
            $(".choice_shipping input").each(function()

            {
                var thisEl = $(this);
                var val_id = thisEl.attr("id");
                if ( thisEl.attr("checked") ) {
                    if ( val_id == "mondialrelay_mondialrelay" )
                    {
                        $("#mondial_relay_bloc").html(\'<td></td><td colspan="2" style="text-align:center;"><iframe src="'.$src.'" name="zone1" height="480" width="480"> Cadres local </iframe></td><td></td>\');
                        document.getElementById("div_bouton_valid").style.display = "none";
                        document.getElementById("div_bouton_adresse").style.display = "none";

                    }
                    else
                    {
                        $("#mondial_relay_bloc").hide();
                        document.getElementById("div_bouton_valid").style.display = "block";
                        document.getElementById("div_bouton_adresse").style.display = "block";
                    }  
               }

            });
           

            $(".choice_shipping input").live("click", function ()
            {
                var thisEl = $(this);
                var val_id = thisEl.attr("id");
                    if ( val_id == "mondialrelay_mondialrelay" )
                    {
                        $("#mondial_relay_bloc").show();
                        $("#mondial_relay_bloc").html(\'<td></td><td colspan="2" style="text-align:center;"><iframe src="'.$src.'" name="zone1" height="480" width="480"> Cadres local </iframe></td><td></td>\');
                        document.getElementById("div_bouton_valid").style.display = "none";
                        document.getElementById("div_bouton_adresse").style.display = "none";

                    }
                    else
                    {
                        $("#mondial_relay_bloc").hide();
                        document.getElementById("div_bouton_valid").style.display = "block";
                        document.getElementById("div_bouton_adresse").style.display = "block";

                    }  
            });
        });
        //--></script>';

    }

    

    function Display_Lien_Suivi($oID)

    {

        $order = new order($oID);



        $crc = strtoupper( md5( '<'.$this->reference_marque_suivi.'>'.$order->info['num_colis_mr_id'].'<'.$this->cle_privee_suivi.'>') );

        $link_suivi = $this->url_suivi_colis_mr.'cmrq='.$this->reference_marque_suivi.'&nexp='.$order->info['num_colis_mr_id'].'&crc=12345678901234567890ABCDEFABCDEF#posthead';

        return $link_suivi;

    }

    

    function Display_Link_Etiquette_Suivi($oID)

    {

        $order = new order($oID);

        

        echo '<tr>

            <td class="main"><img src="http://www.mondialrelay.fr/_img/logo_mondial_relay_ban.gif" alt="Mondial relay" width="50%" height="50%" /></td>

            <td class="main"><a href="'.$this->url_pdf_etiquette_mr.$order->info['url_etiquette_mr'].'">imprimer l\'tiquette</a> | <a href="'.$this->Display_Lien_Suivi($oID).'" target="_blank">suivre le colis</a></td>

          </tr>';

    }

    

    function Display_Link_Etiquette_Suivi2($oID)

    {

        $order = new order($oID);

        

        return '<img src="http://www.mondialrelay.fr/_img/logo_mondial_relay_ban.gif" alt="Mondial relay" style="width:50%;height:50%" /><br />

            <a href="'.$this->url_pdf_etiquette_mr.$order->info['url_etiquette_mr'].'">imprimer l\'tiquette</a> | <a href="'.$this->Display_Lien_Suivi($oID).'" target="_blank">suivre le colis</a>';

    }



    function Display_Erreur($code_erreur)

    {

        $client = $this->Instantiate();

        $mr_method = 'WSI2_STAT_Label';

        $mr_method_result = $mr_method.'Result';

        $params = array('parameters' => array('Enseigne' => $this->enseigne,

                                                  'STAT_ID' => $code_erreur,

                                                  'Langue' => $this->lang)

                                                  );

        $params['parameters']['Security'] = $this->Calcul_Security($params['parameters']);

        $result = $client->call($mr_method,$params);

        $this->Display_Debug($mr_method, $params, $result, $client);

        $erreur = $result[$mr_method_result];

        echo $erreur;

        exit();

    }

    

    function display_info_relais($pays_mr, $relais_mr)

    {

        $client = $this->Instantiate();



        $mr_method = 'WSI2_AdressePointRelais';

        $mr_method_result = $mr_method.'Result';

        $params = array('parameters' => array('Enseigne' => $this->enseigne,

                                                  'Num' => $relais_mr,

                                                  'Pays' => $pays_mr) );

        $params['parameters']['Security'] = $this->Calcul_Security($params['parameters']);

        $result = $client->call($mr_method,$params);

        $this->Display_Debug($mr_method, $params, $result, $client);

        $donnees_point_relais = $result[$mr_method_result];

        if ( $donnees_point_relais['STAT'] != 0 )

        {

            $this->Display_Erreur($info_update_order['STAT']);

        }

        return $donnees_point_relais;

    }

    

    function code_country($name_country) {

        $code_country_query = tep_db_query("select countries_iso_code_2 from " . TABLE_COUNTRIES . " where countries_name = '" . $name_country . "' LIMIT 1");

        $code_country = tep_db_fetch_array($code_country_query);

        return $code_country['countries_iso_code_2'];

  }


    

    function update_order($oID)

    {

        $client = $this->Instantiate();
        require_once(DIR_WS_CLASSES . 'order.php');
        $mr_method = 'WSI2_CreationEtiquette';
        $mr_method_result = $mr_method.'Result';
        $order = new order($oID);
		if ($order->info['poids_commande']< 0.110) { $poids_ajust = 0.110; } else { $poids_ajust = $order->info['poids_commande']; }
        $params = array('parameters' => array('Enseigne' => $this->enseigne,
                                              'ModeCol' => $this->ModeCol,
                                              'ModeLiv' => $this->ModeLiv,
                                              'NDossier' => $oID,
                                              'NClient' => $order->customer['id'],
                                              'Expe_Langage' => $this->lang,
                                              'Expe_Ad1' => $this->Expe_Ad1,
                                              'Expe_Ad2' => $this->Expe_Ad2,
                                              'Expe_Ad3' => $this->Expe_Ad3,
                                              'Expe_Ad4' => $this->Expe_Ad4,
                                              'Expe_Ville' => $this->Expe_Ville,
                                              'Expe_CP' => $this->Expe_CP,
                                              'Expe_Pays' => $this->Expe_Pays,
                                              'Expe_Tel1' => $this->Expe_Tel1,
                                              'Expe_Tel2' => '',
                                              'Expe_Mail' => $this->Expe_Mail,
                                              'Dest_Langage' => $this->lang,
                                              'Dest_Ad1' => filter_text($order->customer['name']),
                                              'Dest_Ad2' => filter_text($order->customer['company']),
                                              'Dest_Ad3' => filter_text($order->customer['street_address']),
                                              'Dest_Ad4' => filter_text($order->customer['suburb']),
                                              'Dest_Ville' => filter_text($order->customer['city']),
                                              'Dest_CP' => $order->customer['postcode'],
                                              'Dest_Pays' => $this->code_country($order->customer['country']),
                                              'Dest_Tel1' => $this->Format_Tel($order->customer['telephone']),
                                              'Dest_Tel2' => '',
                                              'Dest_Mail' => $order->customer['email_address'],
                                              'Poids' => ($poids_ajust)*1000,
                                              'NbColis' => '1', // Nombre de Colis de l'expdition
                                              'CRT_Valeur' => '0', // Valeur de contre remboursement
                                              'CRT_Devise' => 'EUR',
                                              'LIV_Rel_Pays' => $this->code_country($order->customer['country']),
                                              'LIV_Rel' => $order->info['num_relais_mr_id']
                                                  ) );

        $params['parameters']['Security'] = $this->Calcul_Security($params['parameters']);

        $result = $client->call($mr_method,$params);

        $this->Display_Debug($mr_method, $params, $result, $client);

        

/*echo '<pre>';

print_r($order);

echo '</pre>';

*/



        $info_update_order = $result[$mr_method_result];

        if ( $info_update_order['STAT'] != 0 )

        {

            $this->Display_Erreur($info_update_order['STAT']);

        }
$mess=$info_update_order['URL_Etiquette'];
        //           mail('admin@artoisweb.com', 'avant',$mess );

		$info_update_order['URL_Etiquette']=remplace_format_etiquette($info_update_order['URL_Etiquette']);
$mess=$info_update_order['URL_Etiquette'];
       //            mail('admin@artoisweb.com', 'apres',  $mess);
        tep_db_query("update " . TABLE_ORDERS . " set url_etiquette_mr = '" . $info_update_order['URL_Etiquette'] . "', num_colis_mr_id = '" . $info_update_order['ExpeditionNum'] . "' where orders_id = '" . (int)$oID . "'");

        

        $text = "\n\n" . 'Votre commande est prpare et vient d\'tre transmise au service Mondial Relay.' . "\n\n" . 'Pour suivre votre colis, cliquez sur le lien suivant : <a href="'.$this->display_lien_suivi($oID).'">'.$this->display_lien_suivi($oID).'</a>'."\n\n";

        return $text;

    }

}

?>