<?php
/*
 * This file is part of the partner api fnac marketplace package.
 * (c) 2008-2010 Francois Crossette <fcrossette@fnac.com>
 *
 * Example of a common use case for FNAC MARKETPLACE API
 *   - Authentication
 *   - Offers Update
 *   - Offers Query
 *   - Batch Status
 *   - Orders Query
 *   - Orders Update
 *
 */

/*
 * Init :
 *   $partner_id : unique id given by Fnac team
 *   $shop_id    : unique id of Fnac shop
 *   $key        : partner sauthentication key
 */

// CB
//  $partner_id = '74B919C1-9EA4-8113-2393-DE2D7E62CC65';
//  $key        = 'AA353167-578B-6679-DB83-1B71ABD0EFDD';
//  $shop_id    = '489A06A0-FF08-88B5-1075-3C8CC3C5ECCA';

// CB
  $partner_id = '8DA6AE5D-B753-64BC-1497-D55BFE5F9CF6';
  $key        = '2494DD10-6429-A2BA-3214-4B87D243E796';
  //fnac  
  $shop_id    = '489A06A0-FF08-88B5-1075-3C8CC3C5ECCA';
  $url        = 'https://vendeur.fnac.com/api.php/';  
  //DARTY
  $shop_id    = 'A9CA3F7E-A003-FBFE-2D4A-78AA8D14759A';
 // $url        = 'https://partners-test.mp.fnacdarty.com/api.php/';



  try
  {
    /* call auth service  */
    $xmlAuthentication = simplexml_load_file('adminweb/fnac/xml_files/authentification-request.xml');
    $xmlAuthentication->partner_id = $partner_id;
    $xmlAuthentication->shop_id = $shop_id;
    $xmlAuthentication->key = $key;

    /* Validated XML request using XSD */
    $dom = new DOMDocument;
    $dom->loadXML($xmlAuthentication->asXML());
    $valide = $dom->schemaValidate('adminweb/fnac/xsd/AuthenticationService.xsd');
    if( ! $valide)
    {
      throw new Exception('xmlAuthentication: validation failed !');
    }

    // send xml to webservice auth
    $response = do_post_request($url . "auth", $xmlAuthentication->asXML());

    // load xml response
    $xmlResponse = simplexml_load_string(trim($response));
    // get token for session authentication
    $tokenForSession = $xmlResponse->token;
    // Post to this date , the session for this token is no more valid.
    $validityDateForSession = $xmlResponse->validity;
/////////////////////////////////////////////////////

$mise_a_jour=1;

if ($mise_a_jour==1) { // test mise a jour
/////////////////////////////////////////////////////
    /* call offer update service */
//    $xmlOffersUpdate = simplexml_load_file('adminweb/fnac/xml_files/offers-update-request.xml');
//    $xmlOffersUpdate['partner_id'] = $partner_id;
//    $xmlOffersUpdate['shop_id'] = $shop_id;
//    $xmlOffersUpdate['token'] = $tokenForSession;


/************************************************************** traitement exportation **************************************************************/

$string = <<<XML
<?xml version="1.0" encoding="utf-8"?>
<offers_update partner_id="$partner_id"  shop_id="$shop_id"  token="$tokenForSession" xmlns='http://www.fnac.com/schemas/mp-dialog.xsd'>
  <offer>
    <product_reference type='Ean'>3700235440486</product_reference>
    <offer_reference type='SellerSku'>10000</offer_reference>
    <price>23.79</price>
    <product_state>11</product_state>
    <quantity>6</quantity>
    <description>Lampe Lava New York TaxiLave en mouvement a l interieur du cylindre de verreH 34 cmFonctionne avec une ampoule de 25 W type R39 (incluse)Alimentation : 230V / 50 Hz .seb</description>
    <internal_comment>art</internal_comment>
    <showcase>100</showcase>
  </offer>
  <offer>
    <product_reference type='Ean'>3700235440837</product_reference>
    <offer_reference type='SellerSku'>10003</offer_reference>
    <price>23.79</price>
    <product_state>11</product_state>
    <quantity>0</quantity>
    <description>Lampe de chevet cylindrique Hello KittyPVC - Pied en metal Hauteur : 29 cm230 V - 50 Hz, E14 Max. 25WAmpoule non incluse .seb</description>
    <internal_comment>art</internal_comment>
    <showcase>100</showcase>
  </offer>
  <offer>
    <product_reference type='Ean'>5484220135547</product_reference>
    <offer_reference type='SellerSku'>10076</offer_reference>
    <price>3.80</price>
    <product_state>11</product_state>
    <quantity>10</quantity>
    <description>Porte monnaie bleu Winnie l ourson poche zippee Dimension : 11 x 14 cm .seb</description>
    <internal_comment>art</internal_comment>
    <showcase>100</showcase>
  </offer>
</offers_update>
XML;

/************************************************************** traitement exportation **************************************************************/

  require('xml_artoisweb_market_place_fnac.php');

echo $info_string;
echo " nombre de produits : " . $product_num ;

 $string = <<<XML
<?xml version="1.0" encoding="ISO-8859-1" ?>
<offers_update partner_id="$partner_id"  shop_id="$shop_id"  token="$tokenForSession"  xmlns="http://www.fnac.com/schemas/mp-dialog.xsd">
$string
</offers_update>
XML;
//exit("arret seb");

  $xmlOffersUpdate=simplexml_load_string($string);

    /* Validated XML request using XSD */
    $dom = new DOMDocument;
    $dom->loadXML($xmlOffersUpdate->asXML());
   // $valide = $dom->schemaValidate('adminweb/fnac/xsd/OffersUpdateService.xsd');
   // if( ! $valide)
   // {
   //   throw new Exception('xmlOffersUpdate: validation failed !');
   // }

    // send xml to webservice OffersUpdate
    $response = do_post_request($url . "offers_update", $xmlOffersUpdate->asXML());
    $xmlResponse = simplexml_load_string(trim($response));
    // get the batch id to try to get status of import
    echo $batchId = $xmlResponse->batch_id;


	echo "<pre>";
print_r($xmlResponse);
	echo "</pre>";

	echo "<hr>";


//////////////////////////////////////////////////////////////////////////////////////////////////////
    // call batch status service
    // to have an answer for this service, the batch (batch_id) must be treated by fnac.
    // $xmlBatchStatus = simplexml_load_file('xml_files/batch-status-request.xml');
    // $xmlBatchStatus['partner_id'] = $partner_id;
    // $xmlBatchStatus['shop_id'] = $shop_id;
    // $xmlBatchStatus['token'] = $tokenForSession;
    // $xmlBatchStatus->batch_id = $batchId;

$string = <<<XML
<?xml version="1.0" encoding="utf-8"?>
<batch_status partner_id="$partner_id"  shop_id="$shop_id"  token="$tokenForSession" xmlns="http://www.fnac.com/schemas/mp-dialog.xsd">
  <batch_id>$batchId</batch_id>
</batch_status>
XML;

$xmlBatchStatus=simplexml_load_string($string);

    // send xml to webservice BatchStatus
    $response = do_post_request($url . "batch_status", $xmlBatchStatus->asXML());


$xmlResponse = simplexml_load_string(trim($response));

	echo "<pre>";
      print_r($xmlResponse);
	echo "</pre>";

	echo "<hr>";

} // fin  test mise a jour
//////////////////////////////////////////////////////////////////////////////////////////////////////
    // call batch query service
    // to have an answer for this service, the batch (batch_id) must be treated by fnac.
    // $xmlBatchStatus = simplexml_load_file('xml_files/batch-query-request.xml');
    // $xmlBatchStatus['partner_id'] = $partner_id;
    // $xmlBatchStatus['shop_id'] = $shop_id;
    // $xmlBatchStatus['token'] = $tokenForSession;
    // $xmlBatchStatus->batch_id = $batchId;

$string = <<<XML
<?xml version="1.0" encoding="utf-8"?>
<batch_query partner_id="$partner_id"  shop_id="$shop_id"  token="$tokenForSession" xmlns="http://www.fnac.com/schemas/mp-dialog.xsd">
</batch_query>
XML;

$xmlBatchQuery=simplexml_load_string($string);

    // send xml to webservice BatchStatus
    $response = do_post_request($url . "batch_query", $xmlBatchQuery->asXML());


$xmlResponse = simplexml_load_string(trim($response));

	echo "<pre>";
      print_r($xmlResponse);
	echo "</pre>";
	echo "<hr>";


//////////////////////////////////////////////////////////////////////////////////////////////////////


  }

  catch(Exception $e)
  {
    // do what you want with exception
    var_dump($e);
  }

/**************************************************  ***********************************************/


  /**
   * Simulate a post method
   *
   * @param string   $url              : target url
   * @param string   $data             : xml query
   * @param string   $optional_headers : optional headers
   *
   * @return response of the http request
   */
  function do_post_request($url, $data, $optional_headers = null)
  {
/*    $params = array( 'http' => array ( 'method' => 'POST', 'content' => $data ) );
    if ( $optional_headers !== null )
    {
      $params['http']['header'] = $optional_headers;
    }

	echo "<pre>";
    var_dump($params);
	echo "</pre>";

 echo   $ctx = stream_context_create($params);
    $fp = fopen($url, 'rb', false, $ctx);

    if ( !$fp )
    {
      throw new Exception("Problem with $url");
    }

    $response = @stream_get_contents($fp);

    if ( $response === false )
    {
      throw new Exception("Problem reading data from $url");
    }
*/
    // Here is an example with cURL (could be faster)
     $ch = curl_init();

   //  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
     curl_setopt($ch, CURLOPT_POST, 1); 
     curl_setopt($ch, CURLOPT_URL, $url);
     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
     curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

//curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,true); 
//curl_setopt($ch,CURLOPT_CAINFO,'adminweb/cacert.pem'); /* fixed! */

     $response = curl_exec($ch);

     if(0 != curl_errno($ch))
     {
       echo 'curl Error: '.curl_error($ch)."\n<br/>curl info:";
       echo '<pre>';
       print_r(curl_getinfo($ch));
       echo '</pre>';
     }

     curl_close($ch);

    return $response;
  }
?>