<div class="panel panel-primary">
	
	<?php
		//This is aPHP(5)script example on how eurofxref-daily.xml can be parsed
		//Read eurofxref-daily.xml file in memory
		//For the next command you will need the config option allow_url_fopen=On (default)
		$XML=@simplexml_load_file("http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml");
		//the file is updated daily between 2.15 p.m. and 3.00 p.m. CET
  		if ( !empty($XML)) {
			$date_change = $XML->Cube->Cube["time"];      
			foreach($XML->Cube->Cube->Cube as $rate){
				//Output the value of 1EUR for a currency code
				
				if (($rate["currency"] == 'GBP') || ($rate["currency"] == 'USD') ) {
					if ($rate["currency"] == 'GBP') {
						$symbole = 'glyphicon-gbp';
						$livres = $rate["rate"];
						$taux[GBP] = '<h4>1<span class="glyphicon glyphicon-euro"></span> <span class="glyphicon glyphicon-arrow-right"></span>  '.$livres.' <span class="glyphicon '. $symbole  .'"></span></h4>'; 
						
					}
					if ($rate["currency"] == 'USD') {
						$symbole = 'glyphicon-usd';
						$dollars = $rate["rate"];
						$taux[USD] = '<h4>1<span class="glyphicon glyphicon-euro"></span> <span class="glyphicon glyphicon-arrow-right"></span>  '.$dollars.' <span class="glyphicon '. $symbole  .'"></span></h4>'; 
						
						
					}		
					
				}
				if ($rate["currency"] == 'SEK') {
					$symbole = '';
					$SEK = $rate["rate"];
					$taux[SEK] = '<h4>1<span class="glyphicon glyphicon-euro"></span> <span class="glyphicon glyphicon-arrow-right"></span>  '.$SEK.' <span class="glyphicon '. $symbole  .'"></span>Cour suedoise</h4>'; 
					
					
				}		
				
				if ($rate["currency"] == 'PLN') {
					$symbole = '';
					$PLN = $rate["rate"];
					$taux[PLN] = '<h4>1<span class="glyphicon glyphicon-euro"></span> <span class="glyphicon glyphicon-arrow-right"></span>  '.$PLN.' <span class="glyphicon '. $symbole  .'"></span>zloty</h4>'; 
					
					
				}				
			}
		}
	?>
	<div class="panel-heading">Taux de change (BCE)
		<a  class="btn btn-default btn-xs" role="button" href="<?php echo tep_href_link('index.php', 'action=majdevises&livres='.$livres.'&dollars='.$dollars.'&SEK='.$SEK.'&PLN='.$PLN, 'SSL'); ?>"><span class="glyphicon glyphicon-refresh"></span> mettre  jour la base</a>
	</div>
	<div class="table-responsive">
		<table class="table table-hover"  width="100%" cellspacing="0" cellpadding="0">
			<tr class="active">
				<th >Taux au <?php echo $date_change ;?></th>
				<th >Taux dans la base</th>
				
			</tr>
			<tr>
				<td class="success"><?php echo $taux['GBP'] ; ?></td>
				<td class="warning"><h4><?php echo TAUX_LIVRE_STERLING ; ?></h4></td>
			</tr>
			<tr>
				<td class="success"><?php echo $taux['USD'] ; ?></td>
				<td class="warning"><h4><?php echo TAUX_EURO_DOLLAR ; ?></h4></td>
				
			</tr>
			<tr>
				<td class="success"><?php echo $taux['SEK'] ; ?></td>
				<td class="warning"><h4><?php echo TAUX_COURONNE_SUEDOISE_SEK ; ?></h4></td>
				
			</tr>	
			<tr>
				<td class="success"><?php echo $taux['PLN'] ; ?></td>
				<td class="warning"><h4><?php echo TAUX_ZLOTY_POLOGNE_PLN ; ?></h4></td>
				
			</tr>					
		</table>
	</div>
</div>