<?php
/*
  $Id: abxConstants.php,v 1.20 2008/10/23 21:19:20 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  abx_includeLanguageFile(DIR_FS_ABX_INCLUDES,$language,'abxConstants');

  class abxConstants {

    function &getAPIVersions()
    {
      return array(
        array('id' => '1.0', 'text' => '1.0')
      );
    }

    function &getAPIActions()
    {
      return array(
        array('id' => 'insert', 'text' => 'Insert'),
        array('id' => 'update', 'text' => 'Update'),
        array('id' => 'version', 'text' => 'Version')
      );
    }

    function &getAccountStatus()
    {
      return array(
        array('id' => '1', 'text' => 'Registered'),
        array('id' => '2', 'text' => 'Suspended'),
        array('id' => '3', 'text' => 'Unregistered')
      );
    }

    function &getCountryIsoCode2($country_id)
    {
      global $abxDatabase;

      $countries_query_raw = "select countries_iso_code_2 from " . TABLE_COUNTRIES . " where countries_id = " . (int)$country_id;

      $countriesQuery = $abxDatabase->query($countries_query_raw);

      if ($countriesQuery->next()) {

        $code = $countriesQuery->value('countries_iso_code_2');

        if (trim(strtoupper($code)) === "GB")
          $code = 'UK';

        return $code;
      }

      return null;
    }

    function &getAuctionHouses($arr = array())
    {
      global $abxDatabase;

      static $auctionHouses;

      if (isset($auctionHouses) === false) {

        $auctionHousesQuery = &$abxDatabase->query("select auction_house_id, auction_house_label, auction_item_url from " . TABLE_ABX_HOUSES);

        while ($auction_house = $auctionHousesQuery->next())

          $auctionHouses[$auction_house['auction_house_id']] = array(
            'id'   => $auction_house['auction_house_id'],
            'text' => $auction_house['auction_house_label'],
            'url'  => $auction_house['auction_item_url']
          );

      }

      return (empty($arr) === false) ? array_merge($arr,$auctionHouses) : $auctionHouses;
    }

    function &getProfilesDropDown() 
    {
      require_once(DIR_FS_ABX_CLASSES . 'abxProfiles.php');
      $aProfiles = abxProfiles::getProfiles();
      
      $aProfilesText = array();
		  if ($aProfiles) {
	        foreach($aProfiles as $aProfile) {
	          $aProfilesText[] = array(
	            'id'   => $aProfile['id'],
	            'text' => $aProfile['label']);
	        }
	    }
   
		  return $aProfilesText;
    }

    function getEbaySellerNames($arr = array())
    {
      global $abxDatabase;

      static $eBaySellerList;

      if (isset($eBaySellerList) === false) {

        $sellers = abxConstants::getEbaySellerIDs($arr);

        $eBaySellerList = array();

        foreach($sellers as $seller)
          $eBaySellerList[] = array('id' => $seller['text'], 'text' => $seller['text']);

      }

      return (empty($arr) === false) ? array_merge($arr,$eBaySellerList) : $eBaySellerList;
    }

    function &getEbaySellerIDs($arr = array())
    {
      global $abxDatabase;

      static $sellers;

      if (isset($sellers) === false) {

        $sellerQuery = $abxDatabase->query("select seller_id, user_id from " . TABLE_ABX_SELLER_INFO);

        while($seller = $sellerQuery->next())

          $sellers[] = array('id' => $seller['seller_id'], 'text' => $seller['user_id']);

      }

      return (empty($arr) === false) ? array_merge($arr,$sellers) : $sellers;
    }

    function &getInsuranceOptions()
    {
      return array(
        array('id' => '0', 'text' => TEXT_INSURANCE_NONE),
        array('id' => '1', 'text' => TEXT_INSURANCE_OPTIONAL),
        array('id' => '2', 'text' => TEXT_INSURANCE_REQUIRED),
        array('id' => '3', 'text' => TEXT_INSURANCE_INCLUDED)
      );
    }

    function &getShippingTypes()
    {
      return array(
        array('id' => 'F', 'text' => TEXT_FIXED_SHIPPING),
//        array('id' => 'M', 'text' => TEXT_FIXED_SHIPPING_DISCOUNT_ALL_ITEMS),
        array('id' => 'C', 'text' => TEXT_CALCULATED_SHIPPING_DURING_CHECKOUT),
        array('id' => 'E', 'text' => TEXT_CALCULATED_SHIPPING_AT_EBAY),
        array('id' => 'N', 'text' => TEXT_FREE_SHIPPING)
      );
    }

    function &getListingTypes()
    {
      return array(
        array('id' => '1', 'text' => TEXT_AUCTION),
        array('id' => '9', 'text' => TEXT_FIXED_PRICE),
        array('id' => '2', 'text' => TEXT_DUTCH_AUCTION),
        array('id' => '7', 'text' => TEXT_EBAY_STORE)
      );
    }

    function &getListingTypesShort()
    {
      return array(
        '1' => TEXT_AUCTION_SHORT,
        '9' => TEXT_FIXED_PRICE_SHORT,
        '2' => TEXT_DUTCH_AUCTION_SHORT,
        '7' => TEXT_EBAY_STORE_SHORT
      );
    }

    function &getSites()
    {
      return array(
        array('id' => 'US', 'text' => TEXT_COUNTRY_US),
        array('id' => 'CA', 'text' => TEXT_COUNTRY_CA),
        array('id' => 'UK', 'text' => TEXT_COUNTRY_UK),
        array('id' => 'AU', 'text' => TEXT_COUNTRY_AU),
        array('id' => 'AT', 'text' => TEXT_COUNTRY_AT),
        array('id' => 'BFR', 'text' => TEXT_COUNTRY_BFR),
        array('id' => 'FR', 'text' => TEXT_COUNTRY_FR),
        array('id' => 'DE', 'text' => TEXT_COUNTRY_DE),
        array('id' => 'IT', 'text' => TEXT_COUNTRY_IT),
        array('id' => 'BNL', 'text' => TEXT_COUNTRY_BNL),
        array('id' => 'NL', 'text' => TEXT_COUNTRY_NL),
        array('id' => 'ES', 'text' => TEXT_COUNTRY_ES),
        array('id' => 'CH', 'text' => TEXT_COUNTRY_CH),
        //array('id' => '196', 'text' => 'Taiwan'));
        array('id' => 'EMO', 'text' => TEXT_EBAY_MOTORS)
      );
    }

    function &getListingDurations()
    {
      return array(
        array('id' => '1', 'text' => TEXT_DURATION_1DAY),
        array('id' => '3', 'text' => TEXT_DURATION_3DAY),
        array('id' => '5', 'text' => TEXT_DURATION_5DAY),
        array('id' => '7', 'text' => TEXT_DURATION_7DAY),
        array('id' => '10', 'text' => TEXT_DURATION_10DAY),
        array('id' => '-1', 'text' => '---------------'),
        //array('id' => '20', 'text' => '20 days'),   // real estate?
        array('id' => '30', 'text' => TEXT_DURATION_30DAY),
        array('id' => '60', 'text' => TEXT_DURATION_60DAY),
        array('id' => '90', 'text' => TEXT_DURATION_90DAY),
        array('id' => '120', 'text' => TEXT_DURATION_120DAY),
        array('id' => '-1', 'text' => '----------------'),
        array('id' => 'GTC', 'text' => TEXT_DURATION_GTC)
      );
    }

    function &getShippingLocations()
    {
      return array(
        array('id' => 'D', 'text' => TEXT_SHIPPING_DOMESTIC),
        array('id' => 'I', 'text' => TEXT_SHIPPING_WORLDWIDE),
        array('id' => 'N', 'text' => TEXT_SHIPPING_NONE)
      );
    }

    function &getRegions()
    {
      return array(0=>array('id' => '0', 'text' => 'Do not list regionally'));
    }

    function &getGalleryOptions()
    {
      return array(
        array('id' => 'N', 'text' => TEXT_GALLERY_NONE),
        array('id' => 'G', 'text' => TEXT_GALLERY_PICTURE),
        array('id' => 'P', 'text' => TEXT_GALLERY_PLUS),
        array('id' => 'F', 'text' => TEXT_FEATURED_FIRST)
      );
    }

    function &getStoreCategories()
    {
      static $new_cats_array;

      if (isset($new_cats_array) === false) {

        $ebay_store_categories = EBAY_STORE_CATEGORIES;

        if (empty($ebay_store_categories) === false)
          $cats_array = explode(",", $ebay_store_categories);

        $new_cats_array[] = array("id" => '', 'text' => TEXT_EBAY_STORE_CATEGORY_NONE);
        $new_cats_array[] = array("id" => '1', 'text' => TEXT_EBAY_STORE_CATEGORY_OTHER);

        $count = 2;

        if (isset($cats_array) === true)

          foreach($cats_array as $unused => $cat) {

            $new_cats_array[] = array("id" => $count, 'text' => $cat);

            $count++;

          }

        }

      return $new_cats_array;
    }

    function &getShippingServices($site)
    {
      switch($site) {

        case 'US':
        case 'EMO':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '1', 'text' => 'Standard Shipping (fixed only)'),
            array('id' => '2', 'text' => 'Express Shipping (fixed only)'),
            array('id' => '18', 'text' => 'Overnight Shipping (fixed only)'),
            array('id' => '3', 'text' => 'UPS Ground'),
            array('id' => '4', 'text' => 'UPS 3 Day Select'),
            array('id' => '5', 'text' => 'UPS 2nd Day Air'),
            array('id' => '12', 'text' => 'UPS Next Day Air'),
            array('id' => '6', 'text' => 'UPS Next Day Air Saver'),
            array('id' => '19', 'text' => 'USPS Priority Mail Flat Rate Envelope'),
            array('id' => '20', 'text' => 'USPS Priority Mail Flat Rate Box'),
            array('id' => '7', 'text' => 'USPS Priority Mail'),
            array('id' => '8', 'text' => 'USPS Parcel Post'),
            array('id' => '9', 'text' => 'USPS Media Mail'),
            array('id' => '10', 'text' => 'USPS First Class Mail'),
            array('id' => '11', 'text' => 'USPS Express Mail'),
            array('id' => '11', 'text' => 'USPS Express Flat Rate Envelope'),
            array('id' => '16', 'text' => 'Freight Shipping'),
            array('id' => '150', 'text' => 'Local Pickup'),
            array('id' => '13', 'text' => 'Other (see description)'),
          );
          
        case 'CA':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '201', 'text' => 'Standard Shipping'),
            array('id' => '202', 'text' => 'Express Shipping'),
            array('id' => '203', 'text' => 'Canada Post Lettermail'),
            array('id' => '204', 'text' => 'Canada Post Regular Parcel'),
            array('id' => '205', 'text' => 'Canada Post Expedited Parcel'),
            array('id' => '206', 'text' => 'Canada Post Xpresspost'),
            array('id' => '207', 'text' => 'Canada Post Priority Courier')
          );

        case 'UK':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '310', 'text' => 'Standard Shipping'),   // Seller's Standard Rate
            array('id' => '301', 'text' => 'Royal Mail 1st Class Standard'),
            array('id' => '302', 'text' => 'Royal Mail 2nd Class Standard'),
            array('id' => '303', 'text' => 'Royal Mail 1st Class Recorded'),
            array('id' => '304', 'text' => 'Royal Mail 2nd Class Recorded'),
            array('id' => '305', 'text' => 'Royal Mail Special Delivery'),
            array('id' => '306', 'text' => 'Royal Mail Standard Parcels'),
            array('id' => '307', 'text' => 'Parcelforce 24'),
            array('id' => '308', 'text' => 'Parcelforce 48'),
            array('id' => '309', 'text' => 'Other (See description)'),
            array('id' => '311', 'text' => 'Collect in person')
          );

        case 'AU':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '1501', 'text' => 'Standard Shipping'),   // Seller's Standard Rate
            array('id' => '1503', 'text' => 'Express Shipping'),
            array('id' => '1505', 'text' => 'Registered Shipping'),
            array('id' => '1506', 'text' => 'Courier'),
            array('id' => '1507', 'text' => 'Other (See description)')
          );

        case 'AT':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '1601', 'text' => 'Standardversand (unversichert)'),   // Seller's Standard Rate
            array('id' => '1602', 'text' => 'Versicherter Versand'),
            array('id' => '1603', 'text' => 'Einschreiben (Versand inkl. Einschreibengebhr)'),
            array('id' => '1604', 'text' => 'Nachnahme (Versand inkl. Nachnahmegebhr)'),
            array('id' => '1605', 'text' => 'Express- oder Kurierversand'),
            array('id' => '1606', 'text' => 'Versicherter Express- oder Kurierversand'),
            array('id' => '1607', 'text' => 'Sonderversand (z.B. M�el, KFZ)'),
            array('id' => '1608', 'text' => 'Versicherter Sonderversand (z.B. M�el, KFZ)'),
            array('id' => '1609', 'text' => 'Sonstige (Siehe Artikelbeschreibung)')
          );

        case 'FR':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '7101', 'text' => 'Lettre'),
            array('id' => '7102', 'text' => 'Lettre avec suivi'),
            array('id' => '7103', 'text' => 'Lettre recommand'),
            array('id' => '7104', 'text' => 'Colissimo'),
            array('id' => '7106', 'text' => 'Colissimo Recommand'),
            array('id' => '7110', 'text' => 'Contre remboursement'),
            array('id' => '7111', 'text' => 'Autre mode d\'envoi de courrier'),
            array('id' => '7112', 'text' => 'Ecopli'),
            array('id' => '7113', 'text' => 'Coli�o'),
            array('id' => '7114', 'text' => 'Autre mode d\'envoi de colis'),
            array('id' => '7115', 'text' => 'Remise en main propre')
          );

      case 'DE':

        return array(
          array('id' => '0', 'text' => '[ -- Select One -- ]'),
          array('id' => '7701', 'text' => 'Unversicherter Versand'),
          array('id' => '7702', 'text' => 'Versicherter Versand'),
          array('id' => '7703', 'text' => 'Einschreiben (Versand inkl. Einschreibengebhr)'),
          array('id' => '7704', 'text' => 'Nachnahme (Versand inkl. Nachnahmegebhr)'),
          array('id' => '7705', 'text' => 'Express- oder Kurierversand'),
          array('id' => '7706', 'text' => 'Versicherter Express- oder Kurierversand'),
          array('id' => '7707', 'text' => 'Sonderversand (z.B. M�el, KFZ)'),
          array('id' => '7708', 'text' => 'Versicherter Sonderversand (z.B. M�el, KFZ)'),
          array('id' => '7710', 'text' => 'Deutsche Post Brief'),
          array('id' => '7711', 'text' => 'DHL Postpaket'),
          array('id' => '7712', 'text' => 'DHL P�kchen'),
          array('id' => '7713', 'text' => 'Deutsche Post Warensendung'),
          array('id' => '7714', 'text' => 'Deutsche Post Bchersendung '),
          array('id' => '7715', 'text' => 'Hermes Paket (unversichert)'),
          array('id' => '7716', 'text' => 'Hermes Paket (versichert)'),
          array('id' => '7717', 'text' => 'iloxx Transport XXL'),
          array('id' => '7718', 'text' => 'iloxx �ernacht Express'),
          array('id' => '7719', 'text' => 'iloxx Standard'),
          array('id' => '7720', 'text' => 'Sonstige (Siehe Artikelbeschreibung)')
          );

        case 'IT':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '10101', 'text' => 'Posta ordinaria'),
            array('id' => '10102', 'text' => 'Posta prioritaria'),
            array('id' => '10103', 'text' => 'Posta raccomandata'),
            array('id' => '10104', 'text' => 'Posta raccomandata con contrassegno'),
            array('id' => '10105', 'text' => 'Posta assicurata'),
            array('id' => '10106', 'text' => 'Posta celere'),
            array('id' => '10107', 'text' => 'Pacco ordinario'),
            array('id' => '10108', 'text' => 'Pacco celere 1'),
            array('id' => '10109', 'text' => 'Pacco celere 3'),
            array('id' => '10110', 'text' => 'Corriere espresso')
          );

        case 'ES':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '18601', 'text' => 'Cartas nacionales hasta 20 gr'),
            array('id' => '18602', 'text' => 'Cartas nacionales de m� de 20 gr'),
            array('id' => '18603', 'text' => 'Cartas internacionales hasta 20 gr'),
            array('id' => '18604', 'text' => 'Cartas internacionales de mas de 20 gr'),
            array('id' => '18605', 'text' => 'Paquete Azul (nacional) hasta 2 kg'),
            array('id' => '18606', 'text' => 'Paquete Azul (nacional) de m� de 2 kg'),
            array('id' => '18607', 'text' => 'Paquete Internacional Econ�ico'),
            array('id' => '18608', 'text' => 'Urgente (ver descripci�)'),
            array('id' => '18609', 'text' => 'Otros (ver descripci�)')
          );

        case 'CH':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '19301', 'text' => 'Standardversand (A-Post/Priority)'),
            array('id' => '19302', 'text' => 'Standardversand (B-Post/Economy)'),
            array('id' => '19303', 'text' => 'Versicherter Versand (z.B. Assurance/Fragile)'),
            array('id' => '19304', 'text' => 'Einschreiben (Versand inkl. Einschreibengebhr)'),
            array('id' => '19305', 'text' => 'Nachnahme (Versand inkl. Nachnahmegebhr)'),
            array('id' => '19306', 'text' => 'Express- oder Kurierversand'),
            array('id' => '19307', 'text' => 'Versicherter Express- oder Kurierversand'),
            array('id' => '19308', 'text' => 'Sonderversand (z.B. M�el, KFZ)'),
            array('id' => '19309', 'text' => 'Versicherter Sonderversand (z.B. M�el, KFZ)'),
            array('id' => '19310', 'text' => 'Sonstiger Versand (Siehe Artikelbeschreibung)')
          );

        case 'NL':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '14601', 'text' => 'Standaardverzending'),
            array('id' => '14602', 'text' => 'Pakketpost'),
            array('id' => '14603', 'text' => 'Verzending met ontvangstbevestiging'),
            array('id' => '14604', 'text' => 'Andere verzendservice')
          );

        case 'BNL':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '12301', 'text' => 'Standaardverzending'),
            array('id' => '12302', 'text' => 'Verzending met prioriteit'),
            array('id' => '12303', 'text' => 'Pakketpost'),
            array('id' => '12304', 'text' => 'Verzending met ontvangstbevestiging'),
            array('id' => '12305', 'text' => 'Andere verzendservice')
          );

        case 'BFR':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '2301', 'text' => 'Livraison standard'),
            array('id' => '2302', 'text' => 'Livraison express'),
            array('id' => '2303', 'text' => 'Colis'),
            array('id' => '2304', 'text' => 'Courrier en recommandé'),
            array('id' => '2305', 'text' => 'Autre service de livraison')
          );
      }
    }

    function &getShippingServicesGlobal($site)
    {
      switch($site) {

        case 'US':
        case 'EMO':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '50001', 'text' => 'Standard Shipping (fixed only)'),
            array('id' => '50002', 'text' => 'Express Shipping (fixed only)'),
            array('id' => '50010', 'text' => 'UPS Worldwide Express Plus'),
            array('id' => '50011', 'text' => 'UPS Worldwide Express'),
            array('id' => '50012', 'text' => 'UPS Worldwide Expedited'),
            array('id' => '50013', 'text' => 'UPS Standard To Canada'),
            array('id' => '50022', 'text' => 'USPS First Class Mail International'),
            array('id' => '50023', 'text' => 'USPS Priority Mail'),
            array('id' => '50025', 'text' => 'USPS Priority Mail Flat Rate Envelope'),
            array('id' => '50026', 'text' => 'USPS Priority Mail Flat Rate Box'),
            array('id' => '50024', 'text' => 'USPS Express Mail'),
            array('id' => '50027', 'text' => 'USPS Express Mail Flat Rate Envelope'),
            array('id' => '50014', 'text' => 'Other (See description)'),
            array('id' => '50003', 'text' => 'USPS Global Express Mail (OBSOLETE)'),
            array('id' => '50005', 'text' => 'USPS Global Priority Mail (OBSOLETE)'),
            array('id' => '50006', 'text' => 'USPS Economy Parcel Post (OBSOLETE)'),
            array('id' => '50007', 'text' => 'USPS Economy Letter Post (OBSOLETE)'),
            array('id' => '50008', 'text' => 'USPS Airmail Letter Post (OBSOLETE)'),
            array('id' => '50009', 'text' => 'USPS Airmail Parcel Post (OBSOLETE)'),
          );

        case 'CA':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '50201', 'text' => 'Standard Shipping'),
            array('id' => '50202', 'text' => 'Express Shipping'),
            array('id' => '50203', 'text' => 'Other (See description)'),
            array('id' => '50204', 'text' => 'Canada Post Expedited Parcel - USA'),
            array('id' => '50205', 'text' => 'Canada Post Small Packets - USA'),
            array('id' => '50206', 'text' => 'Canada Post Xpresspost - USA'),
            array('id' => '50207', 'text' => 'Canada Post Xpresspost - Global'),
            array('id' => '50208', 'text' => 'Canada Post International Parcel - Groud'),
            array('id' => '50209', 'text' => 'Canada Post International Parcel - Air'),
            array('id' => '50210', 'text' => 'Small Packets - International'),
            array('id' => '50211', 'text' => 'Purolator International')
          );

        case 'UK':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '50301', 'text' => 'Standard Shipping'),
            array('id' => '50302', 'text' => 'Royal Mail Airmail'),
            array('id' => '50303', 'text' => 'Royal Mail Airsure '),
            array('id' => '50304', 'text' => 'Royal Mail Surface Mail'),
            array('id' => '50305', 'text' => 'Royal Mail International Signed-for'),
            array('id' => '50306', 'text' => 'Royal Mail HM Forces Mail'),
            array('id' => '50307', 'text' => 'Parcelforce International Datapost'),
            array('id' => '50308', 'text' => 'Parcelforce Ireland 24'),
            array('id' => '50309', 'text' => 'Parcelforce Euro 48'),
            array('id' => '50310', 'text' => 'Parcelforce International Scheduled'),
            array('id' => '50311', 'text' => 'Other (See description)'),
            array('id' => '50312', 'text' => 'Collect in person')
          );

        case 'AU':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '51507', 'text' => 'Standard Shipping'),
            array('id' => '51508', 'text' => 'Express Shipping'),
            array('id' => '51501', 'text' => 'EMS International Courier - Parcels'),
            array('id' => '51502', 'text' => 'EMS International Courier - Documents'),
            array('id' => '51503', 'text' => 'Express Post International - Documents'),
            array('id' => '51504', 'text' => 'Air Mail'),
            array('id' => '51505', 'text' => 'Economy Air'),
            array('id' => '51506', 'text' => 'Sea Mail'),
            array('id' => '51509', 'text' => 'Other (See description)')
          );

        case 'AT':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '51602', 'text' => 'Unversicherter Versand'),
            array('id' => '51603', 'text' => 'Versicherter Versand'),
            array('id' => '51610', 'text' => 'Sonstiger Versand (Siehe Artikelbeschreibung)'),
            array('id' => '51611', 'text' => 'Unversicherter Express - Versand'),
            array('id' => '51612', 'text' => 'Versicherter Express - Versand')
          );

        case 'FR':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '57101', 'text' => 'Envoi Standard'),
            array('id' => '57102', 'text' => 'Envoi Express'),
            array('id' => '57103', 'text' => 'Autre mode d\'envoi (voir description)'),
            array('id' => '57104', 'text' => 'La Poste - Courrier International Prioritaire'),
            array('id' => '57105', 'text' => 'La Poste - Courrier International Economique'),
            array('id' => '57106', 'text' => 'La Poste - Colis Postal Prioritaire'),
            array('id' => '57107', 'text' => 'La Poste - Colis Postal Economique'),
            array('id' => '57108', 'text' => 'Emballage Colissimo International'),
            array('id' => '57109', 'text' => 'Chronopost Classic International'),
            array('id' => '57110', 'text' => 'Chronopost Premium International'),
            array('id' => '57111', 'text' => 'UPS Standard'),
            array('id' => '57112', 'text' => 'UPS Express'),
            array('id' => '57113', 'text' => 'DHL')
          );

        case 'DE':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '57702', 'text' => 'Unversicherter Versand'),
            array('id' => '57703', 'text' => 'Versicherter Versand'),
            array('id' => '57711', 'text' => 'DHL Postpaket International'),
            array('id' => '57712', 'text' => 'DHL P�kchen International'),
            array('id' => '57720', 'text' => 'Sonstiger Versand (Siehe Artikelbeschreibung)'),
            array('id' => '57721', 'text' => 'Unversicherter Express - Versand'),
            array('id' => '57722', 'text' => 'Versicherter Express - Versand'),
            array('id' => '57723', 'text' => 'Deutsche Post Brief (Land)'),
            array('id' => '57724', 'text' => 'Deutsche Post Brief (Luft)'),
            array('id' => '57725', 'text' => 'iloxx Europa'),
            array('id' => '57726', 'text' => 'iloxx World Wide')
          );

        case 'IT':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '60101', 'text' => 'Spedizione internazionale standard a prezzo fisso'),
            array('id' => '60102', 'text' => 'Spedizione internazionale celere a prezzo fisso'),
            array('id' => '60103', 'text' => 'Altre spedizioni internazionali (vedi descrizione)')
          );

        case 'ES':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '68601', 'text' => 'Env�s internacionales est�dar'),
            array('id' => '68602', 'text' => 'Env�s internacionales urgentes est�dar'),
            array('id' => '68603', 'text' => 'Otros env�s internacionales (ver descripci�)'),
            array('id' => '68604', 'text' => 'Cartas y tarjetas postales internacionales'),
            array('id' => '68605', 'text' => 'Ems postal expres internacional'),
            array('id' => '68606', 'text' => 'Paquete internacional economico')
          );

        case 'CH':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '69313', 'text' => 'ECONOMY Sendungen'),
            array('id' => '69314', 'text' => 'PRIORITY Sendungen'),
            array('id' => '69315', 'text' => 'URGENT Sendungen')
          );

        case 'NL':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '64601', 'text' => 'TPG Post/TNT'),
            array('id' => '64602', 'text' => 'UPS'),
            array('id' => '64603', 'text' => 'Fedex'),
            array('id' => '64604', 'text' => 'DHL'),
            array('id' => '64605', 'text' => 'DPD (Germany)'),
            array('id' => '64606', 'text' => 'GLS (Business only)'),
            array('id' => '64607', 'text' => 'Vaste kosten standaard internationale verzending'),
            array('id' => '64608', 'text' => 'Vaste kosten versnelde internationale verzending'),
            array('id' => '64609', 'text' => 'Andere internationale verzending (zie beschrijving)')
          );

        case 'BNL':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '62301', 'text' => 'De Post'),
            array('id' => '62302', 'text' => 'UPS'),
            array('id' => '62303', 'text' => 'Fedex'),
            array('id' => '62304', 'text' => 'DHL'),
            array('id' => '62305', 'text' => 'TPG Post/TNT (Netherlands)'),
            array('id' => '62306', 'text' => 'La Poste (France)'),
            array('id' => '62307', 'text' => 'Vaste kosten standaard internationale verzending'),
            array('id' => '62308', 'text' => 'Vaste kosten versnelde internationale verzending'),
            array('id' => '62309', 'text' => 'Andere internationale verzending (zie beschrijving)')
          );

        case 'BFR':

          return array(
            array('id' => '0', 'text' => '[ -- Select One -- ]'),
            array('id' => '52301', 'text' => 'De Post'),
            array('id' => '52302', 'text' => 'UPS'),
            array('id' => '52303', 'text' => 'Fedex'),
            array('id' => '52304', 'text' => 'DHL'),
            array('id' => '52305', 'text' => 'TPG Post/TNT (Netherlands)'),
            array('id' => '52306', 'text' => 'Frais de livraison internationale fixes'),
            array('id' => '52307', 'text' => 'Frais fixes pour livraison internationale express'),
            array('id' => '52308', 'text' => 'Autres livraisons internationales (voir description)'),
            array('id' => '52309', 'text' => 'La Poste (France)')
          );
      }
    }

    function &getShippingPackages()
    {
      return array(
        array('id' => '0', 'text' => '[ -- Select One -- ]'),
        array('id' => '1', 'text' => 'Letter'),
        array('id' => '2', 'text' => 'Large envelope'),
        array('id' => '3', 'text' => 'USPS flat rate envelope'),
        array('id' => '4', 'text' => 'Package/thick envelope'),
        array('id' => '5', 'text' => 'USPS large package/oversize 1'),
        array('id' => '6', 'text' => 'Very large package/oversize 2'),
        array('id' => '7', 'text' => 'UPS Letter')
      );
    }

    function &getSalesEmailTypes($arr = array())
    {
      $arr[] = array('id' => 'INVOICE', 'text' => TEXT_EMAIL_INVOICE);
      $arr[] = array('id' => 'REMINDER', 'text' => TEXT_EMAIL_REMINDER);
      $arr[] = array('id' => 'WARNING', 'text' => TEXT_EMAIL_WARNING);

      return $arr;
    }

    function &getFeedbackTypes($arr = array())
    {
      $arr[] = array('id' => '+', 'text' => TEXT_FEEDBACK_POSITIVE);
      $arr[] = array('id' => 'N', 'text' => TEXT_FEEDBACK_NEUTRAL);
      $arr[] = array('id' => '-', 'text' => TEXT_FEEDBACK_NEGATIVE);

      return $arr;
    }

    function &getSaleTypes($arr = array())
    {
      $arr[] = array('id' => '3', 'text' => TEXT_SALES_NOT_CHECKED_OUT);
      $arr[] = array('id' => '4', 'text' => TEXT_SALES_CHECKED_OUT);
      $arr[] = array('id' => '5', 'text' => TEXT_SALES_COMPLETED);

      return $arr;
    }

    function &getListingsTypes($arr = array())
    {
      $arr[] = array('id' => 'PENDING', 'text' => TEXT_LISTINGS_PENDING);
      $arr[] = array('id' => 'ACTIVE', 'text' => TEXT_LISTINGS_ACTIVE);
      $arr[] = array('id' => 'ENDED', 'text' => TEXT_LISTINGS_ENDED);
      $arr[] = array('id' => 'CANCELED', 'text' => TEXT_LISTINGS_CANCELED);
      $arr[] = array('id' => 'FAILED', 'text' => TEXT_LISTINGS_FAILED);
      $arr[] = array('id' => 'SOLD', 'text' => TEXT_LISTINGS_SOLD);
      $arr[] = array('id' => 'UNSOLD', 'text' => TEXT_LISTINGS_UNSOLD);

      return $arr;
    }

    function &getShippingWeightUnits()
    {
      return array(
        array('id' => '0', 'text' => TEXT_NO_CALCULATED_SHIPPING),
        array('id' => '1', 'text' => TEXT_WEIGHT_UNIT_LBS),
        array('id' => '2', 'text' => TEXT_WEIGHT_UNIT_KGS)
      );
    }

    function &getUSATaxRegions()
    {
      return array(
        array('id' => '', 'text' => '[No sales tax]'),
        array('id' => 'AL', 'text' => 'Alabama'),
        array('id' => 'AK', 'text' => 'Alaska'),
        //array('id' => 'AS', 'text' => 'American Samoa'),
        array('id' => 'AZ', 'text' => 'Arizona'),
        array('id' => 'AR', 'text' => 'Arkansas'),
        array('id' => 'CA', 'text' => 'California'),
        array('id' => 'CO', 'text' => 'Colorado'),
        array('id' => 'CT', 'text' => 'Connecticut'),
        array('id' => 'DE', 'text' => 'Delaware'),
        array('id' => 'DC', 'text' => 'District of Columbia'),
        array('id' => 'FL', 'text' => 'Florida'),
        array('id' => 'GA', 'text' => 'Georgia'),
        array('id' => 'GU', 'text' => 'Guam'),
        array('id' => 'HI', 'text' => 'Hawaii'),
        array('id' => 'ID', 'text' => 'Idaho'),
        array('id' => 'IL', 'text' => 'Illinois'),
        array('id' => 'IN', 'text' => 'Indiana'),
        array('id' => 'IA', 'text' => 'Iowa'),
        array('id' => 'KS', 'text' => 'Kansas'),
        array('id' => 'KY', 'text' => 'Kentucky'),
        array('id' => 'LA', 'text' => 'Louisiana'),
        array('id' => 'ME', 'text' => 'Maine'),
        //array('id' => 'MH', 'text' => 'Marshall Islands'),
        array('id' => 'MD', 'text' => 'Maryland'),
        array('id' => 'MA', 'text' => 'Massachusetts'),
        array('id' => 'MI', 'text' => 'Michigan'),
        array('id' => 'MN', 'text' => 'Minnesota'),
        array('id' => 'MS', 'text' => 'Mississippi'),
        array('id' => 'MO', 'text' => 'Missouri'),
        array('id' => 'MT', 'text' => 'Montana'),
        array('id' => 'NE', 'text' => 'Nebraska'),
        array('id' => 'NV', 'text' => 'Nevada'),
        array('id' => 'NH', 'text' => 'New Hampshire'),
        array('id' => 'NJ', 'text' => 'New Jersey'),
        array('id' => 'NM', 'text' => 'New Mexico'),
        array('id' => 'NY', 'text' => 'New York'),
        array('id' => 'NC', 'text' => 'North Carolina'),
        array('id' => 'ND', 'text' => 'North Dakota'),
        //array('id' => 'MP', 'text' => 'Northern Mariana Islands'),
        array('id' => 'OH', 'text' => 'Ohio'),
        array('id' => 'OK', 'text' => 'Oklahoma'),
        array('id' => 'OR', 'text' => 'Oregon'),
        //array('id' => 'PW', 'text' => 'Palau'),
        array('id' => 'PA', 'text' => 'Pennsylvania'),
        //array('id' => 'PR', 'text' => 'Puerto Rico'),
        array('id' => 'RI', 'text' => 'Rhode Island'),
        array('id' => 'SC', 'text' => 'South Carolina'),
        array('id' => 'SD', 'text' => 'South Dakota'),
        array('id' => 'TN', 'text' => 'Tennessee'),
        array('id' => 'TX', 'text' => 'Texas'),
        array('id' => 'UT', 'text' => 'Utah'),
        array('id' => 'VT', 'text' => 'Vermont'),
        //array('id' => 'VI', 'text' => 'Virgin Islands'),
        array('id' => 'VA', 'text' => 'Virginia'),
        array('id' => 'WA', 'text' => 'Washington'),
        array('id' => 'WV', 'text' => 'West Virginia'),
        array('id' => 'WI', 'text' => 'Wisconsin'),
        array('id' => 'WY', 'text' => 'Wyoming')
      );
    }

    function &getCanadianTaxRegions()
    {
      return array(
        array('id' => '', 'text' => '[No sales tax]'),
        array('id' => 'AB', 'text' => 'Alberta'),
        array('id' => 'BC', 'text' => 'British Columbia'),
        array('id' => 'MB', 'text' => 'Manitoba'),
        array('id' => 'NB', 'text' => 'New Brunswick'),
        array('id' => 'NL', 'text' => 'Newfoundland and Labrodor'),
        array('id' => 'NS', 'text' => 'Nova Scotia'),
        array('id' => 'NT', 'text' => 'Northwest Territories'),
        array('id' => 'NU', 'text' => 'Nunavut'),
        array('id' => 'ON', 'text' => 'Ontario'),
        array('id' => 'PE', 'text' => 'Prince Edward Island'),
        array('id' => 'QC', 'text' => 'Quebec'),
        array('id' => 'SK', 'text' => 'Saskatchewan'),
        array('id' => 'YT', 'text' => 'Yukon'),
      );
    }

    function &getSchedulerIntervals($array = array())
    {
      $array[] = array('id' => '1', 'text' => TEXT_TIME_MINUTES);
      $array[] = array('id' => '2', 'text' => TEXT_TIME_HOURS);
      $array[] = array('id' => '3', 'text' => TEXT_TIME_DAYS);
      $array[] = array('id' => '4', 'text' => TEXT_TIME_WEEKS);

      return $array;
    }

    function &getTimeHoursList($array = array())
    {
      for($i=1; $i <= 12; $i++)
        $array[] =  array('id' =>"$i", 'text' => "$i");

      return $array;
    }

    function &getSchedulerTimeMinutesList($array = array())
    {
      $array[] = array('id' => '00', 'text' => '00');
      $array[] = array('id' => '05', 'text' => '05');
      $array[] = array('id' => '10', 'text' => '10');
      $array[] = array('id' => '15', 'text' => '15');
      $array[] = array('id' => '20', 'text' => '20');
      $array[] = array('id' => '25', 'text' => '25');
      $array[] = array('id' => '30', 'text' => '30');
      $array[] = array('id' => '35', 'text' => '35');
      $array[] = array('id' => '40', 'text' => '40');
      $array[] = array('id' => '45', 'text' => '45');
      $array[] = array('id' => '50', 'text' => '50');
      $array[] = array('id' => '55', 'text' => '55');

      return $array;
    }

    function &getTimeAMPMList($array = array())
    {
      $array[] = array('id' => 'AM', 'text' => 'AM');
      $array[] = array('id' => 'PM', 'text' => 'PM');

      return $array;
    }

    function getReturnPolicyNumberOfDays($site)
    {
      return array(
        array('id' => '32031', 'text' => TEXT_RETURN_POLICY_THREE_DAYS),
        array('id' => '32032', 'text' => TEXT_RETURN_POLICY_SEVEN_DAYS),
        array('id' => '32035', 'text' => TEXT_RETURN_POLICY_FOURTEEN_DAYS),
        array('id' => '32036', 'text' => TEXT_RETURN_POLICY_THIRTY_DAYS)
      );
    }

    function getReturnPolicyRefundType($site)
    {
      return array(
        array('id' => '32038', 'text' => TEXT_RETURN_POLICY_TYPE_EXCHANGE),
        array('id' => '32039', 'text' => TEXT_RETURN_POLICY_TYPE_CREDIT),
        array('id' => '32037', 'text' => TEXT_RETURN_POLICY_TYPE_REFUND)
      );
    }

    function getCharacterSetSiteId($site)
    {
      switch(strtoupper($site)) {
        case 'US':
          return '2135';

        case 'CA':
          return '2276';

        case 'UK':
          return '2183';

        case 'AU':
          return '2350';

        case 'AT':
          return '2243';

        case 'FR':
          return '2769';

        case 'DE':
          return '2136';

        case 'IT':
          return '2182';

        case 'ES':
          return '3015';

        case 'CH':
          return '2254';

        case 'EMO':
          return ''; //return '2318';

      }
    }
  }//end class
?>