<?php
/*
  $Id: abxOrderCart.php,v 1.15 2008/03/31 18:17:58 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if (class_exists('abxTax') === false) {

	require_once(DIR_FS_ABX_EXTERNAL_CART . 'includes/classes/abxTax.php');

  }

  if (class_exists('abxCart') === false) {
    require_once(DIR_FS_ABX_CLASSES . 'abxCart.php');
  }

  class abxOrderCart extends abxCart
  {

    function internal_get_auction_products()
    {
      $abxItems = parent::internal_get_auction_products();

      $countItems = count($abxItems);

      $excludeArray = (array)$_POST['abxList'];
      if (empty($excludeArray) === false)
        foreach($abxItems as $id => $product)
         if ($countItems > 1 && !in_array($product['id'],$excludeArray))
            $abxItems[$id]['is_excluded'] = true;
          else
            $abxItems[$id]['is_excluded'] = false;

      return $abxItems;
    }


    function calculateCart()
    {
      global $abxDatabase;
      
      $languages_id = abxRegistry::get("languages_id");

      //Assume physical content-type is sent to shipping address
      $tax_address = array(
        'entry_country_id' => $this->delivery['country_id'],
        'entry_zone_id'    => $this->delivery['zone_id']
      );

      $products = $this->get_products();
      $nShippingCost = 0;

      for($i = 0, $n = sizeof($products); $i < $n; $i++) {

        if (!empty($products[$i]['shipping'])) {
          $nShippingCost += $products[$i]['shipping'];
        }

        $this->products[$i] = array(
          'qty'             => $products[$i]['quantity'],
          'name'            => $products[$i]['name'],
          'model'           => $products[$i]['model'],
          'tax'             => abxTax::getTaxRate($products[$i]['tax_class_id'],$tax_address['entry_country_id'],$tax_address['entry_zone_id']),
          'tax_description' => abxTax::getTaxRateDescription($products[$i]['tax_class_id'],$tax_address['entry_country_id'],$tax_address['entry_zone_id']),
          'price'           => $products[$i]['price'],
          'final_price'     => $products[$i]['price'] + $this->attributes_price($products[$i]['id']),
          'weight'          => $products[$i]['weight'],
          'id'              => $products[$i]['id'],
          'is_excluded'     => $products[$i]['is_excluded']
        );

        if ($products[$i]['attributes']) {

          $subindex = 0;

          reset($products[$i]['attributes']);

          while(list($option, $value) = each($products[$i]['attributes'])) {

            $attributes = $abxDatabase->fetch_row("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa where pa.products_id = '" . (int)$products[$i]['id'] . "' and pa.options_id = '" . (int)$option . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . (int)$value . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . (int)$languages_id . "' and poval.language_id = '" . (int)$languages_id . "'");

            $this->products[$i]['attributes'][$subindex++] = array(
              'option'    => $attributes['products_options_name'],
              'value'     => $attributes['products_options_values_name'],
              'option_id' => $option,
              'value_id'  => $value,
              'prefix'    => $attributes['price_prefix'],
              'price'     => $attributes['options_values_price']
            );

          }

        }

        if ($this->products[$i]['is_excluded'])
          continue;

        // gross
        $shown_price_gross = abxTax::addTax($this->products[$i]['final_price'], $this->products[$i]['tax']) * $this->products[$i]['qty'];

        // net
        $shown_price = $this->products[$i]['final_price'] * $this->products[$i]['qty'];

        // gross
        $this->info['subtotal_gross'] += $shown_price_gross;

        // net
        $this->info['subtotal'] += $shown_price;

        $products_tax = $this->products[$i]['tax'];

        $products_tax_description = $this->products[$i]['tax_description'];

        // gross
        $this->info['tax_gross'] += $shown_price_gross - ($shown_price_gross / (($products_tax < 10) ? "1.0" . str_replace('.', '', $products_tax) : "1." . str_replace('.', '', $products_tax)));
        if (isset($this->info['tax_groups_gross']["$products_tax_description"])) {
          $this->info['tax_groups_gross']["$products_tax_description"] += $shown_price_gross - ($shown_price_gross / (($products_tax < 10) ? "1.0" . str_replace('.', '', $products_tax) : "1." . str_replace('.', '', $products_tax)));
        } else {
          $this->info['tax_groups_gross']["$products_tax_description"] = $shown_price_gross - ($shown_price_gross / (($products_tax < 10) ? "1.0" . str_replace('.', '', $products_tax) : "1." . str_replace('.', '', $products_tax)));
        }

        // net
        $this->info['tax'] += ($products_tax / 100) * $shown_price;

        if (isset($this->info['tax_groups']["$products_tax_description"])) {

          $this->info['tax_groups']["$products_tax_description"] += ($products_tax / 100) * $shown_price;

        } else {

          $this->info['tax_groups']["$products_tax_description"] = ($products_tax / 100) * $shown_price;

        }

      }//end foreach product

      $this->info['shipping_cost'] = $nShippingCost;

      // gross
      $this->info['total_gross'] = $this->info['subtotal_gross'] + $this->info['shipping_cost'];

      // net
      //$this->info['total'] = $this->info['subtotal'] + $this->info['tax'] + $this->info['shipping_cost'];
      $this->info['total'] = $this->info['subtotal'] + $this->info['shipping_cost'];

      if(!empty($this->paypal)) {

        $this->info['total'] = $this->paypal->mc_gross;

        $this->info['tax'] = $this->paypal->tax;

        if (empty($this->info['shipping_cost'])) {
          $this->info['shipping_cost'] = $this->info['total']- $this->info['tax'] - $this->info['subtotal'];
        }

      }
    }

    function displayTaxPrice($amount, $tax, $qty = 1)
    {
      global $currencies;

      if ($tax > 0)
        return $currencies->format(abxTax::addTax($amount, $tax) * $qty, true, $this->info['currency'], $this->info['currency_value']);

      return $currencies->format($amount * $qty, true, $this->info['currency'], $this->info['currency_value']);
    }

    function displayPrice($amount, $tax, $qty = 1)
    {
      global $currencies;

      if (DISPLAY_PRICE_WITH_TAX == 'true' && $tax > 0)
        return $currencies->format(abxTax::addTax($amount, $tax) * $qty, true, $this->info['currency'], $this->info['currency_value']);

      return $currencies->format($amount * $qty, true, $this->info['currency'], $this->info['currency_value']);
    }

    function updateProducts($order_id)
    {
      global $abxDatabase;
      $languages_id = abxRegistry::get("languages_id");
      

      // initialized for the email confirmation
      $this->products_ordered = '';

      for($i = 0, $n = sizeof($this->products); $i < $n; $i++) {

        if ($this->products[$i]['is_excluded'])
          continue;

        $products_id = abx_get_prid($this->products[$i]['id']);

        // Stock Update - Joao Correia
        if (STOCK_LIMITED == 'true') {

          if (DOWNLOAD_ENABLED == 'true') {

            $stock_query_raw = "SELECT products_quantity, pad.products_attributes_filename " .
                               "FROM " . TABLE_PRODUCTS . " p " .
                               "LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES . " pa " .
                               "ON p.products_id=pa.products_id " .
                               "LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad " .
                               "ON pa.products_attributes_id=pad.products_attributes_id " .
                               "WHERE p.products_id = " . (int)$products_id;

            // Will work with only one option for downloadable products
            // otherwise, we have to build the query dynamically with a loop
            $products_attributes = $this->products[$i]['attributes'];

            if (is_array($products_attributes))
              $stock_query_raw .= " AND pa.options_id = '" . $products_attributes[0]['option_id'] . "' AND pa.options_values_id = '" . $products_attributes[0]['value_id'] . "'";

            $stock_values = $abxDatabase->fetch_row($stock_query_raw);

          } else {

            $stock_values = $abxDatabase->fetch_row("select products_quantity from " . TABLE_PRODUCTS . " where products_id = " . (int)$products_id);

          }

          if (!empty($stock_values) > 0) {

               // do not decrement quantities if products_attributes_filename exists
                if (DOWNLOAD_ENABLED != 'true' || !$stock_values['products_attributes_filename'])

                  $stock_left = $stock_values['products_quantity'] - $this->products[$i]['qty'];

                else

                  $stock_left = $stock_values['products_quantity'];

                $abxDatabase->update(TABLE_PRODUCTS, array('products_quantity' => $stock_left), 'products_id = ' . (int)$products_id);

                if ($stock_left < 1 && STOCK_ALLOW_CHECKOUT == 'false')

                  $abxDatabase->update(TABLE_PRODUCTS, array('products_status' => 0), 'products_id = ' . (int)$products_id);

          }

        }

        // Update products_ordered (for bestsellers list)
        $query = "UPDATE " . TABLE_PRODUCTS . " SET products_ordered = products_ordered + {$this->products[$i]['qty']} WHERE products_id = " . (int)$products_id;
        $abxDatabase->query($query);

        $sql_data_array = array(
          'orders_id' => $order_id,
          'products_id' => $products_id,
          'products_model' => $this->products[$i]['model'],
          'products_name' => $this->products[$i]['name'],
          'products_price' => $this->products[$i]['price'],
          'final_price' => $this->products[$i]['final_price'],
          'products_tax' => $this->products[$i]['tax'],
          'products_quantity' => $this->products[$i]['qty']
        );

        // Yuck - TODO: Move order mgmt to cart-specific folders        
        if(CART_INTEGRATION === 'zencart')
        {
          $sql_data_array['products_prid'] = $products_id;
          $sql_data_array['products_priced_by_attribute'] = 0;
          $sql_data_array['product_is_free'] = 0;
          $sql_data_array['products_discount_type'] = 0;
          $sql_data_array['products_discount_type_from'] = 0;
        }        

        $order_products_id = $abxDatabase->insert(TABLE_ORDERS_PRODUCTS, $sql_data_array);

        // ------insert customer choosen option to order--------
        $attributes_exist = '0';

        $products_ordered_attributes = '';

        if (isset($this->products[$i]['attributes'])) {

          $attributes_exist = '1';

          for($j = 0, $n2 = sizeof($this->products[$i]['attributes']); $j < $n2; $j++) {

            if (DOWNLOAD_ENABLED == 'true') {

              $attributes_query = "select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix, pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename
                from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                left join " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                on pa.products_attributes_id=pad.products_attributes_id
                where pa.products_id = '" . $this->products[$i]['id'] . "'
                and pa.options_id = '" . $this->products[$i]['attributes'][$j]['option_id'] . "'
                and pa.options_id = popt.products_options_id
                and pa.options_values_id = '" . $this->products[$i]['attributes'][$j]['value_id'] . "'
                and pa.options_values_id = poval.products_options_values_id
                and popt.language_id = " . (int)$languages_id . "
                and poval.language_id = " . (int)$languages_id;

              $attributes_values = $abxDatabase->fetch_results($attributes_query);

            } else {

              $attributes_values = $abxDatabase->fetch_results("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa where pa.products_id = '" . $this->products[$i]['id'] . "' and pa.options_id = '" . $this->products[$i]['attributes'][$j]['option_id'] . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . $this->products[$i]['attributes'][$j]['value_id'] . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . $languages_id . "' and poval.language_id = '" . $languages_id . "'");

            }

            $sql_data_array = array(
              'orders_id' => $order_id,
              'orders_products_id' => $order_products_id,
              'products_options' => $attributes_values['products_options_name'],
              'products_options_values' => $attributes_values['products_options_values_name'],
              'options_values_price' => $attributes_values['options_values_price'],
              'price_prefix' => $attributes_values['price_prefix']
            );

            $abxDatabase->insert(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);

            if ((DOWNLOAD_ENABLED == 'true') && isset($attributes_values['products_attributes_filename']) && abx_not_null($attributes_values['products_attributes_filename'])) {

              $sql_data_array = array(
                'orders_id' => $order_id,
                'orders_products_id' => $order_products_id,
                'orders_products_filename' => $attributes_values['products_attributes_filename'],
                'download_maxdays' => $attributes_values['products_attributes_maxdays'],
                'download_count' => $attributes_values['products_attributes_maxcount']
              );

              $abxDatabase->insert(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);

            }

            $products_ordered_attributes .= "\n\t" . $attributes_values['products_options_name'] . ' ' . $attributes_values['products_options_values_name'];

          }

        }

        $products_ordered_price = $this->displayPrice($this->products[$i]['final_price'],$this->products[$i]['tax'],$this->products[$i]['qty']);

        $this->products_ordered .= $this->products[$i]['qty'] . ' x ' . $this->products[$i]['name'] . ' (' . $this->products[$i]['model'] . ') = ' . $products_ordered_price . $products_ordered_attributes . "\n";

      }
    }

  }//end class
?>