<?php
/*
  $Id: abxSales.php,v 1.29 2008/12/15 00:47:29 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if (class_exists('abxManager') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'abxManager.php');

  }

  if (class_exists('abxPage') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'Page/abxPage.php');

  }

  class abxSales extends abxManager {

    function &getSales($filter = null, $orderStatus = null, $isArchived = 0)
    {
      global $abxDatabase;
      
      $languages_id = abxRegistry::get("languages_id");
      
      $auction_query_raw =
        "select DISTINCT SQL_CALC_FOUND_ROWS" .
        " a.auction_basket_id as id, " .
        " a.site, a.listing_type, a.quantity as qty," .
        " a.ext_id, a.ext_title, a.ext_desc," .
        " a.quantity, a.price_start, a.price_end," .
        " a.insurance, a.shipping, a.sales_tax as tax, " .
        " a.products_id, a.time_start, a.time_end, a.listing_status, a.currency, a.orders_id," .
        " a.payment_provider, a.payment_transaction_id, a.payment_amount, a.payment_fee, a.payment_currency, " .
        " si.url," .
        " b.ext_email_address, b.ext_customer_id, b.customers_id," .
        " w.label as workflow_label, f.label as feedback_label," .
        " w.state_id as workflow_state_id, f.state_id as feedback_state_id," .
        " o.orders_status," .
        " os.orders_status_name" .
        " FROM " . TABLE_ABX_BASKET . " a" .
        " LEFT JOIN " . TABLE_ABX_SITES . " si on (a.auction_house_id = si.auction_house_id and a.site = si.site)" .
        " LEFT JOIN " . TABLE_ABX_WINNERS . " b on (a.auction_winner_id = b.auction_winner_id)" .
        " LEFT JOIN " . TABLE_ABX_FEEDBACK_STATE . " f on (a.feedback_left = f.state_id)" .
        " LEFT JOIN " . TABLE_ABX_WORKFLOW_STATE . " w on (a.workflow_state = w.state_id)" .
        " LEFT JOIN " . TABLE_ORDERS . " o on (a.orders_id = o.orders_id)" .
        " LEFT JOIN " . TABLE_ORDERS_STATUS . " os on (o.orders_status = os.orders_status_id)" .
        " WHERE (w.language_id = $languages_id OR w.language_id IS NULL)" . // should NEVER be NULL
        " AND (f.language_id = $languages_id OR f.language_id IS NULL)" . // should NEVER be NULL
        " AND (os.language_id = $languages_id OR os.language_id IS NULL)" .  // will be NULL if there is no order
        " AND a.archived = $isArchived";
        
      if (empty($filter) === false) 
      {
        $auction_query_raw .= " AND a.listing_status = " . (int)$filter;
      }
      
      if (empty($orderStatus) === false) 
      {
        $auction_query_raw .= " AND o.orders_status = " . (int)$orderStatus;
      }

      return $auction_query_raw;
    }

    function remove($auction_basket_id)
    {
      global $abxDatabase;

      return $abxDatabase->delete(TABLE_ABX_BASKET,"auction_basket_id in (" . implode(',',$auction_basket_id) . ")");
    }

    function sendInvoice(&$abxList)
    {
      $uuids = $this->getAuctionSaleUuids($abxList);

      if (empty($uuids) === false) {

        $abxAPI = new abxAPI;

        $array = array(
          'defaultProfileId' => $_POST['defaultProfileId'],
          'uuids' => $uuids
        );

        $response = $abxAPI->call('email.sendWinningBidderEmail',$array);

        if ($response['code'] == 'success') {

          foreach($abxList as $id)
            $this->setNextWorkflowState($id,'INVOICE');

          abxMessageStack::add_session(SUCCESS_TEXT_SALE_INVOICES_SENT, 'success');

        } else {

          abxMessageStack::add_session(ERROR_TEXT_SALE_INVOICE_SEND_FAILED, 'error');

        }

      }
    }

    function sendReminder(&$abxList)
    {
      $uuids = $this->getAuctionSaleUuids($abxList);

      if (empty($uuids) === false) {

        $abxAPI = new abxAPI;

        $array = array(
          'defaultProfileId' => $_POST['defaultProfileId'],
          'uuids' => $uuids
        );

        $response = $abxAPI->call('email.sendReminderEmail',$array);

        if ($response['code'] == 'success') {

          foreach($abxList as $id)
           $this->setNextWorkflowState($id,'REMINDER');

          abxMessageStack::add_session(SUCCESS_TEXT_SALE_REMINDERS_SENT, 'success');

        } else {

          abxMessageStack::add_session(ERROR_TEXT_SALE_REMINDER_SEND_FAILED, 'error');

        }

      }
    }

    function sendWarning(&$abxList)
    {
      $uuids = $this->getAuctionSaleUuids($abxList);

      if (empty($uuids) === false) {

        $abxAPI = new abxAPI;

        $array = array(
          'defaultProfileId' => $_POST['defaultProfileId'],
          'uuids' => $uuids
        );

        $response = $abxAPI->call('email.sendWarningEmail',$array);

        if ($response['code'] == 'success') {
          foreach($abxList as $id)
            $this->setNextWorkflowState($id,'WARNING');

          abxMessageStack::add_session(SUCCESS_TEXT_SALE_WARNINGS_SENT, 'success');

        } else {

          abxMessageStack::add_session(ERROR_TEXT_SALE_WARNING_SEND_FAILED, 'error');

        }
      }
    }

    function getWorkflowState($currentState)
    {
      global $abxDatabase;

      $state = $abxDatabase->fetch_row("SELECT label FROM " . TABLE_ABX_WORKFLOW_STATE . " WHERE state_id = '" . addslashes($currentState) . "'");

      return @$state['label'];
    }

    function getNextWorkflowState($currentState)
    {
      global $abxDatabase;

      $state = $abxDatabase->fetch_row("SELECT next_state_id FROM " . TABLE_ABX_WORKFLOW_STATE . " WHERE state_id = '" . addslashes($currentState) . "'");

      return @$state['next_state_id'];
    }

    function setNextWorkflowState($oID, $currentState)
    {
      global $abxDatabase;

      $nextState = $this->getNextWorkflowState($currentState);

      $abxDatabase->update(TABLE_ABX_BASKET, array( 'workflow_state' => $nextState),'auction_basket_id = ' . (int)$oID);
    }

    function downloadSales($seller_id)
    {
      $abxAPI = new abxAPI;
      $response = $abxAPI->callBySellerID('sale.downloadSales',$seller_id);

      if ($response['code'] == 'success')

        abxMessageStack::add_session(TEXT_REQUEST_SUCCESSFULL, 'success');

      else

        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
    }
    
    function updateStatus(&$abxList, $status)
    {
      global $abxDatabase;

      $uuids = $this->getAuctionSaleUuids($abxList);

      if(!empty($uuids)) {

        $abxAPI = new abxAPI();
        $response = $abxAPI->call('sale.updateStatus', array('status' => $status,'uuids' => $uuids));

        if($response['code'] == 'success')
        {
          // ENDED means NOT CHECKED OUT.  Any time we are moving a sale to not checked out, we want to clear
          // any prior order id so that the user may go back through checkout.  Let's also clear any attributes
          // so the user can go back thru checkout.
          if($status == $this->ENDED)  
          {
            $abxDatabase->delete(TABLE_ABX_BASKET_ATTRIBUTES, 'auction_basket_id in (' . implode(',',$abxList) . ')');          
            $abxDatabase->update(TABLE_ABX_BASKET, array('listing_status' => $status, 'orders_id' => null), 'auction_basket_id in (' . implode(',',$abxList) . ')');          
          }
          else
          {
            $abxDatabase->update(TABLE_ABX_BASKET, array('listing_status' => $status), 'auction_basket_id in (' . implode(',',$abxList) . ')');          
          }
          abxMessageStack::add_session(TEXT_REQUEST_SUCCESSFULL, 'success');
        }
        else
        {
          abxMessageStack::add_session(ERROR_TEXT_SALE_STATUS_UPDATE_FAILED, 'error');
        }
      }
    }
    

    function restoreArchived($aArr) {
      global $abxDatabase;

      $uuids = $this->getAuctionSaleUuids($aArr);      
      
      $abxAPI = new abxAPI;
      $response = $abxAPI->call('sale.restoreSales', array('list'=> $uuids));
      
      if($response['code'] == 'success')
      {
        $abxDatabase->update(TABLE_ABX_BASKET, array( 'archived' => '0'), 'auction_basket_id in (' . implode(',', $aArr) . ')');
        abxMessageStack::add_session(TEXT_REQUEST_SUCCESSFULL, 'success');
      }
      else
      {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
      }
    }

    function archive($aArr, $sPaid, $sShipped, $nStatus) {
      global $abxDatabase;
      
      $uuids = $this->getAuctionSaleUuids($aArr);      
      
      $abxAPI = new abxAPI;
      $response = $abxAPI->call('sale.archiveSales', array('list'=> $uuids));
      
      if($response['code'] == 'success')
      {
        $abxDatabase->update(TABLE_ABX_BASKET, array( 'archived' => '1'), 'auction_basket_id in (' . implode(',', $aArr) . ')');
        abxMessageStack::add_session(TEXT_REQUEST_SUCCESSFULL, 'success');
      }
      else
      {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
      }
    }
    
    function getArchivedSalesPaginatorQuery($filter = null, $orderStatusBy = null) {
        return $this->getSales($filter, $orderStatusBy, 1);
    }
  }//end class
?>