<?php
/*
  $Id: abxSalesFeedback.php,v 1.9 2008/03/13 14:33:06 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if (class_exists('abxSales') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'abxSales.php');

  }

  class abxSalesFeedback extends abxSales {

    var $FEEDBACK_POSTIVE  = '+',
        $FEEDBACK_NEUTRAL  = 'N',
        $FEEDBACK_NEGATIVE = '-';

    function leaveFeedback(&$abxList,$type)
    {
      $uuids = $this->getAuctionSaleUuids($abxList);

      if (empty($uuids) === true)
        return;

      $abxAPI = new abxAPI;

      $array = array(
        'defaultProfileId' => $_POST['defaultProfileId'],
        'type'             => $type,
        'uuids'            => $uuids
      );

      $response = $abxAPI->call('feedback.leaveFeedback',$array);

      if ($response['code'] == 'success')
        abxMessageStack::add_session(SUCCESS_TEXT_SALE_FEEDBACK_SENT, 'success');
      else
        abxMessageStack::add_session(ERROR_TEXT_SALE_FEEDBACK_SEND_FAILED, 'error');
    }

    function leavePositiveFeedback(&$abxList)
    {
      return $this->leaveFeedback($abxList,$this->FEEDBACK_POSTIVE);
    }

    function leaveNeutralFeedback(&$abxList)
    {
      return $this->leaveFeedback($abxList,$this->FEEDBACK_NEUTRAL);
    }

    function leaveNegativeFeedback(&$abxList)
    {
      return $this->leaveFeedback($abxList,$this->FEEDBACK_NEGATIVE);
    }

    function downloadFeedback($seller_id)
    {
      $abxAPI = new abxAPI;

      $response = $abxAPI->callBySellerID('feedback.synchronize',$seller_id);

      if ($response['code'] == 'success')
        abxMessageStack::add_session(TEXT_REQUEST_SUCCESSFULL, 'success');
      else
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
    }

  }//end class
?>
