<?php
/*
  $Id: abxShipping.php,v 1.15 2008/12/15 00:47:29 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox


  The purpose of this class is to determine whether to add use osCommerce shipping modules,
  AuctionBlox shipping module, or a combination of both.  We need this class, because
  based on the answer to the question above, we had to massage certain global variables used
  by the other shipping modules.  Namely, we have to handle override these variables.
   $total_weight = $cart->show_weight();
   $total_count = $cart->count_contents();

*/
  class_exists('shipping') || require_once(DIR_WS_CLASSES . 'shipping.php');
  require_once(DIR_WS_MODULES . 'auctionblox/includes/database_tables.php');

  class abxShipping extends shipping {
    
    function quote($method = '', $module = '')
    {
      global $total_weight, $total_count;
      
      if(isset($GLOBALS['fixed']) && is_object($GLOBALS['fixed']) && $GLOBALS['fixed']->is_enabled())
      {
          $fixedModule = $GLOBALS['fixed'];
          $fixedShippingProducts = $fixedModule->getProductsApplicableForFixedShipping();

          if(sizeof($fixedShippingProducts) > 0)
          {
            $shipping = 0.0;
              $other = array();
              $fixed = array();
              
            if(sizeof($fixedShippingProducts) == sizeof($fixedModule->getAllProducts()))
            {
                // This means everything is fixed shipping, so just show fixed shipping options
              if($this->allow_other_shipping())
              {
                $other = parent::quote($method, $module);
              }
              else
              {
                $fixed[] = $fixedModule->quote($method, $module);
              }
            }
            else
            {
              // This is to support correct calculation in other shipping modules
              if(is_array($fixedShippingProducts))
              {
                $total_count -= sizeof($fixedShippingProducts);
                foreach($fixedShippingProducts as $product)
                  $total_weight -= $product['weight'];
              }
            
                // OK - So, show the shop options but add fixed shipping to those options
              $shipping = $fixedModule->calculateShipping();
              $all = parent::quote($method, $module);
              
              // Now, we have to strip out the fixed module from the list.  It had to be enabled to 
              // get the quote for the ebay items
              foreach($all as $possible)
              {
                if($possible['id'] !== 'fixed')
                  $other[] = $possible;
              }
              
              $other = $this->addShipping($other, $shipping);
              
            }
    
            return array_merge($fixed, $other);
          }
      }
      
      // Not installed, enabled or applicable.  We must be using calculated shipping options, so handling fee can apply in this case
      $quotes = parent::quote($method, $module); 
      
      $cart = $_SESSION['cart'];
      if($cart != null && is_object($cart) && method_exists($cart, 'isAbxCart') && $cart->count_auction_contents() > 0)
      {
        // We have a valid AuctionBlox cart that contains eBay items.
        $quotes = $this->addHandling($quotes);
      }

      return $quotes;
    }
    
    function addShipping(&$modules, $shipping)
    {
      for($i=0;$i<sizeof($modules);$i++)
      {
        $module =& $modules[$i];
        $methods =& $module['methods'];
        for($j=0;$j<sizeof($methods);$j++)
        {
            $method =& $methods[$j];
          $method['cost'] = ((double)$method['cost'] + $shipping);
        }
      }
      return $modules;
    }
    
    function addHandling(&$modules)
    {
      if(is_numeric(MODULE_SHIPPING_FIXED_HANDLING_FEE))
      {
          for($i=0;$i<sizeof($modules);$i++)
          {
            $module =& $modules[$i];
            $methods =& $module['methods'];
            for($j=0;$j<sizeof($methods);$j++)
            {
              $method =& $methods[$j];
              $method['cost'] = ((double)$method['cost'] + (double)MODULE_SHIPPING_FIXED_HANDLING_FEE);
            }
          }
      }
      return $modules;
    }
    
    function allow_other_shipping()
    {
      if (MODULE_SHIPPING_FIXED_DISABLE_OTHERS === 'False')
        return true;

      return false;
    }


    function cheapest()
    {
      return parent::cheapest();
    }

  }//end class
?>