<?php
/*
  $Id: items.php,v 1.9 2008/10/23 21:19:21 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Items extends abxCollatedPaginator {

    function sortDefaultArray()
    {
      return array(
        'name' => 'i.last_modified',
        'value' => 'desc'
      );
    }

    function searchTerms()
    {
      return array(
        array('id'=>'i.label','text'=>'SEARCH_LIST_1'),
        array('id'=>'i.title','text'=>'SEARCH_LIST_2'),
        array('id'=>'i.site','text'=>'SEARCH_LIST_SITE'),
        array('id'=>'m.manufacturers_name','text'=>'SEARCH_MANUFACTURERS'),
        array('id'=>'pd.products_name','text'=>'SEARCH_LIST_3'),
        array('id'=>'p.products_model','text'=>'SEARCH_LIST_4'),
        array('id'=>'i.listing_type','text'=>'SEARCH_LIST_5'),
        array('id'=>'i.duration','text'=>'SEARCH_LIST_6'),
        array('id'=>'i.price','text'=>'SEARCH_LIST_7'),
        array('id'=>'i.quantity','text'=>'SEARCH_LIST_8'),
        array('id'=>'i.last_modified','text'=>'SEARCH_LIST_9')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => '<a href="" onclick="lazyloadimages();return false;">Images +</a>'),
        array('heading' => HEADING_AUCTION_TITLE, 'sort_field' => 'i.title'),
        array('heading' => HEADING_AUCTION_STATUS),
        array('heading' => HEADING_AUCTION_SITE, 'sort_field' => 'i.site'),
        array('heading' => HEADING_AUCTION_TYPE, 'sort_field' => 'i.listing_type'),
        array('heading' => HEADING_AUCTION_QTY, 'sort_field' => 'i.quantity'),
        array('heading' => HEADING_AUCTION_PRODUCTS_QTY, 'sort_field' => 'p.products_quantity'),
        array('heading' => HEADING_AUCTION_DURATION, 'sort_field' => 'i.duration'),
        array('heading' => HEADING_AUCTION_PRICE, 'sort_field' => 'i.price'),
        array('heading' => HEADING_AUCTION_BIN_PRICE, 'sort_field' => 'i.bin_price'),
        array('heading' => HEADING_AUCTION_LABEL, 'sort_field' => 'i.label'),
        array('heading' => HEADING_AUCTION_PROFILE, 'sort_field' => 'i.profile_id'),
        array('heading' => HEADING_AUCTION_LAST_UPDATED, 'sort_field' => 'i.last_modified')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies, $listingTypes;

      static $profileID;

      if (isset($profileID) === false) {

        $profileID = array();

        $profiles = abxConstants::getProfilesDropDown();

        foreach((array)$profiles as $index => $profile)
          $profileID["{$profile['id']}"] = $profile['text'];

      }

      $listingTypes = abxConstants::getListingTypesShort();

      if (strtolower(get_class($this)) !== 'templatelistings_page' && empty($array['products_name']) === false) {

        $products_model = (empty($array['products_model']) === false) ? '&nbsp;('.$array['products_model'].')' : '';

        $array['title'] = $array['title'] . '<br /><span class="tableDataSubText">'.$array['products_name'].$products_model.'</span>';

      }

      $str .= '<td ><script language="JavaScript">lazyimages['.$array['id'].']="'.DIR_WS_ABX_CATALOG_IMAGES .$array['products_image'].'";</script>' . $this->image(DIR_WS_ABX_ICONS . 'info.gif', 'Click to load image', 16, 16,'onclick="lazyloadimage('.$array['id'].',this);" id="lazyimage'.$array['id'].'"') . '</td>'.
              '<td>' . $this->cell($array['title'],'150') . '</td>'.
              '<td>' . $this->cell($array['childRecords'][0]['status']) . '</td>'.
              '<td>' . $this->cell($array['site']) . '</td>'.
              '<td>' . $this->cell($listingTypes[$array['listing_type']]) . '</td>';
      
      if($array['quantity'] === '{PRODUCTS_QUANTITY}')
            $str .= '<td align="right" style="color:gray">' . $this->cell($array['products_quantity']) . '</td>';
      else
            $str .= '<td align="right">' . $this->cell($array['quantity']) . '</td>';

      $str .= '<td align="right">' . $this->cell($array['products_quantity']) . '</td>'.
              '<td align="right">' . $this->cell($array['duration']) . '</td>'.
              '<td align="right">' . $this->cell($currencies->format($array['price'])) . '</td>'.
              '<td align="right">' . $this->cell($currencies->format($array['bin_price'])) . '</td>'.
              '<td>' . $this->cellWrap($array['label'], 45) . '</td>'.
              '<td>' . $this->cellWrap($profileID[$array['profile_id']], 45) . '</td>'.
              '<td align="right">' . $this->cellWrapDate(abx_short_date($array['last_modified'])) . '</td>';

      return $str;
    }

    function drawExtraHiddenFields()
    {
      return '<input type="hidden" name="abx_last" value="items">';
    }

    function bulkActions()
    {
      return array(
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_ITEMS."','DeleteConfirm');"),
        'AddListings' => array('icon'=>'uploads.gif','alt'=>ACTION_UPLOAD,'action'=>'scheduler'),
        'Add2Upload'  => array('icon'=>'add2upload.gif','alt'=>ACTION_ADD_TO_UPLOAD,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_ADD_TO_UPLOAD."','".TEXT_ITEMS."','Add2UploadConfirm');")
      );
    }

    function singleActions($array = array())
    {
      return array(
        'editListing' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=items-edit&oID=' . $array['id'].abxPage::getSearchParams())),
        'copyListing' => array('icon'=>'copy.gif','alt'=>ACTION_COPY,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=items-copy&oID=' . $array['id'].abxPage::getSearchParams()))
      );
    }

    function tableDataFooter()
    {
      return '<div align="right">' . $this->navigation(TEXT_CREATE_NEW_ITEM,'items-new') . '</div>';
    }

  }//end class
?>