<?php
/*
  $Id: feed_products.php,v 1.7 2005/04/12 14:08:11 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004-2008 AuctionBlox
*/
  class abxModule_Feed_Products extends abxModule {

    function abxModule_Feed_Products()
    {
        $this->process();
    }

    function process()
    {
       global $abxDatabase;
       
       $sql = '';
       if($_GET['detailLevel'] === 'basic')
       {
         $sql = 'SELECT ' .
            'p.products_id,' .
            'p.products_status,' .
            'p.products_model,' .
            'p.products_quantity,' .
            'p.products_price,' .
            'p.products_image,' .
            'p.products_date_added,' .
            'p.products_tax_class_id ' .
            'FROM ' .
            TABLE_PRODUCTS . ' p ' .
            'WHERE 1 ';
       }
       else
       {
         // full detail
         $sql = 'SELECT ' .
            'p.products_id,' .
            'p.products_status,' .
            'p.products_model,' .
            'p.products_quantity,' .
            'p.products_price,' .
            'p.products_image,' .
            'p.products_date_added,' .
            'p.products_tax_class_id,' .
            'pd.language_id,' .
            'pd.products_name,' .
            'pd.products_description, ' .
            'l.code ' .
            'FROM ' .
            TABLE_PRODUCTS . ' p, ' .
            TABLE_PRODUCTS_DESCRIPTION . ' pd, ' .
            TABLE_LANGUAGES . ' l ' .
            'WHERE p.products_id=pd.products_id ' .
            'AND pd.language_id=l.languages_id';
       }

         //product id found
         $pid = stripslashes($_GET['productId']);
         if ($pid != '') {
           $sql .= ' AND p.products_id = ' . (int)$pid;
         }
            
         //last modified string found
         $lastmod = stripslashes($_GET['updatedAfter']);
         if ($lastmod != '') {
           $sql .= " AND p.products_last_modified>'$lastmod'";
         }

        $query = $abxDatabase->query($sql);
        
        $tokens = array(
            '{CHANNEL_TITLE}' => 'AuctionBlox Catalog Datafeed',
            '{CHANNEL_DESCRIPTION}' => 'AuctionBlox Catalog Datafeed',
            '{CHANNEL_LINK}' => htmlentities(HTTP_SERVER . $_SERVER['REQUEST_URI']),
            '{CHANNEL_VERSION}' => '1.0',
        );
        
        $keys = array_keys($tokens);
        $values = array_values($tokens);
        
        ob_start();        
      
        header("Content-type: text/xml");
        header("Cache-Control: no-store, no-cache");

        echo str_replace($keys, $values, $this->getRssStart());

        // Multiple rows for locale
        $lastProduct = -1;
        while ($row = $query->next()) {
            $str = '';
            
            $tokens = array(
                '{ITEM_LOCALE}' => $row['code'],
                '{ITEM_LINK}' => htmlentities(HTTP_SERVER . DIR_WS_CATALOG . FILENAME_PRODUCT_INFO . '?products_id=' . $row['products_id'] . '&language=' . $row['code']),
                '{ITEM_STATUS}' => $row['products_status'],
                '{ITEM_ID}' => $row['products_id'],
                '{ITEM_SKU}' => null,   //another unique id
                '{ITEM_MODEL}' => htmlentities($row['products_model']),
                '{ITEM_CURRENCY}' => DEFAULT_CURRENCY,
                '{ITEM_PRICE}' => $row['products_price'],
                '{ITEM_IMAGE}' => htmlentities(HTTP_SERVER . DIR_WS_CATALOG . DIR_WS_IMAGES . $row['products_image']),
                '{ITEM_QUANTITY}' => $row['products_quantity'],
                '{ITEM_TITLE}' => htmlentities($row['products_name']),
                '{ITEM_DESCRIPTION}' => '<![CDATA[' . $row['products_description'] . ']]>',
            );
            
            $tokens['{ITEM_CATEGORY}'] = htmlentities($this->processCategory($row['products_id'], $row['language_id']));

            $keys = array_keys($tokens);
            $values = array_values($tokens);

            if($lastProduct !== (int)$row['products_id'])
            {
                if($lastProduct != -1)  // not first time
                  $str .= str_replace($keys, $values, $this->getItemElementEnd());
                
                $str .= str_replace($keys, $values, $this->getItemElementStart());
                $str .= str_replace($keys, $values, $this->getItemBasicElement());
                
                if($_GET['detailLevel'] !== 'basic')
                  $str .= str_replace($keys, $values, $this->getItemExtendedElement());
                
            }
            
            if($_GET['detailLevel'] !== 'basic')
            {
              //locale-specific
              $str .= str_replace($keys, $values, $this->getItemTitleElement());
              $str .= str_replace($keys, $values, $this->getItemDescriptionElement());
              $str .= str_replace($keys, $values, $this->getItemCategoryElement());
            } 
            
            $lastProduct = (int)$row['products_id'];
            
            echo $str;
        }

        if($lastProduct !== -1)
            echo str_replace($keys, $values, $this->getItemElementEnd());
        
        echo $this->getRssEnd();
        
        ob_end_flush();  
        exit;
    }
    
    function processCategory($productId, $languageId)
    {
        global $abxDatabase;

        // This variable will persist through the session
        // so that we don't look up same category more than once...
        // as that could be expensive!
        static $categories = array();   // (category id-language id => category path)

        // We don't currently allow multiple categories per product            
        $strQuery = 'SELECT cd.categories_id, cd.language_id, cd.categories_name FROM ' . TABLE_CATEGORIES_DESCRIPTION . ' cd, ' . TABLE_PRODUCTS_TO_CATEGORIES . ' p2c WHERE cd.categories_id = p2c.categories_id AND p2c.products_id =' . (int)$productId . ' AND cd.language_id = ' . (int)$languageId;
        $query = $abxDatabase->query($strQuery);
        $categoryResult = $query->next(); // only 1
        
        $categoryId = $categoryResult['categories_id'];
        if(!isset($categories[$categoryId.'-'.$languageId]))
        {
            $categories[$categoryId.'-'.$languageId] = implode('/',array_reverse($this->getParentCategory(null, $categoryId, $languageId)));
        }
        
        return $categories[$categoryId.'-'.$languageId];
    }

    function getParentCategory($categories_array, $categoryId, $languageId, $return_ids = false)
    {
        global $abxDatabase;
    
        if (!is_array($categories_array)) $categories_array = array();

        $strQuery = "select c.parent_id, c.categories_id, cd.categories_name" 
                    . " from " . TABLE_CATEGORIES . " c, " 
                    . TABLE_CATEGORIES_DESCRIPTION . " cd, " 
                    . TABLE_LANGUAGES . " l " 
                    . " where c.categories_id = cd.categories_id" 
                    . " and cd.language_id = l.languages_id" 
                    . " and c.categories_id = " . (int)$categoryId  
                    . " and cd.language_id = " . (int)$languageId
                    . " order by c.sort_order, cd.categories_name LIMIT 1";
        
        $query = $abxDatabase->query($strQuery);
        while ($categories = $query->next()) {
            // $categories_array= array_unshift($categories_array, $categories['categories_name']);
            $categories['categories_name'] = str_replace("&", " and " , $categories['categories_name']);
            if ($return_ids == false)$categories_array[] = htmlspecialchars($categories['categories_name']);
            else $categories_array[] = htmlspecialchars($categories['categories_id']);
    
            if ($categories['parent_id'] != 0) {
                $categories_array = $this->getParentCategory($categories_array, $categories['parent_id'], $languageId, $return_ids);
            }
        }
    
        return $categories_array;
    }
    
    function getProductTemplate()
    {
        
    }

    function getRssStart()
    {
       return  '<?xml version="1.0"?>' .
               '<rss version="2.0"' . 
               '      xmlns:abx="http://www.auctionblox.com/services/catalog-feed-ns/rss/1.0/">' .
               '  <channel>' .
               '     <title>{CHANNEL_TITLE}</title>' .
               '     <link>{CHANNEL_LINK}</link>' .
               '     <description>{CHANNEL_DESCRIPTION}</description>' .
               '     <abx:version>{CHANNEL_VERSION}</abx:version>';
    }
    
    function getItemElementStart()
    {
        return '<item>';
    }
    
    function getItemBasicElement()
    {
        return '  <abx:id>{ITEM_ID}</abx:id>' .
               '  <abx:status>{ITEM_STATUS}</abx:status>' .
               '  <abx:sku>{ITEM_SKU}</abx:sku>' .
               '  <abx:model>{ITEM_MODEL}</abx:model>' .
               '  <abx:quantity>{ITEM_QUANTITY}</abx:quantity>';
    }
    
    function getItemExtendedElement()
    {
        return '  <title>{ITEM_TITLE}</title>' .
               '  <link>{ITEM_LINK}</link>' .
               '  <description>{ITEM_DESCRIPTION}</description>' .
               '  <abx:locale>{ITEM_LOCALE}</abx:locale>' .
               '  <abx:price currency="{ITEM_CURRENCY}">{ITEM_PRICE}</abx:price>' .
               '  <abx:image>{ITEM_IMAGE}</abx:image>';
    	
    }
    
    function getItemTitleElement()
    {
        return '  <abx:title locale="{ITEM_LOCALE}" format="text/html">{ITEM_TITLE}</abx:title>';
    }

    function getItemDescriptionElement()
    {
        return '  <abx:description locale="{ITEM_LOCALE}" format="text/html">{ITEM_DESCRIPTION}</abx:description>';
    }
    
    function getItemCategoryElement()
    {
        return '  <abx:category locale="{ITEM_LOCALE}">{ITEM_CATEGORY}</abx:category>';
    }

    function getItemElementEnd()
    {
        return '</item>';
    }
    
    function getRssEnd()
    {
        return '  </channel>' .
                '</rss>';    
    }
    
/*
 $datetime should be a number in the format yyyymmddhhmmss
 Returns the date's UNIX timestamp
*/
function mysql_to_unix_time($datetime) {
    // Convert to string so we can reliably parse it
    settype($datetime, 'string');
    
    // Break the number up into its components (yyyymmddhhmmss)
    // storing results in the array matches
    eregi('(....)(..)(..)(..)(..)(..)',$datetime,$matches);

    // Pop the first element off the matches array.  The first
    // element is not a match, but the original string, which
    // we don't want.
    array_shift ($matches);
    
var_dump($matches);    

    return mktime($matches[0],$matches[1],$matches[2],$matches[3],$matches[4],$matches[5]);
}    
  }//end class
?>