<?php
/*
  $Id: upgrade470.php,v 1.1 2008/04/02 18:47:54 devosc Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES . 'Page/abxPageProgressBar.php');
  
  class abxModule_Upgrade470 extends abxModule {

    function display()
    {
      	global $abxDatabase;
      
      	if (!ini_get('safe_mode'))
        	set_time_limit(0);

		//MMD - for simplicity's sake we are executing business logic in the display function
      	//first we retrieve all of the records from abx_items
      	if ($_GET['totalCount'] == null){
      		$itemsQuery = "select * from abx_items";
      		$items = $abxDatabase->query($itemsQuery);
    		$_GET['totalCount'] = $items->numRows();
      	}
    	$emptyArray = array();
      	$abxPage = new abxPageProgressBar($_GET['counter'],$_GET['progress'],$_GET['totalCount'],$emptyArray,$_GET['errorCount'],$_GET['successCount']);

      	$abxPage->setTitle('AuctionBlox Upgrade');

      	$abxPage->setPopupCloseWindow("return closeWindow('auctionblox.php?abx=install-upgrade&step=complete');");

        $abxPage->init( array("Please wait while the updates are being performed.","Preparing...") );

        require( $abxPage->template() );

      	flush();

		switch($_POST['perform']) {

        	case 'UpgradeContinue':

				if ($abxPage->counter == 0)
            		echo $abxPage->reset("Please wait while the updates are being performed.");
          		else
            		echo $abxPage->update("Please wait while the updates are being performed.",$abxPage->counter);

          		flush();

          		if ($abxPage->counter < $abxPage->totalCount) {
          			
          			$results = abxModule_Upgrade470::performUpgrade($abxPage->counter); 
					$abxPage->counter += $results['processed'];
                    $abxPage->errorCount   += $results['errors'];
            		$abxPage->successCount += $results['success'];
            		
	        		echo $abxPage->listAsHiddenFields('upgrade470', null, $emptyArray);
    	    		flush();
					
                	echo $abxPage->submitNext('upgrade470','UpgradeContinue', 'upgrade470');
            		flush();

          		} else {
					
					echo $abxPage->completed('<div>The Saved Items and Templates have been updated.</div>' . '<div>'.'Errors='.$abxPage->errorCount.' Success='.$abxPage->successCount.'</div>');
            		flush();

          		}
        
        	break;
        	default:
        	
       			$results = abxModule_Upgrade470::performUpgrade($abxPage->counter); 
				$abxPage->counter += $results['processed'];
                $abxPage->errorCount   += $results['errors'];
           		$abxPage->successCount += $results['success'];
            	
        		echo $abxPage->listAsHiddenFields('upgrade470', null, $emptyArray);
        		flush();
			
				echo $abxPage->submitNext('upgrade470','UpgradeContinue', 'upgrade470');
          		flush();
				
			break;
		}
		return FALSE;
    }
    
    function performUpgrade($startIndex){
    	global $abxDatabase;
    	
    	$results = array();
    	$results['processed'] = 0;
    	$results['success'] = 0;
    	$results['errors'] = 0;
    	
    	//first we construct the query to retrieve 100 records starting at startIndex
    	$itemsQuery = "select * from abx_items order by id asc limit " . $startIndex . ", 100";
    	$items = $abxDatabase->query($itemsQuery);
    	while ($item = $items->next()){
    		
    		//make sure to set the version correctly
    		$item['version'] = '401';
    		
			//first we deserialize the object_info
    		$item['object_info'] = unserialize($item['object_info']);
    		//MMD - stuff we need from object_info
    		//"handling_fee";N;s:16:"digital_delivery";N;
    		
    		$item['object_info']["abxship_destination"] = $item['shipping_location'];
    		$item['shipping_location'] = '';
    		
    		$item['object_info']["abxship_shipping_postal_code"] = $item['shipping_postcode'];
    		$item['shipping_postcode'] = '';
    		
    		if ($item['shipping_type'] == 'N'){
    			$item['shipping_type'] = 'F';
    		}
    		$item['object_info']["abxship_dom_shipping_type"] = $item['shipping_type'];
    		$item['object_info']["abxship_int_shipping_type"] = $item['shipping_type'];
    		$item['shipping_type'] = '';
    		
    		$item['object_info']["abxship_shipping_package_type"] = abxModule_Upgrade470::mapPackageType($item['shipping_pkg']);
    		$item['shipping_pkg'] = '0';
    		
    		$item['object_info']["abxship_shipping_weight"] = $item['shipping_weight'];
    		$item['shipping_weight'] = '';
    		
    		if ($item['shipping_weight_unit'] == '0'){
    			$item['shipping_weight_unit'] = '';
    		}
    		else if ($item['shipping_weight_unit'] == '1'){
    			$item['shipping_weight_unit'] = 'lb';
    		}
    		else if ($item['shipping_weight_unit'] == '2'){
    			$item['shipping_weight_unit'] = 'kg';
    		}
    		$item['object_info']["abxship_shipping_weight_units"] = $item['shipping_weight_unit'];
    		$item['shipping_weight_unit'] = '0';
    		
    		$item['object_info']["abxship_shipping_dimensions_length"] = "0";
    		$item['object_info']["abxship_shipping_dimensions_width"] = "0";
    		$item['object_info']["abxship_shipping_dimensions_height"] = "0";
    		$item['object_info']["abxship_shipping_dimensions_units"] = "in";
    		
    		$item['object_info']["abxship_dom_ship_serv_1"] = abxModule_Upgrade470::mapShippingService($item['shipping_svc']);
    		$item['shipping_svc'] = '0';
    		
    		$item['object_info']["abxship_dom_ship_serv_1_flat_cost"] = $item['shipping'];
    		$item['shipping'] = '';
    		$item['object_info']["abxship_dom_ship_serv_1_flat_cost_addl"] = $item['shipping_addl'];
    		$item['shipping_addl'] = '';
    		
    		$item['object_info']["abxship_dom_ship_serv_2"] = "";
    		$item['object_info']["abxship_dom_ship_serv_2_flat_cost"] = "";
    		$item['object_info']["abxship_dom_ship_serv_2_flat_cost_addl"] = "";
    		$item['object_info']["abxship_dom_ship_serv_3"] = "";
    		$item['object_info']["abxship_dom_ship_serv_3_flat_cost"] = "";
    		$item['object_info']["abxship_dom_ship_serv_3_flat_cost_addl"] = "";
    		
    		$item['object_info']["abxship_int_ship_serv_1_ship_to"] = "Worldwide";
    		$item['object_info']["abxship_int_ship_serv_1"] = abxModule_Upgrade470::mapShippingService($item['shipping_global_svc']);
    		$item['shipping_global_svc'] = '0';
    		
    		$item['object_info']["abxship_int_ship_serv_1_flat_cost"] = $item['shipping_global'];
    		$item['shipping_global'] = '';
    		$item['object_info']["abxship_int_ship_serv_1_flat_cost_addl"] = $item['shipping_global_addl'];
    		$item['shipping_global_addl'] = '';
    		
    		$item['object_info']["abxship_int_ship_serv_2_ship_to"] = "WorldWide";
    		$item['object_info']["abxship_int_ship_serv_2"] = "";
    		$item['object_info']["abxship_int_ship_serv_2_flat_cost"] = "";
    		$item['object_info']["abxship_int_ship_serv_2_flat_cost_addl"] = "";
    		$item['object_info']["abxship_int_ship_serv_3_ship_to"] = "Worldwide";
    		$item['object_info']["abxship_int_ship_serv_3"] = "";
    		$item['object_info']["abxship_int_ship_serv_3_flat_cost"] = "";
    		$item['object_info']["abxship_int_ship_serv_3_flat_cost_addl"] = "";
    		
    		$item['object_info']["abxship_shipto_worldwide"] = "true";
    		
    		$item['object_info']["abxship_dom_insurance"] = $item['insurance_option'];
    		$item['object_info']["abxship_dom_insurance_cost"] = $item['insurance'];
    		$item['object_info']["abxship_dom_handling_cost"] = $item['object_info']['handling_fee'];
    		$item['object_info']["abxship_int_insurance"] = $item['insurance_option'];
    		$item['object_info']["abxship_int_insurance_cost"] = $item['insurance'];
    		$item['object_info']["abxship_int_handling_cost"] = $item['object_info']['handling_fee'];
    		$item['insurance_option'] = '0';
    		$item['insurance'] = '0';
    		$item['object_info']['handling_fee'] = '0';
    		
    		//now, before saving the item, we reserialize the object_info
    		$item['object_info'] = serialize($item['object_info']);
    		
    		$abxDatabase->update('abx_items', $item, "id = '" . $item['id'] . "'");   		
    		
    		//we update the results
    		$results['processed']++;
    		$results['success']++;
    	}
    	
    	return $results;
    }
    
    function mapPackageType($numeric_id){
    	$mapping_array = array();
    	
    	$mapping_array["1"]="Letter";
        $mapping_array["2"]="LargeEnvelope";
        $mapping_array["3"]="USPSFlatRateEnvelope";
        $mapping_array["4"]="PackageThickEnvelope";
        $mapping_array["5"]="USPSLargePack";
        $mapping_array["6"]="VeryLargePack";
        $mapping_array["7"]="UPSLetter";
        
        $result = $mapping_array[$numeric_id];
        if ($result == null){
        	$result = '';
        }
        return $result;
        
    }
    
    function mapShippingService($numeric_id){
    	$mapping_array = array();
    	
    	// Valid US domestic options as of 2/18/08
		$mapping_array["1"]= "ShippingMethodStandard";
        $mapping_array["2"] =  "ShippingMethodExpress";
        $mapping_array["3"] =  "UPSGround";
        $mapping_array["4"] =  "UPS3rdDay";
        $mapping_array["5"] =  "UPS2ndDay"; //"UPS2DayAirAM";
        $mapping_array["6"] =  "UPSNextDay";
        $mapping_array["7"] =  "USPSPriority";
        $mapping_array["8"] =  "USPSParcel";
        $mapping_array["9"] =  "USPSMedia";
        $mapping_array["10"] =  "USPSFirstClass";
        $mapping_array["11"] =  "USPSExpressMail";
        $mapping_array["12"] =  "UPSNextDayAir";
        $mapping_array["14"] =  "Other";

        $mapping_array["16"] =  "FreightShipping"; 
        $mapping_array["18"] =  "ShippingMethodOvernight";
        $mapping_array["19"] =  "USPSPriorityFlatRateEnvelope";
        $mapping_array["20"] =  "USPSPriorityFlatRateBox";
        $mapping_array["21"] =  "USPSExpressFlatRateEnvelope";
        $mapping_array["150"] =  "Pickup";
        
        // obsolete
        $mapping_array["13"] =  "Other";
        
        // Valid US international calculated options as of 2/18/08

        $mapping_array["50001"] =  "StandardInternational";
        $mapping_array["50002"] =  "ExpeditedInternational";
        
        $mapping_array["50010"] =  "UPSWorldWideExpressPlus";
        $mapping_array["50011"] =  "UPSWorldWideExpress";
        $mapping_array["50012"] =  "UPSWorldWideExpedited";
        $mapping_array["50013"] =  "UPSStandardToCanada";
        $mapping_array["50014"] =  "OtherInternational";
        
        $mapping_array["50022"] =  "USPSFirstClassMailInternational";
        $mapping_array["50023"] =  "USPSPriorityMailInternational";
        $mapping_array["50024"] =  "USPSExpressMailInternational";
        $mapping_array["50025"] =  "USPSPriorityMailInternationalFlatRateEnvelope";
        $mapping_array["50026"] =  "USPSPriorityMailInternationalFlatRateBox";
        $mapping_array["50027"] =  "USPSExpressMailInternationalFlatRateEnvelope";

        //Start- Deprecated - We are going to map old ids to new ids for backwards compatibility with < abx 4.6.1
        $mapping_array["50003"] =  "USPSExpressMailInternational"; //"USPSGlobalExpress";
        $mapping_array["50005"] =  "USPSPriorityMailInternational"; //"USPSGlobalPriority";
        $mapping_array["50006"] =  "USPSPriorityMailInternationalFlatRateBox"; //"USPSEconomyParcel";
        $mapping_array["50007"] =  "USPSPriorityMailInternationalFlatRateEnvelope"; //"USPSEconomyLetter";
        $mapping_array["50008"] =  "USPSExpressMailInternationalFlatRateEnvelope"; //"USPSAirmailLetter";
        $mapping_array["50009"] =  "USPSExpressMailInternational"; //"USPSAirmailParcel";
        //End - Deprecated
        
        $mapping_array["1601"] =  "StandardDispatch";
        $mapping_array["1602"] =  "InsuredDispatch";
        $mapping_array["1603"] =  "Writing";
        $mapping_array["1604"] =  "COD";
        $mapping_array["1605"] =  "ExpressOrCourier";
        $mapping_array["1606"] =  "InsuredExpressOrCourier";
        $mapping_array["1607"] =  "SpecialDispatch";
        $mapping_array["1608"] =  "InsuredSpecialDispatch";
        $mapping_array["1609"] =  "Sonstige";
        $mapping_array["51602"] =  "UnversicherterVersandInternational";
        $mapping_array["51603"] =  "VersicherterVersandInternational";
        $mapping_array["51610"] =  "SonstigerVersandInternational";
        $mapping_array["51611"] =  "UnversicherterExpressVersandInternational";
        $mapping_array["51612"] =  "VersicherterExpressVersandInternational";
        
        // AU Domestic
        $mapping_array["1501"] =  "Regular";
        $mapping_array["1503"] =  "Express";
        $mapping_array["1505"] =  "Registered";
        $mapping_array["1506"] =  "Courier";
        $mapping_array["1507"] =  "Other";

        // Valid options as of 2/18/08
        $mapping_array["1508"] =  "AU_SmallParcels";
        $mapping_array["1509"] =  "AU_PrePaidParcelPostSatchels500g";
        $mapping_array["1510"] =  "AU_PrePaidParcelPostSatchels3kg";
        $mapping_array["1511"] =  "AU_PrePaidExpressPostSatchel500g";
        $mapping_array["1512"] =  "AU_PrePaidExpressPostSatchel3kg";
        $mapping_array["1513"] =  "AU_PrePaidExpressPostPlatinum500g";
        $mapping_array["1514"] =  "AU_PrePaidExpressPostPlatinum3kg";
        $mapping_array["51550"] =  "AU_Pickup";

        // AU International
        $mapping_array["51507"] =  "StandardInternational";
        $mapping_array["51508"] =  "ExpeditedInternational";
        $mapping_array["51501"] =  "EMSInternationalCourierParcels";
        $mapping_array["51502"] =  "EMSInternationalCourierDocuments";
        $mapping_array["51503"] =  "ExpressPostInternationalDocuments";
        $mapping_array["51504"] =  "AirMailInternational";
        $mapping_array["51505"] =  "EconomyAirInternational";
        $mapping_array["51506"] =  "SeaMailInternational";
        $mapping_array["51509"] =  "OtherInternational";
        
        // Valid options as of 2/18/08
        $mapping_array["51510"] =  "AU_ExpressCourierInternational";
        $mapping_array["51511"] =  "AU_ExpressPostInternational";
        $mapping_array["51512"] =  "AU_PrePaidExpressPostInternationalEnvelopeC5";
        $mapping_array["51513"] =  "AU_PrePaidExpressPostInternationalEnvelopeB4";
        $mapping_array["51514"] =  "AU_PrePaidExpressPostInternationalSatchels2kg";
        $mapping_array["51515"] =  "AU_PrePaidExpressPostInternationalSatchels3kg";
        $mapping_array["51516"] =  "AU_PrePaidExpressPostInternationalBox5kg";
        $mapping_array["51517"] =  "AU_PrePaidExpressPostInternationalBox10kg";
        $mapping_array["51518"] =  "AU_PrePaidExpressPostInternationalBox20kg";
        

        $mapping_array["2301"] =  "StandardDelivery";
        $mapping_array["2302"] =  "PriorityDelivery";
        $mapping_array["2303"] =  "ParcelPost";
        $mapping_array["2304"] =  "RegisteredMail";
        $mapping_array["2305"] =  "Other";
        $mapping_array["52301"] =  "DePostInternational";
        $mapping_array["52302"] =  "UPSInternational";
        $mapping_array["52303"] =  "FedExInternational";
        $mapping_array["52304"] =  "DHLInternational";
        $mapping_array["52305"] =  "TPGPostTNTInternational";
        $mapping_array["52306"] =  "StandardInternational";
        $mapping_array["52307"] =  "ExpeditedInternational";
        $mapping_array["52308"] =  "OtherInternational";
        $mapping_array["52309"] =  "LaPosteInternational";
                
        $mapping_array["12301"] =  "StandardDelivery";
        $mapping_array["12302"] =  "PriorityDelivery";
        $mapping_array["12303"] =  "ParcelPost";
        $mapping_array["12304"] =  "RegisteredMail";
        $mapping_array["12305"] =  "Other";
        $mapping_array["62301"] =  "DePostInternational";
        $mapping_array["62302"] =  "UPSInternational";
        $mapping_array["62303"] =  "FedExInternational";
        $mapping_array["62304"] =  "DHLInternational";
        $mapping_array["62305"] =  "TPGPostTNTInternational";
        $mapping_array["62306"] =  "StandardInternational";
        $mapping_array["62307"] =  "ExpeditedInternational";
        $mapping_array["62308"] =  "OtherInternational";
        $mapping_array["62309"] =  "LaPosteInternational";

        $mapping_array["201"] =  "StandardDelivery";
        $mapping_array["202"] =  "ExpeditedDelivery";
        $mapping_array["203"] =  "PostLettermail";
        $mapping_array["204"] =  "PostRegularParcel";
        $mapping_array["205"] =  "PostExpeditedParcel";
        $mapping_array["206"] =  "PostXpresspost";
        $mapping_array["207"] =  "PostPriorityCourier";
        $mapping_array["50201"] =  "StandardInternational";
        $mapping_array["50202"] =  "ExpeditedInternational";
        $mapping_array["50203"] =  "OtherInternational";
        $mapping_array["50204"] =  "PostExpeditedParcel";
        $mapping_array["50205"] =  "PostSmallPacketsUSA";
        $mapping_array["50206"] =  "PostXpresspostUSA";
        $mapping_array["50207"] =  "PostXpresspostInternational";
        $mapping_array["50208"] =  "PostInternationalParcelSurface";
        $mapping_array["50209"] =  "PostInternationalParcelAir";
        $mapping_array["50210"] =  "SmallPacketsInternational";
        $mapping_array["50211"] =  "PurolatorInternational";

        $mapping_array["19301"] =  "StandardDispatchAPost";
        $mapping_array["19302"] =  "StandardDispatchBPost";
        $mapping_array["19303"] =  "InsuredDispatch";
        $mapping_array["19304"] =  "Writing";
        $mapping_array["19305"] =  "COD";
        $mapping_array["19306"] =  "ExpressOrCourier";
        $mapping_array["19307"] =  "InsuredExpressOrCourier";
        $mapping_array["19308"] =  "SpecialDispatch";
        $mapping_array["19309"] =  "InsuredSpecialDispatch";
        $mapping_array["19310"] =  "Sonstige";
        $mapping_array["69313"] =  "EconomySendungenInternational";
        $mapping_array["69314"] =  "PrioritySendungenInternational";
        $mapping_array["69315"] =  "UrgentSendungenInternational";

        $mapping_array["7701"] =  "StandardDispatch";
        $mapping_array["7702"] =  "InsuredDispatch";
        $mapping_array["7703"] =  "Writing";
        $mapping_array["7704"] =  "COD";
        $mapping_array["7705"] =  "ExpressOrCourier";
        $mapping_array["7706"] =  "InsuredExpressOrCourier";
        $mapping_array["7707"] =  "SpecialDispatch";
        $mapping_array["7708"] =  "InsuredSpecialDispatch";
        $mapping_array["7709"] =  "UnversicherterVersand";
        $mapping_array["7710"] =  "DeutschePostBrief";
        $mapping_array["7711"] =  "DHLPostpaket";
        $mapping_array["7712"] =  "DHLPackchen";
        $mapping_array["7713"] =  "DeutschePostWarensendung";
        $mapping_array["7714"] =  "DeutschePostBuchersendung";
        $mapping_array["7715"] =  "HermesPaketUnversichert";
        $mapping_array["7716"] =  "HermesPaketVersichert";
        $mapping_array["7717"] =  "IloxxTransportXXL";
        $mapping_array["7718"] =  "IloxxUbernachtExpress";
        $mapping_array["7719"] =  "IloxxStandard";
        $mapping_array["7720"] =  "Sonstige";
        $mapping_array["57702"] =  "UnversicherterVersandInternational";
        $mapping_array["57703"] =  "VersicherterVersandInternational";
        $mapping_array["57711"] =  "DHLPostpaketInternational";
        $mapping_array["57712"] =  "DHLPackchenInternational";
        $mapping_array["57720"] =  "SonstigerVersandInternational";
        $mapping_array["57721"] =  "UnversicherterExpressVersandInternational";
        $mapping_array["57722"] =  "VersicherterExpressVersandInternational";
        $mapping_array["57723"] =  "DeutschePostBriefLandInternational";
        $mapping_array["57724"] =  "DeutschePostBriefLuftInternational";
        $mapping_array["57725"] =  "IloxxEuropaInternational";
        $mapping_array["57726"] =  "IloxxWorldWideInternational";

        $mapping_array["18601"] =  "CartasNacionalesHasta20";
        $mapping_array["18602"] =  "CartasNacionalesDeMas20";
        $mapping_array["18603"] =  "CartasInternacionalesHasta20";
        $mapping_array["18604"] =  "CartasInternacionalesDeMas20";
        $mapping_array["18605"] =  "PaqueteAzulHasta2kg";
        $mapping_array["18606"] =  "PaqueteAzulDeMas2kg";
        $mapping_array["18607"] =  "PaqueteInternacionalEconomico";
        $mapping_array["18608"] =  "Urgente";
        $mapping_array["18609"] =  "Otros";
        $mapping_array["68601"] =  "StandardInternational";
        $mapping_array["68602"] =  "ExpeditedInternational";
        $mapping_array["68603"] =  "OtherInternational";
        $mapping_array["68604"] =  "CartasPostalInternational";
        $mapping_array["68605"] =  "EmsPostalExpressInternational";
        $mapping_array["68606"] =  "EconomyPacketInternational";
        
        $mapping_array["7101"] =  "PostOfficeLetter";
        $mapping_array["7102"] =  "PostOfficeLetterFollowed";
        $mapping_array["7103"] =  "PostOfficeLetterRecommended";
        $mapping_array["7104"] =  "ColiposteColissimo";
        $mapping_array["7106"] =  "ColiposteColissimoRecommended";
        $mapping_array["7110"] =  "UPSStandardAgainstRefund";
        $mapping_array["7111"] =  "Autre";
        $mapping_array["7112"] =  "Ecopli";
        $mapping_array["7113"] =  "Colieco";
        $mapping_array["7114"] =  "AuteModeDenvoiDeColis";
        $mapping_array["7115"] =  "RemiseEnMainPropre";
        $mapping_array["57101"] =  "StandardInternational";
        $mapping_array["57102"] =  "ExpeditedInternational";
        $mapping_array["57103"] =  "OtherInternational";
        $mapping_array["57104"] =  "LaPosteInternationalPriorityCourier";
        $mapping_array["57105"] =  "LaPosteInternationalEconomyCourier";
        $mapping_array["57106"] =  "LaPosteColissimoEmballageInternational";
        $mapping_array["57107"] =  "LaPosteColisEconomiqueInternational";
        $mapping_array["57108"] =  "LaPosteColissimoInternational";
        $mapping_array["57109"] =  "ChronopostClassicInternational";
        $mapping_array["57110"] =  "ChronopostPremiumInternational";
        $mapping_array["57111"] =  "UPSStandardInternational";
        $mapping_array["57112"] =  "UPSExpressInternational";
        $mapping_array["57113"] =  "DHLInternational";
        
        $mapping_array["10101"] =  "RegularMail";
        $mapping_array["10102"] =  "PriorityMail";
        $mapping_array["10103"] =  "MailRegisteredLetter";
        $mapping_array["10104"] =  "MailRegisteredLetterWithMark";
        $mapping_array["10105"] =  "InsuredMail";
        $mapping_array["10106"] =  "QuickMail";
        $mapping_array["10107"] =  "RegularPackage";
        $mapping_array["10108"] =  "QuickPackage1";
        $mapping_array["10109"] =  "QuickPackage3";
        $mapping_array["10110"] =  "ExpressCourier";
        $mapping_array["60101"] =  "StandardInternational";
        $mapping_array["60102"] =  "ExpeditedInternational";
        $mapping_array["60103"] =  "OtherInternational";
        
        $mapping_array["14601"] =  "StandardDelivery";
        $mapping_array["14602"] =  "ParcelPost";
        $mapping_array["14603"] =  "RegisteredMail";
        $mapping_array["14604"] =  "Other";
        $mapping_array["64601"] =  "TPGPostTNTInternational";
        $mapping_array["64602"] =  "UPSInternational";
        $mapping_array["64603"] =  "FedExInternational";
        $mapping_array["64604"] =  "DHLInternational";
        $mapping_array["64605"] =  "DPDGBRInternational";
        $mapping_array["64606"] =  "GLSBusinessInternational";
        $mapping_array["64607"] =  "StandardInternational";
        $mapping_array["64608"] =  "ExpeditedInternational";
        $mapping_array["64609"] =  "OtherInternational";
        
        $mapping_array["310"] =  "SellersStandardRate";
        $mapping_array["301"] =  "RoyalMailFirstClassStandard";
        $mapping_array["302"] =  "RoyalMailSecondClassStandard";
        $mapping_array["303"] =  "RoyalMailFirstClassRecorded";
        $mapping_array["304"] =  "RoyalMailSecondClassRecorded";
        $mapping_array["305"] =  "RoyalMailSpecialDelivery";
        $mapping_array["306"] =  "RoyalMailStandardParcel";
        $mapping_array["307"] =  "Parcelforce24";
        $mapping_array["308"] =  "Parcelforce48";
        $mapping_array["309"] =  "OtherCourier";
        $mapping_array["311"] =  "CollectInPerson";
        $mapping_array["50301"] =  "SellersStandardInternationalRate";
        $mapping_array["50302"] =  "RoyalMailAirmailInternational";
        $mapping_array["50303"] =  "RoyalMailAirsureInternational";
        $mapping_array["50304"] =  "RoyalMailSurfaceMailInternational";
        $mapping_array["50305"] =  "RoyalMailInternationalSignedFor";
        $mapping_array["50306"] =  "RoyalMailHMForcesMailInternational";
        $mapping_array["50307"] =  "ParcelForceInternationalDatapost";
        $mapping_array["50308"] =  "ParcelForceIreland24International";
        $mapping_array["50309"] =  "ParcelForceEuro48International";
        $mapping_array["50310"] =  "ParcelForceInternationalScheduled";
        $mapping_array["50311"] =  "OtherCourierOrDeliveryInternational";
        $mapping_array["50312"] =  "CollectInPersonInternational";
    	
    	$result = $mapping_array[$numeric_id];
        if ($result == null){
        	$result = '';
        }
        return $result;
    	
    }

  }//end class
?>