<?php
/*
  French Colissimo Shipping module version 20110315.
  This module has been adapted to fit in osCommerce 2.3.1.

  Copyright � 2009,2010,2011 Philippe BLAIN <pblain@NOSPAMfree.fr>.

  ------------------------------------------------------------------------------
  Ce programme est libre, vous pouvez le redistribuer et/ou le modifier selon
  les termes de la Licence Publique G�n�rale GNU publi�e par la Free Software
  Foundation (version 2 ou bien toute autre version ult�rieure choisie par vous).

  Ce programme est distribu� car potentiellement utile, mais SANS AUCUNE GARANTIE,
  ni explicite ni implicite, y compris les garanties de commercialisation ou
  d'adaptation dans un but sp�cifique.
  Reportez-vous � la  Licence Publique G�n�rale GNU pour plus de d�tails.

  Vous devez avoir re�u une copie de la Licence Publique G�n�rale GNU en m�me
  temps que ce programme; si ce n'est pas le cas, �crivez � la Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, �tats-Unis.

  ------------------------------------------------------------------------------
  RAPPELS :

  DOM : Guadeloupe(971),  Martinique(972), Guyanne Fran�aise(973), R�union(974).
  TOM : Nouvelle Cal�donie(988), Polyn�sie fran�aise(987), Wallis & Futuna(986),
        �les �parses de l'Oc�an Indien + Terres Australes et Arctiques fran�aises(984).
  Collectivit�s Territoriales : Saint-Pierre & Miquelon(975), Mayotte(976),
        Saint-Barth�lemy(977), Saint-Martin(978).

  ------------------------------------------------------------------------------
*/

  define('MODULE_SHIPPING_COLISSIMO_MARK_UNITS', ' Kgs ');
  define('MODULE_SHIPPING_COLISSIMO_MARK_AD_VALOREM', ' +ADVALOREM');
  define('MODULE_SHIPPING_COLISSIMO_MARK_CRBT', ' +CRBT');
  define('MODULE_SHIPPING_COLISSIMO_MARK_AR', ' +AR');

  /* Suppl�ments pour recommand�s */
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_R1', 2.5);
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_R2', 3.4);
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_R3', 4.6);
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_R4', 5.8);
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_R5', 7);
  /* Options */
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_CONTRE_REMBOURSEMENT', 7);
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_ACCUSE_RECEPTION', 1.3);
  define ('MODULE_SHIPPING_COLISSIMO_SUPP_AD_VALOREM', 1);

  /* Frais par d�faut selon le poids */
  define ('MODULE_SHIPPING_COLISSIMO_DEFAULT_HANDLING', '0:0');

class colissimo {
  var $code, $title, $description, $sort_order, $icon, $poids_unitaire, $nb_boites, $tax_class, $international, $avec_avis_reception, $ad_valorem, $avec_delais, $enabled, $too_heavy, $quotes;

  /***** Class constructor *****/
  function colissimo() {
    global $order;

    $this->code                  = 'colissimo';
    $this->title                 = MODULE_SHIPPING_COLISSIMO_TEXT_TITLE;
    $this->description           = MODULE_SHIPPING_COLISSIMO_TEXT_DESCRIPTION;
    $this->sort_order            = MODULE_SHIPPING_COLISSIMO_SORT_ORDER;
    /* Au choix: shipping_laposte.gif, shipping_coliposte.jpg, shipping_colissimo.gif, shipping_colissimo48.gif, shipping_colissimo_inter.gif */
    $this->icon                  = DIR_WS_ICONS . 'shipping_colissimo48.gif';
 	if ($this->poids_unitaire < 0.05)  $this->icon  = DIR_WS_ICONS . 'shipping_lettremax48.gif';
    $this->tax_class             = MODULE_SHIPPING_COLISSIMO_TAX_CLASS;
    $this->taux                  = MODULE_SHIPPING_COLISSIMO_TAUX_RECOMMANDATION;
    $this->international         = ((MODULE_SHIPPING_COLISSIMO_INTERNATIONAL_ENABLED == 'True') ? true : false);
    $this->avec_avis_reception   = ((MODULE_SHIPPING_COLISSIMO_AVIS_RECEPTION == 'True') ? true : false);
    $this->ad_valorem            = ((MODULE_SHIPPING_COLISSIMO_INTERNATIONAL_AD_VALOREM == 'True') ? true : false);
    $this->avec_delais           = ((MODULE_SHIPPING_COLISSIMO_DELAYS_ENABLED == 'True') ? true : false);
    /* enabled: nom utilis� par OsCommerce. */
    $this->enabled               = ((MODULE_SHIPPING_COLISSIMO_STATUS == 'True') ? true : false);
    $this->too_heavy             = 0;

    /* Seulement au d�part du territoire fran�ais */
    $shipping_country_query = tep_db_query("select countries_iso_code_2 from " . TABLE_COUNTRIES . " where countries_id = '" . SHIPPING_ORIGIN_COUNTRY . "' limit 1");
    $shipping_country = tep_db_fetch_array($shipping_country_query);
    $this->origine_iso_code = $shipping_country['countries_iso_code_2'];
    if (!in_array($this->origine_iso_code, array('FR','FX','MC','GP','MQ','BL','MF','GF','RE','YT','PM','TF','WF','PF','NC','CP'))) $this->enabled = false;

    /* V�rification que le pays de livraison est dans la zone de taxation restreinte, sinon le module se d�sactive. */
    if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_COLISSIMO_TAX_ZONE > 0)) {
      $check_flag = false;
      $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_COLISSIMO_TAX_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
      while ($check = tep_db_fetch_array($check_query)) {
        if ($check['zone_id'] < 1) {
          $check_flag = true;
          break;
        } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
          $check_flag = true;
          break;
        }
      }
      if ($check_flag == false) $this->enabled = false;
    }

    $this->quotes = array();
  }

  /***** Private functions *****/
  function _add_method($tarif, $id, $taux, $ad_valorem, $delai) {
    global $order, $cart;

    if (!tep_not_null($tarif)) return;

    /* Si cette m�thode d'exp�dition n'est pas permise, return */
    /* Attention: Ce n'est pas un bool�en mais une cha�ne de valeur 'True' ou 'False' */
    if (constant('MODULE_SHIPPING_COLISSIMO_' . $id . '_ENABLED') == 'False') return;

    /* Calcul du co�t d'un colis. */
    $table = preg_split("/[:,]/" , $tarif);
    $table_count = count($table);
    $shipping = -1;
    /* Comparaison du poids d'un colis avec chaque entr�e dans la table */
    for ($k = 0; $k < $table_count; $k += 2) {
      if ($this->poids_unitaire <= $table[$k]) {
        $shipping = $table[$k+1];
        break;
      }
    }

    /* Pour cette m�thode, le poids unitaire calcul� d'un colis d�passe le maximum de la table. On ne l'affichera pas. */
    if ($shipping == -1) {
      if ($this->trop_lourd == 0) $this->trop_lourd = 1;
      return;
    }
    else {
      $this->trop_lourd = 2;
    }

    if ($id == 'ECONOM')  {
      $libel = MODULE_SHIPPING_COLISSIMO_TEXT_ECO;
    }
    else if (substr($id, 0, 6) == 'RECOMM') {
      $libel = MODULE_SHIPPING_COLISSIMO_TEXT_REC;

      if ($taux == 'Auto') {
        /* Pour du multicolis, la recommandation pour chaque colis sera
           sup�rieure � ce qu'elle devrait �tre puisque on ne connait pas la
           valeur de chaque colis et que l'on calcule � partir du total commande. */
        $order_total_amount = $cart->show_total();
        /* En EUROS. Adapter si besoin */
        if ($order_total_amount <= 50) $taux = 'R1';
        elseif ($order_total_amount <= 200) $taux = 'R2';
        elseif ($order_total_amount <= 400) $taux = 'R3';
        elseif ($order_total_amount <= 600) $taux = 'R4';
        elseif ($order_total_amount <= 800) $taux = 'R5';
        else $taux = 'R5';
      }

      if ($taux == 'R1') {
        $libel .= ' R1';
        $shipping += MODULE_SHIPPING_COLISSIMO_SUPP_R1;
      }
      else if ($taux == 'R2') {
        $libel .= ' R2';
        $shipping += MODULE_SHIPPING_COLISSIMO_SUPP_R2;
      }
      else if ($taux == 'R3') {
        $libel .= ' R3';
        $shipping += MODULE_SHIPPING_COLISSIMO_SUPP_R3;
      }
      else if ($taux == 'R4') {
        $libel .= ' R4';
        $shipping += MODULE_SHIPPING_COLISSIMO_SUPP_R4;
      }
      else if ($taux == 'R5') {
        $libel .= ' R5';
        $shipping += MODULE_SHIPPING_COLISSIMO_SUPP_R5;
      }

      if ($id == 'RECOMMCR') {
        $libel .= MODULE_SHIPPING_COLISSIMO_MARK_CRBT . MODULE_SHIPPING_COLISSIMO_TEXT_CRBT;
        $shipping += MODULE_SHIPPING_COLISSIMO_SUPP_CONTRE_REMBOURSEMENT;
      }

      if ($this->avec_avis_reception) {
        $libel .= MODULE_SHIPPING_COLISSIMO_MARK_AR . MODULE_SHIPPING_COLISSIMO_TEXT_AR;
        $shipping += MODULE_SHIPPING_COLISSIMO_SUPP_ACCUSE_RECEPTION;
      }
    }
    else $libel = '';  /* Normal */

    if ($ad_valorem) {
      /* Assurance compl�mentaire par tranche de 150 EUR (International).
         Pour du multicolis, l'assurance sera sup�rieure � ce qu'elle devrait
         �tre puisque l'on ne connait pas la valeur de chaque colis. */
      if (!isset($order_total_amount)) $order_total_amount = $cart->show_total();
      if ($order_total_amount > 1500) $order_total_amount = 1500;
      $shipping += ((int)ceil($order_total_amount / 150)) * MODULE_SHIPPING_COLISSIMO_SUPP_AD_VALOREM;
      $libel .= MODULE_SHIPPING_COLISSIMO_MARK_AD_VALOREM;
    }

    /* Frais fixes selon le poids */
    $table = preg_split('/[,:]/', MODULE_SHIPPING_COLISSIMO_HANDLING);
    $frais = 0;
    for ($k = 0, $table_count = count($table); $k < $table_count; $k += 2) {
      $frais = $table[$k+1];
      if ($this->poids_unitaire <= $table[$k]) break;
    }
    $shipping += $frais;

    /* Delais */
    if ($this->avec_delais and tep_not_null($delai)) $libel .= $delai;

    /* Co�t pour tous les colis */
    $shipping_cost = round($shipping, 2) * $this->nb_boites;


    /* Stockage param�tres */
    $this->quotes['methods'][] = array(
      'id' => $id,
      'title' => $this->nb_boites . ' x ' . number_format($this->poids_unitaire,3) . MODULE_SHIPPING_COLISSIMO_MARK_UNITS . MODULE_SHIPPING_COLISSIMO_TEXT_WAY . $order->delivery['country']['title'] . $libel,
      'cost' => $shipping_cost);
  }

  function _verifier_methodes() {
    if ($this->trop_lourd == 1) {
      /* Le poids unitaire calcul� d�passait le poids maximum dans toutes les m�thodes */
      $this->quotes['error'] = $this->nb_boites . ' x ' . number_format($this->poids_unitaire,3) . MODULE_SHIPPING_COLISSIMO_MARK_UNITS . MODULE_SHIPPING_COLISSIMO_TOO_HEAVY;
    }
  }

  function _national_vers_national($method_id = '') {
    /* Tarifs pour les envois en France m�tropolitaine, Andorre, Monaco et le Secteur Postal 69000,
      � l'int�rieur des DOM et pour les relations r�ciproques Guadeloupe et Martinique */

//Gestion de la livraison gratuite colissimo National by Brouillard s'embrouille
    global $cart;

    $choix_destination = false;
    switch (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_DESTINATION) {
      case 'National':
          $choix_destination = true;
        break;
      case 'Tous':
        $choix_destination = true;
        break;
    }

    if ( (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_TRUE == 'True') && ($choix_destination == true) && ($cart->show_total() >= MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_NATIONAL) ) {
       $this->quotes['colissimo_free_national'] = 'colissimo_free_national';

    } else {
//Fin Gestion de la livraison gratuite colissimo National by Brouillard s'embrouille
//    $national_NORMAL = '0.5:5.6,1:6.95,2:7.95,3:8.95,5:10.95,7:12.95,10:15.95,15:18.2,30:24.9';
	$port_offert = 100 ;
	$port_offert_horsfrance = 150 ;

	if ( $_SESSION['cart']->total < $port_offert ) {
		    $national_NORMAL = '0.02:2.09,0.05:2.30,0.25:5.23,0.5:5.70,0.75:06.50,1:7.00,2:7.50,3:8.60,4:11.20,5:11.20,6:13.10,7:13.10,8:13.10,9:13.10,10:13.10,15:13.10,30:13.10';									

	} else {
		    $national_NORMAL = '3000:0';
			}

 //   $national_NORMAL = '0.25:07.50,0.5:08.10,0.75:08.60,1:09.50,2:10.45,3:11.59,4:13.68,5:13.68,6:15.77,7:15.77,8:15.77,9:15.77,10:15.77,15:15.77,30:15.77';

    if ($method_id == '') {
      $this->_add_method($national_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_NAT);
      $this->_add_method($national_NORMAL, 'RECOMM', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_NAT);
      $this->_add_method($national_NORMAL, 'RECOMMCR', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_NAT);
    }
    else if ($method_id != 'ECONOM') {
      $this->_add_method($national_NORMAL, $method_id, $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_NAT);
    }
   }
    $this->_verifier_methodes();
  }

  function _entre_national_et_dom($method_id = '') {
    /* Tarifs au d�part de la France m�tropolitaine, Monaco et Andorre � destination des DOM, Mayotte, Saint-Pierre et Miquelon,
       OU au d�part des DOM, Mayotte, Saint Pierre et Miquelon � destination de la France m�tropolitaine, Monaco et Andorre */

//Gestion de la livraison gratuite colissimo International by Brouillard s'embrouille
    global $cart;

    $choix_destination = false;
    switch (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_DESTINATION) {
      case 'International':
          $choix_destination = true;
        break;
      case 'Tous':
        $choix_destination = true;
        break;
    }

    if ( (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_TRUE == 'True') && ($choix_destination == true) && ($cart->show_total() >= MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_INTERNATIONAL) ) {

//Fdp gratuit
        $this->quotes['colissimo_free_international'] = 'colissimo_free_international';

//Ou Fdp reduit
/*     $national_NORMAL = '0.49:5.50,0.99:6.80,1.99:10.80,2.99:13.80,3.99:16.80,4.99:20.80,5.99:23.50,6.99:28.10,7.99:29.40,8.99:34.40,9.99:38.90,14.99:58.90,19.99:74.99,24.99:97.95,30:120.95';

    $this->_add_method($national_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_NAT);*/

    } else {
//Gestion de la livraison gratuite colissimo International by Brouillard s'embrouille
//    $dom_NORMAL = '0.5:8.45,1:12.7,2:17.35,3:22,4:26.65,5:31.3,6:35.95,7:40.6,8:45.25,9:49.9,10:54.55,15:77.75,20:100.95,25:124.15,30:147.35';
    $dom_ECONOM = '0.5:7.5,1:9.65,2:10.75,3:11.85,4:12.95,5:14.05,6:15.15,7:16.9,8:18.65,9:20.4,10:22.15,15:28.65,20:35.15,25:41.65,30:48.15';
$port_offert_horsfrance = 150;
	if ( $_SESSION['cart']->total < $port_offert_horsfrance ) {

    $dom_NORMAL = '0.5:8.00,1:12.00,2:16.00,3:20.00,4:24.00,5:27.50,6:32.00,7:35.50';

	} else {
		    
    $dom_NORMAL = '3000:0';
			}

    if ($method_id == '') {
      $this->_add_method($dom_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM);
      $this->_add_method($dom_ECONOM, 'ECONOM', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ECO);
      $this->_add_method($dom_NORMAL, 'RECOMM', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM);
      $this->_add_method($dom_NORMAL, 'RECOMMCR', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM);
      }
    else {
      if ($method_id == 'ECONOM')
        $this->_add_method($dom_ECONOM, 'ECONOM', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ECO);
      else
        $this->_add_method($dom_NORMAL, $method_id, $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM);
    }
   }
    $this->_verifier_methodes();
  }

  function _dom_vers_dom_de_proximite($method_id = '') {
    /* Tarifs pour les envois entre DOM de proximit� (y compris Mayotte)
      Guadeloupe <---> Guyane / Martinique <---> Guyane / R�union <---> Mayotte */

    $dom_proxi_NORMAL = '0.5:5.65,1:6.8,2:7.95,3:9.1,4:10.25,5:11.4,6:12.55,7:13.7,8:14.85,9:16,10:17.15,15:19.15,20:21.15,25:23.15,30:25.15';

    if ($method_id == '') {
      $this->_add_method($dom_proxi_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_PROXI);
      $this->_add_method($dom_proxi_NORMAL, 'RECOMM', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_PROXI);
      $this->_add_method($dom_proxi_NORMAL, 'RECOMMCR', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_PROXI);
    }
    else if ($method_id != 'ECONOM') {
      $this->_add_method($dom_proxi_NORMAL, $method_id, $this->taux, false, MODULE_SHIPPING_COLISSIMO_DOM_PROXI);
    }
    $this->_verifier_methodes();
  }

  function _dom_vers_dom_eloigne($method_id = '') {
    /* Tarifs pour les envois entre DOM �loign�s (y compris Mayotte)
      Guadeloupe, Martinique, Guyane avec R�union et Mayotte.
      Guadeloupe, Martinique, Guyane, R�union et Mayotte vers Saint Pierre et Miquelon. */

    $dom_eloigne_NORMAL = '0.5:9.95,1:15.45,2:27.9,3:40.35,4:52.8,5:65.25,6:77.7,7:90.15,8:102.6,9:115.05,10:127.5,15:188.5,20:249.5,25:310.5,30:371.5';
    $dom_eloigne_ECONOM = '0.5:7.8,1:10.1,2:11.45,3:12.8,4:14.15,5:15.5,6:16.85,7:18.2,8:19.55,9:20.9,10:22.25,15:29.25,20:36.25,25:43.25,30:50.25';


    if ($method_id == '') {
      $this->_add_method($dom_eloigne_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ELOIGNE);
      $this->_add_method($dom_eloigne_ECONOM, 'ECONOM', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ELOIGNE_ECO);
      $this->_add_method($dom_eloigne_NORMAL, 'RECOMM', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ELOIGNE);
      $this->_add_method($dom_eloigne_NORMAL, 'RECOMMCR', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ELOIGNE);
    }
    else {
      if ($method_id == 'ECONOM')
        $this->_add_method($dom_eloigne_ECONOM, 'ECONOM', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ELOIGNE_ECO);
      else
        $this->_add_method($dom_eloigne_NORMAL, $method_id, $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_ELOIGNE);
    }
    $this->_verifier_methodes();
  }

  function _national_ou_dom_vers_tom($method_id = '') {
    /* Tarifs au d�part de la la France m�tropolitaine, Monaco et Andorre vers les TOM,
       OU au d�part des DOM, Collectivit�s Territoriales vers les TOM */

//Gestion de la livraison gratuite colissimo International by Brouillard s'embrouille
    global $cart;

    $choix_destination = false;
    switch (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_DESTINATION) {
      case 'International':
          $choix_destination = true;
        break;
      case 'Tous':
        $choix_destination = true;
        break;
    }

    if ( (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_TRUE == 'True') && ($choix_destination == true) && ($cart->show_total() >= MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_INTERNATIONAL) ) {
//Fdp Gratuit
        $this->quotes['colissimo_free_international'] = 'colissimo_free_international';

//Ou Fdp Reduit
/*    $national_NORMAL = '0.49:5.50,0.99:6.80,1.99:10.80,2.99:13.80,3.99:16.80,4.99:20.80,5.99:23.50,6.99:28.10,7.99:29.40,8.99:34.40,9.99:38.90,14.99:58.90,19.99:74.99,24.99:97.95,30:120.95';

    $this->_add_method($national_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_NAT);*/

    } else {
//Fin Gestion de la livraison gratuite colissimo International by Brouillard s'embrouille
//    $tom_NORMAL = '0.5:10.1,1:15.2,2:26.8,3:38.4,4:50,5:61.6,6:73.2,7:84.8,8:96.4,9:108,10:119.6,15:177.6,20:235.6,25:293.6,30:351.6';
    $tom_ECONOM = '0.5:9.5,1:12.45,2:20.65,3:28.85,4:37.05,5:45.25,6:53.45,7:61.65,8:69.85,9:78.05,10:86.25,15:137.25,20:188.25,25:239.25,30:290.25';



    $tom_NORMAL = '0.5:10.00,1:14.00,2:24.00,3:34.00,4:44.00,5:53.00,6:63.00,7:73.00';

    if ($method_id == '') {
      $this->_add_method($tom_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_TOM);
      $this->_add_method($tom_ECONOM, 'ECONOM', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_TOM_ECO);
      $this->_add_method($tom_NORMAL, 'RECOMM', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_TOM);
      $this->_add_method($tom_NORMAL, 'RECOMMCR', $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_TOM);
    }
    else {
      if ($method_id == 'ECONOM')
        $this->_add_method($tom_ECONOM, 'ECONOM', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_TOM_ECO);
      else
        $this->_add_method($tom_NORMAL, $method_id, $this->taux, false, MODULE_SHIPPING_COLISSIMO_DELAY_TOM);
    }
   }
    $this->_verifier_methodes();
  }

  function _national_vers_international($depart, $iso_code, $method_id = '') {

    /* ZONES INTERNATIONALES COLISSIMO */
    /* Codes ISO des pays en zone A, s�par�s par une virgule.
      A�ores, Allemagne, Autriche, Belgique, Chypre, Danemark, Espagne, Estonie, Finlande, Gibraltar, Grande-Bretagne, Gernesey, Gr�ce,
      Hongrie, Irlande, Italie, Jersey, Lettonie, Lituanie, Liechtenstein, Luxembourg, Mad�re, Malte, Norv�ge, Pays-Bas, Pologne, Portugal,
      Slovaquie, Slov�nie, Saint-Marin, Su�de, Suisse, Tch�que (R�p.), Vatican.
    */

//Gestion de la livraison gratuite colissimo International by Brouillard s'embrouille
    global $cart;

    $choix_destination = false;
    switch (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_DESTINATION) {
      case 'International':
          $choix_destination = true;
        break;
      case 'Tous':
        $choix_destination = true;
        break;
    }

    if ( (MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_TRUE == 'True') && ($choix_destination == true) && ($cart->show_total() >= MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_INTERNATIONAL) ) {
//Fdp Gratuit
        $this->quotes['colissimo_free_international'] = 'colissimo_free_international';

//Ou Fdp Reduit
/*    $national_NORMAL = '0.99:9.80,1.99:10.80,2.99:13.80,3.99:14.80,4.99:18.80,5.99:21.85,6.99:19.45,7.99:24.90,8.99:32.65,9.99:36.25,14.99:43.25,19.99:50.25,24.99:57.25,30:64.25';

    $this->_add_method($national_NORMAL, 'NORMAL', '', false, MODULE_SHIPPING_COLISSIMO_DELAY_NAT);*/

    } else {
//Fin Gestion de la livraison gratuite colissimo International by Brouillard s'embrouille

    $inter_countries_1 = 'AC,AT,BE,CH,CY,CZ,DE,DK,EE,ES,FI,GB,GI,GR,GS,HU,IE,IT,JE,LI,LT,LU,LV,ME,MT,NL,NO,PL,PT,SE,SI,SK,SM,VA';
    /* Codes ISO des pays en zone B, s�par�s par une virgule.
      Alg�rie, Albanie, Arm�nie, Azerba�djan, Belarus, Bosnie-Herz�govine, Bulgarie, Croatie, G�orgie, Islande, Mac�doine, Roumanie,
      Russie (F�d�ration de), Serbie et Mont�n�gro, Turquie, Ukraine, Maroc, Moldova, Tunisie.
    */
    $inter_countries_2 = 'AL,AM,AZ,BA,BG,BY,CS,DZ,GE,HR,IS,MA,MD,MK,RO,RU,TN,TR,UA';
    /* Codes ISO des pays en zone C, s�par�s par une virgule.
      Afrique du Sud, Angola, Arabie Saoudite (Royaume), Bahra�n, B�nin, Botswana, Burkina Faso, Burundi, Cameroun, Canada,
      Cap-Vert, Centrafrique, Comores, Congo (R�p. du), Congo (R�p. D�m. du ex-Za�re), C�te d�Ivoire (R�p. de la), Djibouti, Egypte,
      Emirats Arabes Unis, Erythr�e, Etats Unis, Ethiopie, Gabon, Gambie, Ghana,Guin�e (R�p. de), Guin�e-Bissau, Guin�e Equatoriale,
      Iran, Iraq, Isra�l, Jordanie, Kenya, Lesotho, Liban, Lib�ria, Libye (Jamahiriya Libyenne), Madagascar, Malawi, Mali, Maurice,
      Mauritanie, Mozambique, Namibie, Niger, Nig�ria, Ouganda, Porto-Rico, Qatar, Rwanda, Seychelles, Sao Tome et Principe, S�n�gal,
      Sierra Leone, Somalie, Soudan, Swaziland,  Syrie (R�p. Arabe Syrienne), Tanzanie, Tchad, Togo, Y�men, Zambie, Zimbabwe.
    */
    $inter_countries_3 = 'AE,AO,BF,BH,BI,BJ,BW,CA,CD,CF,CG,CI,CM,CV,DJ,EG,ER,ET,GA,GH,GM,GN,GQ,GW,IL,IQ,IR,JO,KE,KM,LB,LR,LS,LY,MG,ML,MR,MU,MW,MZ,NA,NE,NG,PR,QA,RW,SA,SC,SD,SL,SN,SO,ST,SY,SZ,TD,TG,TZ,UG,US,YE,ZA,ZM,ZW';
    /* Codes ISO des pays en zone D, s�par�s par une virgule.
      Afghanistan, Anguilla, Antigua & Barbuda, Argentine, Aruba, Australie, Bahamas, Bangladesh, Barbade, Belize, Bermudes, Bhoutan,
      Bolivie, Bonaire, Bresil, Brunei Darussalam, Cambodge, Canaries, Cayman, Chili, Chine, Colombie, Cook, Cor�e du Nord, Cor�e du Sud,
      Costa Rica, Cuba, Curacao, Dominicaine (R�publique), Dominique, El Salvador, Equateur, F�roe (Iles), Fidji, Grenade, Groenland,
      Guam, Guatemala, Guyana, Haiti, Honduras, Hong Kong, Inde, Indon�sie, Jamaique, Japon, Kazakhstan, Kirghizistan, Kiribati,
      Koweit, Laos, Macao, Malaisie, Maldives, Marshall (�les), Mexique, Micron�sie, Mongolie, Montserrat, Myanmar, Nauru, N�pal,
      Nicaragua, Nouvelle Z�lande, Oman, Ouzb�kistan, Pakistan, Palau, Palestine, Panama, Papouasie Nlle Guin�e, Paraguay, P�rou,
      Philippines, Saba, Saint Christophe & N�vis, Saint Eustache, Saint Martin (partie hollandaise), Saint Thomas,
      Saint Vincent & Grenadines, Sainte Croix, Sainte Lucie, Saipan (Iles Mariannes), Salomon, Samoa, Samoa Am�ricaines, Singapour,
      Sri Lanka, Surinam, Tadjikistan, Taiwan, Thailande, Timor Oriental, Tonga (Iles), Trinit� & Tobago, Turkm�nistan,
      Turques & Caiques, Tuvalu, Uruguay, Vanuatu, V�n�zuela, Vierges Am�ricaines (�les), Vierges Britanniques (�les), Vietnam.
    */
    $inter_countries_4  = 'AF,AG,AI,AN,AN,AN,AN,AR,AS,AU,AW,BB,BD,BM,BN,BO,BR,BS,BT,BZ,CK,CL,CN,CO,CR,CU,DM,DO,EC,FJ,FM,FO,GD,GL,GP,GP,GT,GU,GY,HK,HN,HT,IC,ID,IN,JM,JP,KG,KH,KI,KN,KP,KR,KW,KY,KZ,LA,LC,LK,MH,MI,MM,MN,MO,MP,MS,MV,MX,MY,NI,NP,NR,OM,PA,PE,PG,PH,PK,PS,PW,PY,SB,SG,SR,SV,TC,TH,TJ,TL,TM,TO,TT,TV,TW,UY,UZ,VC,VE,VG,VI,VI,VI,VN VU,WS';

    /* Recherche zone de destination */
    $dest_zone = 0;
    for ($i = 1; $i <= 4; $i ++) {
      $c = 'inter_countries_' . $i;
      $countries = preg_split("/[,]/" , $$c);
      if (in_array($iso_code, $countries)) {
        $dest_zone = $i;
        break;
      }
    }

    if ($dest_zone == 0) { /* Code pays dans aucune zone */
      $this->quotes['error'] = MODULE_SHIPPING_COLISSIMO_INVALID_COUNTRY;
      return;
    }
$port_offert_horsfrance = 150;

    /* Tarifs au d�part de la France m�tropolitaine, Monaco, Andorre vers l'International (zones A, B, C et D)*/
//    $inter_NORMAL_1 = '1:16.15,2:17.85,3:21.55,4:25.25,5:28.95,6:32.65,7:36.35,8:40.05,9:43.75,10:47.45,15:54.65,20:61.85,25:69.05,30:76.25';
//    $inter_NORMAL_2 = '1:19.8,2:21.7,3:26.25,4:30.8,5:35.35,6:39.9,7:44.45,8:49,9:53.55,10:58.1,15:68.5,20:78.9';
//    $inter_NORMAL_3 = '1:23.2,2:31.1,3:40.9,4:50.7,5:60.5,6:70.3,7:80.1,8:89.9,9:99.7,10:109.5,15:133.6,20:157.7';
//    $inter_NORMAL_4 = '1:26.4,2:39.7,3:52.9,4:66.1,5:79.3,6:92.5,7:105.7,8:118.9,9:132.1,10:145.3,15:171.3,20:197.3';

    $inter_NORMAL_1 = '1:14.50,2:15.50,3:20.00,4:22.50,5:22.50,6:22.50,7:22.50,8:22.50,9:22.50,10:22.50,15:22.50,20:22.50,25:22.50,30:22.50';
    $inter_NORMAL_2 = '1:17.50,2:20.00,3:23.50,4:27.50,5:27.50,6:27.50,7:27.50,8:27.50,9:27.50,10:27.50,15:27.50,20:27.50,25:27.50,30:27.50';
    $inter_NORMAL_3 = '1:20.50,2:27.00,3:35.50,4:44.00,5:44.00,6:44.00,7:44.00,8:44.00,9:44.00,10:44.00,15:44.00,20:44.00,25:44.00,30:44.00';
    $inter_NORMAL_4 = '1:23.00,2:35.50,3:45.50,4:57.00,5:57.00,6:57.00,7:57.00,8:57.00,9:57.00,10:57.00,15:57.00,20:57.00,25:57.00,30:57.00';

	if ( $_SESSION['cart']->total >= $port_offert_horsfrance ) { $inter_NORMAL_1=  '3000:0'; }
	if ( $_SESSION['cart']->total >= $port_offert_horsfrance ) { $inter_NORMAL_2=  '3000:0'; }
	if ( $_SESSION['cart']->total >= $port_offert_horsfrance ) { $inter_NORMAL_3=  '3000:0'; }
	if ( $_SESSION['cart']->total >= $port_offert_horsfrance ) { $inter_NORMAL_4=  '3000:0'; }


    if ($method_id == '') {
      $t = 'inter_NORMAL_' . $dest_zone;
      $this->_add_method($$t, 'NORMAL', '', $this->ad_valorem, MODULE_SHIPPING_COLISSIMO_DELAY_INTERNAT);
    }
    else if ($method_id == 'NORMAL') {
      $t = 'inter_NORMAL_' . $dest_zone;
      $this->_add_method($$t, $method_id, '', $this->ad_valorem, MODULE_SHIPPING_COLISSIMO_DELAY_INTERNAT);
    }
   }
    $this->_verifier_methodes();
  }

  function _dom_vers_international($depart, $iso_code, $method_id = '') {

    switch ($depart) {
    case '971' : /* Guadeloupe */
    case '972' : /* Martinique */
    case '977' : /* St Barth�lemy */
    case '978' : /* St Martin */
      /* Codes ISO des pays en zone A, s�par�s par une virgule.
        Antigua, Antilles N�erlandaises, Barbade, Dominique, Etats-Unis, Grenade, Guyana, Haiti, Montserrat, Saint-Christophe et N�vis,
        Saint-Vincent, Sainte-Lucie, Trinit�, Iles Vierges */
      $inter_countries_1 = 'AG,AN,BB,DM,GD,GY,HT,KN,LC,MS,TT,US,VC,VG,VI';
      /* Codes ISO des pays en zone B, s�par�s par une virgule. */
      $inter_countries_2 = 'AC,AD,AE,AF,AI,AL,AM,AO,AR,AS,AT,AU,AW,AZ,BA,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BW,BY,BZ,CA,CD,CF,CG,CH,CI,CK,CL,CM,CN,CO,CR,CS,CU,CV,CY,CZ,DE,DJ,DK,DO,DZ,EC,EE,EG,ER,ES,ET,FI,FJ,FM,FO,GA,GB,GB,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GS,GT,GU,GW,HK,HN,HR,HU,IC,ID,IE,IL,IN,IQ,IR,IS,IT,JE,JM,JO,JP,KE,KG,KH,KI,KM,KP,KR,KW,KY,KZ,LA,LB,LI,LK,LR,LS,LT,LU,LV,LY,MA,MD,ME,MG,MH,MI,MK,ML,MM,MN,MO,MP,MQ,MR,MT,MU,MV,MW,MX,MY,MZ,NA,NC,NE,NG,NI,NL,NO,NP,NR,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PR,PS,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SC,SD,SE,SG,SI,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TG,TH,TJ,TL,TM,TN,TO,TR,TV,TW,TZ,UA,UG,UY,UZ,VA,VE,VN,VU,WF,WS,YE,YT,ZA,ZM,ZW';
      break;

    case '973' : /* Guyanne Fran�aise */
      /* Codes ISO des pays en zone A, s�par�s par une virgule.
        Guyana, Haiti, Sainte-Lucie
      */
      $inter_countries_1 = 'GY,HT,LC';
      /* Codes ISO des pays en zone B, s�par�s par une virgule. */
      $inter_countries_2 = 'AC,AD,AE,AF,AG,AI,AL,AM,AN,AO,AR,AS,AT,AU,AW,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BW,BY,BZ,CA,CD,CF,CG,CH,CI,CK,CL,CM,CN,CO,CR,CS,CU,CV,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,ER,ES,ET,FI,FJ,FM,FO,GA,GB,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GS,GT,GU,GW,HK,HN,HR,HU,IC,ID,IE,IL,IN,IQ,IR,IS,IT,JE,JM,JO,JP,KE,KG,KH,KI,KM,KN,KP,KR,KW,KY,KZ,LA,LB,LI,LK,LR,LS,LT,LU,LV,LY,MA,MD,ME,MG,MH,MI,MK,ML,MM,MN,MO,MP,MQ,MR,MS,MT,MU,MV,MW,MX,MY,MZ,NA,NC,NE,NG,NI,NL,NO,NP,NR,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PR,PS,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SC,SD,SE,SG,SI,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TG,TH,TJ,TL,TM,TN,TO,TR,TT,TV,TW,TZ,UA,UG,US,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WF,WS,YE,YT,ZA,ZM,ZW';
      break;

    case '974' : /* R�union */
    case '976' : /* Mayotte */
      /* Codes ISO des pays en zone A, s�par�s par une virgule.
        Afrique du Sud, Comores, Kenya, Madagascar, Maurice, Seychelles
      */
      $inter_countries_1 = 'KE,KM,MG,MU,SC,ZA';
      /* Codes ISO des pays en zone B, s�par�s par une virgule. */
      $inter_countries_2 = 'AC,AD,AE,AF,AG,AI,AL,AM,AN,AO,AR,AS,AT,AU,AW,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BW,BY,BZ,CA,CD,CF,CG,CH,CI,CK,CL,CM,CN,CO,CR,CS,CU,CV,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,ER,ES,ET,FI,FJ,FM,FO,GA,GB,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GS,GT,GU,GW,GY,HK,HN,HR,HT,HU,IC,ID,IE,IL,IN,IQ,IR,IS,IT,JE,JM,JO,JP,KG,KH,KI,KN,KP,KR,KW,KY,KZ,LA,LB,LC,LI,LK,LR,LS,LT,LU,LV,LY,MA,MD,ME,MH,MI,MK,ML,MM,MN,MO,MP,MQ,MR,MS,MT,MV,MW,MX,MY,MZ,NA,NC,NE,NG,NI,NL,NO,NP,NR,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PR,PS,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SD,SE,SG,SI,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TG,TH,TJ,TL,TM,TN,TO,TR,TT,TV,TW,TZ,UA,UG,US,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WF,WS,YE,YT,ZM,ZW';
      break;

    case '975' : /* St Pierre & Miquelon */
      /* Codes ISO des pays en zone A, s�par�s par une virgule. */
      $inter_countries_1 = '';
      /* Codes ISO des pays en zone B, s�par�s par une virgule. */
      $inter_countries_2 = 'AC,AD,AE,AF,AG,AI,AL,AM,AN,AO,AR,AS,AT,AU,AW,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BW,BY,BZ,CA,CD,CF,CG,CH,CI,CK,CL,CM,CN,CO,CR,CS,CU,CV,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,ER,ES,ET,FI,FJ,FM,FO,GA,GB,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GS,GT,GU,GW,GY,HK,HN,HR,HT,HU,IC,ID,IE,IL,IN,IQ,IR,IS,IT,JE,JM,JO,JP,KE,KG,KH,KI,KM,KN,KP,KR,KW,KY,KZ,LA,LB,LC,LI,LK,LR,LS,LT,LU,LV,LY,MA,MD,ME,MG,MH,MI,MK,ML,MM,MN,MO,MP,MQ,MR,MS,MT,MU,MV,MW,MX,MY,MZ,NA,NC,NE,NG,NI,NL,NO,NP,NR,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PR,PS,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SC,SD,SE,SG,SI,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TG,TH,TJ,TL,TM,TN,TO,TR,TT,TV,TW,TZ,UA,UG,US,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WF,WS,YE,YT,ZA,ZM,ZW';
      break;

    default :
      break;
    } /* end switch */

    /* Recherche zone de destination */
    $dest_zone = 0;
    for ($i = 1; $i <= 2; $i ++) {
      $c = 'inter_countries_' . $i;
      $countries = preg_split("/[,]/" , $$c);
      if (in_array($iso_code, $countries)) {
        $dest_zone = $i;
        break;
      }
    }
    if ($dest_zone == 0) { /* Code pays dans aucune zone */
      $this->quotes['error'] = MODULE_SHIPPING_COLISSIMO_INVALID_COUNTRY;
      return;
    }

    /* Tarifs au d�part des DOM et Mayotte, Saint-Pierre et Miquelon vers l'International (zones A et B) */
    $inter_NORMAL_1 = '1:13.7,2:17.9,3:22.1,4:26.3,5:30.5,6:34.7,7:38.9,8:43.1,9:47.3,10:51.5,15:61.9,20:72.3';
    $inter_NORMAL_2 = '1:28.15,2:36.8,3:45.45,4:54.1,5:62.75,6:71.4,7:80.05,8:88.7,9:97.35,10:106,15:148.8,20:191.6,25:234.4,30:277.2';

    /* Les tarifs de la zone B s'appliquent pour toutes les destinations au d�part de St Pierre & Miquelon */
    if ($depart == '975') $dest_zone = 2;

    if ($method_id == '') {
      $t = 'inter_NORMAL_' . $dest_zone;
      $this->_add_method($$t, 'NORMAL', '', $this->ad_valorem, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_INTERNAT);
    }
    else if ($method_id == 'NORMAL') {
      $t = 'inter_NORMAL_' . $dest_zone;
      $this->_add_method($$t, $method_id, '', $this->ad_valorem, MODULE_SHIPPING_COLISSIMO_DELAY_DOM_INTERNAT);
    }
    $this->_verifier_methodes();
  }

  /***** Public functions *****/
  function quote($method_id = '') {
    global $order, $shipping_weight, $shipping_num_boxes;

    if (tep_not_null($method_id)) {
      if ((strcmp($method_id, 'NORMAL') != 0) and (strcmp($method_id, 'ECONOM') != 0) and
          (strcmp($method_id, 'RECOMM') != 0) and (strcmp($method_id, 'RECOMMCR') != 0)) return;
    }

    $this->quotes = array(
      'id' => $this->code,
      'module' => MODULE_SHIPPING_COLISSIMO_TEXT_TITLE,
      'methods' => array()
      );

    if (tep_not_null($this->icon))
      $this->quotes['icon'] = tep_image($this->icon, $this->title);

    /* Returns the tax rate for a zone / class */
    if ($this->tax_class > 0)
      $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);

    /* R�cup�ration du colisage effectu� par osCommerce (Voir fractionnement des colis dans la classe 'shipping'). */
    $this->poids_unitaire = $shipping_weight;
    $this->nb_boites = $shipping_num_boxes;

    /* Code postal de la boutique exp�ditrice */
    $orig2 = substr(trim(SHIPPING_ORIGIN_ZIP), 0, 2);
    $orig3 = substr(trim(SHIPPING_ORIGIN_ZIP), 0, 3);

    if ($orig2 == '97')  $origine = 'DOM';
    elseif ($orig2 == '98')  $origine = 'TOM';
    else $origine = 'NAT';

    /* Pays de destination */
    $dest_country = $order->delivery['country']['iso_code_2'];

    if (tep_not_null($order->delivery['postcode'])) {
      /* On connait le code postal */
      $dest3 = substr(trim($order->delivery['postcode']), 0, 3);

      /* Correction avec code postal destinataire en cas mauvaise saisie utilisateur pour DOM,TOM,CT */
      if ($dest_country == 'FR' or $dest_country == 'FX') {
        if ($dest3 == '971') $dest_country = 'GP';
        elseif ($dest3 == '972') $dest_country = 'MQ';
        elseif ($dest3 == '973') $dest_country = 'GF';
        elseif ($dest3 == '974') $dest_country = 'RE';
        elseif ($dest3 == '975') $dest_country = 'PM';
        elseif ($dest3 == '976') $dest_country = 'YT';
        elseif ($dest3 == '977') $dest_country = 'BL'; /* Saint-Barth�lemy */
        elseif ($dest3 == '978') $dest_country = 'MF'; /* Saint-Martin */
        elseif ($dest3 == '984') $dest_country = 'TF';
        elseif ($dest3 == '986') $dest_country = 'WF';
        elseif ($dest3 == '987') $dest_country = 'PF';
        elseif ($dest3 == '988') $dest_country = 'NC';
        elseif ($dest3 == '989') $dest_country = 'CP'; /* Clipperton */
      }
    }

    switch ($dest_country) {
    case 'FR' :
    case 'FX' :
    case 'AD' :
    case 'MC' :
      if ($origine == 'NAT') $this->_national_vers_national($method_id);
      elseif ($origine == 'DOM') $this->_entre_national_et_dom($method_id);
      else $this->_national_ou_dom_vers_tom($method_id);
      break;

    case 'GP' :
    case 'MQ' :
    case 'BL' :
    case 'MF' :
      if ($origine == 'NAT') $this->_entre_national_et_dom($method_id);
      elseif ($origine == 'DOM') {
        if (($orig3 == '971') or ($orig3 == '972')) $this->_national_vers_national($method_id);
        elseif (($orig3 == '973') or ($orig3 == '977') or ($orig3 == '978')) $this->_dom_vers_dom_de_proximite($method_id);
        elseif (($orig3 == '974') or ($orig3 == '975') or ($orig3 == '976')) $this->_dom_vers_dom_eloigne($method_id);
      }
      else $this->_national_ou_dom_vers_tom($method_id);
      break;

    case 'GF' :
      if ($origine == 'NAT') $this->_entre_national_et_dom($method_id);
      elseif ($origine == 'DOM') {
        if (($orig3 == '971') or ($orig3 == '972') or ($orig3 == '977') or ($orig3 == '978')) $this->_dom_vers_dom_de_proximite($method_id);
        elseif ($orig3 == '973') $this->_national_vers_national($method_id);
        elseif (($orig3 == '974') or ($orig3 == '975') or ($orig3 == '976')) $this->_dom_vers_dom_eloigne($method_id);
      }
      else $this->_national_ou_dom_vers_tom($method_id);
      break;

    case 'RE' :
      if ($origine == 'NAT') $this->_entre_national_et_dom($method_id);
      elseif ($origine == 'DOM') {
        if (($orig3 == '971') or ($orig3 == '972') or ($orig3 =='973') or ($orig3 == '975') or ($orig3 == '977') or ($orig3 == '978')) $this->_dom_vers_dom_eloigne($method_id);
        elseif ($orig3 == '974') $this->_national_vers_national($method_id);
        elseif ($orig3 == '976') $this->_dom_vers_dom_de_proximite($method_id);
      }
      else $this->_national_ou_dom_vers_tom($method_id);
      break;

    case 'YT' :
      if ($origine == 'NAT') $this->_entre_national_et_dom($method_id);
      elseif ($origine == 'DOM') {
        if (($orig3 == '971') or ($orig3 == '972') or ($orig3 =='973') or ($orig3 == '975') or ($orig3 == '977') or ($orig3 == '978')) $this->_dom_vers_dom_eloigne($method_id);
        elseif ($orig3 == '976') $this->_national_vers_national($method_id);
        elseif ($orig3 == '974') $this->_dom_vers_dom_de_proximite($method_id);
      }
      else $this->_national_ou_dom_vers_tom($method_id);
      break;

    case 'PM' :
      if ($origine == 'NAT') $this->_entre_national_et_dom($method_id);
      elseif ($origine == 'DOM') {
        if (($orig3 == '971') or ($orig3 == '972') or ($orig3 =='973') or ($orig3 == '974') or ($orig3 == '976') or ($orig3 == '977') or ($orig3 == '978'))
          $this->_dom_vers_dom_eloigne($method_id);
        elseif ($orig3 == '975') $this->_national_vers_national($method_id);
      }
      else $this->_national_ou_dom_vers_tom($method_id);
      break;

    case 'NC' :
    case 'PF' :
    case 'WF' :
    case 'TF' :
    case 'CP' :
      if (($origine == 'NAT') or ($origine == 'DOM')) $this->_national_ou_dom_vers_tom($method_id);
      else $this->quotes['error'] = MODULE_SHIPPING_COLISSIMO_INVALID_COUNTRY;
      break;

    default :
      $this->icon = DIR_WS_ICONS . 'shipping_colissimo_inter.gif';
      if ($this->international) {
        if ($origine == 'NAT') $this->_national_vers_international($orig3, $dest_country, $method_id);
        elseif ($origine == 'DOM') $this->_dom_vers_international($orig3, $dest_country, $method_id);
        else $this->quotes['error'] = MODULE_SHIPPING_COLISSIMO_INVALID_COUNTRY;
      }
      else  $this->quotes['error'] = MODULE_SHIPPING_COLISSIMO_INVALID_COUNTRY;
      break;
    } /* end switch */

    return $this->quotes;
  }

  /* Retourne le statut du module (activ�/d�sactiv�) */
  function check() {
    /* _check: nom utilis� par OsCommerce. */
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_COLISSIMO_STATUS'");
      $this->_check = tep_db_num_rows($check_query);
    }
    return $this->_check;
  }

  /* Constantes stock�es dans BDD */
  function install() {

    /* Activation du module */
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Module Colissimo activ&eacute;', 'MODULE_SHIPPING_COLISSIMO_STATUS', 'True', 'Voulez-vous desactiver l\'exp&eacute;dition par Colissimo ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

    /* Ajouter des frais fixes HT ? */
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Frais fixes Colissimo HT', 'MODULE_SHIPPING_COLISSIMO_HANDLING', '0', 'Les frais fixes HT d\'exp&eacute;dition par colis (emballage, ...)', '6', '0', now())");

    /* Appliquer une taxe sur frais d'exp�dition ? */
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Classe de taxe sur frais d\'exp&eacute;dition', 'MODULE_SHIPPING_COLISSIMO_TAX_CLASS', '0', 'Appliquer le taux de taxe suivant sur les frais d\'exp&eacute;dition.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");

    /* Exp�dier seulement vers une zone de taxe ? */
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Exp&eacute;dier seulement vers cette zone de taxe', 'MODULE_SHIPPING_COLISSIMO_TAX_ZONE', '0', 'Si une zone de taxe est s&eacute;lectionn&eacute;e, ce mode de livraison fonctionnera uniquement pour la zone choisie.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");

    /* Afficher les d�lais postaux ?*/
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Afficher les d&eacute;lais postaux ?', 'MODULE_SHIPPING_COLISSIMO_DELAYS_ENABLED', 'True', 'Voulez-vous afficher les d&eacute;lais postaux ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

    /* S�lection des affichages */
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Afficher Colissimo Normal ?', 'MODULE_SHIPPING_COLISSIMO_NORMAL_ENABLED', 'True', 'Voulez-vous proposer l\'exp&eacute;dition en Colissimo normal ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Afficher Colissimo Economique ?', 'MODULE_SHIPPING_COLISSIMO_ECONOM_ENABLED', 'True', 'Voulez-vous proposer l\'exp&eacute;dition en Colissimo &eacute;conomique ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Afficher Colissimo Recommand&eacute; ?', 'MODULE_SHIPPING_COLISSIMO_RECOMM_ENABLED', 'True', 'Voulez-vous proposer l\'exp&eacute;dition en Colissimo recommand&eacute;  ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Afficher Colissimo Recommand&eacute; + CRBT ?', 'MODULE_SHIPPING_COLISSIMO_RECOMMCR_ENABLED', 'False', 'Voulez-vous proposer l\'exp&eacute;dition en Colissimo recommand&eacute; avec contre-remboursement  ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

    /* S�lection des options */
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Taux de recommandation ?', 'MODULE_SHIPPING_COLISSIMO_TAUX_RECOMMANDATION', 'Auto', 'Quel taux voulez-vous appliquer pour chaque recommand&eacute; ?', '6', '0','tep_cfg_select_option(array(\'Auto\',\'R1\',\'R2\',\'R3\',\'R4\',\'R5\'), ', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Avis de r&eacute;ception pour les Recommand&eacute;s ?', 'MODULE_SHIPPING_COLISSIMO_AVIS_RECEPTION', 'False', 'Voulez-vous un avis de r&eacute;ception pour chaque recommand&eacute; ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Colissimo International autoris&eacute; ?', 'MODULE_SHIPPING_COLISSIMO_INTERNATIONAL_ENABLED', 'False', 'Voulez-vous autoriser l\'exp&eacute;dition vers l\'International ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Assurance Ad Valorem pour l\'International ?', 'MODULE_SHIPPING_COLISSIMO_INTERNATIONAL_AD_VALOREM', 'False', 'Voulez-vous ajouter une assurance Ad Valorem &agrave; chaque colis vers l\'International ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_SHIPPING_COLISSIMO_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage (le plus petit en premier).', '6', '0', now())");

//Gestion de la livraison gratuite
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Active-Desactive la livraison gratuite', 'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_TRUE', 'False', 'Activer la livraison gratuite ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Montant pour la livraison gratuite National', 'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_NATIONAL', '0', 'Choix du montant de la commande pour la livraison gratuite National', '6', '0', now())");

    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Montant pour la livraison gratuite International', 'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_INTERNATIONAL', '0', 'Choix du montant de la commande pour la livraison gratuite International', '6', '0', now())");

    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Destinations pour la livraison gratuite', 'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_DESTINATION', 'National', 'Choix des destinations pour la livraison gratuite.', '6', '5', 'tep_cfg_select_option(array(\'National\', \'International\', \'Tous\'), ', now())");
//Fin Gestion de la livraison gratuite
  }

  function remove() {
    tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }

  function keys() {
    return array(
      'MODULE_SHIPPING_COLISSIMO_STATUS',
      'MODULE_SHIPPING_COLISSIMO_HANDLING',
      'MODULE_SHIPPING_COLISSIMO_TAX_CLASS',
      'MODULE_SHIPPING_COLISSIMO_TAX_ZONE',
      'MODULE_SHIPPING_COLISSIMO_DELAYS_ENABLED',
      'MODULE_SHIPPING_COLISSIMO_NORMAL_ENABLED',
      'MODULE_SHIPPING_COLISSIMO_ECONOM_ENABLED',
      'MODULE_SHIPPING_COLISSIMO_RECOMM_ENABLED',
      'MODULE_SHIPPING_COLISSIMO_RECOMMCR_ENABLED',
      'MODULE_SHIPPING_COLISSIMO_TAUX_RECOMMANDATION',
      'MODULE_SHIPPING_COLISSIMO_AVIS_RECEPTION',
      'MODULE_SHIPPING_COLISSIMO_INTERNATIONAL_ENABLED',
      'MODULE_SHIPPING_COLISSIMO_INTERNATIONAL_AD_VALOREM',
      'MODULE_SHIPPING_COLISSIMO_SORT_ORDER',
      'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_TRUE',
      'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_NATIONAL',
      'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_COST_INTERNATIONAL',
      'MODULE_SHIPPING_COLISSIMO_FDP_GRATUITS_DESTINATION');
  }
}
?>
