<?php
//------------------------------------------------------------------------------------------------------------
// appel_spplus_php.php
// KIT SPPLUS : Page de test de l'interface de paiement avec API PHP
//---------------------------------------------------------------------------------------------------------
// Destinataire :                Sites en intgration
// Auteur :                      Service intgration SP PLUS
// Numro Version :              2.00
// Date cration	:              25/08/2005
// Date dernire Modification :  30/04/2007
//---------------------------------------------------------------------------------------------------------
//
// Le script appel_spplus_php.php vous permettra de scuriser l'appel au serveur de paiement SP PLUS.
// En effet, il permet d'appeler une des fonctions de calcul du sceau HMAC puis d'appliquer une signature
// numrique sur la chane des paramtres  envoyer au serveur de paiement SPPLUS.
//
// Ce script prsente les fonctions qui permettent de calculer le sceau numrique HMAC  partir
// de l'ensemble des paramtres passs au serveur de paiement SP PLUS.
//
//------------------------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------------------------
// INFORMATIONS A MODIFIER POUR CHAQUE COMMERCANT FOURNIES PAR LE SERVICE INTEGRATION SPPLUS
// cle marchand du commercant au format NT
   $clent = "d1 6d 26 3a 22 d3 5e b5 15 ab c7 96 ba 7c f2 62 9f 79 5b 06 1f 43 be b6";

// code siret du commercant
   $codesiret = "48218304300017-001";

// Montant  rcuprer du panier
   $montant="15.00";

// Devise dans laquelle est exprim la commande : 978 Code pour l'EURO
   $devise="978";

// Rfrence de la commande pour le commercant : unique pour chaque paiement effectu, limite  20 caractres
   $reference = "spp" . date("YmdHis");

// L'email de l'internaute : lment fortement conseill pour identification internaute
   $email="service.installation@spplus.net";

// Langue choisie pour l'interface de paiement
   $langue="FR";

// Taxe applique
   $taxe="0.00";

// Moyen de paiement choisi
   $moyen="CBS";

// Modalit de paiement choisie
   $modalite="1x";

// la fonction ci dessous permet de charger dynamiquement la librairie SP PLUS si elle n'est pas dclare dans le fichier php.ini (rubrique extensions)
   if ( !extension_loaded('SPPLUS') ) { dl('php_spplus.so'); }

// Fonction de calcul calcul_hmac
   $calcul_hmac=calcul_hmac($clent,$codesiret,$reference,$langue,$devise,$montant,$taxe,$validite);
   $url_calcul_hmac = "https://www.spplus.net/paiement/init.do?siret=$codesiret&reference=$reference&langue=$langue&devise=$devise&montant=$montant&taxe=$taxe&hmac=$calcul_hmac&moyen=$moyen&modalite=$modalite";

// Fonction de calcul calculhmac
   $data="siret=$codesiret&reference=$reference&langue=$langue&devise=$devise&montant=$montant&taxe=$taxe&moyen=$moyen&modalite=$modalite";
   $calculhmac=calculhmac($clent,$data);
   $url_calculhmac = "https://www.spplus.net/paiement/init.do?siret=$codesiret&reference=$reference&langue=$langue&devise=$devise&montant=$montant&taxe=$taxe&moyen=$moyen&modalite=$modalite&hmac=$calculhmac";

// Fonction de calcul nthmac
   $data= "$codesiret$reference$langue$devise$montant$taxe$moyen$modalite";
   $nthmac=nthmac($clent,$data);
   $url_nthmac = "https://www.spplus.net/paiement/init.do?siret=$codesiret&reference=$reference&langue=$langue&devise=$devise&montant=$montant&taxe=$taxe&moyen=$moyen&modalite=$modalite&hmac=$nthmac";

// Fonction d'encryptage de l'url SigneUrlPaiement
// Cryptage en base 64 de la chane de paramtres  envoyer au serveur SPPLUS
   $url_signeurlpaiement = "https://www.spplus.net/paiement/init.do?siret=$codesiret&reference=$reference&langue=$langue&devise=$devise&montant=$montant&taxe=$taxe&moyen=$moyen&modalite=$modalite";
   $urlspplus=signeurlpaiement($clent,$url_signeurlpaiement);

//------------------------------------------------------------------------------------------------------------

?>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>INTERFACE DE PAIEMENT SP PLUS - API PHP</title>
<script>

   // on nomme la fentre pour afficher la page de retour internaute dans cette page
   self.name="sitecom";

   function Ouvrir_Spplus()
   {
      // Largeur et hauteur prconises de la fentre SPPLUS
   	var PopupSpplus_largeur	= 750;
   	var PopupSpplus_hauteur	= 560;

      // Position haut et gauche de la fentre SPPLUS pour affichage centr dans l'cran
   	var PopupSpplus_top	=((screen.height-PopupSpplus_hauteur)/2);
   	var PopupSpplus_left	=((screen.width-PopupSpplus_largeur)/2);

   	// Ouverture du popup SPLUS avec barre tat uniquement et focus sur la fentre
   	var win = window.open('', "SPPLUS","status=yes,top="+PopupSpplus_top+",left="+PopupSpplus_left+",width="+PopupSpplus_largeur+",height="+PopupSpplus_hauteur);
   	win.focus();
   }
</script>
</head>

<body>
<center>
<table width="80%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td><a href="http://www.caisse-epargne.fr"><img src="http://www.spplus.net/img_prehome/logo.gif" alt="Caisse d'Epargne - Et si une banque vous aidait  vivre mieux ?" border="0" /></a></div></td>
<td><img src="http://www.spplus.net/img_prehome/slogan.gif" alt=" " /></td>
<td><a href="http://info.spplus.net"><img src="http://www.spplus.net/img_prehome/logopc.gif" alt="Caisse d'Epargne - SPPLUS : Paiement + Confiance" border="0" /></a></td>
</tr>
</table>
<br>
<table width="80%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td align=center>
      <font face="Arial, Verdana" size=5>
		KIT SP PLUS : TEST DE L'INTERFACE DE PAIEMENT SP PLUS AVEC L'API PHP
		</font><p>
      <table width='80%' border=0>
      <TR>
      <TD colspan=2 bgcolor='#CCCCCC'>
      	<br><font face="Arial, Verdana" size=4><strong>Paramtres du paiement : <br><br>
      </TD>
      </TR>
      <TR>
      <TD align=right>
          <font face="Arial, Verdana" size=3><strong><br>Code siret :
          <p>
      </TD>
      <TD>
         <font face="Arial, Verdana" size=3><strong><br><? echo $codesiret ?>
         <p>
      </TD>
      </TR>
      <TR>
      <TD colspan=2 bgcolor='#DDDDDD'>
         <i>
      	Cl NT : <? echo $clent ?>
         </i>
      </TD>
      </TR>

      <TR>
      <TD align=right>
          <font face="Arial, Verdana" size=3><strong><br>Rfrence :
          <p>
      </TD>
      <TD>
         <font face="Arial, Verdana" size=3><strong><br><? echo $reference ?>
         <p>
      </TD>
      </TR>
      <TR>
      <TD colspan=2 bgcolor='#DDDDDD'>
         <i>
      	Rfrence unique de la commande, paramtre obligatoire, mais le CGI gnrera
      	une rfrence valide  partir de la date et de l'heure en cas d'absence de ce
      	paramtre . Elle ne doit pas dpasser 20 caractres
         </i>
      </TD>
      </TR>
      <TR>
      <TD align=right>
         <font face="Arial, Verdana" size=3><strong><br>Montant en euros :
         <p>
      </TD>
      <TD>
         <font face="Arial, Verdana" size=3><strong><br><? echo $montant ?>
         <p>
      </TD>
      </TR>
      <TR>
      <TD colspan=2 bgcolor='#DDDDDD'>
      <i>
      	Montant de la commande en euros, le seul paramtre obligatoire, il peut
      	contenir indiffremment un point ou une virgule comme sparateur dcimal, ne
      	doit contenir que des chiffres ou les caractres . ,
      </i>
      </TD>
      </TR>
      <TR>
      <TD align=right>
          <font face="Arial, Verdana" size=3><strong><br>Langue : <p>
      </TD>
      <TD>
         <font face="Arial, Verdana" size=3><strong><br><? echo $langue ?>
         <p>
      </TD>
      </TR>
      <TR>
      <TD colspan=2 bgcolor='#DDDDDD'>
      <i>
      	Language utilis dans l'interface, paramtre obligatoire, si ce paramtre est
      	absent, le CGI utilisera FR (francais) comme valeur par dfaut. La
      	langue doit tre dfinie sur 2 caractres.
      </i>
      </TD>
      </TR>

      <TR>
      <TD align=right>
          <font face="Arial, Verdana" size=3><strong><br>Email internaute : <p>
      </TD>
      <TD>
         <font face="Arial, Verdana" size=3><strong><? echo $email ?>
      </TD>
      </TR>
      <TR><TD colspan=2 bgcolor='#DDDDDD'>
         <i>
      	Email de l'internaute, paramtre facultatif mais fortement conseill.
         </i>
      </TD></TR>

      <TR><TD colspan=2 height=10><br><br></TD></TR>
      <TR><TD colspan=2 bgcolor='#DDDDDD' align=center>
         <strong><font face='Arial, Verdana' size=3>Test de la fonction calcul_hmac
      </TD></TR>
      <TR><TD colspan=2 align=center>
         <font face='Arial, Verdana' size=3>Valeur du hmac calcul :  <? echo $calcul_hmac ?><BR>
         Tester l'URL : <a target="SPPLUS" onclick="Ouvrir_Spplus();" href="<? echo $url_calcul_hmac ?>" target="_blank">Tester</a><br>
      </TD></TR>

      <TR><TD colspan=2 height=10></TD></TR>
      <TR><TD colspan=2 bgcolor='#DDDDDD' align=center>
         <strong><font face='Arial, Verdana' size=3>Test de la fonction calculhmac
      </TD></TR>
      <TR><TD colspan=2 align=center>
         <font face='Arial, Verdana' size=3>Valeur du hmac calcul :  <? echo $calculhmac ?><BR>
         Tester l'URL : <a target="SPPLUS" onclick="Ouvrir_Spplus();" href="<? echo $url_calculhmac ?>" target="_blank">Tester</a><br>
      </TD></TR>

      <TR><TD colspan=2 height=10></TD></TR>
      <TR><TD colspan=2 bgcolor='#DDDDDD' align=center>
         <strong><font face='Arial, Verdana' size=3>Test de la fonction nthmac
      </TD></TR>
      <TR><TD colspan=2 align=center>
         <font face='Arial, Verdana' size=3>Valeur du hmac calcul :  <? echo $nthmac ?><BR>
         Tester l'URL : <a target="SPPLUS" onclick="Ouvrir_Spplus();" href="<? echo $url_nthmac ?>" target="_blank">Tester</a><br>
      </TD></TR>


      <TR><TD colspan=2 height=10></TD></TR>
      <TR><TD colspan=2 bgcolor='#DDDDDD' align=center>
         <strong><font face="Arial, Verdana" size=3>Test de la fonction SigneUrlPaiement
      </TD></TR>

      <TR><TD colspan=2 height=10></TD></TR>
      <TR><TD colspan=2 align=center>
         <font face='Arial, Verdana' size=3>
         <a target="SPPLUS" href="<? echo $urlspplus ?>" onclick="Ouvrir_Spplus();"><img src="http://kits.spplus.net/integration/logos/tableaux_paiement/tableau_cb.gif" border=0></a>
         <p>
         <a target="SPPLUS" href="<? echo $urlspplus ?>" onclick="Ouvrir_Spplus();">Cliquer ici pour tester la fonction SigneUrlPaiement SPPLUS</a>
      </TD></TR>
      </Table>

</td>
</tr>
</table>
</body>
</html>