<?php

function httpRequest($url, $post = '', $header = null, &$status = null) {
    $ch = curl_init($url);
    curl_setopt_array($ch, array(
        CURLOPT_SSL_VERIFYPEER => true, CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_RETURNTRANSFER => true, CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_FOLLOWLOCATION => false,
    ));
    if ($post) curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    if ($header) curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    $out = curl_exec($ch);
    if (curl_errno($ch)) exit('Error: ' . curl_error($ch));
    if ($status !== null) $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    return $out;
}

function getAccessToken() {
    
    // Return existing access token if exists and not expired
    if (file_exists(TOKEN_CACHE)) {
        $file = file_get_contents(TOKEN_CACHE);
        $json = json_decode($file, true);
        if ($json && !empty($json['token'])) {
            if (!empty($json['expires']) && time() < $json['expires']) {
                return $json['token'];
            }
        }
    }
    
    // Otherwise get new access token
    $post = 'grant_type=refresh_token&refresh_token=' . APP_REFRESH_TOKEN
          . '&client_id=' . APP_LWA_ID . '&client_secret=' . APP_LWA_SECRET;
    $url = 'https://api.amazon.com/auth/o2/token';
    $response = httpRequest($url, $post, array('user-agent:' . USER_AGENT));
    
    // Validate new access token response
    if (strpos($response, '{"access_token":') !== 0) {
        exit('Error: Access token response was bad: ' . $response);
    }
    if (strpos($response, 'expires_in') === false) {
        exit('Error: No "expires_in" found in response: ' . $response);
    }
    $json = json_decode($response, true);
    if (!$json || empty($json['access_token']) || empty($json['expires_in'])) {
        exit('Error: Access token JSON decode failure: ' . $response);
    }
    
    // Cache access token with an expires timestamp
    $cacheData = json_encode(array(
        'token' => $json['access_token'],
        'expires' => time() + $json['expires_in'],
    ));
    file_put_contents(TOKEN_CACHE, $cacheData);
    
    // Return access token
    return $json['access_token'];
}

function amazonRequest($method, $path, $qs = '', $post = '') {
    
    // Get access token
    $accessToken = getAccessToken();
    
    // Two formats for date used throughout
    $date = gmdate('Ymd\THis\Z');
    $ymd = gmdate('Ymd');
    
    // Build a canonical request. This is just a highly-structured and
    // ordered version of the request you will be making. Each part is
    // newline-separated. The number of headers is variable, but this
    // uses four headers. Headers must be in alphabetical order.
    $canonicalRequest = $method . "\n" // HTTP method
    . $path . "\n" //  Path component of the URL
    . $qs . "\n" // Query string component of the URL (without '?')
    . 'host:' . HOST . "\n" // Header
    . 'user-agent:' . USER_AGENT . "\n" // Header
    . 'x-amz-access-token:' . $accessToken . "\n" // Header
    . 'x-amz-date:' . $date . "\n" // Header
    . "\n" // A newline is needed here after the headers
    . 'host;user-agent;x-amz-access-token;x-amz-date' . "\n" // Header names
    . hash('sha256', $post); // Hash of the payload (empty string okay)
    
    // Create signing key, which is hashed four times, each time adding
    // more data to the key. Don't ask me why Amazon does it this way.
    $signKey = hash_hmac('sha256', $ymd, 'AWS4' . IAM_USER_SECRET, true);
    $signKey = hash_hmac('sha256', REGION, $signKey, true);
    $signKey = hash_hmac('sha256', 'execute-api', $signKey, true);
    $signKey = hash_hmac('sha256', 'aws4_request', $signKey, true);
    
    // Create a String-to-Sign, which indicates the hash that is used and
    // some data about the request, including the canonical request from above.
    $stringToSign = 'AWS4-HMAC-SHA256' . "\n"
    . $date . "\n"
    . $ymd . '/' . REGION . '/execute-api/aws4_request' . "\n"
    . hash('sha256', $canonicalRequest);
    
    // Sign the string with the key, which will create the signature
    // you'll need for the authorization header.
    $signature = hash_hmac('sha256', $stringToSign, $signKey);
    
    // Create Authorization header, which is the final step. It does NOT use
    // newlines to separate the data; it is all one line, just broken up here
    // for easier reading.
    $authorization = 'AWS4-HMAC-SHA256 '
    . 'Credential=' . IAM_USER_KEY . '/' . $ymd . '/'
     . REGION . '/execute-api/aws4_request,'
    . 'SignedHeaders=host;user-agent;x-amz-access-token;x-amz-date,'
    . 'Signature=' . $signature;
    
    // Create the header array for the cURL request. The headers must be
    // in alphabetical order. You must include all of the headers that were
    // in the canonical request above, plus you add in the authorization header
    // and an optional content-type header (for POST requests with JSON payload).
    $headers = array();
    $headers[] = 'authorization:' . $authorization;
    if ($post) $headers[] = 'content-type:application/json;charset=utf-8';
    $headers[] = 'host:' . HOST;
    $headers[] = 'user-agent:' . USER_AGENT;
    $headers[] = 'x-amz-access-token:' . $accessToken;
    $headers[] = 'x-amz-date:' . $date;
    
    // Run the http request and capture the status code
    $status = '';
    $fullUrl = ENDPOINT . $path . ($qs ? '?' . $qs : '');
    $result = httpRequest($fullUrl, $post, $headers, $status);
    
    // Validate the response
    if (strpos($result, 'Error:') === 0) exit($result);
    if (empty($result)) exit('Error: Empty response');
    if ($status != 200) exit('Error: Status code ' . $status . ': ' . $result);
    if (strpos($result, '{') !== 0) exit('Error: Invalid JSON: ' . $result);
    
    // Decode json and return it
    $json = json_decode($result, true);
    if (!$json) exit('Error: Problem decoding JSON: ' . $result);
    return $json;
}

function amazonRequestAssumeRole($method, $path, $qs = '', $post = '') {
    
    // Get access token
   // $accessToken = getAccessToken();
    
    // Two formats for date used throughout
    $date = gmdate('Ymd\THis\Z');
    $ymd = gmdate('Ymd');
    
    // Build a canonical request. This is just a highly-structured and
    // ordered version of the request you will be making. Each part is
    // newline-separated. The number of headers is variable, but this
    // uses four headers. Headers must be in alphabetical order.
    $canonicalRequest = $method . "\n" // HTTP method
    . $path . "\n" //  Path component of the URL
    . $qs . "\n" // Query string component of the URL (without '?')
    . 'host:' . HOST_STS . "\n" // Header
    . 'user-agent:' . USER_AGENT . "\n" // Header
    . 'x-amz-date:' . $date . "\n" // Header
    . "\n" // A newline is needed here after the headers
    . 'host;user-agent;x-amz-date' . "\n" // Header names
    . hash('sha256', $post); // Hash of the payload (empty string okay)

                echo "<h5>Canonical to string</h5>";
                echo "<pre>";
                echo $canonicalRequest;
                echo "</pre>";
    
    // Create signing key, which is hashed four times, each time adding
    // more data to the key. Don't ask me why Amazon does it this way.
    $signKey = hash_hmac('sha256', $ymd, 'AWS4' . IAM_USER_SECRET, true);
    $signKey = hash_hmac('sha256', REGION_STS, $signKey, true);
    $signKey = hash_hmac('sha256', 'sts', $signKey, true);
    $signKey = hash_hmac('sha256', 'aws4_request', $signKey, true);
    
    // Create a String-to-Sign, which indicates the hash that is used and
    // some data about the request, including the canonical request from above.
    $stringToSign = 'AWS4-HMAC-SHA256' . "\n"
    . $date . "\n"
    . $ymd . '/' . REGION_STS . '/sts/aws4_request' . "\n"
    . hash('sha256', $canonicalRequest);
    
    // Sign the string with the key, which will create the signature
    // you'll need for the authorization header.
    $signature = hash_hmac('sha256', $stringToSign, $signKey);
    
    // Create Authorization header, which is the final step. It does NOT use
    // newlines to separate the data; it is all one line, just broken up here
    // for easier reading.
    $authorization = 'AWS4-HMAC-SHA256 '
    . 'Credential=' . IAM_USER_KEY . '/' . $ymd . '/'
    . REGION_STS . '/sts/aws4_request,'
    . 'SignedHeaders=host;user-agent;x-amz-date,'
    . 'Signature=' . $signature;
    
    // Create the header array for the cURL request. The headers must be
    // in alphabetical order. You must include all of the headers that were
    // in the canonical request above, plus you add in the authorization header
    // and an optional content-type header (for POST requests with JSON payload).
    $headers = array();
    $headers[] = 'authorization:' . $authorization;
    if ($post) $headers[] = 'content-type:application/json;charset=utf-8';
    $headers[] = 'host:' . HOST_STS;
    $headers[] = 'user-agent:' . USER_AGENT;
    $headers[] = 'x-amz-date:' . $date;
    
    // Run the http request and capture the status code
    $status = '';
    $fullUrl = ENDPOINT_STS . $path . ($qs ? '?' . $qs : '');
    $result = httpRequest($fullUrl, $post, $headers, $status);
    
    // Validate the response
    if (strpos($result, 'Error:') === 0) exit($result);
    if (empty($result)) exit('Error: Empty response');
    if ($status != 200) exit('Error: Status code ' . $status . ': ' . $result);
    if (strpos($result, '{') !== 0) exit('Error: Invalid JSON: ' . $result);
    
    // Decode json and return it
    $json = json_decode($result, true);
    if (!$json) exit('Error: Problem decoding JSON: ' . $result);
    return $json;
}

// Use the 'getItemOffers' operation to get offers for a single ASIN
function getOffersForAsin($asin) {
    $method = 'GET';
    $url = '/products/pricing/v0/items/' . $asin . '/offers';
    $qs = 'Asin=' . $asin . '&ItemCondition=New&MarketplaceId=' . MP_ID;
    return amazonRequest($method, $url, $qs);
}
function getAssumeRole() {
    $method = 'GET';
    $url = '/';
    $qs = 'Version=2011-06-15&Action=AssumeRole&RoleSessionName=seb&RoleArn=arn:aws:iam::217611090416:role/SP-API_client';
    return amazonRequestAssumeRole($method, $url, $qs);
}