<?php
/*
 * This file is part of the partner api fnac marketplace package.
 * (c) 2008-2010 Francois Crossette <fcrossette@fnac.com>
 *
 * Example of a common use case for FNAC MARKETPLACE API
 *   - Authentication
 *   - Offers Update
 *   - Offers Query
 *   - Batch Status
 *   - Orders Query
 *   - Orders Update
 *
 */

/*
 * Init :
 *   $partner_id : unique id given by Fnac team
 *   $shop_id    : unique id of Fnac shop
 *   $key        : partner sauthentication key
 */

// CB

//include('import_top_special.php');


// CB
  $partner_id = '8DA6AE5D-B753-64BC-1497-D55BFE5F9CF6';
  $key        = '2494DD10-6429-A2BA-3214-4B87D243E796';
  $shop_id    = '489A06A0-FF08-88B5-1075-3C8CC3C5ECCA';

  $url        = 'https://vendeur.fnac.com/api.php/';

  try
  {
		    /* call auth service  */
		    $xmlAuthentication = simplexml_load_file('xml_files/authentification-request.xml');
		    $xmlAuthentication->partner_id = $partner_id;
		    $xmlAuthentication->shop_id = $shop_id;
		    $xmlAuthentication->key = $key;
		
		    /* Validated XML request using XSD */
		    $dom = new DOMDocument;
		    $dom->loadXML($xmlAuthentication->asXML());
		    $valide = $dom->schemaValidate('xsd/AuthenticationService.xsd');
		    if( ! $valide)
		    {
		      throw new Exception('xmlAuthentication: validation failed !');
		    }
		
		    // send xml to webservice auth
		    $response = do_post_request($url . "auth", $xmlAuthentication->asXML());
		
		    // load xml response
		    $xmlResponse = simplexml_load_string(trim($response));
		    // get token for session authentication
	echo		$tokenForSession = $xmlResponse->token;
		    // Post to this date , the session for this token is no more valid.
		    $validityDateForSession = $xmlResponse->validity;
			
		
		
		    $xmlOffersQuery['partner_id'] = $partner_id;
		    $xmlOffersQuery['shop_id'] = $shop_id;
		//    $xmlOffersQuery['token'] = $tokenForSession;
		
		$string  = '<?xml version="1.0" encoding="utf-8"?>';
		$string .= '<pricing_query  sellers="all" partner_id="'.$partner_id.'"  shop_id="'.$shop_id.'"  token="'.$tokenForSession.'"  xmlns="http://www.fnac.com/schemas/mp-dialog.xsd">';
		$string .= '<product_reference type="FnacId">22574192</product_reference>';
		$string .= '</pricing_query>';
		
		$xmlPricingQuery=simplexml_load_string($string);

			echo "<pre>";
		// print_r($xmlPricingQuery);
			echo "</pre>";
		
		
		    /* Validated XML request using XSD */
		    $dom = new DOMDocument;
		    $dom->loadXML($xmlPricingQuery->asXML());
		    $valide = $dom->schemaValidate('xsd/PricingQueryService.xsd');
		    if( ! $valide)
		    {
		      throw new Exception('xmlPricingQuery: validation failed !');
		    }
		    // send xml to webservice PricingQuery
		    $response = do_post_request($url . "pricing_query", $xmlPricingQuery->asXML());
		    // NOCDATA convert CDATA into string to avoid manual cast on value
		    $xmlResponse = simplexml_load_string(trim($response), 'SimpleXMLElement', LIBXML_NOCDATA);
		//	$xmlResponse_array = (array) $xmlResponse;


							echo "<hr><pre>";
				 print_r($xmlResponse);
			//	 var_dump($xmlResponse);
					echo "</pre>";

/******************************************************/


			

  }
  catch(Exception $e)
  {
    // do what you want with exception
    var_dump($e);
  }


/************************************************** Fin Traitement  ***********************************************/

  /**
   * Simulate a post method
   *
   * @param string   $url              : target url
   * @param string   $data             : xml query
   * @param string   $optional_headers : optional headers
   *
   * @return response of the http request
   */
  function do_post_request($url, $data, $optional_headers = null)
  {
/*    $params = array( 'http' => array ( 'method' => 'POST', 'content' => $data ) );
    if ( $optional_headers !== null )
    {
      $params['http']['header'] = $optional_headers;
    }

	echo "<pre>";
    var_dump($params);
	echo "</pre>";

 echo   $ctx = stream_context_create($params);
    $fp = fopen($url, 'rb', false, $ctx);

    if ( !$fp )
    {
      throw new Exception("Problem with $url");
    }

    $response = @stream_get_contents($fp);

    if ( $response === false )
    {
      throw new Exception("Problem reading data from $url");
    }
*/
    // Here is an example with cURL (could be faster)
     $ch = curl_init();

     curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
     curl_setopt($ch, CURLOPT_POST, 1); 
     curl_setopt($ch, CURLOPT_URL, $url);
     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
     curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false); 
curl_setopt($ch,CURLOPT_CAINFO,'cacert.pem'); /* fixed! */

     $response = curl_exec($ch);

     if(0 != curl_errno($ch))
     {
       echo 'curl Error: '.curl_error($ch)."\n<br/>curl info:";
       echo '<pre>';
       print_r(curl_getinfo($ch));
       echo '</pre>';
     }

     curl_close($ch);

    return $response;
  }

  
?>