<?php
/*
  $Id: general.php,v 1.1.1.1 2004/03/04 23:39:53 ccwjr Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Chain Reaction Works, Inc
  Copyright &copy; 2005 - 2006 Chain Reaction Works, Inc.

  Last Modified by $Author$
  Last Modifed on : $Date$
  Latest Revision : $Revision: 5504 $

  Released under the GNU General Public License
*/

  function tep_get_products_special_price($product_id) {
    $product_query = tep_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "' and status");
    $product = tep_db_fetch_array($product_query);

    return $product['specials_new_products_price'];
  }



function tep_return_broken($bad_string) {
  $char_count = 35;
  $formatted_string = '';
  $countbefore = 0;
  $i = 0;
  while ($i < strlen($bad_string)) {
    $formatted_string .= $bad_string[$i];
    $countbefore ++;
    if ($countbefore > $char_count) {
      $formatted_string .= chr(13);
      $countbefore = 0;
    }
    $i ++;
  } // End of while loop on strlen of bad string
  return $formatted_string;
}

////
// Stop from parsing any further PHP code
  function tep_exit() {
   tep_session_close();
   exit();
  }


// Redirect to another page or site
  function tep_redirect($url) {
    if ( (strstr($url, "\n") != false) || (strstr($url, "\r") != false) ) { 
      tep_redirect(tep_href_link(FILENAME_DEFAULT, '', 'NONSSL', false));
    }

    if ( (ENABLE_SSL == true) && (getenv('HTTPS') == 'on') ) { // We are loading an SSL page
      if (substr($url, 0, strlen(HTTP_SERVER . DIR_WS_HTTP_CATALOG)) == HTTP_SERVER . DIR_WS_HTTP_CATALOG) { // NONSSL url
        $url = HTTPS_SERVER . DIR_WS_HTTPS_CATALOG . substr($url, strlen(HTTP_SERVER . DIR_WS_HTTP_CATALOG)); // Change it to SSL
      }
    }
 $url =  str_replace("&amp;", "&", $url);
     header('Location: ' . $url);
    tep_exit();
  }

//Admin begin
////
//Check login and file access
function tep_admin_check_login() {
  global $PHP_SELF, $login_groups_id;
  if (!tep_session_is_registered('login_id')) {
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  } else {
    // if they are in group 1, let them do whatever they need to do
    if ( $login_groups_id != 1 ) {
      $filename = basename( $PHP_SELF );
      if ($filename != FILENAME_DEFAULT && $filename != FILENAME_FORBIDEN && $filename != FILENAME_LOGOFF && $filename != FILENAME_ADMIN_ACCOUNT && $filename != FILENAME_POPUP_IMAGE && $filename != 'packingslip.php' && $filename != 'invoice.php') {
        $db_file_query = tep_db_query("select admin_files_name from " . TABLE_ADMIN_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', admin_groups_id) and admin_files_name = '" . $filename . "'");
        if (!tep_db_num_rows($db_file_query)) {
          tep_redirect(tep_href_link(FILENAME_FORBIDEN));
        }
      }
    }
  }
}

////
//Return 'true' or 'false' value to display boxes and files in index.php and column_left.php
function tep_admin_check_boxes($filename, $boxes='') {
  global $login_groups_id;

  $is_boxes = 1;
  if ($boxes == 'sub_boxes') {
    $is_boxes = 0;
  }
  $dbquery = tep_db_query("select admin_files_id from " . TABLE_ADMIN_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', admin_groups_id) and admin_files_is_boxes = '" . $is_boxes . "' and admin_files_name = '" . $filename . "'");

  $return_value = false;
  if (tep_db_num_rows($dbquery)) {
    $return_value = true;
  }
  return $return_value;
}

////
//Return files stored in box that can be accessed by user
function tep_admin_files_boxes ($filename = '', $sub_box_name = '', $connection = 'NONSSL', $parameters = '', $space = '') {
  global $login_groups_id, $request_type, $spaces1;
  $sub_boxes = '';
  $spaces1= '';

 if (MENU_DHTML != 'True') { // We don't need spaces when DHTML menu is ON
  for ($i=0, $n=$space; $i<$n; $i++) {
  $spaces1 .= '&nbsp;';
  }
} // We don't need spaces when DHTML menu is ON
//    $connection = 'NONSSL';

if ($filename != '' ){
  $dbquery = tep_db_query("select admin_files_name from " . TABLE_ADMIN_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', admin_groups_id) and admin_files_is_boxes = '0' and admin_files_name = '" . $filename . "'");
  if (tep_db_num_rows($dbquery)) {
     $sub_boxes = $spaces1 . '<a href="' . tep_href_link($filename, $parameters, $connection) . '" class="menuBoxContentLink"><nobr>' . $sub_box_name . '</nobr></a><br>';
     } else if ( (tep_db_num_rows($dbquery)) || ($connection == '') ) {
     $sub_boxes = $spaces1 . '<a href="' . tep_href_link($filename, $parameters, $connection) . '" class="menuBoxContentLink"><nobr>' . $sub_box_name . '</nobr></a><br>';
    }
  } else  if ($filename == ''){
      $sub_boxes = $spaces1 .  '<class="menuBoxHeadLink"><b><nobr>' . $sub_box_name . '</nobr></b><br>';
   } else {
        $sub_boxes = $spaces1 .  '<class="menuBoxHeadLink"><nobr>' . $sub_box_name . '</nobr><br>';
    }
  return $sub_boxes;
}

////
//Get selected file for index.php
function tep_selected_file($filename) {
  global $login_groups_id;
  $randomize = FILENAME_ADMIN_ACCOUNT;

  $dbquery = tep_db_query("select admin_files_id as boxes_id from " . TABLE_ADMIN_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', admin_groups_id) and admin_files_is_boxes = '1' and admin_files_name = '" . $filename . "'");
  if (tep_db_num_rows($dbquery)) {
    $boxes_id = tep_db_fetch_array($dbquery);
    $randomize_query = tep_db_query("select admin_files_name from " . TABLE_ADMIN_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', admin_groups_id) and admin_files_is_boxes = '0' and admin_files_to_boxes = '" . $boxes_id['boxes_id'] . "'");
    if (tep_db_num_rows($randomize_query)) {
      $file_selected = tep_db_fetch_array($randomize_query);
      $randomize = $file_selected['admin_files_name'];
    }
  }
  return $randomize;
}
//Admin end


////
// Parse the data used in the html tags to ensure the tags will not break
  function tep_parse_input_field_data($data, $parse) {
    return strtr(trim($data), $parse);
  }

  function tep_output_string($string, $translate = false, $protected = false) {
    if ($protected == true) {
      return htmlspecialchars($string);
    } else {
      if ($translate == false) {
        return tep_parse_input_field_data($string, array('"' => '&quot;'));
      } else {
        return tep_parse_input_field_data($string, $translate);
      }
    }
  }

  function tep_output_string_protected($string) {
    return tep_output_string($string, false, true);
  }

  function tep_sanitize_string($string) {
    $string = ereg_replace(' +', ' ', $string);

    return preg_replace("/[<>]/", '_', $string);
  }

  function tep_customers_name($customers_id) {
    $customers = tep_db_query("select customers_firstname, customers_lastname from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customers_id . "'");
    $customers_values = tep_db_fetch_array($customers);

    return $customers_values['customers_firstname'] . ' ' . $customers_values['customers_lastname'];
  }

  function tep_get_path($current_category_id = '') {
    global $cPath_array;

    if ($current_category_id == '') {
      $cPath_new = implode('_', $cPath_array);
    } else {
      if (sizeof($cPath_array) == 0) {
        $cPath_new = $current_category_id;
      } else {
        $cPath_new = '';
        $last_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$cPath_array[(sizeof($cPath_array)-1)] . "'");
        $last_category = tep_db_fetch_array($last_category_query);

        $current_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$current_category_id . "'");
        $current_category = tep_db_fetch_array($current_category_query);

        if ($last_category['parent_id'] == $current_category['parent_id']) {
          for ($i = 0, $n = sizeof($cPath_array) - 1; $i < $n; $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        } else {
          for ($i = 0, $n = sizeof($cPath_array); $i < $n; $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        }

        $cPath_new .= '_' . $current_category_id;

        if (substr($cPath_new, 0, 1) == '_') {
          $cPath_new = substr($cPath_new, 1);
        }
      }
    }

    return 'cPath=' . $cPath_new;
  }

  function tep_get_all_get_params($exclude_array = '') {
    global $HTTP_GET_VARS;

    if ($exclude_array == '') $exclude_array = array();

    $get_url = '';

    reset($HTTP_GET_VARS);
    while (list($key, $value) = each($HTTP_GET_VARS)) {
      if (($key != tep_session_name()) && ($key != 'error') && (!in_array($key, $exclude_array))) $get_url .= $key . '=' . $value . '&';
    }

    return $get_url;
  }

  function tep_date_long($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;

    $year = (int)substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    return strftime(DATE_FORMAT_LONG, mktime($hour, $minute, $second, $month, $day, $year));
  }

////
// Output a raw date string in the selected locale date format
// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
// NOTE: Includes a workaround for dates before 01/01/1970 that fail on windows servers
  function tep_date_short($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;

    $year = substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    if (@date('Y', mktime($hour, $minute, $second, $month, $day, $year)) == $year) {
      return date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
    } else {
      return ereg_replace('2037' . '$', $year, date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, 2037)));
    }

  }

  function tep_datetime_short($raw_datetime) {
    if ( ($raw_datetime == '0000-00-00 00:00:00') || ($raw_datetime == '') ) return false;

    $year = (int)substr($raw_datetime, 0, 4);
    $month = (int)substr($raw_datetime, 5, 2);
    $day = (int)substr($raw_datetime, 8, 2);
    $hour = (int)substr($raw_datetime, 11, 2);
    $minute = (int)substr($raw_datetime, 14, 2);
    $second = (int)substr($raw_datetime, 17, 2);

    return strftime(DATE_TIME_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
  }

  function tep_get_category_tree($parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false) {
    global $languages_id;

    if (!is_array($category_tree_array)) $category_tree_array = array();
    if ( (sizeof($category_tree_array) < 1) && ($exclude != '0') ) $category_tree_array[] = array('id' => '0', 'text' => TEXT_TOP);

    if ($include_itself) {
      $category_query = tep_db_query("select cd.categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " cd where cd.language_id = '" . (int)$languages_id . "' and cd.categories_id = '" . (int)$parent_id . "'");
      $category = tep_db_fetch_array($category_query);
      $category_tree_array[] = array('id' => $parent_id, 'text' => $category['categories_name']);
    }

    $categories_query = tep_db_query("select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' and c.parent_id = '" . (int)$parent_id . "' order by c.sort_order, cd.categories_name");
    while ($categories = tep_db_fetch_array($categories_query)) {
      if ($exclude != $categories['categories_id']) $category_tree_array[] = array('id' => $categories['categories_id'], 'text' => $spacing . $categories['categories_name']);
      $category_tree_array = tep_get_category_tree($categories['categories_id'], $spacing . '&nbsp;&nbsp;&nbsp;', $exclude, $category_tree_array);
    }

    return $category_tree_array;
  }

  function tep_draw_products_pull_down($name, $parameters = '', $exclude = '') {
    global $currencies, $languages_id;

    if ($exclude == '') {
      $exclude = array();
    }

    $select_string = '<select name="' . $name . '"';

    if ($parameters) {
      $select_string .= ' ' . $parameters;
    }

    $select_string .= '>';

// Eversun mod for sppc and qty price breaks
    $all_groups=array();
    $customers_groups_query = tep_db_query("select customers_group_name, customers_group_id from " . TABLE_CUSTOMERS_GROUPS . " order by customers_group_id ");
    while ($existing_groups =  tep_db_fetch_array($customers_groups_query)) {
      $all_groups[$existing_groups['customers_group_id']]=$existing_groups['customers_group_name'];
    }
// Eversun mod end for sppc and qty price breaks

    $products_query = tep_db_query("SELECT p.products_id, pd.products_name, p.products_price
                                    FROM " . TABLE_PRODUCTS . " p,
                                         " . TABLE_PRODUCTS_DESCRIPTION . " pd
                                    WHERE p.products_id = pd.products_id
                                      and pd.language_id = '" . (int)$languages_id . "'
                                      and (p.products_status = '1'
                                          or (p.products_status <> '1' and p.products_parent_id <> 0))
                                    ORDER BY products_name");
    while ($products = tep_db_fetch_array($products_query)) {

// Eversun mod for sppc and qty price breaks
/*      if (!in_array($products['products_id'], $exclude)) {
        $select_string .= '<option value="' . $products['products_id'] . '">' . $products['products_name'] . ' (' . $currencies->format($products['products_price']) . ')</option>'; */
      if (!in_array($products['products_id'], $exclude)) {
        $price_query=tep_db_query("select customers_group_price, customers_group_id from " . TABLE_PRODUCTS_GROUPS . " where products_id = " . $products['products_id']);
        $product_prices=array();
        while($prices_array=tep_db_fetch_array($price_query)){
          $product_prices[$prices_array['customers_group_id']]=$prices_array['customers_group_price'];
        }
        reset($all_groups);
        $price_string="";
        $sde=0;
        while(list($sdek,$sdev)=each($all_groups)){
          if (!in_array((int)$products['products_id'].":".(int)$sdek, $exclude)) {
            if($sde) $price_string.=", ";
            $price_string.=$sdev.": ".$currencies->format(isset($product_prices[$sdek]) ? $product_prices[$sdek]:$products['products_price']);
            $sde=1;
          }
        }
        $select_string .= '<option value="' . $products['products_id'] . '">' . $products['products_name'] . ' (' . $price_string . ')</option>\n';
      }
// Eversun mod end for sppc and qty price breaks
    }

    $select_string .= '</select>';

    return $select_string;
  }

  function tep_options_name($options_id) {
    global $languages_id;

    $options = tep_db_query("select products_options_name from " . TABLE_PRODUCTS_OPTIONS_TEXT . " where products_options_text_id = '" . (int)$options_id . "' and language_id = '" . (int)$languages_id . "'");
    $options_values = tep_db_fetch_array($options);

    return $options_values['products_options_name'];
  }

  function tep_values_name($values_id) {
    global $languages_id;

    $values = tep_db_query("select products_options_values_name from " . TABLE_PRODUCTS_OPTIONS_VALUES . " where products_options_values_id = '" . (int)$values_id . "' and language_id = '" . (int)$languages_id . "'");
    $values_values = tep_db_fetch_array($values);

    return $values_values['products_options_values_name'];
  }

  function tep_info_image($image, $alt, $width = '', $height = '') {
    if (tep_not_null($image) && (file_exists(DIR_FS_CATALOG_IMAGES . $image)) ) {
      $image = tep_image(HTTP_SERVER . DIR_WS_CATALOG_IMAGES . $image, $alt, $width, $height);
    } else {
      $image = TEXT_IMAGE_NONEXISTENT;
    }

    return $image;
  }

  function tep_break_string($string, $len, $break_char = '-') {
    $l = 0;
    $output = '';
    for ($i=0, $n=strlen($string); $i<$n; $i++) {
      $char = substr($string, $i, 1);
      if ($char != ' ') {
        $l++;
      } else {
        $l = 0;
      }
      if ($l > $len) {
        $l = 1;
        $output .= $break_char;
      }
      $output .= $char;
    }

    return $output;
  }

  function tep_get_country_name($country_id) {
    $country_query = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");

    if (!tep_db_num_rows($country_query)) {
      return $country_id;
    } else {
      $country = tep_db_fetch_array($country_query);
      return $country['countries_name'];
    }
  }

  function tep_get_zone_name($country_id, $zone_id, $default_zone) {
    $zone_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' and zone_id = '" . (int)$zone_id . "'");
    if (tep_db_num_rows($zone_query)) {
      $zone = tep_db_fetch_array($zone_query);
      return $zone['zone_name'];
    } else {
      return $default_zone;
    }
  }

  function tep_not_null($value) {
    if (is_array($value)) {
      if (sizeof($value) > 0) {
        return true;
      } else {
        return false;
      }
    } else {
      if ( (is_string($value) || is_int($value)) && ($value != '') && ($value != 'NULL') && (strlen(trim($value)) > 0)) {
        return true;
      } else {
        return false;
      }
    }
  }

  function tep_browser_detect($component) {
    global $HTTP_USER_AGENT;

    return stristr($HTTP_USER_AGENT, $component);
  }

  function tep_tax_classes_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $classes_query = tep_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
    while ($classes = tep_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['tax_class_id'] . '"';
      if ($selected == $classes['tax_class_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['tax_class_title'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }

  function tep_geo_zones_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $zones_query = tep_db_query("select geo_zone_id, geo_zone_name from " . TABLE_GEO_ZONES . " order by geo_zone_name");
    while ($zones = tep_db_fetch_array($zones_query)) {
      $select_string .= '<option value="' . $zones['geo_zone_id'] . '"';
      if ($selected == $zones['geo_zone_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $zones['geo_zone_name'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }

  function tep_get_geo_zone_name($geo_zone_id) {
    $zones_query = tep_db_query("select geo_zone_name from " . TABLE_GEO_ZONES . " where geo_zone_id = '" . (int)$geo_zone_id . "'");

    if (!tep_db_num_rows($zones_query)) {
      $geo_zone_name = $geo_zone_id;
    } else {
      $zones = tep_db_fetch_array($zones_query);
      $geo_zone_name = $zones['geo_zone_name'];
    }

    return $geo_zone_name;
  }

  function tep_address_format($address_format_id, $address, $html, $boln, $eoln) {
    $address_format_query = tep_db_query("select address_format as format from " . TABLE_ADDRESS_FORMAT . " where address_format_id = '" . (int)$address_format_id . "'");
    $address_format = tep_db_fetch_array($address_format_query);

    $company = tep_output_string_protected($address['company']);
    if (isset($address['firstname']) && tep_not_null($address['firstname'])) {
      $firstname = tep_output_string_protected($address['firstname']);
      $lastname = tep_output_string_protected($address['lastname']);
    } elseif (isset($address['name']) && tep_not_null($address['name'])) {
      $firstname = tep_output_string_protected($address['name']);
      $lastname = '';
    } else {
      $firstname = '';
      $lastname = '';
    }
    $street = tep_output_string_protected($address['street_address']);
    $suburb = tep_output_string_protected($address['suburb']);
    $city = tep_output_string_protected($address['city']);
    $state = tep_output_string_protected($address['state']);
    if (isset($address['country_id']) && tep_not_null($address['country_id'])) {
      $country = tep_get_country_name($address['country_id']);

      if (isset($address['zone_id']) && tep_not_null($address['zone_id'])) {
        $state = tep_get_zone_code($address['country_id'], $address['zone_id'], $state);
      }
    } elseif (isset($address['country']) && tep_not_null($address['country'])) {
      $country = tep_output_string_protected($address['country']);
    } else {
      $country = '';
    }
    $postcode = tep_output_string_protected($address['postcode']);
    $zip = $postcode;

    if ($html) {
// HTML Mode
      $HR = '<hr>';
      $hr = '<hr>';
      if ( ($boln == '') && ($eoln == "\n") ) { // Values not specified, use rational defaults
        $CR = '<br>';
        $cr = '<br>';
        $eoln = $cr;
      } else { // Use values supplied
        $CR = $eoln . $boln;
        $cr = $CR;
      }
    } else {
// Text Mode
      $CR = $eoln;
      $cr = $CR;
      $HR = '----------------------------------------';
      $hr = '----------------------------------------';
    }

    $statecomma = '';
    $streets = $street;
    if ($suburb != '') $streets = $street . $cr . $suburb;
    if ($country == '') $country = tep_output_string_protected($address['country']);
    if ($state != '') $statecomma = $state . ', ';

    $fmt = $address_format['format'];
    eval("\$address = \"$fmt\";");

    if ( (ACCOUNT_COMPANY == 'true') && (tep_not_null($company)) ) {
      $address = $company . $cr . $address;
    }

    return $address;
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Function    : tep_get_zone_code
  //
  // Arguments   : country           country code string
  //               zone              state/province zone_id
  //               def_state         default string if zone==0
  //
  // Return      : state_prov_code   state/province code
  //
  // Description : Function to retrieve the state/province code (as in FL for Florida etc)
  //
  ////////////////////////////////////////////////////////////////////////////////////////////////
  function tep_get_zone_code($country, $zone, $def_state) {

    $state_prov_query = tep_db_query("select zone_code from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and zone_id = '" . (int)$zone . "'");

    if (!tep_db_num_rows($state_prov_query)) {
      $state_prov_code = $def_state;
    }
    else {
      $state_prov_values = tep_db_fetch_array($state_prov_query);
      $state_prov_code = $state_prov_values['zone_code'];
    }

    return $state_prov_code;
  }

  function tep_get_uprid($prid, $params) {
    $uprid = $prid;
    if ( (is_array($params)) && (!strstr($prid, '{')) ) {
      while (list($option, $value) = each($params)) {
        $uprid = $uprid . '{' . $option . '}' . $value;
      }
    }

    return $uprid;
  }

  function tep_get_prid($uprid) {
    $pieces = explode('{', $uprid);

    return $pieces[0];
  }

  function tep_get_languages() {
    $languages_query = tep_db_query("select languages_id, name, code, image, directory from " . TABLE_LANGUAGES . " order by sort_order");
    while ($languages = tep_db_fetch_array($languages_query)) {
      $languages_array[] = array('id' => $languages['languages_id'],
                                 'name' => $languages['name'],
                                 'code' => $languages['code'],
                                 'image' => $languages['image'],
                                 'directory' => $languages['directory']);
    }

    return $languages_array;
  }

  function tep_get_category_name($category_id, $language_id) {
    $category_query = tep_db_query("select categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = tep_db_fetch_array($category_query);

    return $category['categories_name'];
  }

    function tep_get_category_htc_title($category_id, $language_id) {
    $category_query = tep_db_query("select categories_head_title_tag from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = tep_db_fetch_array($category_query);

    return $category['categories_head_title_tag'];
  }
    
  function tep_get_category_htc_desc($category_id, $language_id) {
    $category_query = tep_db_query("select categories_head_desc_tag from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = tep_db_fetch_array($category_query);

    return $category['categories_head_desc_tag'];
  }
   
  function tep_get_category_htc_keywords($category_id, $language_id) {
    $category_query = tep_db_query("select categories_head_keywords_tag  from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = tep_db_fetch_array($category_query);

    return $category['categories_head_keywords_tag '];
  }
  
  function tep_get_category_htc_description($category_id, $language_id) {
    $category_query = tep_db_query("select categories_htc_description from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = tep_db_fetch_array($category_query);

    return $category['categories_htc_description'];
  }
  
  function tep_get_orders_status_name($orders_status_id, $language_id = '') {
    global $languages_id;

    if (!$language_id) $language_id = $languages_id;
    $orders_status_query = tep_db_query("select orders_status_name from " . TABLE_ORDERS_STATUS . " where orders_status_id = '" . (int)$orders_status_id . "' and language_id = '" . (int)$language_id . "'");
    $orders_status = tep_db_fetch_array($orders_status_query);

    return $orders_status['orders_status_name'];
  }

  function tep_get_orders_status() {
    global $languages_id;

    $orders_status_array = array();
    $orders_status_query = tep_db_query("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "' order by orders_status_id");
    while ($orders_status = tep_db_fetch_array($orders_status_query)) {
      $orders_status_array[] = array('id' => $orders_status['orders_status_id'],
                                     'text' => $orders_status['orders_status_name']);
    }

    return $orders_status_array;
  }

  function tep_get_products_name($product_id, $language_id = 0) {
    global $languages_id;

    if ($language_id == 0) $language_id = $languages_id;
    $product_query = tep_db_query("select products_name from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_name'];
  }

  function tep_get_infobox_file_name($infobox_id, $language_id = 0) {
    global $languages_id;

    if ($language_id == 0) $language_id = $languages_id;
    $infobox_query = tep_db_query("select infobox_file_name from " . TABLE_INFOBOX_CONFIGURATION . " where infobox_id = '" . (int)$infobox_id . "' and language_id = '" . (int)$language_id . "'");
    $infobox = tep_db_fetch_array($infobox_query);

    return $infobox['infobox_file_name'];
  }

  function tep_get_products_description($product_id, $language_id) {
    $product_query = tep_db_query("select products_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_description'];
  }

  function tep_get_products_script($product_id, $language_id) {
    $product_query = tep_db_query("select products_script from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_script'];
  }

  function tep_get_products_head_title_tag($product_id, $language_id) {
    $product_query = tep_db_query("select products_head_title_tag from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_head_title_tag'];
  }

  function tep_get_products_head_desc_tag($product_id, $language_id) {
    $product_query = tep_db_query("select products_head_desc_tag from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_head_desc_tag'];
  }

  function tep_get_products_head_keywords_tag($product_id, $language_id) {
    $product_query = tep_db_query("select products_head_keywords_tag from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_head_keywords_tag'];
  }

  function tep_get_products_url($product_id, $language_id) {
    $product_query = tep_db_query("select products_url from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_url'];
  }

////
// Return the manufacturers URL in the needed language
// TABLES: manufacturers_info
  function tep_get_manufacturer_url($manufacturer_id, $language_id) {
    $manufacturer_query = tep_db_query("select manufacturers_url from " . TABLE_MANUFACTURERS_INFO . " where manufacturers_id = '" . (int)$manufacturer_id . "' and languages_id = '" . (int)$language_id . "'");
    $manufacturer = tep_db_fetch_array($manufacturer_query);

    return $manufacturer['manufacturers_url'];
  }

	////
	// Return the manufacturers name in the needed language
	// TABLES: manufacturers_info
	  function tep_get_manufacturer_name($manufacturer_id, $language_id) {
	    $manufacturer_query = tep_db_query("select manufacturers_name from " . TABLE_MANUFACTURERS_INFO . " where manufacturers_id = '" . (int)$manufacturer_id . "' and languages_id = '" . (int)$language_id . "'");
	    $manufacturer = tep_db_fetch_array($manufacturer_query);

	    return $manufacturer['manufacturers_name'];
	  }

	////
	// Return the manufacturers description in the needed language
	// TABLES: manufacturers_info
	  function tep_get_manufacturers_description($manufacturers_id, $language_id) {
	    $manufacturers_query = tep_db_query("select manufacturers_description from " . TABLE_MANUFACTURERS_INFO . " where manufacturers_id = '" . (int)$manufacturers_id . "' and languages_id = '" . (int)$language_id . "'");
	    $manufacturer = tep_db_fetch_array($manufacturers_query);

	    return $manufacturer['manufacturers_description'];
	  }


////
// Wrapper for class_exists() function
// This function is not available in all PHP versions so we test it before using it.
  function tep_class_exists($class_name) {
    if (function_exists('class_exists')) {
      return class_exists($class_name);
    } else {
      return true;
    }
  }

////
// Count how many products exist in a category
// TABLES: products, products_to_categories, categories
  function tep_products_in_category_count($categories_id, $include_deactivated = false) {
    $products_count = 0;

    if ($include_deactivated) {
      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . (int)$categories_id . "'");
    } else {
      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id = '" . (int)$categories_id . "'");
    }

    $products = tep_db_fetch_array($products_query);

    $products_count += $products['total'];

    $childs_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
    if (tep_db_num_rows($childs_query)) {
      while ($childs = tep_db_fetch_array($childs_query)) {
        $products_count += tep_products_in_category_count($childs['categories_id'], $include_deactivated);
      }
    }

    return $products_count;
  }

////
// Count how many subcategories exist in a category
// TABLES: categories
  function tep_childs_in_category_count($categories_id) {
    $categories_count = 0;

    $categories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
    while ($categories = tep_db_fetch_array($categories_query)) {
      $categories_count++;
      $categories_count += tep_childs_in_category_count($categories['categories_id']);
    }

    return $categories_count;
  }

////
// Returns an array with countries
// TABLES: countries
  function tep_get_countries($default = '') {
    $countries_array = array();
    if ($default) {
      $countries_array[] = array('id' => '',
                                 'text' => $default);
    }
    $countries_query = tep_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " order by countries_name");
    while ($countries = tep_db_fetch_array($countries_query)) {
      $countries_array[] = array('id' => $countries['countries_id'],
                                 'text' => $countries['countries_name']);
    }

    return $countries_array;
  }

////
// return an array with country zones
  function tep_get_country_zones($country_id) {
    $zones_array = array();
    $zones_query = tep_db_query("select zone_id, zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' order by zone_name");
    while ($zones = tep_db_fetch_array($zones_query)) {
      $zones_array[] = array('id' => $zones['zone_id'],
                             'text' => $zones['zone_name']);
    }

    return $zones_array;
  }

  function tep_prepare_country_zones_pull_down($country_id = '') {
// preset the width of the drop-down for Netscape
    $pre = '';
    if ( (!tep_browser_detect('MSIE')) && (tep_browser_detect('Mozilla/4')) ) {
      for ($i=0; $i<45; $i++) $pre .= '&nbsp;';
    }

    $zones = tep_get_country_zones($country_id);

    if (sizeof($zones) > 0) {
      $zones_select = array(array('id' => '', 'text' => PLEASE_SELECT));
      $zones = array_merge($zones_select, $zones);
    } else {
      $zones = array(array('id' => '', 'text' => TYPE_BELOW));
// create dummy options for Netscape to preset the height of the drop-down
      if ( (!tep_browser_detect('MSIE')) && (tep_browser_detect('Mozilla/4')) ) {
        for ($i=0; $i<9; $i++) {
          $zones[] = array('id' => '', 'text' => $pre);
        }
      }
    }

    return $zones;
  }

////
// Get list of address_format_id's
  function tep_get_address_formats() {
    $address_format_query = tep_db_query("select address_format_id from " . TABLE_ADDRESS_FORMAT . " order by address_format_id");
    $address_format_array = array();
    while ($address_format_values = tep_db_fetch_array($address_format_query)) {
      $address_format_array[] = array('id' => $address_format_values['address_format_id'],
                                      'text' => $address_format_values['address_format_id']);
    }
    return $address_format_array;
  }

////
// Alias function for Store configuration values in the Administration Tool
  function tep_cfg_pull_down_country_list($country_id) {
    return tep_draw_pull_down_menu('configuration_value', tep_get_countries(), $country_id);
  }

  function tep_cfg_pull_down_zone_list($zone_id) {
    return tep_draw_pull_down_menu('configuration_value', tep_get_country_zones(STORE_COUNTRY), $zone_id);
  }

  function tep_cfg_pull_down_tax_classes($tax_class_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $tax_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $tax_class_query = tep_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
    while ($tax_class = tep_db_fetch_array($tax_class_query)) {
      $tax_class_array[] = array('id' => $tax_class['tax_class_id'],
                                 'text' => $tax_class['tax_class_title']);
    }

    return tep_draw_pull_down_menu($name, $tax_class_array, $tax_class_id);
  }
//++++ QT Pro: Begin Changed code
////
// Function to build menu of available class files given a file prefix
// Used for configuring plug-ins for product information attributes
  function tep_cfg_pull_down_class_files($prefix, $current_file) {
    $d=DIR_FS_CATALOG . DIR_WS_CLASSES;
    $function_directory = dir ($d);

    while (false !== ($function = $function_directory->read())) {
      if (preg_match('/^'.$prefix.'(.+)\.php$/',$function,$function_name)) {
          $file_list[]=array('id'=>$function_name[1], 'text'=>$function_name[1]);
      }
    }
    $function_directory->close();

    return tep_draw_pull_down_menu('configuration_value', $file_list, $current_file);
  }

//++++ QT Pro: End Changed Code
////
// Function to read in text area in admin
 function tep_cfg_textarea($text) {
    return tep_draw_textarea_field('configuration_value', false, 35, 5, $text);
  }

  function tep_cfg_get_zone_name($zone_id) {
    $zone_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_id = '" . (int)$zone_id . "'");

    if (!tep_db_num_rows($zone_query)) {
      return $zone_id;
    } else {
      $zone = tep_db_fetch_array($zone_query);
      return $zone['zone_name'];
    }
  }

////
// Sets the status of a banner
  function tep_set_banner_status($banners_id, $status) {
    if ($status == '1') {
      return tep_db_query("update " . TABLE_BANNERS . " set status = '1', expires_impressions = NULL, expires_date = NULL, date_status_change = NULL where banners_id = '" . $banners_id . "'");
    } elseif ($status == '0') {
      return tep_db_query("update " . TABLE_BANNERS . " set status = '0', date_status_change = now() where banners_id = '" . $banners_id . "'");
    } else {
      return -1;
    }
  }

////
// Sets the status of a product
  function tep_set_product_status($products_id, $status) {
    if ($status == '1') {
      return tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '1', products_last_modified = now() where products_id = '" . (int)$products_id . "'");
    } elseif ($status == '0') {
      return tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '0', products_last_modified = now() where products_id = '" . (int)$products_id . "'");
    } else {
      return -1;
    }
  }

////
// Sets the status of a product on special
  function tep_set_specials_status($specials_id, $status) {
    if ($status == '1') {
      return tep_db_query("update " . TABLE_SPECIALS . " set status = '1', expires_date = NULL, date_status_change = NULL where specials_id = '" . (int)$specials_id . "'");
    } elseif ($status == '0') {
      return tep_db_query("update " . TABLE_SPECIALS . " set status = '0', date_status_change = now() where specials_id = '" . (int)$specials_id . "'");
    } else {
      return -1;
    }
  }

////
// Sets timeout for the current script.
// Cant be used in safe mode.
  function tep_set_time_limit($limit) {
    if (!get_cfg_var('safe_mode')) {
      set_time_limit($limit);
    }
  }

////
// Alias function for Store configuration values in the Administration Tool
  function tep_cfg_select_option($select_array, $key_value, $key = '') {
    $string = '';

    for ($i=0, $n=sizeof($select_array); $i<$n; $i++) {
      $name = ((tep_not_null($key)) ? 'configuration[' . $key . ']' : 'configuration_value');

      $string .= '<br><input type="radio" name="' . $name . '" value="' . $select_array[$i] . '"';

      if ($key_value == $select_array[$i]) $string .= ' CHECKED';

      $string .= '> ' . $select_array[$i];
    }

    return $string;
  }

////
// Alias function for module configuration keys
  function tep_mod_select_option($select_array, $key_name, $key_value) {
    reset($select_array);
    while (list($key, $value) = each($select_array)) {
      if (is_int($key)) $key = $value;
      $string .= '<br><input type="radio" name="configuration[' . $key_name . ']" value="' . $key . '"';
      if ($key_value == $key) $string .= ' CHECKED';
      $string .= '> ' . $value;
    }

    return $string;
  }

////
// Retreive server information
  function tep_get_system_information() {
    global $HTTP_SERVER_VARS;

    $db_query = tep_db_query("select now() as datetime");
    $db = tep_db_fetch_array($db_query);

    list($system, $host, $kernel) = preg_split('/[\s,]+/', @exec('uname -a'), 5);

    return array('date' => tep_datetime_short(date('Y-m-d H:i:s')),
                 'system' => $system,
                 'kernel' => $kernel,
                 'host' => $host,
                 'ip' => gethostbyname($host),
                 'uptime' => @exec('uptime'),
                 'http_server' => $HTTP_SERVER_VARS['SERVER_SOFTWARE'],
                 'php' => PHP_VERSION,
                 'zend' => (function_exists('zend_version') ? zend_version() : ''),
                 'db_server' => DB_SERVER,
                 'db_ip' => gethostbyname(DB_SERVER),
                 'db_version' => 'MySQL ' . (function_exists('mysql_get_server_info') ? mysql_get_server_info() : ''),
                 'db_date' => tep_datetime_short($db['datetime']));
  }

  function tep_generate_category_path($id, $from = 'category', $categories_array = '', $index = 0) {
    global $languages_id;

    if (!is_array($categories_array)) $categories_array = array();

    if ($from == 'product') {
      $categories_query = tep_db_query("select categories_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . (int)$id . "'");
      while ($categories = tep_db_fetch_array($categories_query)) {
        if ($categories['categories_id'] == '0') {
          $categories_array[$index][] = array('id' => '0', 'text' => TEXT_TOP);
        } else {
          $category_query = tep_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$categories['categories_id'] . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
          $category = tep_db_fetch_array($category_query);
          $categories_array[$index][] = array('id' => $categories['categories_id'], 'text' => $category['categories_name']);
          if ( (tep_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = tep_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
          $categories_array[$index] = array_reverse($categories_array[$index]);
        }
        $index++;
      }
    } elseif ($from == 'category') {
      $category_query = tep_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
      $category = tep_db_fetch_array($category_query);
      $categories_array[$index][] = array('id' => $id, 'text' => $category['categories_name']);
      if ( (tep_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = tep_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
    }

    return $categories_array;
  }

  function tep_output_generated_category_path($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = tep_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);

    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;

    return $calculated_category_path_string;
  }

  function tep_get_generated_category_path_ids($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = tep_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['id'] . '_';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -1) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);

    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;

    return $calculated_category_path_string;
  }

  function tep_remove_category($category_id) {
    $category_image_query = tep_db_query("select categories_image from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    $category_image = tep_db_fetch_array($category_image_query);

    $duplicate_image_query = tep_db_query("select count(*) as total from " . TABLE_CATEGORIES . " where categories_image = '" . tep_db_input($category_image['categories_image']) . "'");
    $duplicate_image = tep_db_fetch_array($duplicate_image_query);

    if ($duplicate_image['total'] < 2) {
      if (file_exists(DIR_FS_CATALOG_IMAGES . $category_image['categories_image'])) {
        @unlink(DIR_FS_CATALOG_IMAGES . $category_image['categories_image']);
      }
    }

    tep_db_query("delete from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    tep_db_query("delete from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS_TO_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");

    if (USE_CACHE == 'true') {
      tep_reset_cache_block('categories');
      tep_reset_cache_block('also_purchased');
    }
	//++++ QT Pro: Begin Changed code
	qtpro_doctor_amputate_all_from_product($product_id);
	//++++ QT Pro: End Changed code
  }

  function tep_remove_product($product_id) {
    $product_image_query = tep_db_query("select products_image from " . TABLE_PRODUCTS . " where products_id = '" . (int)$product_id . "'");
    $product_image = tep_db_fetch_array($product_image_query);

    $duplicate_image_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " where products_image = '" . tep_db_input($product_image['products_image']) . "'");
    $duplicate_image = tep_db_fetch_array($duplicate_image_query);

    if ($duplicate_image['total'] < 2) {
      if (file_exists(DIR_FS_CATALOG_IMAGES . $product_image['products_image'])) {
        @unlink(DIR_FS_CATALOG_IMAGES . $product_image['products_image']);
      }
    }

    tep_db_query("delete from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS . " where products_id = '" . (int)$product_id . "'");
    
// Eversun mod for sppc and qty price breaks    
    tep_db_query("delete from " . TABLE_PRODUCTS_GROUPS . " where products_id = '" . (int)$product_id . "'");
// Eversun mod end for sppc and qty price breaks
    
    tep_db_query("delete from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_PRODUCTS_ATTRIBUTES . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where products_id = '" . (int)$product_id . "'");
    tep_db_query("delete from " . TABLE_CUSTOMERS_BASKET_ATTRIBUTES . " where products_id = '" . (int)$product_id . "'");
// START: Extra Fields Contribution  DMG
    tep_db_query("delete from " . TABLE_PRODUCTS_TO_PRODUCTS_EXTRA_FIELDS . " where products_id = " . (int)$product_id);
// END: Extra Fields Contribution
    $product_reviews_query = tep_db_query("select reviews_id from " . TABLE_REVIEWS . " where products_id = '" . (int)$product_id . "'");
    while ($product_reviews = tep_db_fetch_array($product_reviews_query)) {
      tep_db_query("delete from " . TABLE_REVIEWS_DESCRIPTION . " where reviews_id = '" . (int)$product_reviews['reviews_id'] . "'");
    }
    tep_db_query("delete from " . TABLE_REVIEWS . " where products_id = '" . (int)$product_id . "'");

    if (USE_CACHE == 'true') {
      tep_reset_cache_block('categories');
      tep_reset_cache_block('also_purchased');
    }
  }

  function tep_remove_order($order_id, $restock) {
    if ($restock == 'on') {
      $order_query = tep_db_query("select products_id, products_quantity from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
      while ($order = tep_db_fetch_array($order_query)) {
        tep_db_query("update " . TABLE_PRODUCTS . " set products_quantity = products_quantity + " . $order['products_quantity'] . ", products_ordered = products_ordered - " . $order['products_quantity'] . " where products_id = '" . (int)$order['products_id'] . "'");
      }
    }

    //begin PayPal_Shopping_Cart_IPN 2.8 DMG
 include_once(DIR_FS_CATALOG_MODULES . 'payment/paypal/functions/general.func.php');
    paypal_remove_order($order_id);
//end PayPal_Shopping_Cart_IPN
    tep_db_query("delete from " . TABLE_ORDERS . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . (int)$order_id . "'");
  }

  function tep_reset_cache_block($cache_block) {
    global $cache_blocks;
$dir_cache = DIR_FS_CATALOG . DIR_FS_CACHE ;
   // get default template
   if (tep_not_null($cptemplate1['template_selected'])) {
  define(TEMPLATE_NAME, $cptemplate['template_selected']);
    }else if  (tep_not_null(DEFAULT_TEMPLATE)){
  define(TEMPLATE_NAME, DEFAULT_TEMPLATE);  
    } else {
    define(TEMPLATE_NAME, 'default');
    }
     $template_query = tep_db_query("select template_name from " . TABLE_TEMPLATE . "  order by template_name");
      while ($template = tep_db_fetch_array($template_query)) {
        $template_array=array(template=>template_name);
        }

    
    for ($i=0, $n=sizeof($cache_blocks); $i<$n; $i++) {
      if ($cache_blocks[$i]['code'] == $cache_block) {
        if ($cache_blocks[$i]['multiple']) {
          if ($dir = @opendir($dir_cache)) {
            while ($cache_file = readdir($dir)) {
              $cached_file = $cache_blocks[$i]['file'];
              $languages = tep_get_languages();
              for ($j=0, $k=sizeof($languages); $j<$k; $j++) {
                $cached_file_unlink = ereg_replace('-language', '-' . $languages[$j]['directory'], $cached_file);
                
                              for ($j=0, $k=sizeof($template_array); $j<$k; $j++) {
                    $cached_file_unlink = ereg_replace('-TEMPLATE_NAME', '-' . $template_array[$j]['template_name'] , $cached_file);
              
                
                if (ereg('^' . $cached_file_unlink, $cache_file)) {
                  @unlink($dir_cache . $cache_file);
                  }
                }
              }
            } 
            closedir($dir);
          }
        } else {
          $cached_file = $cache_blocks[$i]['file'];
          $languages = tep_get_languages();
          for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
            $cached_file = ereg_replace('-language', '-' . $languages[$i]['directory'], $cached_file);
            @unlink(DIR_FS_CACHE . $cached_file);
          }
        }
        break;
      }
    }
  }

  function tep_get_file_permissions($mode) {
// determine type
    if ( ($mode & 0xC000) == 0xC000) { // unix domain socket
      $type = 's';
    } elseif ( ($mode & 0x4000) == 0x4000) { // directory
      $type = 'd';
    } elseif ( ($mode & 0xA000) == 0xA000) { // symbolic link
      $type = 'l';
    } elseif ( ($mode & 0x8000) == 0x8000) { // regular file
      $type = '-';
    } elseif ( ($mode & 0x6000) == 0x6000) { //bBlock special file
      $type = 'b';
    } elseif ( ($mode & 0x2000) == 0x2000) { // character special file
      $type = 'c';
    } elseif ( ($mode & 0x1000) == 0x1000) { // named pipe
      $type = 'p';
    } else { // unknown
      $type = '?';
    }

// determine permissions
    $owner['read']    = ($mode & 00400) ? 'r' : '-';
    $owner['write']   = ($mode & 00200) ? 'w' : '-';
    $owner['execute'] = ($mode & 00100) ? 'x' : '-';
    $group['read']    = ($mode & 00040) ? 'r' : '-';
    $group['write']   = ($mode & 00020) ? 'w' : '-';
    $group['execute'] = ($mode & 00010) ? 'x' : '-';
    $world['read']    = ($mode & 00004) ? 'r' : '-';
    $world['write']   = ($mode & 00002) ? 'w' : '-';
    $world['execute'] = ($mode & 00001) ? 'x' : '-';

// adjust for SUID, SGID and sticky bit
    if ($mode & 0x800 ) $owner['execute'] = ($owner['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x400 ) $group['execute'] = ($group['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x200 ) $world['execute'] = ($world['execute'] == 'x') ? 't' : 'T';

    return $type .
           $owner['read'] . $owner['write'] . $owner['execute'] .
           $group['read'] . $group['write'] . $group['execute'] .
           $world['read'] . $world['write'] . $world['execute'];
  }

  function tep_remove($source) {
    global $messageStack, $tep_remove_error;

    if (isset($tep_remove_error)) $tep_remove_error = false;

    if (is_dir($source)) {
      $dir = dir($source);
      while ($file = $dir->read()) {
        if ( ($file != '.') && ($file != '..') ) {
          if (is_writeable($source . '/' . $file)) {
            tep_remove($source . '/' . $file);
          } else {
            $messageStack->add('search', sprintf(ERROR_FILE_NOT_REMOVEABLE, $source . '/' . $file), 'error');
            $tep_remove_error = true;
          }
        }
      }
      $dir->close();

      if (is_writeable($source)) {
        rmdir($source);
      } else {
        $messageStack->add('search', sprintf(ERROR_DIRECTORY_NOT_REMOVEABLE, $source), 'error');
        $tep_remove_error = true;
      }
    } else {
      if (is_writeable($source)) {
        unlink($source);
      } else {
        $messageStack->add('search', sprintf(ERROR_FILE_NOT_REMOVEABLE, $source), 'error');
        $tep_remove_error = true;
      }
    }
  }

////
// Output the tax percentage with optional padded decimals
  function tep_display_tax_value($value, $padding = TAX_DECIMAL_PLACES) {
    if (strpos($value, '.')) {
      $loop = true;
      while ($loop) {
        if (substr($value, -1) == '0') {
          $value = substr($value, 0, -1);
        } else {
          $loop = false;
          if (substr($value, -1) == '.') {
            $value = substr($value, 0, -1);
          }
        }
      }
    }

    if ($padding > 0) {
      if ($decimal_pos = strpos($value, '.')) {
        $decimals = strlen(substr($value, ($decimal_pos+1)));
        for ($i=$decimals; $i<$padding; $i++) {
          $value .= '0';
        }
      } else {
        $value .= '.';
        for ($i=0; $i<$padding; $i++) {
          $value .= '0';
        }
      }
    }

    return $value;
  }

  function tep_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name, $from_email_address) {
    if (SEND_EMAILS != 'true') return false;

    // Instantiate a new mail object
    $message = new email(array('X-Mailer: osCommerce'));

    // Build the text version
    $text = strip_tags($email_text);
    if (EMAIL_USE_HTML == 'true') {
      $message->add_html($email_text, $text);
    } else {
      $message->add_text($text);
    }

    // Send message
    $message->build_message();
    $message->send($to_name, $to_email_address, $from_email_name, $from_email_address, $email_subject);
  }

  function tep_get_tax_class_title($tax_class_id) {
    if ($tax_class_id == '0') {
      return TEXT_NONE;
    } else {
      $classes_query = tep_db_query("select tax_class_title from " . TABLE_TAX_CLASS . " where tax_class_id = '" . (int)$tax_class_id . "'");
      $classes = tep_db_fetch_array($classes_query);

      return $classes['tax_class_title'];
    }
  }

  function tep_banner_image_extension() {
    if (function_exists('imagetypes')) {
      if (imagetypes() & IMG_PNG) {
        return 'png';
      } elseif (imagetypes() & IMG_JPG) {
        return 'jpg';
      } elseif (imagetypes() & IMG_GIF) {
        return 'gif';
      }
    } elseif (function_exists('imagecreatefrompng') && function_exists('imagepng')) {
      return 'png';
    } elseif (function_exists('imagecreatefromjpeg') && function_exists('imagejpeg')) {
      return 'jpg';
    } elseif (function_exists('imagecreatefromgif') && function_exists('imagegif')) {
      return 'gif';
    }

    return false;
  }

////
// Wrapper function for round() for php3 compatibility
  function tep_round($value, $precision) {
    if (PHP_VERSION < 4) {
      $exp = pow(10, $precision);
      return round($value * $exp) / $exp;
    } else {
      return round($value, $precision);
    }
  }

////
// Add tax to a products price
  function tep_add_tax($price, $tax) {
    global $currencies;

    if ( (DISPLAY_PRICE_WITH_TAX == 'true') && ($tax > 0) ) {
      return round($price, '3') + tep_calculate_tax($price, $tax);
    } else {
      return round($price, '3');
    }
  }

// Calculates Tax rounding the result
  function tep_calculate_tax($price, $tax) {
    global $currencies;

    return round($price * $tax / 100, '3');
  }

////

//// debut modif by paddybl for ecotax
// Returns the tax rate for a zone / class
// TABLES: tax_rates, zones_to_geo_zones
// This is the original function
/*
  function tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1) {
    global $customer_zone_id, $customer_country_id;

    if ( ($country_id == -1) && ($zone_id == -1) ) {
      if (!tep_session_is_registered('customer_id')) {
        $country_id = STORE_COUNTRY;
        $zone_id = STORE_ZONE;
      } else {
        $country_id = $customer_country_id;
        $zone_id = $customer_zone_id;
      }
    }

    $tax_query = tep_db_query("select sum(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za ON tr.tax_zone_id = za.geo_zone_id left join " . TABLE_GEO_ZONES . " tz ON tz.geo_zone_id = tr.tax_zone_id WHERE (za.zone_country_id IS NULL OR za.zone_country_id = '0' OR za.zone_country_id = '" . (int)$country_id . "') AND (za.zone_id IS NULL OR za.zone_id = '0' OR za.zone_id = '" . (int)$zone_id . "') AND tr.tax_class_id = '" . (int)$class_id . "' GROUP BY tr.tax_priority");
    if (tep_db_num_rows($tax_query)) {
      $tax_multiplier = 0;
      while ($tax = tep_db_fetch_array($tax_query)) {
        $tax_multiplier += $tax['tax_rate'];
      }
      return $tax_multiplier;
    } else {
      return 0;
    }
  }
  */
 //this one is copied from the catalog side
  function tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1) {
    global $customer_zone_id, $customer_country_id;

    if ( ($country_id == -1) && ($zone_id == -1) ) {
      if (!tep_session_is_registered('customer_id')) {
        $country_id = STORE_COUNTRY;
        $zone_id = STORE_ZONE;
      } else {
        $country_id = $customer_country_id;
        $zone_id = $customer_zone_id;
      }
    }

    $tax_query = tep_db_query("select sum(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' group by tr.tax_priority");
    if (tep_db_num_rows($tax_query)) {
      $tax_multiplier = 1.0;
      while ($tax = tep_db_fetch_array($tax_query)) {
        $tax_multiplier *= 1.0 + ($tax['tax_rate'] / 100);
      }
      return ($tax_multiplier - 1.0) * 100;
    } else {
      return 0;
    }
  }
  //fin modif by paddybl for ecotax
////
// Returns the tax rate for a tax class
// TABLES: tax_rates
//debut modif by paddybl for ecotax
  function tep_get_tax_rate_value($class_id, $country_id = -1, $zone_id = -1) {
      global $customer_zone_id, $customer_country_id;

    if ( ($country_id == -1) && ($zone_id == -1) ) {
      if (!tep_session_is_registered('customer_id')) {
        $country_id = STORE_COUNTRY;
        $zone_id = STORE_ZONE;
      } else {
        $country_id = $customer_country_id;
        $zone_id = $customer_zone_id;
      }
    }

    $tax_query = tep_db_query("select sum(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' group by tr.tax_priority");
   // $tax_query = tep_db_query("select SUM(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " where tax_class_id = '" . (int)$class_id . "' group by tax_priority");
   //fin modif by paddybl for ecotax
    if (tep_db_num_rows($tax_query)) {
      $tax_multiplier = 0;
      while ($tax = tep_db_fetch_array($tax_query)) {
        $tax_multiplier += $tax['tax_rate'];
      }
      return $tax_multiplier;
    } else {
      return 0;
    }
  }

  function tep_call_function($function, $parameter, $object = '') {
    if ($object == '') {
      return call_user_func($function, $parameter);
    } elseif (PHP_VERSION < 4) {
      return call_user_method($function, $object, $parameter);
    } else {
      return call_user_func(array($object, $function), $parameter);
    }
  }

  function tep_get_zone_class_title($zone_class_id) {
    if ($zone_class_id == '0') {
      return TEXT_NONE;
    } else {
      $classes_query = tep_db_query("select geo_zone_name from " . TABLE_GEO_ZONES . " where geo_zone_id = '" . (int)$zone_class_id . "'");
      $classes = tep_db_fetch_array($classes_query);

      return $classes['geo_zone_name'];
    }
  }

  function tep_cfg_pull_down_zone_classes($zone_class_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $zone_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $zone_class_query = tep_db_query("select geo_zone_id, geo_zone_name from " . TABLE_GEO_ZONES . " order by geo_zone_name");
    while ($zone_class = tep_db_fetch_array($zone_class_query)) {
      $zone_class_array[] = array('id' => $zone_class['geo_zone_id'],
                                  'text' => $zone_class['geo_zone_name']);
    }

    return tep_draw_pull_down_menu($name, $zone_class_array, $zone_class_id);
  }

  function tep_cfg_pull_down_order_statuses($order_status_id, $key = '') {
    global $languages_id;

    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $statuses_array = array(array('id' => '0', 'text' => TEXT_DEFAULT));
    $statuses_query = tep_db_query("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "' order by orders_status_name");
    while ($statuses = tep_db_fetch_array($statuses_query)) {
      $statuses_array[] = array('id' => $statuses['orders_status_id'],
                                'text' => $statuses['orders_status_name']);
    }

    return tep_draw_pull_down_menu($name, $statuses_array, $order_status_id);
  }

  function tep_get_order_status_name($order_status_id, $language_id = '') {
    global $languages_id;

    if ($order_status_id < 1) return TEXT_DEFAULT;

    if (!is_numeric($language_id)) $language_id = $languages_id;

    $status_query = tep_db_query("select orders_status_name from " . TABLE_ORDERS_STATUS . " where orders_status_id = '" . (int)$order_status_id . "' and language_id = '" . (int)$language_id . "'");
    $status = tep_db_fetch_array($status_query);

    return $status['orders_status_name'];
  }

////
// Return a random value
  function tep_rand($min = null, $max = null) {
    static $seeded;

    if (!$seeded) {
      mt_srand((double)microtime()*1000000);
      $seeded = true;
    }

    if (isset($min) && isset($max)) {
      if ($min >= $max) {
        return $min;
      } else {
        return mt_rand($min, $max);
      }
    } else {
      return mt_rand();
    }
  }

// nl2br() prior PHP 4.2.0 did not convert linefeeds on all OSs (it only converted \n)
  function tep_convert_linefeeds($from, $to, $string) {
    if ((PHP_VERSION < "4.0.5") && is_array($from)) {
      return ereg_replace('(' . implode('|', $from) . ')', $to, $string);
    } else {
      return str_replace($from, $to, $string);
    }
  }

  function tep_string_to_int($string) {
    return (int)$string;
  }

////
// Parse and secure the cPath parameter values
  function tep_parse_category_path($cPath) {
// make sure the category IDs are integers
    $cPath_array = array_map('tep_string_to_int', explode('_', $cPath));

// make sure no duplicate category IDs exist which could lock the server in a loop
    $tmp_array = array();
    $n = sizeof($cPath_array);
    for ($i=0; $i<$n; $i++) {
      if (!in_array($cPath_array[$i], $tmp_array)) {
        $tmp_array[] = $cPath_array[$i];
      }
    }

    return $tmp_array;
  }
// Alias function for array of configuration values in the Administration Tool
  function tep_cfg_select_multioption($select_array, $key_value, $key = '') {
    for ($i=0; $i<sizeof($select_array); $i++) {
      $name = (($key) ? 'configuration[' . $key . '][]' : 'configuration_value');
      $string .= '<br><input type="checkbox" name="' . $name . '" value="' . $select_array[$i] . '"';
      $key_values = explode( ", ", $key_value);
      if ( in_array($select_array[$i], $key_values) ) $string .= 'CHECKED';
      $string .= '> ' . $select_array[$i];
    }
    return $string;
  }

//create a select list to display list of themes available for selection
  function tep_cfg_pull_down_template_list($template_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $template_query = tep_db_query("select template_id, template_name from " . TABLE_TEMPLATE . " order by template_name");
    while ($template = tep_db_fetch_array($template_query)) {
      $template_array[] = array('id' => $template['template_name'],
                                 'text' => $template['template_name']);
    }

    return tep_draw_pull_down_menu($name, $template_array, $template_id);
  }


// BOF: WebMakers.com Added: Downloads Controller
require(DIR_WS_FUNCTIONS . 'downloads_controller.php');
// EOF: WebMakers.com Added: Downloads Controller

// Contact US Email Subjects : DMG
// PassionSeed Contact Us Email Subject begin
  function tep_get_email_subjects_list($subjects_array = '') {
    if (!is_array($subjects_array)) $subjects_array = array();

    $subjects_query = tep_db_query("select email_subjects_id, email_subjects_name from " . TABLE_EMAIL_SUBJECTS . " order by email_subjects_name");
    while ($subjects = tep_db_fetch_array($subjects_query)) {
      $subjects_array[] = array('id' => $subjects['email_subjects_name'], 'text' => $subjects['email_subjects_name']);
    }

    return $subjects_array;
  }
// PassionSeed Contact Us Email Subject end
function tep_get_pay_method($pay_methods_id, $language_id = '') {
    global $languages_id;

    if (!$language_id) $language_id = $languages_id;
    $pay_method_query1 = tep_db_query("select pay_method from " . TABLE_ORDERS_PAY_METHODS . " where pay_methods_id = '" . (int)$pay_methods_id . "' and pay_method_language = '" . (int)$language_id . "'");
    $pay_method1 = tep_db_fetch_array($pay_method_query1);

    return $pay_method1['pay_method'];
  }
function tep_get_ship_method($ship_methods_id, $language_id = '') {
    global $languages_id;

    if (!$language_id) $language_id = $languages_id;
    $ship_method_query1 = tep_db_query("select ship_method from " . TABLE_ORDERS_SHIP_METHODS . " where ship_methods_id = '" . (int)$ship_methods_id . "' and ship_method_language = '" . (int)$language_id . "'");
    $ship_method1 = tep_db_fetch_array($ship_method_query1);

    return $ship_method1['ship_method'];
  }

  function tep_get_ip_address() {
    if (isset($_SERVER)) {
      if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
      } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
      } else {
        $ip = $_SERVER['REMOTE_ADDR'];
      }
    } else {
      if (getenv('HTTP_X_FORWARDED_FOR')) {
        $ip = getenv('HTTP_X_FORWARDED_FOR');
      } elseif (getenv('HTTP_CLIENT_IP')) {
        $ip = getenv('HTTP_CLIENT_IP');
      } else {
        $ip = getenv('REMOTE_ADDR');
      }
    }

    return $ip;
  }

  
function tep_get_box_heading($infobox_id, $languages_id) {
    $configuration_query12 = tep_db_query("select box_heading from " . TABLE_INFOBOX_HEADING . " where infobox_id = '" . (int)$infobox_id . "' and languages_id = '" . (int)$languages_id . "'");
    $configuration12 = tep_db_fetch_array($configuration_query12);

    return $configuration12['box_heading'];
  }

 //debut modif by paddybl for ecotax
  // attention cette fonction peut tre en double!!!!
  
  // Function    : tep_get_country_id
  // Arguments   : country_name		country name string
  // Return      : country_id
  // Description : Function to retrieve the country_id based on the country's name
  function tep_get_country_id2($country_name) {
    $country_id_query = tep_db_query("select * from " . TABLE_COUNTRIES . " where countries_name = '" . $country_name . "'");
    if (!tep_db_num_rows($country_id_query)) {
      return 0;
    }
    else {
      $country_id_row = tep_db_fetch_array($country_id_query);
      return $country_id_row['countries_id'];
    }
  }

    // attention cette fonction peut tre en double!!!!
  
   // Function    : tep_get_zone_id
  // Arguments   : country_id		country id string    zone_name		state/province name
  // Return      : zone_id
  // Description : Function to retrieve the zone_id based on the zone's name
  function tep_get_zone_id2($country_id, $zone_name) {
    $zone_id_query = tep_db_query("select * from " . TABLE_ZONES . " where zone_country_id = '" . $country_id . "' and zone_name = '" . addslashes($zone_name) . "'");
    if (!tep_db_num_rows($zone_id_query)) {
      return 0;
    }
    else {
      $zone_id_row = tep_db_fetch_array($zone_id_query);
      return $zone_id_row['zone_id'];
    }
  }
  	//fin ajout fonction by paddybl for ecotax
	
    //debut modif by paddybl for ecotax
    function tep_ecotax_classes_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $classes_query = tep_db_query("select ecotax_class_id, ecotax_class_title from " . TABLE_ECOTAX_CLASS . " order by ecotax_class_title");
    while ($classes = tep_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['ecotax_class_id'] . '"';
      if ($selected == $classes['ecotax_class_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['ecotax_class_title'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }
      function tep_ecotax_categorie_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
	 $select_string .= '<option value="">Choisissez</option>';
    $classes_query = tep_db_query("select ecotax_class_id,ecotax_class_title, ecotax_class_description from " . TABLE_ECOTAX_CLASS . " order by ecotax_class_title");
    while ($classes = tep_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['ecotax_class_id'] . '"';
      if ($selected == $classes['ecotax_class_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['ecotax_class_description'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }
  
      function tep_ecotax_rate_pull_down($parameters,$ecotax_class_id, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
	 $select_string .= '<option value="">Choisissez</option>';
	 $select_string .= '<option value="0" ';
	 if ($selected == 0) $select_string .= ' SELECTED';
	 $select_string.= '>Produit non assujettie  l\'Ecotaxe</option>';
	 $select_string .= '<option value="999" ';
	 if ($selected == 999 or $selected <0) $select_string .= ' SELECTED';
	 $select_string.= '>Ecotaxe personalise</option>';
	 if ($ecotax_class_id!=0){
    $classes_query = tep_db_query("select ecotax_rates_id,ecotax_description,code_ecotax from " . TABLE_ECOTAX_RATES . " where ecotax_class_id=\"".$ecotax_class_id."\" order by ecotax_rates_id");}else{$classes_query = tep_db_query("select ecotax_rates_id,ecotax_description,code_ecotax from " . TABLE_ECOTAX_RATES . " order by ecotax_class_id");}
    while ($classes = tep_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['ecotax_rates_id'] . '"';
      if ($selected == $classes['ecotax_rates_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['ecotax_description'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }
function tep_ecotax_rate_pull_down_prodsub($parameters,$ecotax_class_id, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
	 $select_string .= '<option value="">Choisissez</option>';
	 $select_string .= '<option value="0" ';
	 if ($selected == 0) $select_string .= ' SELECTED';
	 $select_string.= '>Produit non assujettie  l\'Ecotaxe</option>';
	 if ($ecotax_class_id!=0){
    $classes_query = tep_db_query("select ecotax_rates_id,ecotax_description,code_ecotax from " . TABLE_ECOTAX_RATES . " where ecotax_class_id=\"".$ecotax_class_id."\" order by ecotax_rates_id");}else{$classes_query = tep_db_query("select ecotax_rates_id,ecotax_description,code_ecotax from " . TABLE_ECOTAX_RATES . " order by ecotax_class_id");}
    while ($classes = tep_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['ecotax_rates_id'] . '"';
      if ($selected == $classes['ecotax_rates_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['ecotax_description'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }

//debut modif by paddybl for ecotax
////
// Returns the ecotax rate for a zone / class
// TABLES: ecotax, zones_to_geo_zones
  function tep_get_custom_ecotax($class_id){
    $custom_ecotax_query = tep_db_query("select custom_ecotax as ecotax_price from " . TABLE_CUSTOM_ECOTAX . " where products_id = '" . (int)$class_id . "'"); 
	if (tep_db_num_rows($custom_ecotax_query)) {
	$custom_ecotax = tep_db_fetch_array($custom_ecotax_query);
	$custom_ecotax= tep_round($custom_ecotax['ecotax_price']/((CUSTOM_ECOTAX_RATE/100)+1),2);
	return $custom_ecotax;}else{
	return 0;}
  }
  function tep_get_custom_ecotax_text($class_id){
    $custom_ecotax_query = tep_db_query("select custom_ecotax_text as ecotax_text from " . TABLE_CUSTOM_ECOTAX . " where products_id = '" . (int)$class_id . "'"); 
	if (tep_db_num_rows($custom_ecotax_query)) {
	$custom_ecotax_query = tep_db_fetch_array($custom_ecotax_query);
	$custom_ecotax_text= $custom_ecotax_query['ecotax_text'];
	return $custom_ecotax_text;}else{
	return 0;}
  }   
  function tep_get_ecotax_price_value($class_id) {

  	if ((int)$class_id<0 or (int)$class_id==999){return tep_get_custom_ecotax(abs((int)$class_id));}else{
    $ecotax_query = tep_db_query("select SUM(ecotax_price) as ecotax_price from " . TABLE_ECOTAX_RATES . " where ecotax_rates_id = '" . (int)$class_id . "'");
    if (tep_db_num_rows($ecotax_query)) {
      $ecotax_multiplier = 0;
      while ($ecotax = tep_db_fetch_array($ecotax_query)) {
        $ecotax_multiplier += $ecotax['ecotax_price'];
      }
      return tep_round($ecotax_multiplier, 2);
    } else {	
	return 0;}
    }
  }
  function tep_get_ecotax_rate_value($class_id) {
	if ((int)$class_id<0 or (int)$class_id==999){return CUSTOM_ECOTAX_RATE;}else{
	    $ecotax_query = tep_db_query("select SUM(tax_rate) as tax_rate from " . TABLE_ECOTAX_RATES . " where ecotax_rates_id = '" . (int)$class_id . "'");
    if (tep_db_num_rows($ecotax_query)) {
      $ecotax_multiplier = 0;
      while ($ecotax = tep_db_fetch_array($ecotax_query)) {
        $ecotax_multiplier += $ecotax['tax_rate'];
      }
      return $ecotax_multiplier;
    } else {

	return 0;}
    }
  }
  //fin modif by paddybl for ecotax
  
  //debut modif by paddybl for ecotax
  function tep_get_ecotax_class_id($product_id, $language_id = 0) {
    global $languages_id;

    if ($language_id == 0) $language_id = $languages_id;
    $product_query = tep_db_query("select c.ecotax_class_id from ((" . TABLE_PRODUCTS . " p) left join " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c on (p.products_id = p2c.products_id)) left join " . TABLE_CATEGORIES . " c on ( p2c.categories_id = c.categories_id )  where p.products_id = '" . (int)$product_id . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['ecotax_class_id'];
  }
  
   function tep_get_ecotax_rates_id($product_id, $language_id = 0) {
    global $languages_id;

    if ($language_id == 0) $language_id = $languages_id;
    $product_query = tep_db_query("select ecotax_rates_id from " . TABLE_PRODUCTS . " where products_id = '" . (int)$product_id . "'");
    $product = tep_db_fetch_array($product_query);
	
    return $product['ecotax_rates_id'];
  }
  
  function tep_get_ecotax_rate($rates_id, $country_id = -1, $zone_id = -1) {
    global $customer_zone_id, $customer_country_id;

    if ( ($country_id == -1) && ($zone_id == -1) ) {
      if (!tep_session_is_registered('customer_id')) {
        $country_id = STORE_COUNTRY;
        $zone_id = STORE_ZONE;
      } else {
        $country_id = $customer_country_id;
        $zone_id = $customer_zone_id;
      }
    }

if ((int)$rates_id<0 or (int)$rates_id==999){return CUSTOM_ECOTAX_RATE;}else{
    $ecotax_query = tep_db_query("select sum(tax_rate) as tax_rate from " . TABLE_ECOTAX_RATES . " tr  where tr.ecotax_rates_id = '" . (int)$rates_id . "' group by tr.ecotax_rates_id");

    if (tep_db_num_rows($ecotax_query)) {	
      $ecotax_multiplier = 1.0;
      while ($ecotax = tep_db_fetch_array($ecotax_query)) {
        $ecotax_multiplier *= 1.0 + ($ecotax['tax_rate'] / 100);
      }
	
      return ($ecotax_multiplier - 1.0) * 100;
    } else {	
      return 0;}
    }
  } 
   
  function display_deee($array_deee,$ecotax_rates_id=0){
	$tax_rate=tep_get_ecotax_rate($ecotax_rates_id);
	$ecotax_price=tep_get_ecotax_price_value($ecotax_rates_id);
	$ecotax_detail=tep_get_ecotax_description($ecotax_rates_id);
	$ecotax_code=$ecotax_detail[0]['code'];
	$ecotax_description=$ecotax_detail[0]['text'];	
	$ecotax_class=$ecotax_detail[0]['class'];
	$ecotax_class_text=$ecotax_detail[0]['title'];

$i=0;
$add_line=1;
    $n=sizeof($array_deee);
do  {
		if ($array_deee[$i]['id']==$ecotax_code){$add_line=0;}
									  $i++;				  					
									  }while(  $i<=$n );							  
		if ($add_line==1){
		      $array_deee[$n] = array('id' => $ecotax_detail[0]['code'],
		  					          'categorie' => $ecotax_class_text.' - Classe d\'appareil ('.$ecotax_detail[0]['code'].'):<br><small>'.$ecotax_detail[0]['text'].'</small>',
                                 	  'price' => $ecotax_price);
									  }
	return 	$array_deee;							  
  }
  

  function tep_get_ecotax_description($rates_id, $country_id = -1, $zone_id = -1) {
      global $customer_zone_id, $customer_country_id;

    if ( ($country_id == -1) && ($zone_id == -1) ) {
      if (!tep_session_is_registered('customer_id')) {
        $country_id = STORE_COUNTRY;
        $zone_id = STORE_ZONE;
      } else {
        $country_id = $customer_country_id;
        $zone_id = $customer_zone_id;
      }
    }

	if ((int)$rates_id<0 or (int)$rates_id==999){	$ecotax_description=array();
      $ecotax_description[] =array( 'id' => $rates_id,
	  								'title' => CUSTOM_ECOTAX_CLASS_TITLE,
									'class' =>CUSTOM_ECOTAX_CLASS_TEXT,
	  								'code' => "Spcifique",
									'ecotax_id_other' =>"",
	  							    'text' =>tep_get_custom_ecotax_text(abs((int)$rates_id)));
									     
	 return $ecotax_description;}else{	
    $ecotax_query = tep_db_query("select tr.ecotax_description as ecotax_description ,tr.code_ecotax as code_ecotax ,tr.ecotax_class_id as ecotax_class_id ,tc.ecotax_class_title as ecotax_class_title ,tc.ecotax_class_description as ecotax_class_description from " . TABLE_ECOTAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_ECOTAX_CLASS . " tc on (tc.ecotax_class_id = tr.ecotax_class_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.ecotax_rates_id = '" . (int)$rates_id . "' order by tr.ecotax_rates_id");

    if (tep_db_num_rows($ecotax_query)) {
      $ecotax_description = '';
$ecotax = tep_db_fetch_array($ecotax_query);
        $ecotax_text .= $ecotax['ecotax_description'];
		$ecotax_code_ecotax=$ecotax['code_ecotax'];
		$ecotax_class_id=$ecotax['ecotax_class_id'];
		$ecotax_class_title=$ecotax['ecotax_class_title'];
		$ecotax_class_text=$ecotax['ecotax_class_description'];

	  
  $ecotax_description=array();
      $ecotax_description[] =array( 'id' => $ecotax_class_id,
	  								'title' => $ecotax_class_title,
									'class' =>$ecotax_class_text,
	  								'code' => $ecotax_code_ecotax,
	  							    'text' =>$ecotax_text);

      return $ecotax_description;
    } else{
	    $ecotax_francaise_query = tep_db_query("select tr.code_ecotax as code_ecotax ,tr.ecotax_class_id as ecotax_class_id from " . TABLE_ECOTAX_RATES . " tr where tr.ecotax_rates_id = '" . (int)$rates_id . "' order by tr.ecotax_rates_id limit 1");
    if (tep_db_num_rows($ecotax_francaise_query)) {
$ecotax_francaise = tep_db_fetch_array($ecotax_francaise_query); 


    $ecotax_generique_query = tep_db_query("select tr.ecotax_rates_id, tr.ecotax_description as ecotax_description ,tr.code_ecotax as code_ecotax ,tr.ecotax_class_id as ecotax_class_id ,tc.ecotax_class_title as ecotax_class_title ,tc.ecotax_class_description as ecotax_class_description from " . TABLE_ECOTAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_ECOTAX_CLASS . " tc on (tc.ecotax_class_id = tr.ecotax_class_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.code_ecotax = '" . $ecotax_francaise['code_ecotax'] . "' and tr.ecotax_class_id = '" . $ecotax_francaise['ecotax_class_id'] . "' order by tr.ecotax_rates_id limit 1");

    if (tep_db_num_rows($ecotax_generique_query)) {
	$countries_query = tep_db_query("select countries_name from ".TABLE_COUNTRIES." where countries_id='".$country_id."'");
	    if (tep_db_num_rows($countries_query)) {$countries = tep_db_fetch_array($countries_query);$countries_name="<br>(".$countries['countries_name'].")";}
      $ecotax_description = '';
$ecotax = tep_db_fetch_array($ecotax_generique_query);
	  	$ecotax_rates_id=$ecotax['ecotax_rates_id'];
        $ecotax_text .= $ecotax['ecotax_description'];
		$ecotax_code_ecotax=$ecotax['code_ecotax'].$countries_name;
		$ecotax_class_id=$ecotax['ecotax_class_id'];
		$ecotax_class_title=$ecotax['ecotax_class_title'];
		$ecotax_class_text=$ecotax['ecotax_class_description'];

	  
  $ecotax_description=array();
      $ecotax_description[] =array( 'id' => $ecotax_class_id,
	  								'title' => $ecotax_class_title,
									'class' =>$ecotax_class_text,
	  								'code' => $ecotax_code_ecotax,
									'ecotax_id_other' =>$ecotax_rates_id,
	  							    'text' =>$ecotax_text);
      return $ecotax_description;
    }else {$ecotax_description=array();
      $ecotax_description[] =array( 'id' => "0",
	  								'title' => "",
									'class' =>"",
	  								'code' => "",
									'ecotax_id_other' =>"0",
	  							    'text' =>"Not used");
	 return $ecotax_description;}}
	 else {$ecotax_description=array();
      $ecotax_description[] =array( 'id' => "0",
	  								'title' => "",
									'class' =>"",
	  								'code' => "",
									'ecotax_id_other' =>"0",
	  							    'text' =>"Not used");
	 return $ecotax_description;}}
  }
}  
  function verif_ecotax($ecotax){
$product_info_ecotax=tep_get_ecotax_description($ecotax);
if ($ecotax!=$product_info_ecotax[0]['ecotax_id_other']&& $product_info_ecotax[0]['ecotax_id_other']!=""){
if ($product_info_ecotax[0]['ecotax_id_other']!="0" && (int)$product_info_ecotax[0]['ecotax_id_other']>0){return $product_info_ecotax[0]['ecotax_id_other'];
}else{return 0;}
}else{return $ecotax;}
}
  //fin modif by paddybl for ecotax
  //debut modif by paddybl for ecotax
  
//// 
// Add ecotax to a products price
  function tep_add_ecotax($price,$ecotax_taxe_rate=-1, $ecotax,$qty=1) {

    global $currencies, $customer_id, $tag;
if ($ecotax_taxe_rate==-1)$ecotax_taxe_rate=tep_get_ecotax_rate($ecotax);

		$ecotax=tep_get_ecotax_price_value($ecotax);
	
  	$group_taxed = (DISPLAY_PRICE_WITH_TAX == 'true' || $ecotax > 0 ) ? 'true' : 'false';		
		
		switch ($group_taxed) { 
  	case 'true':
		
  		return floatval($price) + tep_round(($ecotax+tep_calculate_tax($ecotax,$ecotax_taxe_rate)), 2)*$qty; 
  	case 'false': 

  		return floatval($price); 
  		break;
			}
  }

//fin modif by paddybl for ecotax 
  //retour la tva sur l'cotaxe
  function tep_get_ecotax_taxable($class_id){
  $ecotax=tep_get_ecotax_price_value($class_id);
  $ecotax_taxe_rate=tep_get_ecotax_rate($class_id);
  $ecotax_taxable=tep_calculate_tax($ecotax,$ecotax_taxe_rate);
  return $ecotax_taxable;
  }
//fin modif by paddybl for ecotax
//debut modif by paddybl for ecotax
  function tep_display_ecotax_value($value, $padding = TAX_DECIMAL_PLACES) {
    if (strpos($value, '.')) {
      $loop = true;
      while ($loop) {
        if (substr($value, -1) == '0') {
          $value = substr($value, 0, -1);
        } else {
          $loop = false;
          if (substr($value, -1) == '.') {
            $value = substr($value, 0, -1);
          }
        }
      }
    }

    if ($padding > 0) {
      if ($decimal_pos = strpos($value, '.')) {
        $decimals = strlen(substr($value, ($decimal_pos+1)));
        for ($i=$decimals; $i<$padding; $i++) {
          $value .= '0';
        }
      } else {
        $value .= '.';
        for ($i=0; $i<$padding; $i++) {
          $value .= '0';
        }
      }
    }

    return $value;
  }
  //fin modif by paddyl for ecotax

// Function to reset SEO URLs database cache entries 
// Ultimate SEO URLs v2.2
function tep_reset_cache_data_seo_urls($action){	
	switch ($action){
		case 'reset':
			tep_db_query("DELETE FROM cache WHERE cache_name LIKE '%seo_urls%'");
			tep_db_query("UPDATE configuration SET configuration_value='false' WHERE configuration_key='SEO_URLS_CACHE_RESET'");
			break;
		default:
			break;
	}
	# The return value is used to set the value upon viewing
	# It's NOT returining a false to indicate failure!!
	return 'false';
}
//++++ QT Pro: Begin Changed code
//These are functions for calculating and dooing different QTPro things.
//The future goal is that this kit of functions will make the integration of other contributions easier.
//Contributors: Please feel free to ad new functions to this kit. But please make sure that they are error free.


//-------------------------//
//---  Small Tools  ---//
//-------------------------//
/*
This function will take a string looking like "1-2,3-4,5-6" and return an array looking like:
Array
(
    [1] => 2
    [3] => 4
    [5] => 6
)
*/
function qtpro_products_attributes_string2array($products_attributes_string){
$ret_array = array();

	$optionchoise_array =explode(',', $products_attributes_string);// values in $option_choise_array looks like: '1-2'
	//Now put them into $ret_array in a correct way:
	foreach($optionchoise_array as $optionchoise){
		$splitted_array = explode('-', $optionchoise);
		$option = $splitted_array[0];
		$choise = $splitted_array[1];
		
		$ret_array[$option] = $choise;
	}

return $ret_array;
}

/*
This function will take a string looking like "1-2,3-4,5-6" and return an array looking like:
Array
(
    [0] => 1
    [2] => 3
    [3] => 5
)
*/
function qtpro_products_attributes_string2options_array($products_attributes_string){
$ret_array = array();

	$optionchoise_array =explode(',', $products_attributes_string);// values in $option_choise_array looks like: '1-2'
	//Now put them into $ret_array in a correct way:
	foreach($optionchoise_array as $optionchoise){
		$splitted_array = explode('-', $optionchoise);		
		$ret_array[] = $splitted_array[0];;
	}

return $ret_array;
}

//-------------------------//
//---  Doctor Functions  ---//
//-------------------------//

//This is the most detailed doctor function for examining a product.
function qtpro_doctor_investigate_product($products_id){
$facts_array = array();
$facts_array['id'] = $products_id;
$facts_array['any_problems'] = false;
$facts_array['has_tracked_options'] = false;

$facts_array['summary_and_calc_stock_match'] = true; //If summary_stock and calc_stock is the same value; this = true; else this = false
$facts_array['summary_stock'] = 0; //The current summary stock for this product in the database.
$facts_array['calc_stock'] = 0; //The summary stock calculated by looking at the options products_stock.

$facts_array['stock_entries_healthy'] = true; //If any row is sick; this = true; else this = false;
$facts_array['stock_entries_count'] = 0; //The number of rows this product had in the options products_stock database table.
$facts_array['sick_stock_entries_count'] = 0;//The number of sick rows this product had in the options products_stock database table.
$facts_array['lacks_id_array'] = array(); //An array with all the id:s of the options that were lacked anywhere in the options products_stock table.
$facts_array['intruders_id_array'] = array(); //An array with all the id:s of the options that were intruding anywhere in the options products_stock table.

	$facts_array['has_tracked_options'] = qtpro_product_has_tracked_options($products_id);//DE NYA IDEERNA KAN CLASHA performance mssigt!!
	$facts_array['summary_stock'] = qtpro_get_products_summary_stock($products_id); //Denna kan ej dubbelkra sql
	
	//Calculate the summary stock by looking att the stock for the different options
	if($facts_array['has_tracked_options']){
		$products_stock_quantity_query = tep_db_query("SELECT products_stock_quantity FROM " . TABLE_PRODUCTS_STOCK . " WHERE products_id = '" . $products_id . "'");
		
		while($row = tep_db_fetch_array($products_stock_quantity_query)){
			if($row['products_stock_quantity'] > 0){ //If they are negative they are oversold and this do not affect what we have on stock.
				$facts_array['calc_stock']+= $row['products_stock_quantity'];
			}
		}
		
	}else{
		//Set the calc_stock to the summary stock
		$facts_array['calc_stock'] = $facts_array['summary_stock'];
	}
	
	//Decide summary_and_calc_stock_match
	if($facts_array['summary_stock'] == $facts_array['calc_stock']){
		$facts_array['summary_and_calc_stock_match'] = true;
	}else{
		$facts_array['summary_and_calc_stock_match'] = false;
	}

	//Get all products_stock entries for the product. ---------------------------------------
	$attributes_stock_query = tep_db_query("SELECT products_stock_attributes
											FROM " . TABLE_PRODUCTS_STOCK . " 
											WHERE products_id = '" . $products_id . "'");
											
	$facts_array['stock_entries_count'] = tep_db_num_rows($attributes_stock_query);
	
	if ($facts_array['stock_entries_count'] == 0){
		$facts_array['sick_stock_entries_count'] = 0;
		$facts_array['stock_entries_healthy'] = true;	
	}else{
		//Get the id for all options this product has and put them in the array: $products_options_array  ---------------------------------------
		$products_options_query = tep_db_query("SELECT DISTINCT options_id
												FROM " . TABLE_PRODUCTS_ATTRIBUTES . " 
												WHERE products_id = '" . $products_id . "'");
		$products_options_array = array();
		while ($products_option_id = tep_db_fetch_array($products_options_query)) {
			$products_options_array[] =$products_option_id['options_id'];
		}
												
		//Get the id for all attributes which are tracked and put them in the array: $tracked_options_array  ---------------------------------------
		$tracked_options_query = tep_db_query("SELECT DISTINCT products_options_id
												FROM " . TABLE_PRODUCTS_OPTIONS . " 
												WHERE products_options_track_stock = 1");
		$tracked_options_array = array();
		while ($tracked_option_id = tep_db_fetch_array($tracked_options_query)) {
			$tracked_options_array[] =$tracked_option_id['products_options_id'];
		}
		//Ok so now we can check if the option_id 8 is tracked by running: in_array(8, $tracked_options_array) =)
		

		//Check every products_stock_attributes for errors
		while ($products_stock_attributes = tep_db_fetch_array($attributes_stock_query)) {
			$this_row_is_sick = false;
			$string_options_array = qtpro_products_attributes_string2options_array($products_stock_attributes['products_stock_attributes']);
			
			//Now check for "intruder" errors (check for attributes which are there but should not as they are not stocktracked)
			foreach($string_options_array as $option){
				if(!in_array($option, $tracked_options_array)){
					$this_row_is_sick = false;
					$facts_array['sick_stock_entries_count']++;
					$facts_array['stock_entries_healthy'] = false;
					$facts_array['intruders_id_array'][] = $option;
				}
			}
			
			//Now check for "lack" errors (check for attributes should be there, because they are stocktracked, but for some reason are not)
			foreach($products_options_array as $product_option){
				if(in_array($product_option, $tracked_options_array) && !in_array($product_option, $string_options_array)){
					$this_row_is_sick = false;
					
					$facts_array['stock_entries_healthy'] = false;
					$facts_array['lacks_id_array'][] = $product_option;
				}
			}

			if($this_row_is_sick){
				$facts_array['sick_stock_entries_count']++;
			}
			
		}
	}
	
	//Set the overwiev variables:
	if(!$facts_array['summary_and_calc_stock_match'] or !$facts_array['stock_entries_healthy']){
		$facts_array['any_problems'] = true;
	}

return $facts_array;
}

function qtpro_doctor_formulate_product_investigation($facts_array, $formulate_style){
$str_ret ='';
	switch($formulate_style){
		case 'short_suggestion':
			if($facts_array['any_problems']){
				if($facts_array['summary_and_calc_stock_match'] != true && $facts_array['stock_entries_healthy'] != true){
					$str_ret ='The database entries for this products stock is messy and the summary stock calculation is wrong. Please take a look at this <a href="' . tep_href_link("stock.php", 'product_id=' . $facts_array['id']) . '" class="headerLink">products stock</a>.';
				}elseif(!$facts_array['summary_and_calc_stock_match']){
					$str_ret ='The summary stock calculation is wrong. Please take a look at this <a href="' . tep_href_link("stock.php", 'product_id=' . $facts_array['id']) . ' " class="headerLink">products stock</a>.';
				}elseif(!$facts_array['stock_entries_healthy']){
					$str_ret ='The database entries for this products stock is messy. Please take a look at this <a href="' . tep_href_link("stock.php", 'product_id=' . $facts_array['id']) . ' " class="headerLink">products stock</a>.';
				}else{
					$str_ret ="Errorcatsh 754780+94322354678";
				}
			}else{
				$str_ret ="This product is all ok.";
			}
		
		break;
		case 'detailed':
			//Create Header
			/*if($facts_array['any_problems']){
				$str_ret ='<span style="color:red; font-weight: bold; font-size:1.2em;">This product needs attention!</span><br /><br />';
			}else{
				$str_ret ='<span style="color:green; font-weight: bold;">This product is all ok.</span><br /><br />';
			}*/
			
			//Talk about summary and calc stock
			if($facts_array['summary_and_calc_stock_match']){
				$str_ret .='<span style="color:green; font-weight: bold; font-size:1.2em;">Le stock quantit globale est ok</span><br />
aucune diffrence entre la base et la somme des options	.<br />
				<b>Le stock produit cumul est de: '. $facts_array['summary_stock'] .'</b><br /><br />';
			}else{
				$str_ret .='<span style="color:red; font-weight: bold; font-size:1.2em;">La somme des quantits de ce produit n\'est pas bonne</span><br />
		attention diffrence en la sommes des options et la stock du produit dans la base de dons.<br />
				<b>LE stock actuel est: '. $facts_array['summary_stock'] .'</b><br />
				<b>Si l\'on calcule, il nous obtenons: '. $facts_array['calc_stock'] .'</b><br /><br />';
			}

			//Talk about the health of the stock entries
			if($facts_array['stock_entries_healthy']){
				$str_ret .='<span style="color:green; font-weight: bold; font-size:1.2em;">Le stock options est OK</span><br />
		Aucune option font dfaut dans toute la ligne	.<br />
				<b>Nombre total d\'entres stock de ce produit a: '. $facts_array['stock_entries_count'] .'</b><br />
				<b>Nombre d\'entres en dsordre: '. $facts_array['sick_stock_entries_count'] .'</b><br />';
				
			}else{
				$str_ret .='<span style="color:red; font-weight: bold; font-size:1.2em;">Le stock options pas bon</span><br />			
Cela signifie qu\'au moins un de la base de donnes pour ce produit est incohrent. Chacune des options sont manquantes dans les lignes ou les options possibles dans les lignes ils ne devraient pas.<br />
				<b>Nombre total d\'entres stock de ce produit a: '. $facts_array['stock_entries_count'] .'</b><br />
				<b>Nombre d\'entres en dsordre: '. $facts_array['sick_stock_entries_count'] .'</b><br /><br />';
				
				if(sizeof($facts_array['lacks_id_array']) > 0){
					$str_ret .='<b>These options were missing in row(s):</b><br />';
					foreach($facts_array['lacks_id_array'] as $lack_id){
						$str_ret .= '<span style="color:red;"><b>'. tep_options_name($lack_id) .'</b></span><br />';
					}
					$str_ret .='<span style="color:blue; font-weight: bold;">solutions possibles: </span>Supprimer la ligne correspondante (s) de la base de donnes ou d\'arrter les actions de suivi pour cette option.<br /><br />';
				}
				
				if(sizeof($facts_array['intruders_id_array']) > 0){
					$str_ret .= '<br /><b>These options exists in row(s) although they should not:</b><br />';
					foreach($facts_array['intruders_id_array'] as $intruder_id){
						$str_ret .= '<span style="color:red;"><b>'. tep_options_name($intruder_id) .'</b></span><br />';
					}
					$str_ret .='<span style="color:blue; font-weight: bold;">solutions possibles: </span>Supprimer la ligne correspondante (s) de la base de donnes ou initier le suivi du stock de cette option.<br /><br />';
				}
				
			}
			
			//Talk about automatic solutions
			if($facts_array['any_problems']){
				$str_ret .='<span style="color:blue; font-weight: bold; font-size:1.2em;">Automatic Solutions Avaliable:</span><br />';
				if(!$facts_array['stock_entries_healthy']){
					$str_ret .='<a href="' . tep_href_link(FILENAME_QTPRODOCTOR, 'action=amputate&pID='.$facts_array['id'], 'NONSSL') . '" class="menuBoxContentLink" target="_blank">Amputation (Deletes all messy rows)</a><br />';
				}
				
				if(!$facts_array['summary_and_calc_stock_match']){
					$str_ret .='<br /><a href="' . tep_href_link(FILENAME_QTPRODOCTOR, 'action=update_summary&pID='.$facts_array['id'], 'NONSSL') . '" class="menuBoxContentLink" target="_blank">Set the summary stock to: '. $facts_array['calc_stock'] .'</a><br />';
				}
			}
			
			
		break;
	}

return $str_ret;
}


//looks at the products_stock_attributes database entries for a product and then returns the number of errors found.
//What is an error? Answer: there are two types of errors. The first is called "intruder" error. This is when there exist an attribute in the products_stock_attributes string which is not stocktracked. The Second type of error called "lack" error. This is when an attribute is missing in products_stock_attributes; that is: when the product has an attribute with tracked stock and that attribute is not in the products_stock_attributes.
function qtpro_doctor_product_healthy($products_id){
$return_bool = true; //This means the product is ok

	//MISSION CODENAME "Get information" STARTS HERE
	//Get all products_stock entries for the product. ---------------------------------------
	$attributes_stock_query = tep_db_query("SELECT products_stock_attributes
											FROM " . TABLE_PRODUCTS_STOCK . " 
											WHERE products_id = '" . $products_id . "'");
											
	//Ops! a sub mission to possibly save work:
	if (tep_db_num_rows($attributes_stock_query) == 0){
		//This is normal if the product has NO strackstocked attributes
		//BUT it can also happen for products WITH strackstocked attributes. Nothing in stock that is.
		return true; //The examination is complete. Doctor says product is healthy  :D
	}
	//Submission complete; let's continue
	
	//Get the id for all options this product has and put them in the array: $products_options_array  ---------------------------------------
	$products_options_query = tep_db_query("SELECT DISTINCT options_id
											FROM " . TABLE_PRODUCTS_ATTRIBUTES . " 
											WHERE products_id = '" . $products_id . "'");
	$products_options_array = array();
	while ($products_option_id = tep_db_fetch_array($products_options_query)) {
		$products_options_array[] =$products_option_id['options_id'];
	}
											
	//Get the id for all attributes which are tracked and put them in the array: $tracked_options_array  ---------------------------------------
	$tracked_options_query = tep_db_query("SELECT DISTINCT products_options_id
											FROM " . TABLE_PRODUCTS_OPTIONS . " 
											WHERE products_options_track_stock = 1");
	$tracked_options_array = array();
	while ($tracked_option_id = tep_db_fetch_array($tracked_options_query)) {
		$tracked_options_array[] =$tracked_option_id['products_options_id'];
	}
	//Ok so now we can check if the option_id 8 is tracked by running: in_array(8, $tracked_options_array) =)
	
	//MISSION CODENAME "Get information" ENDS HERE
	
	
	//Check every products_stock_attributes for errors
	while ($products_stock_attributes = tep_db_fetch_array($attributes_stock_query)) {
		$string_options_array = qtpro_products_attributes_string2options_array($products_stock_attributes['products_stock_attributes']);
		
		//Now check for "intruder" errors (check for attributes which are there but should not as they are not stocktracked)
		foreach($string_options_array as $option){
			if(!in_array($option, $tracked_options_array)){
				//aha! an "intruder"
				return false; //The examination is complete. Doctor says product is sick :'(
			}
		}
		
		//Now check for "lack" errors (check for attributes should be there, because they are stocktracked, but for some reason are not)
		foreach($products_options_array as $product_option){
			if(in_array($product_option, $tracked_options_array) && !in_array($product_option, $string_options_array)){
				//aha! a "lack"
				return false; //The examination is complete. Doctor says product is sick :'(
			}
		}
	}

return true; //The examination is complete. Doctor says product is healthy  :D
}

//This function will delete all option stock entries from the product.
function qtpro_doctor_amputate_all_from_product($products_id){
	tep_db_query("DELETE FROM " . TABLE_PRODUCTS_STOCK . " WHERE products_id =". (int)$products_id);	
}

function qtpro_doctor_amputate_bad_from_product($products_id){
$return_amputate_count = 0;

	//MISSION CODENAME "Get information" STARTS HERE
	//Get all products_stock entries for the product. ---------------------------------------
	$attributes_stock_query = tep_db_query("SELECT products_stock_attributes, products_stock_id
											FROM " . TABLE_PRODUCTS_STOCK . " 
											WHERE products_id = '" . $products_id . "'");
											
	//Ops! a sub mission to possibly save work:
	if (tep_db_num_rows($attributes_stock_query) == 0){
		//This is normal if the product has NO strackstocked attributes
		//BUT it can also happen for products WITH strackstocked attributes. Nothing in stock that is.
		return $return_amputate_count; //The surgery is complete. Doctor says nothing to amputate :D
	}
	//Submission complete; let's continue
	
	//Get the id for all options this product has and put them in the array: $products_options_array  ---------------------------------------
	$products_options_query = tep_db_query("SELECT DISTINCT options_id
											FROM " . TABLE_PRODUCTS_ATTRIBUTES . " 
											WHERE products_id = '" . $products_id . "'");
	$products_options_array = array();
	while ($products_option_id = tep_db_fetch_array($products_options_query)) {
		$products_options_array[] =$products_option_id['options_id'];
	}
											
	//Get the id for all attributes which are tracked and put them in the array: $tracked_options_array  ---------------------------------------
	$tracked_options_query = tep_db_query("SELECT DISTINCT products_options_id
											FROM " . TABLE_PRODUCTS_OPTIONS . " 
											WHERE products_options_track_stock = 1");
	$tracked_options_array = array();
	while ($tracked_option_id = tep_db_fetch_array($tracked_options_query)) {
		$tracked_options_array[] =$tracked_option_id['products_options_id'];
	}
	//Ok so now we can check if the option_id 8 is tracked by running: in_array(8, $tracked_options_array) =)
	
	//MISSION CODENAME "Get information" ENDS HERE
	
	
	//Check every row for errors
	while ($products_stock_attributes = tep_db_fetch_array($attributes_stock_query)) {
		$amputate_this = false;
		$string_options_array = qtpro_products_attributes_string2options_array($products_stock_attributes['products_stock_attributes']);
		
		//Now check for "intruder" errors (check for attributes which are there but should not as they are not stocktracked)
		foreach($string_options_array as $option){
			if(!in_array($option, $tracked_options_array)){
				//aha! an "intruder"
				$amputate_this = true; //The examination is complete. Doctor says this products_stock_id must be amputated :'(
			}
		}
		
		//Now check for "lack" errors (check for attributes should be there, because they are stocktracked, but for some reason are not)
		foreach($products_options_array as $products_option){
			if(in_array($products_option, $tracked_options_array) && !in_array($products_option, $string_options_array)){
				//aha! a "lack"
				$amputate_this = true; //The examination is complete. Doctor says this products_stock_id must be amputated :'(
			}
		}
		
		if($amputate_this){
			tep_db_query("DELETE 
						  FROM " . TABLE_PRODUCTS_STOCK . "
						  WHERE products_stock_id =". $products_stock_attributes['products_stock_id']);	
			$return_amputate_count++;		
		}
	}

return $return_amputate_count; //This will return the array with the amputate count.
}

//This function will update the summary_stock for a product
function qtpro_update_summary_stock($products_id){
      tep_db_query("UPDATE " . TABLE_PRODUCTS . " 
                      SET products_quantity = " . qtpro_calculate_summary_stock($products_id) . "
                      WHERE products_id = '" . $products_id . "'");

}

//------------------------------------------//
//---  Product Investigation Functions  ---//
//----------------------------------------//

function qtpro_product_exists($products_id){
	$prod_query = tep_db_query("SELECT products_id FROM " . TABLE_PRODUCTS . " WHERE products_id = '" . $products_id . "'");
	if (tep_db_num_rows($prod_query) == 0){ 
		//Nothing was found so it did not exist.
		return false;
	}else{	
		return true;
	}
}

function qtpro_product_has_tracked_options($products_id){
	//Get the id for all options this product has and put them in the array: $products_options_array  ---------------------------------------
	$products_options_query = tep_db_query("SELECT DISTINCT options_id
											FROM " . TABLE_PRODUCTS_ATTRIBUTES . " 
											WHERE products_id = '" . $products_id . "'");
	$products_options_array = array();
	while ($products_option_id = tep_db_fetch_array($products_options_query)) {
		$products_options_array[] =$products_option_id['options_id'];
	}
											
	//Get the id for all attributes which are tracked and put them in the array: $tracked_options_array  ---------------------------------------
	$tracked_options_query = tep_db_query("SELECT DISTINCT products_options_id
											FROM " . TABLE_PRODUCTS_OPTIONS . " 
											WHERE products_options_track_stock = 1");
	$tracked_options_array = array();
	while ($tracked_option_id = tep_db_fetch_array($tracked_options_query)) {
		$tracked_options_array[] =$tracked_option_id['products_options_id'];
	}
	//Ok so now we can check if the option_id 8 is tracked by running: in_array(8, $tracked_options_array) =)

	//Do the test:
	foreach($products_options_array as $products_option){
		if(in_array($products_option, $tracked_options_array)){
			return true;
		}
	}

return false;
}

function qtpro_get_products_summary_stock($products_id){
	$products_summary_stock_query = tep_db_query("SELECT products_quantity
											FROM " . TABLE_PRODUCTS . " 
											WHERE products_id = '" . $products_id . "'");
	$product_facts = tep_db_fetch_array($products_summary_stock_query);
	return $product_facts['products_quantity'];
}

//This function will calculate and return the summary_stock for a product. If it is a product without tracked attributes the summary_stock will be returned anyway.
//NOTE!!!: This function will include all entries. Even damaged ones...
function qtpro_calculate_summary_stock($products_id){
$summary_stock_to_return = 0;
	if(qtpro_product_has_tracked_options($products_id)){
		//Calculate the summary stock by looking att the stock for the different options
		//Get all products_stock entries for the product. ---------------------------------------
		$products_stock_quantity_query = tep_db_query("SELECT products_stock_quantity
												FROM " . TABLE_PRODUCTS_STOCK . " 
												WHERE products_id = '" . $products_id . "'");
		while($row = tep_db_fetch_array($products_stock_quantity_query)){
			if($row['products_stock_quantity'] > 0){ //If they are negative they are oversold and this do not affect what we have on stock.
				$summary_stock_to_return+= $row['products_stock_quantity'];
			}
		}
		
	}else{
		//Just return he current summary stock
		$summary_stock_to_return = qtpro_get_products_summary_stock($products_id);
	}
return $summary_stock_to_return;
}

function qtpro_products_summary_stock_is_as_calculated($products_id){
	if(qtpro_calculate_summary_stock($products_id) == qtpro_get_products_summary_stock($products_id)){
		return true;
	}else{
		return false;
	}
}







//-------------------------//
//---  Trash-Tools ---//
//-------------------------//

//This function will determine if the parameter row (taken from database table products_stock) is trash
//It is if the products it liks to not exists.
//The $row_array must contain the keys: 'products_id'
function qtpro_stock_row_is_trash($row_array){
	$prod_query = tep_db_query("SELECT products_id FROM " . TABLE_PRODUCTS . " WHERE products_id = '" . $products_id . "'");

	if (qtpro_product_exists($row_array['products_id'])){ 
		return false;
	}else{
		//The product this row links to does not exists. So it is trash then
		return true;	
	}
}

//This function will count the number of strash rows in the database.
//These rows should never come to exist but this is a good statistical fact for progammers as this indicate something is wrong
function qtpro_number_of_trash_stock_rows(){
$trash_count_ret = 0;

	$products_stock_row_query = tep_db_query("SELECT products_id FROM " . TABLE_PRODUCTS_STOCK);
	while($row = tep_db_fetch_array($products_stock_row_query)){
		if(qtpro_stock_row_is_trash($row)){
			$trash_count_ret++;
		}
	}

return $trash_count_ret;
}

// This function will erase all strash rows in the database table for products option stock.
function qtpro_chuck_trash(){
$trash_count_ret = 0;
	
	$products_stock_row_query = tep_db_query("SELECT products_stock_id, products_id FROM " . TABLE_PRODUCTS_STOCK);
	while($row = tep_db_fetch_array($products_stock_row_query)){
		if(qtpro_stock_row_is_trash($row)){
			tep_db_query("DELETE FROM " . TABLE_PRODUCTS_STOCK . " WHERE products_stock_id=" . $row['products_stock_id']);
			$trash_count_ret++;
		}
	}	
	
return $trash_count_ret;
}

//-------------------------//
//---     Statistics    ---//
//-------------------------//

function qtpro_normal_product_count(){
	$prod_query = tep_db_query("SELECT products_id FROM " . TABLE_PRODUCTS);
	return tep_db_num_rows($prod_query);
}

function qtpro_tracked_product_count(){
$count_ret = 0;
	$prod_query = tep_db_query("SELECT products_id FROM " . TABLE_PRODUCTS);
	while($product = tep_db_fetch_array($prod_query)){
		if(qtpro_product_has_tracked_options($product['products_id'])){
			$count_ret++;
		}	
	}

return $count_ret;
}

function qtpro_sick_product_count(){
$count_ret = 0;
	$prod_query = tep_db_query("SELECT products_id FROM " . TABLE_PRODUCTS);
	while($product = tep_db_fetch_array($prod_query)){
		if(!qtpro_doctor_product_healthy($product['products_id'])){
			$count_ret++;
		}	
	}

return $count_ret;
}

//++++ QT Pro: End Changed code

// function to retrieve the country iso code based on the country's id
  function tep_get_country_iso2($country_id) {
    $country_query = tep_db_query("select countries_iso_code_2 from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");

    if (!tep_db_num_rows($country_query)) {
	  return $country_id;
    } else {
   	  $country = tep_db_fetch_array($country_query);
      return $country['countries_iso_code_2'];
    }
  }

include('general_fonctions_artoisweb.php');
?>