<?php
/*
  $Id: macros.php,v 1.5 2006/03/10 02:23:22 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  /**
   * @package abxMacrosManager
   */
  class abxMacrosManager extends abxMacros 
  {
    function productCustomMacros()
    {
        return array(
         'PRODUCTS_PRICE_MINUS_5PERCENT',
         'PRODUCTS_PRICE_MINUS_10PERCENT',
         'PRODUCTS_PRICE_MINUS_15PERCENT',
         'PRODUCTS_PRICE_MINUS_20PERCENT',
         'PRODUCTS_PRICE_MINUS_30PERCENT',
         'PRODUCTS_PRICE_MINUS_40PERCENT',

         'PRODUCTS_PRICE_PLUS_5PERCENT',
         'PRODUCTS_PRICE_PLUS_10PERCENT',
         'PRODUCTS_PRICE_PLUS_15PERCENT',
         'PRODUCTS_PRICE_PLUS_20PERCENT',
         'PRODUCTS_PRICE_PLUS_30PERCENT',
         'PRODUCTS_PRICE_PLUS_40PERCENT',
            'PRODUCTS_PRICE_FORMATTED',
            'PRODUCTS_WITH_GST',
            'BIN_PRICE',
            'PRODUCTS_IMAGE_POPUP',
            'ADDITIONAL_IMAGES_POPUP',
			'VERTICAL_ADDITIONAL_IMAGES_POPUP',
			'TWO_COLUMN_ADDITIONAL_IMAGES_POPUP'
        );
    }
    
    function productImageMacros()
    {
      return array(
        'PRODUCTS_IMAGE',
        'PRODUCTS_IMAGE_MED',
        'PRODUCTS_IMAGE_LRG',
        'PRODUCTS_IMAGE_SM_1',
        'PRODUCTS_IMAGE_XL_1',
        'PRODUCTS_IMAGE_SM_2',
        'PRODUCTS_IMAGE_XL_2',
        'PRODUCTS_IMAGE_SM_3',
        'PRODUCTS_IMAGE_XL_3',
        'PRODUCTS_IMAGE_SM_4',
        'PRODUCTS_IMAGE_XL_4',
        'PRODUCTS_IMAGE_SM_5',
        'PRODUCTS_IMAGE_XL_5',
        'PRODUCTS_IMAGE_SM_6',
        'PRODUCTS_IMAGE_XL_6',
        'PICTURE1_URL',
        'PICTURE2_URL',
        'PICTURE3_URL',
        'PICTURE4_URL',
        'PICTURE5_URL',
        'PICTURE6_URL',
        'PICTURE7_URL',
        'PICTURE8_URL',
        'PRODUCTS_IMAGE_HTML',
        'PRODUCTS_IMAGE_MED_HTML',
        'PRODUCTS_IMAGE_LRG_HTML',
      );
    }    

    function runProductCustomMacros(&$target, &$product)
    {
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_5PERCENT', $product['products_price'] * .95, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_10PERCENT', $product['products_price'] * .90, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_15PERCENT', $product['products_price'] * .85, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_20PERCENT', $product['products_price'] * .80, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_30PERCENT', $product['products_price'] * .70, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_40PERCENT', $product['products_price'] * .60, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_5PERCENT', $product['products_price'] * 1.05, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_10PERCENT', $product['products_price'] * 1.10, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_15PERCENT', $product['products_price'] * 1.15, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_20PERCENT', $product['products_price'] * 1.20, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_30PERCENT', $product['products_price'] * 1.30, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_40PERCENT', $product['products_price'] * 1.40, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_FORMATTED', '$' . number_format($product['products_price'],2), $target);
        $target =& $this->runMacro('PRODUCTS_WITH_GST', $product['products_price'], $target);
        $target =& $this->runMacro('BIN_PRICE', $product['products_price'] * 1.05, $target);
        
        $target =& $this->runMacro('PRODUCTS_IMAGE_POPUP',
                                   $this->createProductsImagePopup($target, $product),
                                   $target);

        $target =& $this->runMacro('ADDITIONAL_IMAGES_POPUP',
                                   $this->createAdditionalImagesPopup($target, $product),
                                   $target);
		$target =& $this->runMacro('VERTICAL_ADDITIONAL_IMAGES_POPUP',
                                   $this->createVerticalAdditionalImagesPopup($target, $product),
                                   $target);
		$target =& $this->runMacro('TWO_COLUMN_ADDITIONAL_IMAGES_POPUP',
                                   $this->createTwoColumnAdditionalImagesPopup($target, $product),
                                   $target);
                                   
        $target =& $this->runMacro('PRODUCTS_IMAGE_HTML',
                                $this->createFullyQualifiedImageTag($product['products_image']),
                                $target);

        $target =& $this->runMacro('PRODUCTS_IMAGE_MED_HTML',
                                $this->createFullyQualifiedImageTag($product['products_image_med']),
                                $target);
                                   
        $target =& $this->runMacro('PRODUCTS_IMAGE_LRG_HTML',
                                $this->createFullyQualifiedImageTag($product['products_image_lrg']),
                                $target);
                                   
        
        return $target;
    }
    
    
    function createFullyQualifiedImageTag($img)
    {
      $img = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $img;
      return '<img src="' . $img . '" border="0" />';
    }    
    
    function createProductsImagePopup(&$target, &$product)
    {
      $srcSmall = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image'];
      $srcLarge = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image'];
        
      $images .= '<table id="abx-image-popup" width="100%"><tr>';
      
      if(strlen($product['products_image']) > 0)
        $images .= $this->createImageRow($srcSmall, $srcLarge);

      $images .= '</tr></table>';
      
      return $images;
    }
	
	function getAdditionalImages(&$product){
		
		$result = array();

      if(strlen($product['products_image_sm_1']) > 0 && $product['products_image_sm_1'] != 'NULL')
        $result[] = array("image" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_sm_1'], 
        				"image_lrg" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_xl_1']);

      if(strlen($product['products_image_sm_2']) > 0 && $product['products_image_sm_2'] != 'NULL')
        $result[] = array("image" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_sm_2'], 
        				"image_lrg" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_xl_2']);

      if(strlen($product['products_image_sm_3']) > 0 && $product['products_image_sm_3'] != 'NULL')
        $result[] = array("image" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_sm_3'], 
        				"image_lrg" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_xl_3']);

      if(strlen($product['products_image_sm_4']) > 0 && $product['products_image_sm_4'] != 'NULL')
        $result[] = array("image" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_sm_4'], 
        				"image_lrg" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_xl_4']);

      if(strlen($product['products_image_sm_5']) > 0 && $product['products_image_sm_5'] != 'NULL')
        $result[] = array("image" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_sm_5'], 
        				"image_lrg" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_xl_5']);

      if(strlen($product['products_image_sm_6']) > 0 && $product['products_image_sm_6'] != 'NULL')
        $result[] = array("image" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_sm_6'], 
        				"image_lrg" => HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $product['products_image_xl_6']);
		
		
		return $result;
		
	}
    
    function createAdditionalImagesPopup(&$target, &$product)
    {
      $image_array = $this->getAdditionalImages($product);
    	
      $images = '<table id="abx-horizontal-images" bordercolor="#e4eafc" border="0" width="100%" cellspacing="1"><tr valign="bottom">';

      if(sizeof($image_array) > 0){
      	foreach ($image_array as $unused => $image_data){
        	$images .= $this->createImageRow($image_data['image'], $image_data['image_lrg']);
      	}
      }

      $images .= '</tr></table>';
      
      return $images;
    }
	
	function createVerticalAdditionalImagesPopup(&$target, &$product)
    {
    	$image_array = $this->getAdditionalImages($product);
      
      $images = '<table id="abx-vertical-images" bordercolor="#e4eafc" border="0" width="100%" cellspacing="1">';

      foreach($image_array as $unused => $image_data){
        $images .= '<tr valign="bottom">' . $this->createImageRow($image_data['image'], $image_data['image_lrg']) . '</tr>';
      }

      $images .= '</table>';
      
      return $images;
    }
    
    function createTwoColumnAdditionalImagesPopup(&$target, &$product)
    {
    	$image_array = $this->getAdditionalImages($product);
      
      $images = '<table id="abx-two-column-images" bordercolor="#e4eafc" border="0" width="100%" cellspacing="1">';

      for($i = 0; $i < count($image_array); $i++){
      	$image_data_1 = $image_array[$i];
      	$i++;
      	$image_data_2 = $image_array[$i];
        $images .= '<tr valign="bottom">';
        $images .= $this->createImageRow($image_data_1['image'], $image_data_1['image_lrg']);
		if ($image_data_2){
			$images .= $this->createImageRow($image_data_2['image'], $image_data_2['image_lrg']);
		}
		$images .= '</tr>';
      }

      $images .= '</table>';
      
      return $images;
    }
    
    function createImageRow(&$smallImage, &$largeImage)
    {   
      //$server = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES;
      $server = HTTP_CATALOG_SERVER . DIR_WS_CATALOG;

      return '<td align="center">' .
             '<a href="' . $largeImage . '" target="_popup">' .
             '<img src="' . $smallImage . '" border="0" hspace="5" vspace="5"><br/>' .
             '<img src="' . $server . DIR_WS_MODULES . 'auctionblox/images/image_enlarge.gif" border="0" alt="Click to enlarge" title="Click to enlarge">' .
             '</a>' .
             '</td>';
    }
  }
?>