<?php
/*
  $Id: macros.php,v 1.5 2006/03/10 02:23:22 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  /**
   * @package abxMacrosManager
   */
  class abxMacrosManager extends abxMacros 
  {
    function productCustomMacros()
    {
        return array(

         'PRODUCTS_PRICE_MINUS_5PERCENT',
         'PRODUCTS_PRICE_MINUS_10PERCENT',
         'PRODUCTS_PRICE_MINUS_15PERCENT',
         'PRODUCTS_PRICE_MINUS_20PERCENT',
         'PRODUCTS_PRICE_MINUS_30PERCENT',
         'PRODUCTS_PRICE_MINUS_40PERCENT',

         'PRODUCTS_PRICE_PLUS_5PERCENT',
         'PRODUCTS_PRICE_PLUS_10PERCENT',
         'PRODUCTS_PRICE_PLUS_15PERCENT',
         'PRODUCTS_PRICE_PLUS_20PERCENT',
         'PRODUCTS_PRICE_PLUS_30PERCENT',
         'PRODUCTS_PRICE_PLUS_40PERCENT',

            'PRODUCTS_PRICE_FORMATTED',
            'PRODUCTS_WITH_GST',
            'PRICE_TIMES_1POINT05',
            //'PRODUCTS_IMAGE_POPUP',
            'ADDITIONAL_IMAGES_POPUP',
            'VERTICAL_ADDITIONAL_IMAGES_POPUP',
            'TWO_COLUMN_ADDITIONAL_IMAGES_POPUP'
        );
    }
    

    function runProductCustomMacros(&$target, &$product)
    {
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_5PERCENT', $product['products_price'] * .95, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_10PERCENT', $product['products_price'] * .90, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_15PERCENT', $product['products_price'] * .85, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_20PERCENT', $product['products_price'] * .80, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_30PERCENT', $product['products_price'] * .70, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_MINUS_40PERCENT', $product['products_price'] * .60, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_5PERCENT', $product['products_price'] * 1.05, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_10PERCENT', $product['products_price'] * 1.10, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_15PERCENT', $product['products_price'] * 1.15, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_20PERCENT', $product['products_price'] * 1.20, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_30PERCENT', $product['products_price'] * 1.30, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_PLUS_40PERCENT', $product['products_price'] * 1.40, $target);
        $target =& $this->runMacro('PRODUCTS_PRICE_FORMATTED', '$' . number_format($product['products_price'],2), $target);
        $target =& $this->runMacro('PRODUCTS_WITH_GST', $product['products_price'], $target);
        $target =& $this->runMacro('PRICE_TIMES_1POINT05', $product['products_price'] * 1.05, $target);
        
        $target =& $this->runMacro('PRODUCTS_IMAGE_POPUP',
                                   $this->createProductsImagePopup($target, $product),
                                   $target);

        $target =& $this->runMacro('ADDITIONAL_IMAGES_POPUP',
                                   $this->createAdditionalImagesPopup($target, $product),
                                   $target);
        $target =& $this->runMacro('VERTICAL_ADDITIONAL_IMAGES_POPUP',
                                   $this->createVerticalAdditionalImagesPopup($target, $product),
                                   $target);
        $target =& $this->runMacro('TWO_COLUMN_ADDITIONAL_IMAGES_POPUP',
                                   $this->createTwoColumnAdditionalImagesPopup($target, $product),
                                   $target);
        
        return $target;
    }
    
    function productImageMacros()
    {
      return array(
        'PRODUCTS_IMAGE',
        'PRODUCTS_IMAGE_SMALL',
        'PRODUCTS_IMAGE_MED',
        'PRODUCTS_IMAGE_MEDIUM',
        'PRODUCTS_IMAGE_LRG',
        'PRODUCTS_IMAGE_LARGE',
        'PRODUCTS_IMAGE_SM_1',
        'PRODUCTS_IMAGE_XL_1',
        'PRODUCTS_IMAGE_SM_2',
        'PRODUCTS_IMAGE_XL_2',
        'PRODUCTS_IMAGE_SM_3',
        'PRODUCTS_IMAGE_XL_3',
        'PRODUCTS_IMAGE_SM_4',
        'PRODUCTS_IMAGE_XL_4',
        'PRODUCTS_IMAGE_SM_5',
        'PRODUCTS_IMAGE_XL_5',
        'PRODUCTS_IMAGE_SM_6',
        'PRODUCTS_IMAGE_XL_6',
      );
    }
    
   function _getImageFilename($imageName, $alt, $width, $height)
    {
        if (function_exists('handle_image')) {
        // use the image handler 2 contribution that is very popular
        
        // must pass DIR_WS_IMAGES in (and only this) or handle_image will revert to zen std way
        $image_data = handle_image(DIR_WS_IMAGES . $imageName, $alt, $width, $height, '');
        return str_replace(' ', '%20', HTTP_SERVER . DIR_WS_CATALOG . $image_data[0]);
      }
      else
      {
        // fallback to standard zen way
        return str_replace(' ', '%20', HTTP_SERVER . DIR_WS_CATALOG . DIR_WS_IMAGES . $imageName);
      }
    }
        
    function getAdditionalImages(&$product){
        $images = $this->_zenGetAdditionalImages($product['products_image']);
        return $images;
    }
    
    function runProductImageMacros(&$target, &$product)
    {
      $macros = $this->productImageMacros();
      
      $value = null;

      //MMD - copied and modified from <DIR_WS_MODULES>/main_product_image.php to work with Zen-style images
      //We do this because of a Zen algorithm where different sizes of the same image may be placed in 
      //a special folder hierarchy and Zen will automatically detect them.  This mechanism is described at
      //this url: http://tutorials.zen-cart.com/index.php?article=58
      //it does not appear that this technique is widely used since image handler is now part of 
      //zen, but it still needs to be supported
      $products_image_extension = substr($product['products_image'], strrpos($product['products_image'], '.'));
      $products_image_base = ereg_replace($products_image_extension . '$', '', $product['products_image']);
      $products_image_medium = 'medium/' . $products_image_base . IMAGE_SUFFIX_MEDIUM . $products_image_extension;
      $products_image_large  = 'large/' . $products_image_base . IMAGE_SUFFIX_LARGE .  $products_image_extension;
    
    $additional_images = $this->getAdditionalImages($product);

      foreach($macros as $macro) 
      {
        $value = null; // clear out prior version 
        
        switch($macro) {
            case 'PRODUCTS_IMAGE':
          case 'PRODUCTS_IMAGE_SML':
            $value = $this->_getImageFilename($product['products_image'], $product['products_name'], SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
            break;
            
            
          //in order to handle the image algorithm described earlier in this file, first we try to find a 
          //medium image to use, then a large image, and if neither of those exist, we use the default image
          case 'PRODUCTS_IMAGE_MED':
          case 'PRODUCTS_IMAGE_MEDIUM':
            if (file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $products_image_medium)){
               $value = $this->_getImageFilename($products_image_medium, $products_image_medium, MEDIUM_IMAGE_WIDTH, MEDIUM_IMAGE_HEIGHT);
            }
            else if (file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $products_image_large)){
               $value = $this->_getImageFilename($products_image_large, $products_image_large, MEDIUM_IMAGE_WIDTH, MEDIUM_IMAGE_HEIGHT);            
            }
            else{
               $value = $this->_getImageFilename($product['products_image'], $product['products_name'], MEDIUM_IMAGE_WIDTH, MEDIUM_IMAGE_HEIGHT);
            }
            break;

          //in order to handle the image algorithm described earlier in this file, first we try to find a 
          //large image to use, then a medium image, and if neither of those exist, we use the default image
        case 'PRODUCTS_IMAGE_LARGE':
        case 'PRODUCTS_IMAGE_LRG':          
            if (file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $products_image_large)){
               $value = $this->_getImageFilename($products_image_large, $products_image_large, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
            }else if (file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $products_image_medium)){
               $value = $this->_getImageFilename($products_image_medium, $products_image_medium, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
            }
            else{
               $value = $this->_getImageFilename($product['products_image'], $product['products_name'], LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
            }
            break;

        case 'PRODUCTS_IMAGE_SM_1':
          if(sizeof($additional_images) >= 1)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[0]['image'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;
          
        case 'PRODUCTS_IMAGE_XL_1':
          if(sizeof($additional_images) >= 1)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[0]['image_lrg'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;
          
        case 'PRODUCTS_IMAGE_SM_2':
          if(sizeof($additional_images) >= 2)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[1]['image'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;
          
        case 'PRODUCTS_IMAGE_XL_2':
          if(sizeof($additional_images) >= 2)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[1]['image_lrg'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;

        case 'PRODUCTS_IMAGE_SM_3':
          if(sizeof($additional_images) >= 3)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[2]['image'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;
          
        case 'PRODUCTS_IMAGE_XL_3':
          if(sizeof($additional_images) >= 3)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[2]['image_lrg'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;

        case 'PRODUCTS_IMAGE_SM_4':
          if(sizeof($additional_images) >= 4)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[3]['image'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;
          
        case 'PRODUCTS_IMAGE_XL_4':
          if(sizeof($additional_images) >= 4)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[3]['image_lrg'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;

        case 'PRODUCTS_IMAGE_SM_5':
          if(sizeof($additional_images) >= 5)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[4]['image'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;
          
        case 'PRODUCTS_IMAGE_XL_5':
          if(sizeof($additional_images) >= 5)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[4]['image_lrg'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;

        case 'PRODUCTS_IMAGE_SM_6':
          if(sizeof($additional_images) >= 6)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[5]['image'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;
          
        case 'PRODUCTS_IMAGE_XL_6':
          if(sizeof($additional_images) >= 6)
          {
            // strip out "images" folder + trailing /
            $filename = substr($additional_images[5]['image_lrg'], strlen(DIR_WS_IMAGES));
            $value = $this->_getImageFilename($filename, $filename, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
          }
          else
          {
            $value = $this->_getImageFilename('pixel_trans.gif', 'pixel_trans.gif', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); 
          }
          break;

        default:
          $value = $this->_getImageFilename($filename, $filename, LARGE_IMAGE_WIDTH, LARGE_IMAGE_HEIGHT);
          break;
        }

        // run *real* macro
        $target =& $this->runMacro($macro, $value, $target);
        
        // URL encoded macro
        $target =& $this->runRawMacro('%7B'.strtoupper($macro).'%7D', $value, $target);         
      }
      
      return $target;
    }
    
    function createProductsImagePopup(&$target, &$product)
    {
      $images .= '<table id="abx-image-popup" width="100%"><tr>';
      
      if(strlen($product['products_image']) > 0)
        $images .= $this->createImageRow($product['products_image'], $product['products_image_lrg']);

      $images .= '</tr></table>';
      
      return $images;
    }
    
    function createAdditionalImagesPopup(&$target, &$product)
    {
      $image_array = $this->getAdditionalImages($product);
        
      $images = '<table id="abx-horizontal-images" bordercolor="#e4eafc" border="0" width="100%" cellspacing="1"><tr valign="bottom">';

      if(count($image_array) > 0){
        foreach ($image_array as $unused => $image_data){
            $images .= $this->createImageRow($image_data['image'], $image_data['image_lrg']);
        }
      }

      $images .= '</tr></table>';
      
      return $images;
    }
    
    function createVerticalAdditionalImagesPopup(&$target, &$product)
    {
        $image_array = $this->getAdditionalImages($product);
      
      $images = '<table id="abx-vertical-images" bordercolor="#e4eafc" border="0" width="100%" cellspacing="1">';

      foreach($image_array as $unused => $image_data){
        $images .= '<tr valign="bottom">' . $this->createImageRow($image_data['image'], $image_data['image_lrg']) . '</tr>';
      }

      $images .= '</table>';
      
      return $images;
    }
    
    function createTwoColumnAdditionalImagesPopup(&$target, &$product)
    {
        $image_array = $this->getAdditionalImages($product);
      
      $images = '<table id="abx-two-column-images" bordercolor="#e4eafc" border="0" width="100%" cellspacing="1">';

      for($i = 0; $i < count($image_array); $i++){
        $image_data_1 = $image_array[$i];
        $i++;
        $image_data_2 = $image_array[$i];
        $images .= '<tr valign="bottom">';
        $images .= $this->createImageRow($image_data_1['image'], $image_data_1['image_lrg']);
        if ($image_data_2){
            $images .= $this->createImageRow($image_data_2['image'], $image_data_2['image_lrg']);
        }
        $images .= '</tr>';
      }

      $images .= '</table>';
      
      return $images;
    }
    
    function createImageRow(&$smallImage, &$largeImage)
    {   
      //$server = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES;
      $server = HTTP_CATALOG_SERVER . DIR_WS_CATALOG;
      
      //MMD - we need to use the zen_image function for the thumbnail size image
      //so that we can get the benefits of using any image handler contributions
      //being used by Zen
      $small_image = zen_image($smallImage, '', SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
      $small_image = str_replace('src="', 'src="' . $server, $small_image);

      return '<td align="center">' .
             '<a href="' . $server . $largeImage . '" target="_popup">' .
             //'<img src="' . $smallImage . '" border="0" hspace="5" vspace="5"><br/>' .
             $small_image . '<br/>' . 
             '<img src="' . $server . DIR_WS_MODULES . 'auctionblox/images/image_enlarge.gif" border="0" alt="Click to enlarge" title="Click to enlarge">' .
             '</a>' .
             '</td>';
    }
    
    function _zenGetAdditionalImages($products_image){
        //code copied from Zen additional_images module
        if ($products_image != '') {
   
            // prepare image name
            $products_image_extension = substr($products_image, strrpos($products_image, '.'));
            $products_image_base = str_replace($products_image_extension, '', $products_image);

            // if in a subdirectory
            if (strrpos($products_image, '/')) {
                $products_image_match = substr($products_image, strrpos($products_image, '/')+1);
                //echo 'TEST 1: I match ' . $products_image_match . ' - ' . $file . ' -  base ' . $products_image_base . '<br>';
                $products_image_match = str_replace($products_image_extension, '', $products_image_match) . '_';
                $products_image_base = $products_image_match;
            }

            $products_image_directory = str_replace($products_image, '', substr($products_image, strrpos($products_image, '/')));
            if ($products_image_directory != '') {
                //MMD - code copied from catalog module, append '../' to work in admin
                //$products_image_directory = DIR_WS_IMAGES . str_replace($products_image_directory, '', $products_image) . "/";
                $products_real_image_directory = DIR_WS_IMAGES . str_replace($products_image_directory, '', $products_image) . "/";
                $products_image_directory = '../' . DIR_WS_IMAGES . str_replace($products_image_directory, '', $products_image) . "/";
                
            } else {
                //MMD - code copied from catalog module, append '../' to work in admin
                //$products_image_directory = DIR_WS_IMAGES;
                $products_image_directory = '../' . DIR_WS_IMAGES;
                $products_real_image_directory = DIR_WS_IMAGES;
            }

            // Check for additional matching images
            $file_extension = $products_image_extension;
            $products_image_match_array = array();
                
            if ($dir = @dir($products_image_directory)) {
                while ($file = $dir->read()) {
                    if (!is_dir($products_image_directory . $file)) {
                        if (substr($file, strrpos($file, '.')) == $file_extension) {
                            //          if(preg_match("/" . $products_image_match . "/i", $file) == '1') {
                            if(preg_match("/" . $products_image_base . "/i", $file) == 1) {
                                if ($file != $products_image) {
                                    if ($products_image_base . str_replace($products_image_base, '', $file) == $file) {
                                        //  echo 'I AM A MATCH ' . $file . '<br>';
                                        $images_array[] = $file;
                                    } else {
                                        //  echo 'I AM NOT A MATCH ' . $file . '<br>';
                                    }
                                }
                            }
                        }
                    }
                }
                if (sizeof($images_array)) {
                    sort($images_array);
                }
                $dir->close();
            }
        }
        
        $result_array = array();
        for ($i=0, $n=count($images_array); $i<$n; $i++) {
            $file = $images_array[$i];
            $products_image_large = str_replace(DIR_WS_IMAGES, DIR_WS_IMAGES . 'large/', $products_image_directory) . str_replace($products_image_extension, '', $file) . IMAGE_SUFFIX_LARGE . $products_image_extension;
            $products_real_image_large = str_replace(DIR_WS_IMAGES, DIR_WS_IMAGES . 'large/', $products_real_image_directory) . str_replace($products_image_extension, '', $file) . IMAGE_SUFFIX_LARGE . $products_image_extension;
            $flag_has_large = file_exists($products_image_large);
            //$products_image_large = ($flag_has_large ? $products_image_large : $products_image_directory . $file);
            $products_image_large = ($flag_has_large ? $products_real_image_large : $products_real_image_directory . $file);
            //$flag_display_large = (IMAGE_ADDITIONAL_DISPLAY_LINK_EVEN_WHEN_NO_LARGE == 'Yes' || $flag_has_large);
            //$base_image = $products_image_directory . $file;
            $base_image = $products_real_image_directory . $file;
            //$thumb_slashes = zen_image($base_image, addslashes($products_name), SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
            //$thumb_regular = zen_image($base_image, $products_name, SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT);
            //$large_link = zen_href_link(FILENAME_POPUP_IMAGE_ADDITIONAL, 'pID=' . $_GET['products_id'] . '&pic=' . $i . '&products_image_large_additional=' . $products_image_large);

            //MMD - changing this due to need to use zen_image function to get correct formatting for
            //small images
            //$result_array[] = array('image' => HTTP_CATALOG_SERVER . DIR_WS_CATALOG . $base_image, 'image_lrg' => HTTP_CATALOG_SERVER . DIR_WS_CATALOG . $products_image_large);
            $result_array[] = array('image' => $base_image, 'image_lrg' => $products_image_large);
        } // end for loop
        
        return $result_array;
    }
  }
?>