<?php
/*
  $Id: abxTax.php,v 1.2 2005/09/16 18:37:48 devosc Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

*/

  class abxTax {

    function getTaxRateValue($class_id) {
      static $aTaxVals = array();

      if (!isset($aTaxVals[$class_id])) {
        $tax_query = tep_db_query("select SUM(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " where tax_class_id = '" . (int)$class_id . "' group by tax_priority");
        if (tep_db_num_rows($tax_query)) {
          $tax_multiplier = 0;
          while ($tax = tep_db_fetch_array($tax_query)) {
            $tax_multiplier += $tax['tax_rate'];
          }
          $aTaxVals[$class_id] = $tax_multiplier;
        } else {
          $aTaxVals[$class_id] = 0;
        }
      }

      return $aTaxVals[$class_id];
    }

    function getTaxRate($class_id, $country_id = '', $zone_id = '')
    {

      global $abxDatabase;

      if (empty($country_id) && empty($zone_id)) {

        $country_id = STORE_COUNTRY;

        $zone_id = STORE_ZONE;

      }

      static $tax_rates = array();

      if (!isset($tax_rates[$class_id][$country_id][$zone_id]['rate'])) {

        $taxQuery = $abxDatabase->query("select sum(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' group by tr.tax_priority");

        if ($taxQuery->numRows()) {

          $tax_multiplier = 1.0;

          while($tax = $taxQuery->next())

            $tax_multiplier *= 1.0 + ($tax['tax_rate'] / 100);

          $tax_rate = ($tax_multiplier - 1.0) * 100;

        } else {

          $tax_rate = 0;

        }

        $tax_rates[$class_id][$country_id][$zone_id]['rate'] = $tax_rate;

      }

      return $tax_rates[$class_id][$country_id][$zone_id]['rate'];
    }

    function getTaxRateDescription($class_id, $country_id, $zone_id)
    {

      global $abxDatabase;

      static $tax_rates = array();

      if (!isset($tax_rates[$class_id][$country_id][$zone_id]['description'])) {

        $taxQuery = $abxDatabase->query("select tax_description from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' order by tr.tax_priority");

        if ($taxQuery->numRows()) {

          $tax_description = '';

          while($tax = $taxQuery->next())

            $tax_description .= $tax['tax_description'] . ' + ';

          $tax_rates[$class_id][$country_id][$zone_id]['description'] = substr($tax_description, 0, -3);

        } else {

          $tax_rates[$class_id][$country_id][$zone_id]['description'] = TEXT_UNKNOWN_TAX_RATE;

        }

      }

      return $tax_rates[$class_id][$country_id][$zone_id]['description'];
    }

    function addTax($price, $tax)
    {

      global $currencies;

      if ($tax > 0)
        return round($price, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']) + abxTax::calculateTax($price, $tax);

      return round($price, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']);
    }

    function calculateTax($price, $tax)
    {

      global $currencies;

      return round($price * $tax / 100, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']);
    }

    function displayTaxValue($value, $padding = '')
    {

      if (empty($padding))
        $padding = TAX_DECIMAL_PLACES;

      if (strpos($value, '.')) {

        $loop = true;

        while($loop) {

          if (substr($value, -1) == '0') {

            $value = substr($value, 0, -1);

          } else {

            $loop = false;

            if (substr($value, -1) == '.')

              $value = substr($value, 0, -1);

          }

        }

      }

      if ($padding > 0) {

        if ($decimal_pos = strpos($value, '.')) {

          $decimals = strlen(substr($value, ($decimal_pos+1)));

          for($i=$decimals; $i<$padding; $i++)

            $value .= '0';

        } else {

          $value .= '.';

          for($i=0; $i<$padding; $i++)

            $value .= '0';

        }

      }

      return $value;
    }

  }//end class
?>