<?php
/*
  $Id: abxAPI.php,v 1.14 2006/10/02 03:06:51 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  // ----------------------------------------------------------------------

  require_once realpath(dirname(__FILE__).
                        '/../../../external/xmlrpc/xmlrpc.inc.php');

  // ----------------------------------------------------------------------

  require_once dirname(__FILE__).'/abxToken.php';

  // ----------------------------------------------------------------------

  class abxAPI {

    // --------------------------------------------------------------------

    var
      $api_calls = array(),

      $LIST_ITEM   = 'lister.listItem',
      $RELIST_ITEM = 'lister.relistItem',
      $CANCEL_ITEM = 'lister.cancelItem';

    // --------------------------------------------------------------------

    function abxAPI() {
      $this->api_calls = array(
        $this->LIST_ITEM,
        $this->RELIST_ITEM,
        $this->CANCEL_ITEM
      );
    }

    // --------------------------------------------------------------------

    function isValidAction($action) {
      return in_array($action, $this->api_calls);
    }

    // --------------------------------------------------------------------

    function callBySellerID($action, $nSellerId, $aVars = array()) {
      return abxAPI::xmlRPCMethod($action, 300, $aVars, $nSellerId);
    }

    // --------------------------------------------------------------------

    function call($action, $aVars = array()) {
      return abxAPI::xmlRPCMethod($action, 300, $aVars);
    }

    // --------------------------------------------------------------------

    function getAccount() {
      return abxAPI::xmlRPCMethod('account.getAccount', 300);
    }

    // --------------------------------------------------------------------

    function getProfiles() {
      return abxAPI::xmlRPCMethod('profile.getProfiles', 300);
    }

    // --------------------------------------------------------------------

    function listItem($aVars) {
      return abxAPI::xmlRPCMethod('lister.listItem', 300, $aVars);
    }

    // --------------------------------------------------------------------

    function xmlRPCMethod($sMethod, $nVersion, $aVars = array(), $nSellerId = null) {
      if (!$nSellerId && isset($aVars['seller_id'])) {
        $nSellerId = $aVars['seller_id'];
      }

      $aToken = abxAPI::createXMLRPCAuthToken($sMethod, $nVersion, $nSellerId);
      
      if (!$aVars) {
        $Message = new xmlrpcmsg($sMethod, array(new xmlrpcval($aToken, 'struct')));
      } else {
        //TODO: Fix the vars!
        $Message = new xmlrpcmsg(
          $sMethod, array(new xmlrpcval($aToken, 'struct'), abx_xmlrpc_encode($aVars)));
      }

      $aURL = parse_url(ABX_API_URL);
      $Client = new xmlrpc_client($aURL['path'], $aURL['host'], $aURL['port']);
      //$Client->setDebug(0);

      $Response = $Client->send($Message, 30);

      if(!$Response->faultCode()) {
        return abx_xmlrpc_decode($Response->value());
      } else {
        return array(
          'status'  => $Response->faultCode(),
          'message' => $Response->faultString()
        );
      }
    }

    // --------------------------------------------------------------------

    function createXMLRPCAuthToken($sMethod, $nVersion, $nSellerId) {
      $aParam = array();

      // authentication token
      $aParam['version']   = $nVersion;
      $aParam['perform']   = $sMethod;
	  $aParam['timestamp'] = iso8601_encode(time());
      $aParam['seller']    = $nSellerId;
      $aParam['email']     = AUCTIONBLOX_USERID;

      $aParam['signature'] = abxToken::sign($aParam, AUCTIONBLOX_PASSCODE);

      return array(
        'version'   => new xmlrpcval($aParam['version'],   'int'),
        'perform'   => new xmlrpcval($aParam['perform'],   'string'),
        'timestamp' => new xmlrpcval($aParam['timestamp'], 'dateTime.iso8601'),
        'seller'    => new xmlrpcval($aParam['seller'],    'string'),
        'email'     => new xmlrpcval($aParam['email'],     'string'),
        'signature' => new xmlrpcval($aParam['signature'], 'string')
      );
    }

    // --------------------------------------------------------------------

    function isError($aResult) {
      return (intval($aResult['status']) === -1 || $aResult['code'] !== 'success');
    }

    // --------------------------------------------------------------------

  }//end class

  // ----------------------------------------------------------------------

?>