<?php

/*
  $Id: abxPageFactory.php,v 1.4 2006/10/02 03:06:49 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPageFactory {

    function &newPaginator($sPaginator) {

      include_once DIR_FS_ABX_CLASSES.'Page/abxPaginator.php';

      if (include(DIR_FS_ABX_PAGINATORS."$sPaginator.php")) {
        $sPaginator = abxPageFactory::getPaginatorName($sPaginator);

        $Paginator = &new $sPaginator;

        if (is_object($Paginator) && is_subclass_of($Paginator, 'abxPaginator')) {
          return $Paginator;
        }
      }
    }

    function &createWebServicePaginator($sPaginator, $sMethod = null) {

      include_once DIR_FS_ABX_CLASSES.'Page/abxWebServicePaginator.php';

      if (include(DIR_FS_ABX_PAGINATORS."$sPaginator.php")) {
        $sPaginator = abxPageFactory::getPaginatorName($sPaginator);
        return $Paginator = &new $sPaginator($sMethod);
      }
    }

    function &newCollatedPaginator($sPaginator, $sMethod = null) {

      include_once DIR_FS_ABX_CLASSES.'Page/abxCollatedPaginator.php';

      if (include(DIR_FS_ABX_PAGINATORS."$sPaginator.php")) {
        $sPaginator = abxPageFactory::getPaginatorName($sPaginator);
        return $Paginator = &new $sPaginator($sMethod);
      }
    }

    function getPaginatorName($sPaginator) {
      $aPaginator = explode('_', $sPaginator);

      for($i=0, $n=count($aPaginator); $i<$n; $i++) {
        $aPaginator[$i] = ucfirst($aPaginator[$i]);
      }

      return 'abxPaginator_'.implode('_', $aPaginator);
    }

  } //end class
?>