<?php
/*
  $Id: abxOrder.php,v 1.27 2009/04/10 14:51:00 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class_exists('abxArray') || require_once(dirname(__FILE__).'/abxArray.php');
  class_exists('abxOrderCart') || require_once(dirname(__FILE__).'/abxOrderCart.php');
  class_exists('abxCheckout') || require_once(dirname(__FILE__).'/abxCheckout.php');
  class_exists('abxLocale') || require_once(dirname(__FILE__).'/abxLocale.php');
  class_exists('abxShippingModules') || require_once(dirname(__FILE__).'/abxShippingModules.php');
  
  require_once (dirname(__FILE__) .'/../functions/abx_currencies.php');
  require_once (dirname(__FILE__) .'/../functions/sales_order.php');

  class abxOrder extends abxOrderCart
  {
    var $ShippingModules;
    
    function abxOrder($basket_id)
    {
      global $abxDatabase, $currencies;
      $languages_id = abxRegistry::get("languages_id");
      
      $ebayCustomer = $abxDatabase->fetch_row("select b.*, a.currency " . " from " . TABLE_ABX_BASKET . " a left join " . TABLE_ABX_WINNERS . " b " . " using (auction_winner_id) where a.auction_basket_id = " . (int)$basket_id);
 
			$this->setEmail($ebayCustomer['ext_email_address']);
      $this->restore_contents();
            
      $currency = !empty($ebayCustomer['payment_currency']) ? $ebayCustomer['payment_currency'] : $ebayCustomer['currency'];
      
      $checkout = new abxCheckout();
      $sales = $checkout->getAdminOrderItems($ebayCustomer['ext_email_address']);
     
      $totalAmount = 0.0;
      $totalFee = 0.0; 
      foreach($sales as $key => $sale)
      {
        if($sale['payment_transaction_id'] != null)
        {
	        $totalAmount += $sale['payment_amount'];
	        $totalFee += $sale['payment_fee'];

	        $id = $sale['id'];
	      	$this->payments['transactions'][$id] = array(
																		'transaction_id' => $sale['payment_transaction_id'],
																		'provider' => $sale['payment_provider'],
																		'timestamp' => $sale['payment_timestamp'],
																		'currency' => $sale['payment_currency'],
																		'amount' => $sale['payment_amount'],
																		'fee' => $sale['payment_fee']
												      		);
	      }
      }

      $this->payments['total_amount'] = $totalAmount;
      $this->payments['total_fee'] = $totalFee;
      
      $this->info = array(
        'orders_status' => DEFAULT_ORDERS_STATUS_ID,
        'currency' => $currency,
        'currency_value' => $currencies->currencies[$currency]['value'],
        'payment_method' => $ebayCustomer['payment_provider'],
        'cc_type' => '',
        'cc_owner' => '',
        'cc_number' => '',
        'cc_expires' => '',
        'shipping_method' => '',
        'shipping_cost' => '',
        'subtotal' => '',
        'tax' => '',
        'tax_groups' => array(),
        'comments' => '',
        'payment_id' => $ebayCustomer['payment_transaction_id']
      );

      $customer_country_id = abx_countryID($ebayCustomer['country']);

/*
      // billing address
      $this->billing = array(
        'firstname' => !empty($this->paypal->first_name) ? $this->paypal->first_name : '',
        'lastname' => !empty($this->paypal->last_name) ? $this->paypal->last_name : '',
        'company' => !empty($this->paypal->payer_business_name) ? $this->paypal->payer_business_name : '',
        'street_address' => !empty($paypalStreetAddress) ? $paypalStreetAddress : '',
        'suburb' => !empty($paypalSuburb) ? $paypalSuburb : '',
        'city' => !empty($this->paypal->address_city) ? $this->paypal->address_city : '',
        'postcode' => !empty($this->paypal->address_zip) ? $this->paypal->address_zip : '',
        'state' => !empty($this->paypal->address_state) ? $this->paypal->address_state : '',
        'zone_id' => abx_zoneID($customer_country_id,$this->paypal->address_state),
        'country' => array('id' => $customer_country_id, 'title' => $this->paypal->address_country),
        'country_id' => $customer_country_id,
        'format_id' => abx_addressFormatID($customer_country_id)
      );

    $this->billing = array(
      'firstname' => $delivery_first_name,
      'lastname' => $delivery_last_name,
      'company' => '',
      'street_address' => $ebayCustomer['street1'] . ' ' . $ebayCustomer['street2'],
      'suburb' => '',
      'city' => $ebayCustomer['city'],
      'postcode' => $ebayCustomer['zip'],
      'state' => $ebayCustomer['state'],
      'zone_id' => abx_zoneID($shipping_country_id,$ebayCustomer['state']),
      'country' => array('id' => $shipping_country_id, 'title' => $ebayCustomer['country']),
      'country_id' => $shipping_country_id,
      'format_id' => abx_addressFormatID($shipping_country_id)
*/

//      if (empty($ebayCustomer['name']) === false) { //presumes ebay shipping address has been received

        $shipping_country_id = abx_countryID($ebayCustomer['country']);
        list($delivery_first_name, $delivery_last_name) = explode(' ',$ebayCustomer['name'], 2);

        $this->delivery = array(
          'firstname' => $delivery_first_name,
          'lastname' => $delivery_last_name,
          'company' => '',
          'street_address' => $ebayCustomer['street1'] . ' ' . $ebayCustomer['street2'],
          'suburb' => '',
          'city' => $ebayCustomer['city'],
          'postcode' => $ebayCustomer['zip'],
          'state' => $ebayCustomer['state'],
          'zone_id' => abx_zoneID($shipping_country_id,$ebayCustomer['state']),
          'country' => array('id' => $shipping_country_id, 'title' => $ebayCustomer['country']),
          'country_id' => $shipping_country_id,
          'format_id' => abx_addressFormatID($shipping_country_id)
        );
        
        $this->billing = $this->delivery;
        
      $this->customer = $this->billing;
      $this->customer['customers_telephone'] = $ebayCustomer['phone'];
      $this->customer['email_address'] = $ebayCustomer['ext_email_address'];
      $this->customer['customers_id'] = $abxDatabase->fetch_value('customers_id',TABLE_CUSTOMERS,"customers_email_address = '" . addslashes($this->customer['email_address']) . "'");
      $this->customer['ext_customer_id'] = $ebayCustomer['ext_customer_id'];
        

        unset($shipping_country_id,$shipping_zone_id,$delivery_first_name,$delivery_last_name);

//        if (empty($this->billing['firstname']) === true) {
//          $this->billing = $this->delivery;
//          $this->shipping_as_billing = true;
//        } else {

          $this->shipping_as_billing = false;

//        }

//      } else {

//        $this->delivery = $this->billing;

//        $this->shipping_as_billing = true;

//      }
//        var_dump($this);
    }
    
    function restore_contents() 
    {
       $abxCheckout = new abxCheckout();
       $this->abxProducts = $abxCheckout->getAdminOrderItems($this->email);
    }
    
/*
    function calculateCart()
    {
      parent::calculateCart();
			$ids;
			foreach($this->products as $key => $product)
			{
				$ids[] = $product['auction_basket_id'];
			}
			var_dump($uuids);
    }
*/    
    
//    function findApplicableSalesForOrder($aBasketId)
//    {
//      global $abxDatabase;
//      $languages_id = abxRegistry::get("languages_id");
//
//      $ebayCustomer = $abxDatabase->fetch_row("select b.ext_email_address from " . TABLE_ABX_BASKET . " a left join " . TABLE_ABX_WINNERS . " b " . " using (auction_winner_id) where a.auction_basket_id = " . (int)$aBasketId);
//			parent::abxOrderCart($ebayCustomer['ext_email_address']);
//    }
//      
//		function populateOrder($arrSales)
//		{
//		  global $abxDatabase, $currencies;
//      $languages_id = abxRegistry::get("languages_id");
//          
//		      
//      $currency = !empty($ebayCustomer['payment_currency']) ? $ebayCustomer['payment_currency'] : $ebayCustomer['currency'];
//
//      $this->info = array(
//        'orders_status' => DEFAULT_ORDERS_STATUS_ID,
//        'currency' => $currency,
//        'currency_value' => $currencies->currencies[$currency]['value'],
//        'payment_method' => $ebayCustomer['payment_provider'],
//        'cc_type' => '',
//        'cc_owner' => '',
//        'cc_number' => '',
//        'cc_expires' => '',
//        'shipping_method' => '',
//        'shipping_cost' => '',
//        'subtotal' => '',
//        'tax' => '',
//        'tax_groups' => array(),
//        'comments' => '',
//        'payment_id' => $ebayCustomer['payment_transaction_id']
//      );
//
//      $customer_country_id = abx_countryID($ebayCustomer['country']);
//
///*
//      // billing address
//      $this->billing = array(
//        'firstname' => !empty($this->paypal->first_name) ? $this->paypal->first_name : '',
//        'lastname' => !empty($this->paypal->last_name) ? $this->paypal->last_name : '',
//        'company' => !empty($this->paypal->payer_business_name) ? $this->paypal->payer_business_name : '',
//        'street_address' => !empty($paypalStreetAddress) ? $paypalStreetAddress : '',
//        'suburb' => !empty($paypalSuburb) ? $paypalSuburb : '',
//        'city' => !empty($this->paypal->address_city) ? $this->paypal->address_city : '',
//        'postcode' => !empty($this->paypal->address_zip) ? $this->paypal->address_zip : '',
//        'state' => !empty($this->paypal->address_state) ? $this->paypal->address_state : '',
//        'zone_id' => abx_zoneID($customer_country_id,$this->paypal->address_state),
//        'country' => array('id' => $customer_country_id, 'title' => $this->paypal->address_country),
//        'country_id' => $customer_country_id,
//        'format_id' => abx_addressFormatID($customer_country_id)
//      );
//
//    $this->billing = array(
//      'firstname' => $delivery_first_name,
//      'lastname' => $delivery_last_name,
//      'company' => '',
//      'street_address' => $ebayCustomer['street1'] . ' ' . $ebayCustomer['street2'],
//      'suburb' => '',
//      'city' => $ebayCustomer['city'],
//      'postcode' => $ebayCustomer['zip'],
//      'state' => $ebayCustomer['state'],
//      'zone_id' => abx_zoneID($shipping_country_id,$ebayCustomer['state']),
//      'country' => array('id' => $shipping_country_id, 'title' => $ebayCustomer['country']),
//      'country_id' => $shipping_country_id,
//      'format_id' => abx_addressFormatID($shipping_country_id)
//*/
//
////      if (empty($ebayCustomer['name']) === false) { //presumes ebay shipping address has been received
//
//        $shipping_country_id = abx_countryID($ebayCustomer['country']);
//        list($delivery_first_name, $delivery_last_name) = explode(' ',$ebayCustomer['name'], 2);
//
//        $this->delivery = array(
//          'firstname' => $delivery_first_name,
//          'lastname' => $delivery_last_name,
//          'company' => '',
//          'street_address' => $ebayCustomer['street1'] . ' ' . $ebayCustomer['street2'],
//          'suburb' => '',
//          'city' => $ebayCustomer['city'],
//          'postcode' => $ebayCustomer['zip'],
//          'state' => $ebayCustomer['state'],
//          'zone_id' => abx_zoneID($shipping_country_id,$ebayCustomer['state']),
//          'country' => array('id' => $shipping_country_id, 'title' => $ebayCustomer['country']),
//          'country_id' => $shipping_country_id,
//          'format_id' => abx_addressFormatID($shipping_country_id)
//        );
//        
//        $this->billing = $this->delivery;
//        
//      $this->customer = $this->billing;
//      $this->customer['customers_telephone'] = $ebayCustomer['phone'];
//      $this->customer['email_address'] = $ebayCustomer['ext_email_address'];
//      $this->customer['customers_id'] = $abxDatabase->fetch_value('customers_id',TABLE_CUSTOMERS,"customers_email_address = '" . addslashes($this->customer['email_address']) . "'");
//      $this->customer['ext_customer_id'] = $ebayCustomer['ext_customer_id'];
//        
//
//        unset($shipping_country_id,$shipping_zone_id,$delivery_first_name,$delivery_last_name);
//
////        if (empty($this->billing['firstname']) === true) {
////          $this->billing = $this->delivery;
////          $this->shipping_as_billing = true;
////        } else {
//
//          $this->shipping_as_billing = false;
//
////        }
//
////      } else {
//
////        $this->delivery = $this->billing;
//
////        $this->shipping_as_billing = true;
//
////      }
//
//    
//    }
//
    function insertOrUpdateOrder(&$postvars)
    {
      global $currencies;

      $customer_country_id = abx_countryID($postvars['country']);

      $this->customer['firstname'] = $postvars['firstname'];

      $this->customer['lastname'] = $postvars['lastname'];

      $this->customer['company'] = $postvars['company'];

      $this->customer['street_address'] = $postvars['street_address'];

      $this->customer['suburb'] = $postvars['suburb'];

      $this->customer['city'] = $postvars['city'];

      $this->customer['state'] = $postvars['state'];

      $this->customer['zone_id'] = abx_zoneID($customer_country_id,$postvars['state']);

      $this->customer['postcode'] = $postvars['postcode'];

      $this->customer['country']['title'] = $postvars['country'];

      $this->customer['country_id'] = $customer_country_id;
      $this->customer['country']['id'] = $customer_country_id;

      $this->customer['customers_telephone'] = $postvars['customers_telephone'];

      if (empty($this->customer['customers_id']) === true)
        $this->customer['customers_newsletter'] = $postvars['customers_newsletter'] == 'Yes' ? 1 : 0;

      //$this->customer['email_address'] = $postvars['email_address'];
      //$this->customer['ext_customer_id'] = $postvars['ext_customer_id'];

      $this->billing = $this->customer;

      if ($postvars['shipping_as_billing'] == 'on') {

        $this->delivery = $this->billing;

        $this->shipping_as_billing = true;

      } else {

        $shipping_country_id = abx_countryID($postvars['shipping_country']);

        $this->delivery['firstname'] = $postvars['shipping_firstname'];

        $this->delivery['lastname'] = $postvars['shipping_lastname'];

        $this->delivery['company'] = $postvars['shipping_company'];

        $this->delivery['street_address'] = $postvars['shipping_street_address'];

        $this->delivery['suburb'] = $postvars['shipping_suburb'];

        $this->delivery['city'] = $postvars['shipping_city'];

        $this->delivery['state'] = $postvars['shipping_state'];

        $this->delivery['zone_id'] = abx_zoneID($shipping_country_id,$postvars['shipping_state']);

        $this->delivery['postcode'] = $postvars['shipping_postcode'];

        $this->delivery['country']['title'] = $postvars['shipping_country'];

        $this->delivery['country_id'] = $shipping_country_id;
        $this->delivery['country']['id'] = $shipping_country_id;

        $this->shipping_as_billing = false;

      }

      $this->info['payment_method'] = $postvars['payment_method'];

      $this->info['shipping_method'] = $this->ShippingModules->getMethodNameByClassName($postvars['shipping_method']);

      $this->info['shipping_cost'] =  abx_currencies_convertCurrency($postvars['shipping_cost'], $this->info['currency']);

      $this->calculateCart();

      $this->info['orders_status'] = $postvars['orders_status'];

      $this->info['comments'] = $postvars['comments'];

      if ($postvars['salesOrderCalculate'] == 'false') {

        $this->info['subtotal'] = abx_currencies_convertCurrency($postvars['subtotal'], $this->info['currency']);
        $this->info['subtotal_gross'] = abx_currencies_convertCurrency($postvars['subtotal_gross'], $this->info['currency']);

        $this->info['tax'] = abx_currencies_convertCurrency($postvars['tax'], $this->info['currency']);
        $this->info['tax_gross'] = abx_currencies_convertCurrency($postvars['tax_gross'], $this->info['currency']);

        $this->info['shipping_cost'] =  abx_currencies_convertCurrency($postvars['shipping_cost'], $this->info['currency']);
        $this->info['shipping_cost_gross'] =  abx_currencies_convertCurrency($postvars['shipping_cost_gross'], $this->info['currency']);

        $this->info['total'] = $this->info['subtotal'] + $this->info['tax'] + $this->info['shipping_cost'];
        $this->info['total_gross'] = $this->info['subtotal_gross'] + $this->info['shipping_cost_gross'];

        $customer_id = $this->customerOrderDetails();

        $order_id = $this->insertOrder($customer_id);

        $this->order_totals = $this->insertOrderTotals($order_id);

        $this->updateProducts($order_id);

        $notify_customer = ($postvars['customer_notify'] == 'Yes') ? true : false;

        $this->updateOrderStatus($order_id,$notify_customer);

        if ($notify_customer === true)
          $this->notifyCustomer($order_id);

        $this->reset(true, $order_id);

        return $order_id;
      }

      return 0;
    }
    
    function set(&$postvars)
    {
      global $currencies;

      $customer_country_id = abx_countryID($postvars['country']);

      $this->customer['firstname'] = $postvars['firstname'];

      $this->customer['lastname'] = $postvars['lastname'];

      $this->customer['company'] = $postvars['company'];

      $this->customer['street_address'] = $postvars['street_address'];

      $this->customer['suburb'] = $postvars['suburb'];

      $this->customer['city'] = $postvars['city'];

      $this->customer['state'] = $postvars['state'];

      $this->customer['zone_id'] = abx_zoneID($customer_country_id,$postvars['state']);

      $this->customer['postcode'] = $postvars['postcode'];

      $this->customer['country']['title'] = $postvars['country'];

      $this->customer['country_id'] = $customer_country_id;
      $this->customer['country']['id'] = $customer_country_id;

      $this->customer['customers_telephone'] = $postvars['customers_telephone'];

      if (empty($this->customer['customers_id']) === true)
        $this->customer['customers_newsletter'] = $postvars['customers_newsletter'] == 'Yes' ? 1 : 0;

      //$this->customer['email_address'] = $postvars['email_address'];
      //$this->customer['ext_customer_id'] = $postvars['ext_customer_id'];

      $this->billing = $this->customer;

      if ($postvars['shipping_as_billing'] == 'on') {

        $this->delivery = $this->billing;

        $this->shipping_as_billing = true;

      } else {

        $shipping_country_id = abx_countryID($postvars['shipping_country']);

        $this->delivery['firstname'] = $postvars['shipping_firstname'];

        $this->delivery['lastname'] = $postvars['shipping_lastname'];

        $this->delivery['company'] = $postvars['shipping_company'];

        $this->delivery['street_address'] = $postvars['shipping_street_address'];

        $this->delivery['suburb'] = $postvars['shipping_suburb'];

        $this->delivery['city'] = $postvars['shipping_city'];

        $this->delivery['state'] = $postvars['shipping_state'];

        $this->delivery['zone_id'] = abx_zoneID($shipping_country_id,$postvars['shipping_state']);

        $this->delivery['postcode'] = $postvars['shipping_postcode'];

        $this->delivery['country']['title'] = $postvars['shipping_country'];

        $this->delivery['country_id'] = $shipping_country_id;
        $this->delivery['country']['id'] = $shipping_country_id;

        $this->shipping_as_billing = false;

      }

      $this->info['payment_method'] = $postvars['payment_method'];

      $this->info['shipping_method'] = $this->ShippingModules->getMethodNameByClassName($postvars['shipping_method']);

      $this->info['shipping_cost'] =  abx_currencies_convertCurrency($postvars['shipping_cost'], $this->info['currency']);

      $this->calculateCart();

      $this->info['orders_status'] = $postvars['orders_status'];

      $this->info['comments'] = $postvars['comments'];

      if ($postvars['salesOrderCalculate'] == 'false') {

        $this->info['subtotal'] = abx_currencies_convertCurrency($postvars['subtotal'], $this->info['currency']);
        $this->info['subtotal_gross'] = abx_currencies_convertCurrency($postvars['subtotal_gross'], $this->info['currency']);

        $this->info['tax'] = abx_currencies_convertCurrency($postvars['tax'], $this->info['currency']);
        $this->info['tax_gross'] = abx_currencies_convertCurrency($postvars['tax_gross'], $this->info['currency']);

        $this->info['shipping_cost'] =  abx_currencies_convertCurrency($postvars['shipping_cost'], $this->info['currency']);
        $this->info['shipping_cost_gross'] =  abx_currencies_convertCurrency($postvars['shipping_cost_gross'], $this->info['currency']);

        $this->info['total'] = $this->info['subtotal'] + $this->info['tax'] + $this->info['shipping_cost'];
        $this->info['total_gross'] = $this->info['subtotal_gross'] + $this->info['shipping_cost_gross'];

        $customer_id = $this->customerOrderDetails();

        $order_id = $this->insertOrder($customer_id);

        $this->order_totals = $this->insertOrderTotals($order_id);

        $this->updateProducts($order_id);

        $notify_customer = ($postvars['customer_notify'] == 'Yes') ? true : false;

        $this->updateOrderStatus($order_id,$notify_customer);

        if ($notify_customer === true)
          $this->notifyCustomer($order_id);

        $this->reset(true, $order_id);

        return $order_id;
      }

      return 0;
    }
    

    function insertOrder($customer_id)
    {
      global $abxDatabase;
      
      $country_array = abxLocale::getCountryByIso2Code($this->billing['country']['title']);
      $billing_country = $country_array['name'];

      $country_array = abxLocale::getCountryByIso2Code($this->delivery['country']['title']);
      $delivery_country = $country_array['name'];

      $state_array = abxLocale::getStateNameByCode($this->billing['country_id'], $this->billing['state']);
      $billing_state = $state_array['name'];

      $state_array = abxLocale::getStateNameByCode($this->delivery['country_id'], $this->delivery['state']);
      $delivery_state = $state_array['name'];

      $sql_data_array = array(
        'customers_id' => $customer_id,
        'customers_name' => $this->customer['firstname'] . ' ' . $this->customer['lastname'] . ' (' . $this->customer['ext_customer_id'] . ')',
        'customers_company' => $this->customer['company'],
        'customers_street_address' => $this->customer['street_address'],
        'customers_suburb' => $this->customer['suburb'],
        'customers_city' => $this->customer['city'],
        'customers_postcode' => $this->customer['postcode'],
        'customers_state' => $billing_state,
        'customers_country' => $billing_country,
        'customers_telephone' => $this->customer['customers_telephone'],
        'customers_email_address' => $this->customer['email_address'],
        'customers_address_format_id' => $this->customer['format_id'],
        'delivery_name' => $this->delivery['firstname'] . ' ' . $this->delivery['lastname'],
        'delivery_company' => $this->delivery['company'],
        'delivery_street_address' => $this->delivery['street_address'],
        'delivery_suburb' => $this->delivery['suburb'],
        'delivery_city' => $this->delivery['city'],
        'delivery_postcode' => $this->delivery['postcode'],
        'delivery_state' => $delivery_state,
        'delivery_country' => $delivery_country,
        'delivery_address_format_id' => $this->delivery['format_id'],
        'billing_name' => $this->billing['firstname'] . ' ' . $this->billing['lastname'],
        'billing_company' => $this->billing['company'],
        'billing_street_address' => $this->billing['street_address'],
        'billing_suburb' => $this->billing['suburb'],
        'billing_city' => $this->billing['city'],
        'billing_postcode' => $this->billing['postcode'],
        'billing_state' => $billing_state,
        'billing_country' => $billing_country,
        'billing_address_format_id' => $this->billing['format_id'],
        'payment_method' => $this->info['payment_method'],
        'date_purchased' => 'now()',
        'orders_status' => $this->info['orders_status'],
        'currency' => $this->info['currency'],
        'currency_value' => $this->info['currency_value'],
        'payment_id' => $this->info['payment_id']
      );

      $sql_data_array = abxArray::prune($sql_data_array);

      return $abxDatabase->insert(TABLE_ORDERS, $sql_data_array);
    }

    function insertOrderTotals($order_id)
    {
      global $currencies, $abxDatabase;

      $order_totals_array = array();

      $nSubTotal = $this->info['subtotal'];
      $nTax      = $this->info['tax'];
      $nShipping = $this->info['shipping_cost'];
      $nTotal    = $this->info['total'];

      if (DISPLAY_PRICE_WITH_TAX == 'true') {
        $nSubTotal = $this->info['subtotal_gross'];
        $nTax      = $this->info['tax_gross'];
        $nShipping = $this->info['shipping_cost_gross'];
        $nTotal    = $this->info['total_gross'];
      }


      $sql_data_array = array(
        'orders_id' => $order_id,
        'title' => ABX_ENTRY_SUB_TOTAL,
        'text' => $currencies->format($nSubTotal, true, $this->info['currency'], $this->info['currency_value']),
        'value' => $nSubTotal,
        'class' => 'ot_subtotal',
        'sort_order' => 1
      );

      $abxDatabase->insert(TABLE_ORDERS_TOTAL, $sql_data_array);

      $order_totals_array[] = array(
        'title' => $sql_data_array['title'],
        'text' => $sql_data_array['text']
      );

      $sql_data_array = array(
        'orders_id' => $order_id,
        'title' => ABX_ENTRY_TAX,
        'text' => $currencies->format($nTax, true, $this->info['currency'], $this->info['currency_value']),
        'value' => $nTax,
        'class' => 'ot_tax',
        'sort_order' => 2
      );

      $abxDatabase->insert(TABLE_ORDERS_TOTAL, $sql_data_array);

      $order_totals_array[] = array(
        'title' => $sql_data_array['title'],
        'text' => $sql_data_array['text']
      );

      $sql_data_array = array(
        'orders_id' => $order_id,
        'title' => $this->info['shipping_method'], //ABX_ENTRY_SHIPPING_COST,
        'text' => $currencies->format($nShipping, true, $this->info['currency'], $this->info['currency_value']),
        'value' => $nShipping,
        'class' => 'ot_shipping',
        'sort_order' => 3
      );

      $abxDatabase->insert(TABLE_ORDERS_TOTAL, $sql_data_array);

      $order_totals_array[] = array(
        'title' => $sql_data_array['title'],
        'text' => $sql_data_array['text']
      );

      $sql_data_array = array(
        'orders_id' => $order_id,
        'title' => ABX_ENTRY_TOTAL,
        'text' => $currencies->format($nTotal, true, $this->info['currency'], $this->info['currency_value']),
        'value' => $nTotal,
        'class' => 'ot_total',
        'sort_order' => 4
      );

      $abxDatabase->insert(TABLE_ORDERS_TOTAL, $sql_data_array);

      $order_totals_array[] = array(
        'title' => $sql_data_array['title'],
        'text' => $sql_data_array['text']
      );

      return $order_totals_array;
    }

    function updateOrderStatus($order_id, $customer_notified = false)
    {
      global $abxDatabase;

      $sql_data_array = array(
        'orders_id' => $order_id,
        'orders_status_id' => $this->info['orders_status'],
        'date_added' => 'now()',
        'customer_notified' => ($customer_notified === true ? '1' : '0'),
        'comments' => $this->info['comments']
      );

      $abxDatabase->insert(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
    }

    function customerOrderDetails()
    {
      global $abxDatabase;

      if (empty($this->customer['customers_id']) === false) {

        return $this->customer['customers_id'];

      } else {

        $sql_data_array = array(
          'customers_firstname' => $this->customer['firstname'],
          'customers_lastname' => $this->customer['lastname'] . ' (' . $this->customer['ext_customer_id'] . ')',
          'customers_email_address' => $this->customer['email_address'],
          //'customers_telephone' => $this->customer['customers_telephone'],
          'customers_newsletter' => $this->customer['customers_newsletter'],
          'customers_password' => abx_generateRandomPassword()
        );

        $customers_id = $abxDatabase->insert(TABLE_CUSTOMERS, $sql_data_array);

        $sql_data_array = array(
          'customers_info_id' => $customers_id,
          'customers_info_date_account_created' => date("Y-m-d H:i:s"),
          'customers_info_date_account_last_modified' => date("Y-m-d H:i:s")
        );

        $abxDatabase->insert(TABLE_CUSTOMERS_INFO, $sql_data_array);

        $addres_book_zone = abx_zoneID($this->customer['country']['id'],$this->customer['state']);

        $sql_data_array = array(
          'customers_id' => $customers_id,
          'entry_firstname' => $this->customer['firstname'],
          'entry_lastname' => $this->customer['lastname'],
          'entry_company' => $this->customer['company'],
          'entry_street_address' => $this->customer['street_address'],
          'entry_suburb' => $this->customer['suburb'],
          'entry_city' => $this->customer['city'],
          'entry_postcode' => $this->customer['postcode'],
          'entry_state' => $this->customer['state'],
          'entry_country_id' => $this->customer['country']['id'],
          'entry_zone_id' => $addres_book_zone['zone_id']
        );

        $address_book_insert_id = $abxDatabase->insert(TABLE_ADDRESS_BOOK, $sql_data_array);

        $abxDatabase->update(TABLE_CUSTOMERS, array('customers_default_address_id' => $address_book_insert_id), 'customers_id='.$customers_id);

        $abxDatabase->update(TABLE_ABX_WINNERS, array('customers_id' => $customers_id), "ext_email_address= '" . addslashes($this->customer['email_address']) . "'");

        return $customers_id;

      }
    }

    function notifyCustomer($order_id)
    {
      foreach($this->order_totals as $order_total)
        $order_totals .= strip_tags($order_total['title']) . ' ' . strip_tags($order_total['text']) . "\n";

      $info = array(
        'order_id'                => $order_id,
        'comments'                => $this->info['comments'],
        'products_ordered'        => $this->products_ordered,
        'order_totals'            => $order_totals,
        'delivery_format_id'      => $this->delivery['format_id'],
        'delivery_address'        => $this->delivery,
        'billing_format_id'       => $this->billing['format_id'],
        'billing_address'         => $this->billing,
        'payment_method'          => $this->info['payment_method'],
        'customer_firstname'      => $this->customer['firstname'],
        'customer_lastname'       => $this->customer['lastname'],
        'customer_email_address'  => $this->customer['email_address']
      );

      abx_salesOrderCustomerEmailNotify($info);
    }

  }//end class
?>