<?php
/*
  $Id: abxProfiles.php,v 1.8 2005/04/11 17:13:29 auctionblox Exp $

  AuctionBlox, sell more, work less!

  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES . 'abxProfiles.php');
  
  class abxProfilesEmail {

    function updateTemplate(&$aPost) {
      
      $aArr = array(
        'profile_id'   => $aPost['profile_id'],
        'type'         => $aPost['type'],
        'subject'      => $aPost['subject'],
        'body'         => $aPost['body'],
        'id'           => $aPost['oID']
      );

      $aResult = abxAPI::call('profile.updateEmailTemplate', $aArr);
      if (abxAPI::isError($aResult)) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED,'error');
      }
    }

    function insertTemplates(&$aPost) {
      
      $bError = false;
      foreach($aPost['abxList'] as $nProfileId) {
        $aArr = array(
          'profile_id'   => $nProfileId,
          'type'         => $aPost['type'],
          'subject'      => $aPost['subject'],
          'body'         => $aPost['body']
        );

        $aResult = abxAPI::call('profile.insertEmailTemplate', $aArr);

        if (abxAPI::isError($aResult)) {
          $bError = true;
        }
      }

      if ($bError) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED,'error');
      }
    }

    function insertTemplate(&$aPost) {
      
      $aArr = array(
        'profile_id'   => $aPost['profile_id'],
        'type'         => $aPost['type'],
        'subject'      => $aPost['subject'],
        'body'         => $aPost['body'],
        'from_address' => ''
      );

      $aResult = abxAPI::call('profile.insertEmailTemplate', $aArr);

      if (abxAPI::isError($aResult)) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
      }
    }

    function deleteTemplates($aProfiles) {
      if (!$aProfiles) {
        return false;
      }

      $bError = false;
      foreach($aProfiles as $nProfileId) {
        $aArr = array('id' => $nProfileId);

        $aResult = abxAPI::call('profile.removeEmailTemplate', $aArr);

        if (abxAPI::isError($aResult)) {
          $bError = true;
        }
      }

      if ($bError) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED,'error');
      }
    }

    function getTemplateById($id) {
      
      $aArr = array('id' => $id);
      $aResult = abxAPI::call('profile.getEmailTemplateById', $aArr);

      if (abxAPI::isError($aResult)) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
        abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-email&oID='.$id.abxPage::getSearchParams()));
      }

      return $aResult['data'];
    }
    
    function getProfileNameByEmailTemplateId($id) 
    {	
    	$profiles = abxProfiles::getProfiles();
    	foreach($profiles as $key1 => $profile)
    	{
    		$emailTemplates = $profile['emailTemplates'];
    		foreach($emailTemplates as $key2 => $emailTemplate)
    		{
    			if(strcmp($id, $emailTemplate['id']) === 0)
    				return $profile['label'];
    		}
    	}
    	return "{UNKNOWN}";	
    }    

  }//end class

?>