<?php
/*
  $Id: abxCatalogService.php,v 1.4 2007/04/01 01:19:13 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004-2006 AuctionBlox
*/

  require_once (DIR_FS_ABX_CLASSES . 'core/abxSingleton.php');
  require_once (DIR_FS_ABX_CLASSES . 'API/abxSoapClient.php');

  class abxListerService extends abxSingleton
  {
    var $domesticCalculatedShippingServicesBySite = array();
    var $internationalCalculatedShippingServicesBySite = array();    
      	
    var $domesticFixedShippingServicesBySite = array();
    var $internationalFixedShippingServicesBySite = array();    

  	function abxListerService()
  	{
  	}

    // static method
    function loadCalculatedShippingServices($site)
    {
      $instance = abxListerService::getInstance(__CLASS__);

      if(!isset($instance->domesticCalculatedShippingServicesBySite[$site]['loaded']))
      {
        // do the api call
        $result = abxSoapClient::call('ShippingService', 'getCalculatedShippingMethods', array('site'=>$site));

        $instance->internationalCalculatedShippingServicesBySite[$site]['list'] = array();
        $instance->domesticCalculatedShippingServicesBySite[$site]['list'] = array();
        
        foreach($result['shippingMethod'] as $key => $value)
        {
            if(isset($value['international']))
            {
                $instance->internationalCalculatedShippingServicesBySite[$site]['list'][] = array('id' => $value['name'], 'text' => $value['description'], 'value' => $value);
            }
            else
            {
                $instance->domesticCalculatedShippingServicesBySite[$site]['list'][] = array('id' => $value['name'], 'text' => $value['description'], 'value' => $value);
            }
        }

        $instance->domesticCalculatedShippingServicesBySite[$site]['loaded'] = true;
        $instance = abxListerService::setInstance(__CLASS__, $instance);
      }
    }
  	
    function loadFixedShippingServices($site)
    {
      $instance = abxListerService::getInstance(__CLASS__);

      if(!isset($instance->domesticFixedShippingServicesBySite[$site]['loaded']))
      {
        // do the api call
        $result = abxSoapClient::call('ShippingService', 'getFixedShippingMethods', array('site'=>$site));

        $instance->internationalFixedShippingServicesBySite[$site]['list'] = array();
        $instance->domesticFixedShippingServicesBySite[$site]['list'] = array();
        
        foreach($result['shippingMethod'] as $key => $value)
        {
            if(isset($value['international']))
            {
                $instance->internationalFixedShippingServicesBySite[$site]['list'][] = array('id' => $value['name'], 'text' => $value['description'], 'value' => $value);
            }
            else
            {
                $instance->domesticFixedShippingServicesBySite[$site]['list'][] = array('id' => $value['name'], 'text' => $value['description'], 'value' => $value);
            }
        }

        $instance->domesticFixedShippingServicesBySite[$site]['loaded'] = true;
        $instance = abxListerService::setInstance(__CLASS__, $instance);
      }
    }

	  // static method
	  function getDomesticCalculatedShippingServices($site)
	  {
       abxListerService::loadCalculatedShippingServices($site);
       $instance = abxListerService::getInstance(__CLASS__);
       return $instance->domesticCalculatedShippingServicesBySite[$site]['list'];
    }
    
      function getInternationalCalculatedShippingServices($site)
      {
       abxListerService::loadCalculatedShippingServices($site);
       $instance = abxListerService::getInstance(__CLASS__);
       return $instance->internationalCalculatedShippingServicesBySite[$site]['list'];
    }

      function getDomesticFixedShippingServices($site)
      {
       abxListerService::loadFixedShippingServices($site);
       $instance = abxListerService::getInstance(__CLASS__);
       return $instance->domesticFixedShippingServicesBySite[$site]['list'];
    }

      function getInternationalFixedShippingServices($site)
      {
       abxListerService::loadFixedShippingServices($site);
       $instance = abxListerService::getInstance(__CLASS__);
       return $instance->internationalFixedShippingServicesBySite[$site]['list'];
    }

  }//end class
?>