<?php
/*
  $Id: sales_order.js.php,v 1.3 2007/10/15 22:47:32 devosc Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/
?>

var sFormName = 'salesOrder';

// ------------------------------------------------------------------------

function calculateSubmit() {
  var form = document.forms[sFormName];
  form.salesOrderCalculate.value = 'true';
  form.submit();
}

// ------------------------------------------------------------------------

function shippingAsBilling(checkbox) {
  var form = document.forms[sFormName];

  if(checkbox.checked == true) {
    form.shipping_firstname.value       = form.firstname.value;
    form.shipping_lastname.value        = form.lastname.value;
    form.shipping_company.value         = form.company.value;
    form.shipping_street_address.value  = form.street_address.value;
    form.shipping_suburb.value          = form.suburb.value;
    form.shipping_city.value            = form.city.value;
    form.shipping_state.value           = form.state.value;
    form.shipping_postcode.value        = form.postcode.value;
    form.shipping_country.selectedIndex = form.country.selectedIndex;
  }
}

// ------------------------------------------------------------------------

function getFloat(nVal, nPlaces) {
  if (nPlaces == null) {
    nPlaces = 4;
  }
  return Math.round(nVal * Math.pow(10, nPlaces)) / Math.pow(10, nPlaces);
}

// ------------------------------------------------------------------------

function updateTotals() {
  calculateTotal();
  calculateGrossTotal();
}

// ------------------------------------------------------------------------

function calculateTotal() {
  var form = document.forms[sFormName];

  var nTotal = parseFloat(form.subtotal.value)
               + parseFloat(form.shipping_cost.value);

  form.total.value = getFloat(nTotal);
}

// ------------------------------------------------------------------------

function calculateGrossTotal() {
  var form = document.forms[sFormName];

  var nGross = parseFloat(form.subtotal_gross.value)
                    + parseFloat(form.shipping_cost_gross.value);

  form.total_gross.value = getFloat(nGross);
}

// ------------------------------------------------------------------------

var aShippingTaxRates = new Array();

<?php
  $aShipTaxClasses = $order->ShippingModules->getTaxRates();
  for ($i=0, $n=count($aShipTaxClasses); $i<$n; $i++) {
    if ($aShipTaxClasses[$i]['class'] > 0) {
      echo "    aShippingTaxRates['{$aShipTaxClasses[$i]['id']}'] = ".
           abxTax::getTaxRateValue($aShipTaxClasses[$i]['class']).";\n";
    }
  }
?>

// ------------------------------------------------------------------------

function getShippingTaxRate() {
  var form = document.forms[sFormName];

  var nIndex = form.shipping_method.selectedIndex;

  var sVal = form.shipping_method[nIndex].value;

  if (aShippingTaxRates[sVal] > 0) {
    return aShippingTaxRates[sVal];
  } else {
    return 0;
  }
}

// ------------------------------------------------------------------------

function updateGrossShipping() {
  var form = document.forms[sFormName];

  var nTaxRate = getShippingTaxRate();

  var nNet = form.shipping_cost.value;

  var nAmt = nNet;

  if (nTaxRate > 0) {
    var nGross = nNet * ((nTaxRate / 100) + 1);
    nAmt = nGross;
    form.shipping_cost_gross.value = getFloat(nGross);
  } else {
    form.shipping_cost_gross.value = nNet;
  }
  updateTax(nAmt, nTaxRate);
  updateTotals();
}

// ------------------------------------------------------------------------

function updateNetShipping() {
  var form = document.forms[sFormName];

  var nTaxRate = getShippingTaxRate();

  var nGross = form.shipping_cost_gross.value;

  var nAmt = nGross;

  if (nTaxRate > 0) {
    var nNet = nGross / ((nTaxRate / 100) + 1);
    nAmt = nNet;
    form.shipping_cost.value = getFloat(nNet);
  } else {
    form.shipping_cost.value = nGross;
  }
  updateTax(nAmt, nTaxRate);
  updateTotals();
}

// ------------------------------------------------------------------------

<?php
  require_once DIR_FS_ABX_FUNCTIONS.'abx_currencies.php';
  
  echo 'var nBaseTax = '.
       abx_currencies_invertCurrency($order->info['tax'],
                                    $order->info['currency'], true)."\n";
?>

function updateTax(nAmt, nTaxRate) {
  var form = document.forms[sFormName];

  var nTax = nAmt * nTaxRate / 100;

  var nTaxVal = parseFloat(nBaseTax) + parseFloat(nTax);

  form.tax.value = getFloat(nTaxVal);
  form.tax_gross.value = getFloat(nTaxVal);
}

// ------------------------------------------------------------------------
