<?php
/*
  $Id: items_generator.php,v 1.18 2008/03/31 18:22:19 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Items_Generator extends abxCollatedPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if (isset($filterTerms) === false)
      {
      	$values = array(
                      array('id' => '', 'text' => '[-- No Filter --]'),
                      array('id' => '', 'text' => '-- Listing Status --'),
                      array('id' => 'product-anylisting-notactive', 'text' => 'Products with no active eBay listing'),
                      array('id' => 'product-storelisting-notactive', 'text' => 'Products with no active eBay *store* listings'),
                      array('id' => 'product-fixedlisting-notactive', 'text' => 'Products with no active eBay *fixed* listings'),
                      array('id' => 'product-auctionlisting-notactive', 'text' => 'Products with no active eBay *auction* listings'),
                      array('id' => '', 'text' => '-- Sales --'),
                      array('id' => 'product-bestsellers', 'text' => 'Bestsellers'),
                      array('id' => '', 'text' => '-- Inventory --'),
                      array('id' => 'inventory-instock', 'text' => 'Products In Stock'),
//                      array('id' => 'inventory-avail', 'text' => 'Products Available For Sale'),
//                      array('id' => '', 'text' => '-- Listing Type --'),
//                      array('id' => 'listing-auction', 'text' => 'eBay Auction'),
//                      array('id' => 'listing-fixed', 'text' => 'eBay Fixed'),
//                      array('id' => 'listing-store', 'text' => 'eBay Store'),
                      array('id' => '', 'text' => '-- Category --')
                   );
                   
        $values = array_merge($values, abx_get_category_tree());

        $filterTerms = array(
          'name'   => 'filter',
          'values' => $values
        );      
      }

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'p.products_last_modified',
        'value' => 'desc'
      );
    }

    function countSellerIDs()
    {
      return 0;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"m.manufacturers_name",'text'=>'SEARCH_MANUFACTURER'),
        array('id'=>"pd.products_name",'text'=>'SEARCH_LIST_1'),
        array('id'=>"p.products_model",'text'=>'SEARCH_LIST_2'),
        array('id'=>"p.products_price",'text'=>'SEARCH_LIST_3'),
        array('id'=>"p.products_last_modified",'text'=>'SEARCH_LIST_4')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => '<a href="" onclick="lazyloadimages();return false;">Images +</a>'),
        array('heading' => TABLE_HEADING_PRODUCT_TITLE, 'sort_field' => 'pd.products_name'),
        array('heading' => TABLE_HEADING_PRODUCT_MODEL, 'sort_field' => 'p.products_model'),
        array('heading' => TABLE_HEADING_PRODUCTS_PRICE, 'sort_field' => 'p.products_price'),
        array('heading' => TABLE_HEADING_PRODUCTS_TOTAL_SOLD, 'sort_field' => 'total_sold'),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_IN_STOCK, 'sort_field' => 'p.products_quantity'),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_PENDING),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_RESERVED),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_ACTIVE),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_REMAINING),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING, 'sort_field' => 'pfs.shipping'),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING_ADDL, 'sort_field' => 'pfs.shipping_addl'),
        array('heading' => TABLE_HEADING_PRODUCTS_LAST_MODIFIED, 'sort_field' => 'p.products_last_modified')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;
      
      $qtyInStock = $array['products_quantity'];
      $qtyPending = 0; if(isset($array['childRecords'][0]['quantity_pending'])) $qtyPending = $array['childRecords'][0]['quantity_pending'];
      $qtyReserved = 0; if(isset($array['childRecords'][0]['quantity_reserved'])) $qtyReserved = $array['childRecords'][0]['quantity_reserved']; 
      $qtyActive = 0;  if(isset($array['childRecords'][0]['quantity_active'])) $qtyActive = $array['childRecords'][0]['quantity_active'];
      
      $qtyRemaining = $qtyInStock - $qtyPending - $qtyReserved - $qtyActive;

      return '<td ><script language="JavaScript">lazyimages['.$array['products_id'].']="'.DIR_WS_ABX_CATALOG_IMAGES .$array['products_image'].'";</script>' . $this->image(DIR_WS_ABX_ICONS . 'info.gif', 'Click to load image', 16, 16,'onclick="lazyloadimage('.$array['products_id'].',this);" id="lazyimage'.$array['products_id'].'"') . '</td>'.
             '<td>' . $this->cell($array['products_name']) . '</td>'.
             '<td>' . $this->cell($array['products_model']) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['products_price'])) . '</td>'.
             '<td align="right">' . $this->cell($array['total_sold']) . '</td>'.
             '<td align="right">' . $this->cell($qtyInStock) . '</td>'.
             '<td align="right">' . $this->cell(($qtyPending > 0) ? $qtyPending : '---') . '</td>'.
             '<td align="right">' . $this->cell(($qtyReserved > 0) ? $qtyReserved : '---') . '</td>'.
             '<td align="right">' . $this->cell(($qtyActive > 0) ? $qtyActive : '---') . '</td>'.
             '<td align="right">' . $this->cell($qtyRemaining) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['shipping'])) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['shipping_addl'])) . '</td>'.
             '<td align="right">' . $this->cellWrapDate(abx_short_date($array['products_last_modified'])) . '</td>';
    }

    function drawExtraHiddenFields()
    {
      return '<input type="hidden" name="templateid" value=""><input type="hidden" name="abx_last" value="generator">'; 
    }

    function bulkActions()
    {
      return array(array());
    }

    function generateListingFields($templateid)
    {
      $templates = new abxItemTemplates;  
      $template = $templates->getTemplate($templateid);

      $template['site'] = !empty($_POST['site']) ? $_POST['site'] : $template['site'];
      
      $str = '<table border="0" width="100%" cellspacing="5" cellpadding="5" class="tableForm">' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_TITLE, '<span>') . '&nbsp;&nbsp;&nbsp;' . $this->input('title', $template['title'], 'size="55" maxlength="55"', false) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_SUBTITLE, '<span>') . '&nbsp;' . $this->input('subtitle', $template['subtitle'], 'size="55" maxlength="55"', false) . '&nbsp;&nbsp;&nbsp;&nbsp;<span></td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' .
             '      <table border="0" cellspacing="0" cellpadding="2" class="tableForm">' .
             '        <tr>' .
             '          <td>' . strip_tags(ENTRY_MINIMUM_BID, '<span>') . '</td>'.'<td>'.$this->input('price', $template['price'], '', false).'</td>'.
             '          <td>' . strip_tags(ENTRY_BIN_PRICE, '<span>') . '</td>'.'<td>'.$this->input('bin_price',$template['bin_price'], 'size="11"', false).'</td>'.
             '          <td>' . strip_tags(ENTRY_RESERVE_PRICE, '<span>') . '</td>'.'<td>'.$this->input('reserve_price',$template['reserve_price'], 'size="15"', false).'</td>'.
             '        </tr>' .
             '      </table>'.
             '    </td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_EBAY_SELLER_ID, '<span>') . '&nbsp;' . $this->select('seller_id', abxConstants::getEbaySellerIDs(), $template['seller_id']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . ENTRY_PROFILE_ID . '&nbsp;' . $this->select('profile_id', abxConstants::getProfilesDropDown(), $template['profile_id']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_LISTING_TYPE, '<span>') . '&nbsp;'.$this->select('listing_type', abxConstants::getListingTypes(), $template['listing_type']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_SITE, '<span>') . '&nbsp;' . $this->select('site', abxConstants::getSites(), $template['site'], 'onchange="changeSite(this.form,\''.TEXT_CATEGORIES_DIFFER.'\'); submit_form(this.form,\'GenerateListing\');"') . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_CATEGORY1, '<span>') . '&nbsp;' . $this->input('category1', $template['category1'], 'size="25" maxlength="32"', false) . '&nbsp;' . $this->imageButton(DIR_WS_ABX_ICONS . 'search.gif',TEXT_CATEGORY_FIND,'16','16',"selectcat(document.forms['confirm'],'category1');") . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_CATEGORY2, '<span>') . '&nbsp;' . $this->input('category2', $template['category2'], 'size="25" maxlength="32"', false) . '&nbsp;' . $this->imageButton(DIR_WS_ABX_ICONS . 'search.gif',TEXT_CATEGORY_FIND,'16','16',"selectcat(document.forms['confirm'],'category2');") . '&nbsp;<span class="fees">&#36;</span></td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_STORE_CATEGORY, '<span>') . '&nbsp;'. $this->select('store_category', abxCatalogService::getEBayStoreCategories(), $template['store_category']) . '</td>'. 
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_STORE_CATEGORY2, '<span>') . '&nbsp;'. $this->select('store_category2', abxCatalogService::getEBayStoreCategories(), $template['store_category2']) . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_DURATION, '<span>') . '&nbsp;' . 
                          $this->select('duration', abxConstants::getListingDurations(), $template['duration']) . 
                          '&nbsp;&nbsp;&nbsp;&nbsp;' . 
                          strip_tags(ENTRY_QUANTITY, '<span>') . '&nbsp;' . 
                          $this->input('quantity', $template['quantity'], 'size="25" maxlength="25"', false) . 
                          '&nbsp;&nbsp;&nbsp;&nbsp;' . 
                          strip_tags(ENTRY_MAX_QUANTITY, '<span>') . '&nbsp;' . 
                          $this->input('max_quantity', '', 'size="25" maxlength="25"', false) . 
             '    </td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_PICTURE1_URL, '<span>') . '&nbsp;'.$this->input('picture1_url', $template['picture1_url'], 'maxsize="128"', false). '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_GALLERY_OPTION, '<span>') . '&nbsp;'.$this->select('extra_gallery', abxConstants::getGalleryOptions(), $template['extra_gallery']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_GALLERY_URL, '<span>') . '&nbsp;' . $this->input('extra_gallery_url', $template['extra_gallery_url'], 'maxsize="128"', false) . '</td>'.
             '  </tr>' .
             '</table>'.$this->hidden('templateid',$templateid).$this->hidden('products_id','{PRODUCTS_ID}');

      return array(array('text' => $str));
    }

    function infoBox($action)
    {
      switch($action) {
        case 'GenerateListing':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_GENERATE_LISTINGS,'<div style="float: left;">'.TEXT_INFO_GENERATE_LISTINGS.'</div><div style="float: right;">'.$this->imageButton(DIR_WS_ABX_ICONS . 'contents.gif', TEXT_HELP, '16', '16',"openWindow('".abx_href_link(FILENAME_AUCTIONBLOX, 'abx=help-tokens')."');").'</div>','GenerateConfirm',ABX_GENERATOR,'',$this->generateListingFields($_POST['templateid']));
          break;
        default:
          $templates = abxItemTemplates::getTemplatesForDropdown();
          $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_GENERATE_LISTINGS . '</b>');
          $contents[] = array('align' => 'center', 'text' => '' . TEXT_FROM_TEMPLATE . '<br>' . $this->select('templateid', $templates, ''));
          $contents[] = array('align' => 'center', 'text' => '<div style="padding: 5px;">' . $this->button(TEXT_GENERATE_LISTING,"submit_generateListing_form(document.forms['abxPaginator'],'GenerateListing',this.form['templateid']);") . '<div>' );
          return  $this->form('confirm', FILENAME_AUCTIONBLOX,'abx=generator').
                  $this->hidden('perform','null').
                  $this->infoBoxDisplay($heading, $contents).
                  '</form>';
          break;
      }
    }

  }//end class
?>