<?php
/*
  $Id: items_generator.php,v 1.9 2007/01/03 02:00:13 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Items_Generator extends abxCollatedPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if (isset($filterTerms) === false)
        $filterTerms = array(
        'values' => abx_get_category_tree()
      );

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'p.products_last_modified',
        'value' => 'desc'
      );
    }

    function countSellerIDs()
    {
      return 0;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"m.manufacturers_name",'text'=>'SEARCH_MANUFACTURER'),
        array('id'=>"pd.products_name",'text'=>'SEARCH_LIST_1'),
        array('id'=>"p.products_model",'text'=>'SEARCH_LIST_2'),
        array('id'=>"p.products_price",'text'=>'SEARCH_LIST_3'),
        array('id'=>"p.products_last_modified",'text'=>'SEARCH_LIST_4')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => ''),
        array('heading' => TABLE_HEADING_PRODUCT_TITLE, 'sort_field' => 'pd.products_name'),
        array('heading' => TABLE_HEADING_PRODUCT_MODEL, 'sort_field' => 'p.products_model'),
        array('heading' => TABLE_HEADING_PRODUCTS_PRICE, 'sort_field' => 'p.products_price'),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_AVAILABLE, 'sort_field' => 'p.products_quantity'),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_ACTIVE),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING, 'sort_field' => 'pfs.shipping'),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING_ADDL, 'sort_field' => 'pfs.shipping_addl'),
        array('heading' => TABLE_HEADING_PRODUCTS_LAST_MODIFIED, 'sort_field' => 'p.products_last_modified')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;

      return '<td>' . $this->image(DIR_WS_ABX_CATALOG_IMAGES . $array['products_image'], 'No image', 50, 40) . '</td>'.
             '<td>' . $this->cell($array['products_name']) . '</td>'.
             '<td>' . $this->cell($array['products_model']) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['products_price'])) . '</td>'.
             '<td align="right">' . $this->cell($array['products_quantity']) . '</td>'.
             '<td align="right">' . $this->cell((isset($array['childRecords']['quantity_active'])) ? $array['childRecords']['quantity_active'] : '---') . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['shipping'])) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['shipping_addl'])) . '</td>'.
             '<td align="right">' . $this->cellWrapDate(abx_short_date($array['products_last_modified'])) . '</td>';
    }

    function drawExtraHiddenFields()
    {
      return '<style type="text/css">' .
             '  .dojoDialog { ' .
             '     background : #eee; ' .
             '     border : 1px solid #999; ' .
             '     -moz-border-radius : 5px; ' .
             '     padding : 4px; ' .
             '   }' .
             '</style>' .
             '<input type="hidden" name="templateid" value=""><input type="hidden" name="abx_last" value="generator">' . 
             '<div dojoType="dialog" id="dialog0" bgColor="gray" bgOpacity=".6" toggle="fade" toggleDuration="250">' .
             '    <form onsubmit="return false;">' .
             '         <table> ' .
             '           <tr> ' .
             '               <td>Name:</td> ' .
             '               <td><input type="text"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td>Location:</td> ' .
             '               <td><input type="text"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td>Description:</td> ' .
             '               <td><input type="text"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td>Location:</td> ' .
             '               <td><input type="file"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td colspan="2" align="center"> ' .
             '                   <input type="button" id="hider0" value="OK"></td> ' .
             '           </tr> ' .
             '       </table> ' .
             '   </form> ' .
             '</div> ';
      
    }

    function bulkActions()
    {
      return array(array());
    }

    function generateListingFields($templateid)
    {
      $templates = new abxItemTemplates;  
      $template = $templates->getTemplate($templateid);
      
      $str = '<div dojoType="dialog" id="dialog0" bgColor="white" bgOpacity="0.5" toggle="fade" toggleDuration="250">' .
             '   <form onsubmit="return false;">' .
             '         <table> ' .
             '           <tr> ' .
             '               <td>Name:</td> ' .
             '               <td><input type="text"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td>Location:</td> ' .
             '               <td><input type="text"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td>Description:</td> ' .
             '               <td><input type="text"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td>Location:</td> ' .
             '               <td><input type="file"></td> ' .
             '           </tr> ' .
             '           <tr> ' .
             '               <td colspan="2" align="center"> ' .
             '                   <input type="button" id="hider0" value="OK"></td> ' .
             '           </tr> ' .
             '       </table> ' .
             '   </form> ' .
             ' </div> ';

      return array(array('text' => $str));
    }

    function generateListingFields2($templateid)
    {
      $templates = new abxItemTemplates;  
      $template = $templates->getTemplate($templateid);

      $template['site'] = !empty($_POST['site']) ? $_POST['site'] : $template['site'];
      
      $str = '<table border="0" width="100%" cellspacing="5" cellpadding="5" class="tableForm">' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_TITLE, '<span>') . '&nbsp;&nbsp;&nbsp;' . $this->input('title', $template['title'], 'maxlength="55"', false) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_SUBTITLE, '<span>') . '&nbsp;' . $this->input('subtitle', $template['subtitle'], 'maxlength="55"', false) . '&nbsp;&nbsp;&nbsp;&nbsp;<span></td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' .
             '      <table border="0" cellspacing="0" cellpadding="2" class="tableForm">' .
             '        <tr>' .
             '          <td>' . strip_tags(ENTRY_MINIMUM_BID, '<span>') . '</td>'.'<td>'.$this->input('price', $template['price'], '', false).'</td>'.
             '          <td>' . strip_tags(ENTRY_BIN_PRICE, '<span>') . '</td>'.'<td>'.$this->input('bin_price',$template['bin_price'], 'size="11"', false).'</td>'.
             '          <td>' . strip_tags(ENTRY_RESERVE_PRICE, '<span>') . '</td>'.'<td>'.$this->input('reserve_price',$template['reserve_price'], 'size="15"', false).'</td>'.
             '        </tr>' .
             '      </table>'.
             '    </td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_EBAY_SELLER_ID, '<span>') . '&nbsp;' . $this->select('seller_id', abxConstants::getEbaySellerIDs(), $template['seller_id']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . ENTRY_PROFILE_ID . '&nbsp;' . $this->select('profile_id', abxConstants::getProfilesDropDown(), $template['profile_id']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_LISTING_TYPE, '<span>') . '&nbsp;'.$this->select('listing_type', abxConstants::getListingTypes(), $template['listing_type']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_SITE, '<span>') . '&nbsp;' . $this->select('site', abxConstants::getSites(), $template['site'], 'onchange="changeSite(this.form,\''.TEXT_CATEGORIES_DIFFER.'\'); submit_form(this.form,\'GenerateListing\');"') . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_STORE_CATEGORY, '<span>') . '&nbsp;'. $this->select('store_category', abxCatalogService::getEBayStoreCategories(), $template['store_category']). '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_CATEGORY1, '<span>') . '&nbsp;' . $this->input('category1', $template['category1'], 'size="7" maxlength="32"', false) . '&nbsp;' . $this->imageButton(DIR_WS_ABX_ICONS . 'search.gif',TEXT_CATEGORY_FIND,'16','16',"selectcat(document.forms['confirm'],'category1');") . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_CATEGORY2, '<span>') . '&nbsp;' . $this->input('category2', $template['category2'], 'size="7" maxlength="32"', false) . '&nbsp;' . $this->imageButton(DIR_WS_ABX_ICONS . 'search.gif',TEXT_CATEGORY_FIND,'16','16',"selectcat(document.forms['confirm'],'category2');") . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_STORE_CATEGORY2, '<span>') . '&nbsp;'. $this->select('store_category2', abxCatalogService::getEBayStoreCategories(), $template['store_category2']) . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_DURATION, '<span>') . '&nbsp;' . $this->select('duration', abxConstants::getListingDurations(), $template['duration']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_QUANTITY, '<span>') . '&nbsp;' . $this->input('quantity', '{PRODUCTS_QUANTITY}', 'size="25" maxlength="25"', false).'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_SHIPPING_LOCATION, '<span>') . '&nbsp;' . $this->select('shipping_location', abxConstants::getShippingLocations(), $template['shipping_location']). '&nbsp;&nbsp;&nbsp;&nbsp;' . ENTRY_SHIPPING_WEIGHT . '&nbsp;&nbsp;' . $this->input('shipping_weight', $template['shipping_weight'], 'size="7"', false) . '&nbsp;&nbsp;' . $this->select('shipping_weight_unit', abxConstants::getShippingWeightUnits(), $template['shipping_weight_unit']) .'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_SHIPPING_TYPE, '<span>') . '&nbsp;' . $this->select('shipping_type', abxConstants::getShippingTypes(), $template['shipping_type']). '&nbsp;&nbsp;&nbsp;&nbsp;' . ENTRY_SHIPPING_PACKAGE . '&nbsp;' . $this->select('shipping_pkg', abxConstants::getShippingPackages(), $template['shipping_pkg']) . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . ENTRY_SHIPPING_SVC . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $this->select('shipping_svc', abxConstants::getShippingServices($template['site']), $template['shipping_svc']) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' .strip_tags(ENTRY_SHIPPING_FIRST_ITEM, '<span>') . '&nbsp;' .$this->input('shipping',$template['shipping'], 'size="14"'). '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_SHIPPING_ADDL_ITEM, '<span>') . '&nbsp;' .$this->input('shipping_addl',$template['shipping_addl'], 'size="14"').'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . ENTRY_SHIPPING_SVC_GLOBAL . '&nbsp;' . $this->select('shipping_global_svc', abxConstants::getShippingServicesGlobal($template['site']), $template['shipping_global_svc']) . '&nbsp;&nbsp;&nbsp;&nbsp;' .strip_tags(ENTRY_SHIPPING_GLOBAL_FIRST_ITEM, '<span>') . '&nbsp;' . $this->input('shipping_global',$template['shipping_global'], 'size="14"') . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_SHIPPING_GLOBAL_ADDL_ITEM, '<span>') . '&nbsp;' . $this->input('shipping_global_addl',$template['shipping_global_addl'], 'size="14"') .'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . strip_tags(ENTRY_PICTURE1_URL, '<span>') . '&nbsp;'.$this->input('picture1_url', '{PRODUCTS_IMAGE}', 'maxsize="128"', false). '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_GALLERY_OPTION, '<span>') . '&nbsp;'.$this->select('extra_gallery', abxConstants::getGalleryOptions(), $template['extra_gallery']) . '&nbsp;&nbsp;&nbsp;&nbsp;' . strip_tags(ENTRY_GALLERY_URL, '<span>') . '&nbsp;' . $this->input('extra_gallery_url', '{PRODUCTS_IMAGE}', 'maxsize="128"', false) . '</td>'.
             '  </tr>' .
             '</table>'.$this->hidden('templateid',$templateid).$this->hidden('products_id','{PRODUCTS_ID}');

      return array(array('text' => $str));
    }

    function infoBox($action)
    {
      switch($action) {
        case 'GenerateListing':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_GENERATE_LISTINGS,'<div style="float: left;">'.TEXT_INFO_GENERATE_LISTINGS.'</div><div style="float: right;">'.$this->imageButton(DIR_WS_ABX_ICONS . 'contents.gif', TEXT_HELP, '16', '16',"openWindow('".abx_href_link(FILENAME_AUCTIONBLOX, 'abx=help-tokens')."');").'</div>','GenerateConfirm',ABX_GENERATOR,'',$this->generateListingFields($_POST['templateid']));
          break;
        default:
          $templates = abxItemTemplates::getTemplatesForDropdown();
          $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_GENERATE_LISTINGS . '</b>');
          $contents[] = array('align' => 'center', 'text' => '' . TEXT_FROM_TEMPLATE . '<br>' . $this->select('templateid', $templates, ''));
          //$contents[] = array('align' => 'center', 'text' => '<div style="padding: 5px;">' . $this->button(TEXT_GENERATE_LISTING,"submit_generateListing_form(document.forms['abxPaginator'],'GenerateListing',this.form['templateid']);") . '<div>' );
          $contents[] = array('align' => 'center', 'text' => '<button dojoType="button" onclick="dlg0.show()">' . TEXT_GENERATE_LISTING . '</button>');
          return  $this->form('confirm', FILENAME_AUCTIONBLOX,'abx=generator').
                  $this->hidden('perform','null').
                  $this->infoBoxDisplay($heading, $contents).
                  '</form>';
          break;
      }
    }

  }//end class
?>