<?php
/*
  $Id: sales_feedback.php,v 1.9 2006/04/20 00:40:31 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Sales_Feedback extends abxWebServicePaginator {

    var
      $sMethod = 'feedback.getFeedback';

    function filterTerms()
    {
      static $filterTerms = array();

      if (empty($filterTerms) === true)

        $filterTerms = array(
          'name'   => 'type',
          'values' => abxConstants::getFeedbackTypes()
        );

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'time',
        'value' => 'desc'
      );
    }

    function sellerIDs()
    {
      static $eBaySellerList;

      if (isset($eBaySellerList) === false) {

        $sellers = abxConstants::getEbaySellerIDs(array(array('id' => '', 'text' => '')));

        foreach($sellers as $seller)
          $eBaySellerList[] = array( 'id' => $seller['text'], 'text' => $seller['text']);

      }

      return $eBaySellerList;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"buyerId",'text'=>'SEARCH_LIST_1'),
        array('id'=>"listingId",'text'=>'SEARCH_LIST_2'),
        array('id'=>"buyerResponse",'text'=>'SEARCH_LIST_3')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => HEADING_AUCTION_TITLE, 'sort_field' => 'title'),
        array('heading' => HEADING_AUCTION_SITE, 'sort_field' => 'site'),
        array('heading' => HEADING_AUCTION_USERID, 'sort_field' => 'buyerId'),
        array('heading' => HEADING_FEEDBACK_DATE, 'sort_field' => 'timeOfComment'),
        array('heading' => HEADING_AUCTION_COMMENT, 'sort_field' => 'comment')
      );
    }

    function tableDataRowContents($array)
    {
      $row = '<td>' . $this->cellWrap($array['title'] . '<br /><span class="tableDataSubText">' . $array['listingId'] . '</span>') . '</td>'.
             '<td>' . $this->cell($array['site']) . '</td>'.
             '<td>' . $this->cell($array['buyerId'] . '<br /><span class="tableDataSubText">' . $array['buyerEmail']) . '</span>' . '</td>'.
             '<td align="right">' . $this->cellWrapDate(gmt_date_to_local_pretty_format($array['timeOfComment'])) . '</td>'.
             '<td>' . $this->cellWrap($array['comment']);
      
      if(isset($array['sellerFollowup']) && strlen($array['sellerFollowup']) > 0)
             $row .= '<br/><i>' . $this->cell($array['sellerFollowup']) . '</i>';

      if(isset($array['buyerResponse']) && strlen($array['buyerResponse']) > 0)
             $row .= '<br/><strong>' . $this->cell($array['buyerResponse']) . '</strong></td>';
             
      return $row;
    }

    function drawExtraHiddenFields()
    {
      return '<input type="hidden" name="abx_last" value="sales-feedback">';
    }

    function bulkActions()
    {
      return array(
        'PositiveFeedback' => array('icon'=>'feedback_pos.gif','alt'=>ACTION_POSITIVE_FEEDBACK),
        'NeutralFeedback'  => array('icon'=>'feedback_neu.gif','alt'=>ACTION_NEUTRAL_FEEDBACK),
        'NegativeFeedback' => array('icon'=>'feedback_neg.gif','alt'=>ACTION_NEGATIVE_FEEDBACK)
      );
    }

    function infoBox($action)
    {
      switch($action) {
        case 'PositiveFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_POSITIVE_FEEDBACK,TEXT_INFO_POSITIVE_FEEDBACK,'PositiveFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'NeutralFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_NEUTRAL_FEEDBACK,TEXT_INFO_NEUTRAL_FEEDBACK,'NeutralFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'NegativeFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_NEGATIVE_FEEDBACK,TEXT_INFO_NEGATIVE_FEEDBACK,'NegativeFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'feedbackDownload':
          return $this->infoPageBox(TEXT_INFO_HEADING_DOWNLOAD_FEEDBACK,TEXT_INFO_DOWNLOAD_FEEDBACK, 'sales', 'downloadFeedbackConfirm','sales-feedback-download','', $this->infoBoxDownloads());
          break;
      }
    }

    function tableDataFooter()
    {
      return '<div align="right"><form name="feedbackDownload" method="post"><input type="hidden" name="perform">' . $this->submit(TEXT_DOWNLOAD_FEEDBACK,'this.form','feedbackDownload','sales-feedback-download'.abxPage::getSearchParams(),'','greenButton') . '</form></div>';
    }

    function infoBoxDownloads()
    {
      return array(array('text' =>  '<div style="margin: 10px;">' . $this->select('seller_id',abxConstants::getEbaySellerIDs()) . '</div>'));
    }

  }//end class
?>