<?php
/*
  $Id: shipping_fixed.php,v 1.4 2008/03/31 18:19:41 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Shipping_Fixed extends abxPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if(isset($filterTerms) === false) {

        $filterTerms = array(
          'values' => abx_get_category_tree()
        );

      }

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'pd.products_name',
        'value' => 'desc'
      );
    }

    function countSellerIDs()
    {
      return 0;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"pd.products_name",'text'=>'SEARCH_LIST_1')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => TABLE_HEADING_PRODUCTS, 'sort_field' => 'products_name'),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING_ADDL),
        array('heading' => TABLE_HEADING_GLOBAL_SHIPPING),
        array('heading' => TABLE_HEADING_GLOBAL_SHIPPING_ADDL),
        array('heading' => TABLE_HEADING_STATUS, 'align' => 'center', 'sort_field' => 'is_enabled')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;

      $str = '<td>' . $this->cellWrap($array['products_name'], 150) . '</td>';

      if ($array['shipping'] != null) {

        $str .= '<td align="right">' . $this->cell($currencies->format($array['shipping'])) . '</td>'.
                '<td align="right">' . $this->cell($currencies->format($array['shipping_addl'])) . '</td>'.
                '<td align="right">' . $this->cell($currencies->format($array['shipping_global'])) . '</td>'.
                '<td align="right">' . $this->cell($currencies->format($array['shipping_global_addl'])) . '</td>';

        if ($array['is_enabled'] == '1')

          $str .= '<td align="center">' . $this->cell($this->image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_green.gif', IMAGE_ICON_STATUS_GREEN, 10, 10) . '&nbsp;&nbsp;<a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=shipping_fixed&action=setflag&flag=0&oID=' . $array['id'].'&page=' . $_GET['page'], 'NONSSL') . '">' . $this->image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_red_light.gif', IMAGE_ICON_STATUS_RED_LIGHT, 10, 10) . '</a>') . '</td>';

        else

          $str .= '<td align="center">' . $this->cell('<a href="' . abx_href_link(FILENAME_AUCTIONBLOX, 'abx=shipping_fixed&action=setflag&flag=1&oID=' . $array['id'].'&page=' . $_GET['page'], 'NONSSL') . '">' . $this->image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_green_light.gif', IMAGE_ICON_STATUS_GREEN_LIGHT, 10, 10) . '</a>&nbsp;&nbsp;' . $this->image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_red.gif', IMAGE_ICON_STATUS_RED, 10, 10)).'</td>';

      } else {

        $str .= '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="right">' . $this->cell('&nbsp;---&nbsp;') . '</td>'.
                '<td align="center">' . $this->cell($this->image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_red_light.gif', '', '10', '10') . '&nbsp;&nbsp;' . $this->image(DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'icon_status_red_light.gif', '', '10', '10')) . '</td>';
      }

      return $str;
    }

    function bulkActions()
    {
      return array(
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_SHIPPING_FIXED."','delete_confirm');"),
        'UpdateItems' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT)
      );
    }

    function updateListingFields()
    {
      global $abxDatabase;

      $nSelectedRows = count($_POST['abxList']);

      if ($nSelectedRows == 1)
        $single = abxShippingFixed::getFixedShippingProduct($_POST['abxList'][0]);

      $domestic_shipping      = $nSelectedRows == 1 ? $single['shipping'] : '';
      $domestic_shipping_addl = $nSelectedRows == 1 ? $single['shipping_addl'] : '';
      $global_shipping        = $nSelectedRows == 1 ? $single['shipping_global'] : '';
      $global_shipping_addl   = $nSelectedRows == 1 ? $single['shipping_global_addl'] : '';
      $is_enabled             = $nSelectedRows == 1 ? $single['is_enabled'] : '';

      $str = '<table border="0" width="100%" cellspacing="0" cellpadding="2" class="tableForm">' .
             '  <tr>' .
             '    <td>' . TEXT_PRODUCT_DOMESTIC_SHIPPING . '</td>'.'<td>'.$this->input('products_domestic_shipping', $domestic_shipping, 'size="10" maxlength="10"').'</td>'.
             '    <td>' . TEXT_PRODUCT_DOMESTIC_SHIPPING_ADDL . '</td>'.'<td>'.$this->input('products_domestic_additional_shipping', $domestic_shipping_addl, 'size="10" maxlength="10"').'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_PRODUCT_GLOBAL_SHIPPING . '</td>'.'<td>'.$this->input('products_global_shipping', $global_shipping, 'size="10" maxlength="10"').'</td>'.
             '    <td>' . TEXT_PRODUCT_GLOBAL_SHIPPING_ADDL . '</td>'.'<td>'.$this->input('products_global_additional_shipping', $global_shipping_addl, 'size="10" maxlength="10"').'</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_ENABLE_FIXED_PRICES . '</td>'.'<td>'.$this->radio('fixed_price_enabled', '1', '', $is_enabled === '1') . '&nbsp;' . TEXT_TRUE . '&nbsp;' . $this->radio('fixed_price_enabled', '0', '', $is_enabled === '0') . '&nbsp;' . TEXT_FALSE.'</td>'.
             '    <td colspan="2">' .'&nbsp;' . '</td>'.
             '  </tr>' .
             '</table>';

      return array(array('text' => $str));
    }

    function infoBox($action)
    {
      switch($action) {
        case 'UpdateItems':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_CREATE_SHIPPING,TEXT_INFO_CREATE_INTRO,'create_confirm','','',$this->updateListingFields());
          break;
      }
    }

  }//end class
?>