<?php
/*
  $Id: listings.php,v 1.25 2008/12/15 00:47:30 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES . 'abxListings.php');
  
  require_once(DIR_FS_ABX_CLASSES . 'Page/abxPageFactory.php');  

  class abxModule_Listings extends abxModule {

    function abxModule_Listings()
    {
      $this->process();
    }

    function process()
    {
      switch ($_POST['perform']) {
        
        case 'CancelConfirm':
          abxListings::cancelById($_POST['abxList']);
          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX, 'abx=listings'.abxPage::getSearchParams()));
          break;

        case 'DeleteConfirm':

          abxListings::removeByID($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX, 'abx=listings'.abxPage::getSearchParams()));

          break;

        case 'downloadConfirm':

          abxListings::downloadListings($_POST['seller_id']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=listings'.abxPage::getSearchParams()));

        break;

        case 'RelistListings':

          break;

      }
    }

    function display()
    {
      switch($_GET['filter']) {

        case 'PENDING':
          $page = abxPageFactory::newPaginator('listings_pending');
          $page->paginatorQuery( abxListings::getPendingItemsQuery() );
          break;

        case 'ENDED':
          switch(implode('-', $GLOBALS['abx'])) {
            case 'listings-relist':
              require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');
              $page = new abxPage;
              $page->addJavaScript('listings_relist.js');
              $page->setContentFile('listings_relist');
              $page->includeLanguageFile('listings_relist');
              $page->vars['perform'] = 'RelistListings';
              $page->vars['listings'] = abxListings::getRelistItemsEditQuery(abxArray::set_type($_POST['abxList'],'integer'));
              return $page;
              break;
              
            default:
              $page = abxPageFactory::newPaginator('listings_ended');
              $page->paginatorQuery( abxListings::getEndedItemsQuery() );
              break;
          }
          break;


        case 'SOLD':
          switch(implode('-', $GLOBALS['abx'])) {
            case 'listings-relist':
              require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');
              $page = new abxPage;
              $page->addJavaScript('listings_relist.js');
              $page->setContentFile('listings_relist');
              $page->includeLanguageFile('listings_relist');
              $page->vars['perform'] = 'RelistListings';
              $page->vars['listings'] = abxListings::getRelistItemsEditQuery(abxArray::set_type($_POST['abxList'],'integer'));
              return $page;
              break;
              
            default:
              $page = abxPageFactory::newPaginator('listings_reports');
              $page->paginatorQuery( abxListings::getSoldItemsQuery() );
              break;
          }
          break;

        case 'UNSOLD':
          switch(implode('-', $GLOBALS['abx'])) {
            case 'listings-relist':
              require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');
              $page = new abxPage;
              $page->addJavaScript('listings_relist.js');
              $page->setContentFile('listings_relist');
              $page->includeLanguageFile('listings_relist');
              $page->vars['perform'] = 'RelistListings';
              $page->vars['listings'] = abxListings::getRelistItemsEditQuery(abxArray::set_type($_POST['abxList'],'integer'));
              return $page;
              break;
              
            default:
              $page = abxPageFactory::newPaginator('listings_reports');
              $page->paginatorQuery( abxListings::getUnsoldItemsQuery() );
              break;
          }
          break;

        case 'CANCELED':
          switch(implode('-', $GLOBALS['abx'])) {
            case 'listings-relist':
              require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');
              $page = new abxPage;
              $page->addJavaScript('listings_relist.js');
              $page->setContentFile('listings_relist');
              $page->includeLanguageFile('listings_relist');
              $page->vars['perform'] = 'RelistListings';
              $page->vars['listings'] = abxListings::getRelistItemsEditQuery(abxArray::set_type($_POST['abxList'],'integer'));
              return $page;
              break;
            default:
              $page = abxPageFactory::newPaginator('listings_cancelled');
              $page->paginatorQuery( abxListings::getCancelledItemsQuery() );
              break;
          }
          break;

        case 'FAILED':
          $page = abxPageFactory::newPaginator('listings_failed');
          $page->paginatorQuery( abxListings::getFailedItemsQuery() );
          break;

        case 'RELIST':
          switch(implode('-', $GLOBALS['abx'])) {
            case 'listings-relist':
            default:
              $page = new abxPage;
              $page->setContentFile('listings_relist');
              $page->includeLanguageFile('listings_relist');
              $page->vars['perform'] = 'RelistListings';
              $page->vars['listings'] = abxListings::getRelistItemsEditQuery(abxArray::set_type($_POST['abxList'],'integer'));
              return $page;
              break;
          }

          break;

        case 'ACTIVE':
          switch(implode('-', $GLOBALS['abx'])) {
            case 'listings-relist':
              require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');
              $page = new abxPage;
              $page->addJavaScript('listings_relist.js');
              $page->setContentFile('listings_relist');
              $page->includeLanguageFile('listings_relist');
              $page->vars['perform'] = 'RelistListings';
              $page->vars['listings'] = abxListings::getRelistItemsEditQuery(abxArray::set_type($_POST['abxList'],'integer'));
              return $page;
              break;

            default:       
	          $page = abxPageFactory::newPaginator('listings_active');
	          $page->paginatorQuery( abxListings::getActiveItemsQuery() );
              break;
          }

          break;


        default:
          $page = abxPageFactory::newPaginator('listings_active');
          $_GET['filter'] = 'ACTIVE';
          $page->paginatorQuery( abxListings::getActiveItemsQuery() );
          break;

      }
	  $page->addJavaScript('lazyimages.js');
      $page->includeLanguageFile('listings');

      $page->generatePaginatorContent();

      return $page;
    }

  }//end class
?>