<?php
/*
  $Id: profiles.php,v 1.17 2008/03/13 14:33:03 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  include_once DIR_FS_ABX_CLASSES.'abxProfiles.php';
  include_once DIR_FS_ABX_CLASSES.'abxProfilesEmail.php';
  include_once DIR_FS_ABX_CLASSES.'abxProfilesFeedback.php';

  class abxModule_Profiles extends abxModule {

    function abxModule_Profiles() {
      $this->process();
    }

    function process() {
      $abxProfiles = new abxProfiles;

      $profile_id = (isset($_GET['profile_id']) && !empty($_GET['profile_id'])) ? '&profile_id=' . $_GET['profile_id'] : '';

      switch($_POST['perform']) {

        case 'updateFeedbackTemplate':

          abxProfilesFeedback::updateTemplate($_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-feedback' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'insertFeedbackTemplates':

          abxProfilesFeedback::insertTemplates($_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-feedback' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'insertFeedbackTemplate':

          abxProfilesFeedback::insertTemplate($_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-feedback' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'DeleteFeedbackTemplatesConfirm':

          abxProfilesFeedback::deleteTemplates($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-feedback' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'updateEmailTemplate':

          abxProfilesEmail::updateTemplate($_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-email' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'insertEmailTemplates':

          abxProfilesEmail::insertTemplates($_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-email' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'insertEmailTemplate':

          abxProfilesEmail::insertTemplate($_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-email' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'DeleteEmailTemplatesConfirm':

          abxProfilesEmail::deleteTemplates($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-email' . $profile_id . abxPage::getSearchParams()));

          break;

        case 'DeleteProfilesConfirm':
          abxProfiles::delete($_POST['abxList']);
          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles'.abxPage::getSearchParams()));
          break;

        case 'createNewProfile':
        case 'editProfile':
          abxProfiles::save($_POST);
          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles'.abxPage::getSearchParams()));
          break;
      }

    }

    function display()
    {
      global $abx;

      $abxProfiles = new abxProfiles;
      $abxProfiles->invalidate();

      switch (implode("-", $abx)) {

        case 'profiles-feedback':
        case 'profiles-feedback-new':
        case 'profiles-feedback-edit':
        case 'profiles-feedback-copy':
          $page = abxPageFactory::createWebServicePaginator('abx_profiles_feedback');
          $page->includeLanguageFile('abx_profiles_feedback');
          $page->generatePaginatorContent();
          break;

        case 'profiles-email':
        case 'profiles-email-new':
        case 'profiles-email-edit':
        case 'profiles-email-copy':
          $page = abxPageFactory::createWebServicePaginator('abx_profiles_email');
          $page->includeLanguageFile('abx_profiles_email');
          $page->generatePaginatorContent();
          break;

        default:
          $page = abxPageFactory::createWebServicePaginator('abx_profiles');
          $page->includeLanguageFile('abx_profiles');
          $page->generatePaginatorContent();
          break;
      }

      return $page;
    }

  }//end class
?>
